/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.CEP;
import jalis.util.ComponenteUtils;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class UnidadeSaude
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TTextField txtCidade;
    private JButton jButton1;
    private JButton jButton2;
    private TTextField txtDescCidade;
    private JLabel jLabel4;
    private TTextField txtEndereco;
    private JLabel jLabel5;
    private TTextField txtComplemento;
    private JLabel jLabel6;
    private TTextField txtCodBairro;
    private TTextField txtDescBairro;
    private JLabel jLabel7;
    private TTextField txtCEP;
    private JLabel jLabel8;
    private TTextFieldTelefone txtFone;
    private TTextField textCodigoIDS;
    private JLabel labelCodigoIDS;
    private JLabel labelSequencialEquipe;
    private TTextField textSequencialEquipe;
    private JLabel labelAreaEquipe;
    private TTextField textAreaEquipe;
    private JButton bBuscaCep;
    private String retornoParaPesquisa = "";
    private JPanel panelIntegracaoIDS = null;
    private JPanel panelBPA;

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(UnidadeSaude.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101400001"));
        this.setModuloEdita(Long.parseLong("0101400002"));
        this.setModuloApaga(Long.parseLong("0101400003"));
    }

    public UnidadeSaude() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "UnidadeSaude: 59");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtCodigo.setUpperCase(true);
        this.txtCodBairro.setUpperCase(true);
    }

    public void jbInit() throws Exception {
        this.setName("UnidadeSaude");
        this.setLabelDescricao("Cadastro de unidades de sa\u00fade");
        this.setLabelFormulario("Cadastro de unidades de sa\u00fade");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_unidadesaude.jpg"));
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(7);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtCidade = new TTextField(5, 1);
        this.txtCidade.setName("txtCidade");
        this.jButton1 = new JButton();
        this.jButton1.setName("jButton1");
        this.jButton2 = new JButton();
        this.jButton2.setName("jButton2");
        this.txtDescCidade = new TTextField(80);
        this.txtDescBairro = new TTextField(80);
        this.jLabel4 = new JLabel();
        this.txtEndereco = new TTextField(80);
        this.txtEndereco.setName("txtEndereco");
        this.jLabel5 = new JLabel();
        this.txtComplemento = new TTextField(50);
        this.txtComplemento.setName("txtComplemento");
        this.jLabel6 = new JLabel();
        this.txtCodBairro = new TTextField(5);
        this.txtCodBairro.setName("txtCodBairro");
        this.jLabel7 = new JLabel();
        this.txtCEP = new TTextField(9, 9);
        this.txtCEP.setName("txtCEP");
        this.jLabel8 = new JLabel();
        this.txtFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
        this.txtFone.setName("txtFone");
        this.textCodigoIDS = new TTextField(10, 1);
        this.textCodigoIDS.setName("textCodigoIDS");
        this.labelCodigoIDS = new JLabel("C\u00f3d. Integra\u00e7\u00e3o:");
        this.labelSequencialEquipe = new JLabel("Sequencial de Equipe: ");
        this.textSequencialEquipe = new TTextField(8, 1);
        this.textSequencialEquipe.setName("textSequencialEquipe");
        this.labelAreaEquipe = new JLabel("\u00c1rea de Equipe: ");
        this.textAreaEquipe = new TTextField(3, 1);
        this.textAreaEquipe.setName("textAreaEquipe");
        this.bBuscaCep = new JButton();
        this.bBuscaCep.setName("bBuscaCep");
        this.panelIntegracaoIDS = new JPanel(new GridBagLayout());
        this.panelIntegracaoIDS.setBorder(new TitledBorder("Configura\u00e7\u00e3o IDS"));
        this.panelBPA = new JPanel(null);
        this.panelBPA.setBorder(new TitledBorder("Info. Equipe"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.txtCodigo.setText("");
        this.jLabel1.setBounds(new Rectangle(5, 9, 55, 14));
        this.txtCodigo.setBounds(new Rectangle(97, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(97, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(5, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel3.setText("Cidade:");
        this.jLabel3.setBounds(new Rectangle(5, 51, 63, 14));
        this.txtCidade.setText("");
        this.txtCidade.setBounds(new Rectangle(97, 49, 69, 20));
        this.jButton1.setBounds(new Rectangle(167, 49, 20, 20));
        this.jButton1.setFocusable(false);
        this.jButton1.setText("");
        Funcoes.imagemPesquisa(this.jButton1);
        this.txtDescCidade.setText("");
        this.txtDescCidade.setEditable(false);
        this.txtDescCidade.setFocusable(false);
        this.txtDescCidade.setBounds(new Rectangle(188, 49, 309, 20));
        this.jLabel4.setText("Endere\u00e7o:");
        this.jLabel4.setBounds(new Rectangle(5, 72, 63, 14));
        this.txtEndereco.setText("");
        this.txtEndereco.setBounds(new Rectangle(97, 70, 400, 20));
        this.jLabel5.setText("Complemento:");
        this.jLabel5.setBounds(new Rectangle(5, 93, 92, 14));
        this.txtComplemento.setText("");
        this.txtComplemento.setBounds(new Rectangle(97, 91, 400, 20));
        this.jLabel6.setText("Bairro:");
        this.jLabel6.setBounds(new Rectangle(5, 114, 63, 14));
        this.txtCodBairro.setText("");
        this.txtCodBairro.setBounds(new Rectangle(97, 112, 69, 20));
        this.jButton2.setBounds(new Rectangle(167, 112, 20, 20));
        this.jButton2.setFocusable(false);
        this.jButton2.setText("");
        Funcoes.imagemPesquisa(this.jButton2);
        this.txtDescBairro.setText("");
        this.txtDescBairro.setEditable(false);
        this.txtDescBairro.setFocusable(false);
        this.txtDescBairro.setBounds(new Rectangle(188, 112, 130, 20));
        this.jLabel7.setBounds(new Rectangle(346, 114, 35, 14));
        this.jLabel7.setText("CEP:");
        this.txtCEP.setBounds(new Rectangle(381, 112, 95, 20));
        this.txtCEP.setText("");
        this.bBuscaCep.setBounds(new Rectangle(476, 112, 20, 20));
        this.bBuscaCep.setFocusable(false);
        this.bBuscaCep.setText("");
        Funcoes.imagemPesquisa(this.bBuscaCep);
        this.jLabel8.setBounds(new Rectangle(5, 135, 63, 14));
        this.jLabel8.setText("Fone:");
        this.txtFone.setBounds(new Rectangle(97, 133, 116, 20));
        this.txtFone.clear();
        this.panelIntegracaoIDS.setBounds(new Rectangle(5, 210, 494, 50));
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.txtFone);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel8, null);
        this.painelCentral.add((Component)this.jLabel6, null);
        this.painelCentral.add((Component)this.jLabel5, null);
        this.painelCentral.add((Component)this.jLabel4, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.txtFone, null);
        this.painelCentral.add((Component)this.txtCodBairro, null);
        this.painelCentral.add((Component)this.jButton2, null);
        this.painelCentral.add((Component)this.txtDescBairro, null);
        this.painelCentral.add((Component)this.txtComplemento, null);
        this.painelCentral.add((Component)this.txtEndereco, null);
        this.painelCentral.add((Component)this.txtCidade, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.jButton1, null);
        this.painelCentral.add((Component)this.txtDescCidade, null);
        this.painelCentral.add((Component)this.jLabel7, null);
        this.painelCentral.add((Component)this.txtCEP, null);
        this.painelCentral.add((Component)this.bBuscaCep, null);
        this.montaPainelEquipe();
        this.painelCentral.add((Component)this.panelBPA, null);
        if (!Funcoes.textoVazio(ParametrosGerais.getConfiguracaoIntegracaoIDS())) {
            this.montaPainelIntegracaoIDS();
            this.painelCentral.add((Component)this.panelIntegracaoIDS, null);
        }
        this.controlaCampos();
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnidadeSaude.this.buscaCidade();
            }
        });
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnidadeSaude.this.buscaBairro();
            }
        });
        this.bBuscaCep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CEP.buscarCEP(null, UnidadeSaude.this.txtCEP, UnidadeSaude.this.txtEndereco, UnidadeSaude.this.txtCidade, UnidadeSaude.this.txtDescCidade, UnidadeSaude.this.txtCodBairro, UnidadeSaude.this.txtDescBairro, UnidadeSaude.this);
                ScreenUtil.requisitarFoco(UnidadeSaude.this.txtCEP);
            }
        });
        this.txtCEP.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    CEP.buscarCEP(null, UnidadeSaude.this.txtCEP, UnidadeSaude.this.txtEndereco, UnidadeSaude.this.txtCidade, UnidadeSaude.this.txtDescCidade, UnidadeSaude.this.txtCodBairro, UnidadeSaude.this.txtDescBairro, UnidadeSaude.this);
                }
            }
        });
        this.txtCEP.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean validaCEP;
                if (!Funcoes.textoVazio(UnidadeSaude.this.txtCEP) && e.getOppositeComponent() != null && e.getOppositeComponent().getParent() == UnidadeSaude.this.txtCEP.getParent() && !(validaCEP = CEP.cepValido(UnidadeSaude.this.txtCEP))) {
                    ScreenUtil.requisitarFoco(UnidadeSaude.this.txtCEP);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.txtCidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (UnidadeSaude.this.txtCidade.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select cid_nome, cid_uf from cidades where fil_codigo = " + Variaveis.filialPadrao + " and cid_codigo=" + UnidadeSaude.this.txtCidade.getText());
                        if (rs.next()) {
                            UnidadeSaude.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                        } else {
                            UnidadeSaude.this.txtDescCidade.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(UnidadeSaude.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        UnidadeSaude.this.setStatus(1);
                        UnidadeSaude.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodBairro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (UnidadeSaude.this.txtCodBairro.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select bai_descricao from bairro where fil_codigo = " + Variaveis.filialPadrao + " and upper(bai_codigo)=upper(" + UnidadeSaude.this.txtCodBairro.getTextDBEscape() + ")");
                        if (rs.next()) {
                            UnidadeSaude.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                        } else {
                            UnidadeSaude.this.txtDescBairro.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(UnidadeSaude.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        UnidadeSaude.this.setStatus(1);
                        UnidadeSaude.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (UnidadeSaude.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuilder buf = new StringBuilder("select a.uns_descricao, a.cid_codigo, a.uns_cep, a.uns_endereco, a.uns_cep, ");
                            buf.append(" a.uns_complemento, a.uns_fone, b.cid_nome, b.cid_uf, c.bai_descricao, a.bai_codigo, uns_integracaoids, ");
                            buf.append(" a.uns_sequencialequipe, a.uns_areaequipe ");
                            buf.append("from unidadesaude a left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo=b.cid_codigo ");
                            buf.append("left  join bairro c on a.fil_codigo = c.fil_codigo and upper(a.bai_codigo)=upper(c.bai_codigo) ");
                            buf.append(" where a.fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and upper(a.uns_codigo)=upper(").append(UnidadeSaude.this.txtCodigo.getTextDBEscape()).append(")");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                if (UnidadeSaude.this.getStatus() == 2) {
                                    UnidadeSaude.this.setStatus(3);
                                }
                                UnidadeSaude.this.txtDescricao.setText(rs.getString("uns_descricao"));
                                UnidadeSaude.this.txtCidade.setText(rs.getString("cid_codigo"));
                                if (!DBUtil.campoNull(rs.getString("cid_nome"))) {
                                    UnidadeSaude.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                                }
                                UnidadeSaude.this.txtEndereco.setText(rs.getString("uns_endereco"));
                                UnidadeSaude.this.txtComplemento.setText(rs.getString("uns_complemento"));
                                UnidadeSaude.this.txtCodBairro.setText(rs.getString("bai_codigo"));
                                UnidadeSaude.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                                UnidadeSaude.this.txtCEP.setText(rs.getString("uns_cep"));
                                UnidadeSaude.this.txtFone.setText(rs.getString("uns_fone"));
                                UnidadeSaude.this.textCodigoIDS.setText(rs.getString("uns_integracaoids"));
                                UnidadeSaude.this.textSequencialEquipe.setText(rs.getString("uns_sequencialequipe"));
                                UnidadeSaude.this.textAreaEquipe.setText(rs.getString("uns_areaequipe"));
                                UnidadeSaude.this.txtCodigo.setEnabled(false);
                            } else if (UnidadeSaude.this.getStatus() == 3) {
                                Funcoes.mensagem(UnidadeSaude.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                UnidadeSaude.this.setStatus(1);
                                UnidadeSaude.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(UnidadeSaude.this, sqlex.getMessage(), sqlex.getStackTrace(), "Coleta");
                    }
                }
            }
        });
    }

    private void montaPainelEquipe() {
        this.panelBPA.setBounds(new Rectangle(5, 160, 494, 50));
        this.labelSequencialEquipe.setBounds(new Rectangle(8, 18, 145, 20));
        this.textSequencialEquipe.setBounds(new Rectangle(140, 18, 100, 20));
        this.labelAreaEquipe.setBounds(new Rectangle(284, 18, 100, 20));
        this.textAreaEquipe.setBounds(new Rectangle(380, 18, 50, 20));
        this.panelBPA.add(this.labelSequencialEquipe);
        this.panelBPA.add(this.textSequencialEquipe);
        this.panelBPA.add(this.labelAreaEquipe);
        this.panelBPA.add(this.textAreaEquipe);
        this.panelBPA.add(new JLabel());
    }

    private void montaPainelIntegracaoIDS() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelIntegracaoIDS.add((Component)this.labelCodigoIDS, c);
        ++c.gridx;
        this.textCodigoIDS.setPreferredSize(new Dimension(100, 20));
        this.textCodigoIDS.setMinimumSize(new Dimension(100, 20));
        this.panelIntegracaoIDS.add((Component)this.textCodigoIDS, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelIntegracaoIDS.add((Component)new JLabel(), c);
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.unidadeSaude(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("uns_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(7, 3));
        this.txtCodigo.setUpperCase(true);
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("unidadesaude", 1);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("uns_codigo", 0, false, true, this.txtCodigo.getTextDBEscape());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaUnidadeSaude());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace(), "Coleta");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(7, 18));
        this.txtCodigo.setUpperCase(true);
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCidade.setText(String.valueOf(ParametrosGerais.getCidCodigo()));
        this.txtCodigo.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                SalvaDados salvar = new SalvaDados("unidadesaude", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("uns_codigo", 0, false, true, this.txtCodigo.getTextDBEscape());
                salvar.adicionaCampo("uns_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("cid_codigo", 2, false, false, this.txtCidade.getText());
                salvar.adicionaCampo("uns_endereco", 0, true, false, this.txtEndereco.getTextDBEscape());
                salvar.adicionaCampo("uns_complemento", 0, true, false, this.txtComplemento.getTextDBEscape());
                salvar.adicionaCampo("bai_codigo", 0, true, false, Funcoes.textoVazio(this.txtCodBairro.getTextDB()) ? null : this.txtCodBairro.getTextDBEscape());
                salvar.adicionaCampo("uns_cep", 0, true, false, this.txtCEP.getTextDBEscape());
                salvar.adicionaCampo("uns_fone", 0, true, false, this.txtFone.getTextDBEscape());
                salvar.adicionaCampo("uns_integracaoids", 0, true, false, this.textCodigoIDS.getTextDBEscape());
                salvar.adicionaCampo("uns_sequencialequipe", 0, true, false, this.textSequencialEquipe.getTextDBEscape());
                salvar.adicionaCampo("uns_areaequipe", 0, true, false, this.textAreaEquipe.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaUnidadeSaude());
                this.retornoParaPesquisa = this.txtCodigo.getText();
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace(), "Coleta");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtEndereco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtComplemento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodBairro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCEP.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFone.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton1.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton2.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bBuscaCep.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoIDS.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textSequencialEquipe.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textAreaEquipe.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.txtCidade.setText("");
        this.txtDescCidade.setText("");
        this.txtEndereco.setText("");
        this.txtComplemento.setText("");
        this.txtCodBairro.setText("");
        this.txtDescBairro.setText("");
        this.txtCEP.setText("");
        this.txtFone.clear();
        this.textCodigoIDS.clear();
        this.textSequencialEquipe.clear();
        this.textAreaEquipe.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 2) {
            Statement st = Conexao.getStatement();
            try (ResultSet rs = null;){
                rs = Conexao.executeQuery(st, "select uns_codigo from unidadesaude where fil_codigo = " + Variaveis.filialPadrao + " and upper(uns_codigo)=upper(" + this.txtCodigo.getTextDBEscape().trim() + ") ");
                if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                    Funcoes.mensagem(this, "Coleta j\u00e1 cadastrada", 1);
                    this.txtCodigo.grabFocus();
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtCodigo.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (this.txtCidade.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo cidade n\u00e3o informado", 1);
            this.txtCidade.selectAll();
            this.txtCidade.grabFocus();
            return false;
        }
        if (this.txtCodBairro.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo bairro n\u00e3o informado", 1);
            this.txtCodBairro.selectAll();
            this.txtCodBairro.grabFocus();
            return false;
        }
        if (this.txtCidade.getText().trim().length() > 0 && this.txtDescCidade.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cidade n\u00e3o localizada", 1);
            this.txtCidade.selectAll();
            this.txtCidade.grabFocus();
            return false;
        }
        if (this.txtCodBairro.getText().trim().length() > 0 && this.txtDescBairro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Bairro n\u00e3o localizado", 1);
            this.txtCodBairro.selectAll();
            this.txtCodBairro.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCEP)) return true;
        if (CEP.tamanhoDoCepCorreto(this.txtCEP)) return true;
        Funcoes.mensagem(this, "CEP Inv\u00e1lido", 1);
        this.txtCEP.grabFocus();
        return false;
    }

    private void buscaCidade() {
        Hashtable resultado = Pesquisas.cidade(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCidade.setText(resultado.get("cid_codigo").toString());
        }
        this.txtCidade.requestFocus();
    }

    private void buscaBairro() {
        Hashtable resultado = Pesquisas.bairro(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodBairro.setText(resultado.get("bai_codigo").toString());
        }
        this.txtCodBairro.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCidade.hasFocus()) {
            this.buscaCidade();
        } else if (this.txtCodBairro.hasFocus()) {
            this.buscaBairro();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101400000");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "uns_codigo";
    }
}

