/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.Conversao;
import jalis.laboratorio.cadastro.DadosConversao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;

public class UnidadeMedida
extends FrmCadPadrao {
    private JLabel jLabel1 = new JLabel();
    private TTextField txtCodigo = new TTextField(8);
    private TTextField txtDescricao = new TTextField(80);
    private JLabel jLabel2 = new JLabel();
    private JButton bConversao = new JButton("Tabela de convers\u00e3o");
    private ArrayList conversao = new ArrayList();
    private String retornoParaPesquisa = "";

    public UnidadeMedida() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "UnidadeMedida");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("UnidadeMedida");
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao.setName("txtDescricao");
        this.setLabelDescricao("Cadastro de unidades de medida para materiais em estoque");
        this.setLabelFormulario("Cadastro de unidades de medida");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_unidade_medida.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.bConversao.setMnemonic('T');
        this.bConversao.setBounds(new Rectangle(292, 49, 180, 25));
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.bConversao, null);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (UnidadeMedida.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select unm_codigo, unm_descricao from unidademedida where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and upper(unm_codigo)=upper(").append(UnidadeMedida.this.txtCodigo.getTextDBEscape()).append(")");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs != null && rs.next()) {
                                UnidadeMedida.this.txtDescricao.setText(rs.getString("unm_descricao"));
                                if (UnidadeMedida.this.getStatus() == 2) {
                                    UnidadeMedida.this.setStatus(3);
                                }
                                buf.delete(0, buf.length());
                                buf.append("select a.unm_coddestino, a.cun_operacao, a.cun_fator, b.unm_descricao from conversaounidade a ");
                                buf.append("left join unidademedida b on a.fil_codigo = b.fil_codigo and upper(a.unm_coddestino)=upper(b.unm_codigo) ");
                                buf.append("where a.fil_codigo = ");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and upper(a.unm_codigo)=upper(").append(UnidadeMedida.this.txtCodigo.getTextDBEscape()).append(")");
                                ResultSet rconversao = Conexao.executeQuery(st, buf.toString());
                                if (rconversao != null) {
                                    String operacao = new String();
                                    while (rconversao.next()) {
                                        operacao = rconversao.getString("cun_operacao");
                                        operacao = operacao.equalsIgnoreCase("M") ? "Multiplicar" : "Dividir";
                                        UnidadeMedida.this.conversao.add(new DadosConversao(rconversao.getString("unm_coddestino"), rconversao.getString("unm_descricao"), operacao, rconversao.getDouble("cun_fator")));
                                    }
                                }
                                UnidadeMedida.this.txtCodigo.setEnabled(false);
                            } else if (UnidadeMedida.this.getStatus() == 3) {
                                Funcoes.mensagem(UnidadeMedida.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                UnidadeMedida.this.setStatus(1);
                                UnidadeMedida.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(UnidadeMedida.this, sqlex.getMessage(), sqlex.getStackTrace(), "UnidadeMedida");
                    }
                }
            }
        });
        this.bConversao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conversao c = new Conversao((Frame)Laboratorio.getInstancia(), "Tabela de convers\u00f5es");
                c.setConversao(UnidadeMedida.this.conversao);
                c.setUnidadePai(UnidadeMedida.this.txtCodigo.getText());
                c.setVisible(true);
                if (c.isOK()) {
                    UnidadeMedida.this.conversao = c.getConversao();
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(UnidadeMedida.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101300201"));
        this.setModuloEdita(Long.parseLong("0101300202"));
        this.setModuloApaga(Long.parseLong("0101300203"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.unidadeMedida(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("unm_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("unidademedida", 1);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("unm_codigo", 0, false, true, this.txtCodigo.getTextDBEscape());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaUnidadeMedida());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "UnidadeMedida");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodigo.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                SalvaDados salvar = new SalvaDados("unidademedida", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("unm_codigo", 0, false, true, this.txtCodigo.getTextDBEscape());
                salvar.adicionaCampo("unm_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaUnidadeMedida());
                salvar.limpar();
                salvar.setTabela("conversaounidade");
                salvar.setOperacao(1);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("unm_codigo", 0, false, true, StringUtil.textoDBEscape(this.txtCodigo.getText()));
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaUnidadeMedida());
                Util.gravaAlteracaoUnidadeMedida(statement, this.txtCodigo.getText());
                salvar.setTabela("conversaounidade");
                salvar.setOperacao(0);
                for (int i = 0; i < this.conversao.size(); ++i) {
                    DadosConversao c = (DadosConversao)this.conversao.get(i);
                    salvar.limpar();
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("unm_codigo", 0, false, true, StringUtil.textoDBEscape(this.txtCodigo.getText()));
                    salvar.adicionaCampo("unm_coddestino", 0, false, true, StringUtil.textoDBEscape(c.getCodigo()));
                    salvar.adicionaCampo("cun_operacao", 0, true, false, StringUtil.textoDBEscape(c.getOperacao().substring(0, 1)));
                    salvar.adicionaCampo("cun_fator", 0, true, false, StringUtil.textoDBEscape(Funcoes.limpaDecimal(String.valueOf(c.getFator()))));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaUnidadeMedida());
                }
                this.retornoParaPesquisa = this.txtCodigo.getText();
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "UnidadeMedida");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bConversao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.conversao.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 2) {
            Statement st = Conexao.getStatement();
            try (ResultSet rs = null;){
                rs = Conexao.executeQuery(st, "select unm_codigo from unidademedida where fil_codigo = " + Variaveis.filialPadrao + " and upper(unm_codigo)=upper(" + this.txtCodigo.getTextDBEscape() + ")");
                if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                    Funcoes.mensagem(this, "Unidade de medida j\u00e1 cadastrada", 1);
                    this.txtCodigo.grabFocus();
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtCodigo.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() != 0) return true;
        Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
        this.txtDescricao.selectAll();
        this.txtDescricao.grabFocus();
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101300200");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "unm_codigo";
    }
}

