/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosTipoUsuario;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class TiposUsuarioConvenio
extends AbstractDialogoOKCancelar
implements ActionListener {
    private TTextField textPercentual = new TTextField(10, 2, 4);
    private JComboBox comboTipo = new JComboBox();
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Percentual", "Tipo de usu\u00e1rio"});
    private JTable tabela = new JTable(this.modelo);
    private JButton buttonOKDesconto = ComponenteFactory.novoJButton("OK", this);
    private final int COLUNA_PERCENTUAL = 0;
    private final int COLUNA_TIPO = 1;
    private int editandoLinha = -1;

    public static TiposUsuarioConvenio novaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new TiposUsuarioConvenio((Dialog)owner);
        }
        if (owner instanceof Frame) {
            return new TiposUsuarioConvenio((Frame)owner);
        }
        return null;
    }

    public TiposUsuarioConvenio(Dialog pai) {
        super(pai, "Tipos de usu\u00e1rio");
        this.montaTela();
    }

    public TiposUsuarioConvenio(Frame pai) {
        super(pai, "Tipos de usu\u00e1rio");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(500, 300));
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.modelo.setColumnSize(new int[]{100, 0}, this.tabela);
        this.carregaTipos();
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        p.add((Component)new JLabel("Percentual"), c);
        ++c.gridx;
        p.add((Component)new JLabel("Tipo de Usu\u00e1rio"), c);
        ++c.gridy;
        c.gridx = 0;
        this.textPercentual.setPreferredSize(new Dimension(100, 20));
        this.textPercentual.setMinimumSize(new Dimension(100, 20));
        this.textPercentual.setMaximumSize(new Dimension(100, 20));
        p.add((Component)this.textPercentual, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.comboTipo.setPreferredSize(new Dimension(100, 20));
        this.comboTipo.setMinimumSize(new Dimension(100, 20));
        p.add((Component)this.comboTipo, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonOKDesconto.setPreferredSize(new Dimension(40, 20));
        this.buttonOKDesconto.setMinimumSize(new Dimension(40, 20));
        this.buttonOKDesconto.setMaximumSize(new Dimension(40, 20));
        p.add((Component)this.buttonOKDesconto, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        p.add((Component)new JScrollPane(this.tabela), c);
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && TiposUsuarioConvenio.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4) == 0) {
                    TiposUsuarioConvenio.this.modelo.removeLine(TiposUsuarioConvenio.this.tabela.getSelectedRow());
                } else if (e.getKeyCode() == 32 && TiposUsuarioConvenio.this.tabela.getSelectedRow() > -1) {
                    TiposUsuarioConvenio.this.editandoLinha = TiposUsuarioConvenio.this.tabela.getSelectedRow();
                    TiposUsuarioConvenio.this.textPercentual.setText(TiposUsuarioConvenio.this.modelo.getValueAt(TiposUsuarioConvenio.this.editandoLinha, 0).toString());
                    TiposUsuarioConvenio.this.comboTipo.setSelectedItem(TiposUsuarioConvenio.this.modelo.getValueAt(TiposUsuarioConvenio.this.editandoLinha, 1));
                    ScreenUtil.requisitarFoco(TiposUsuarioConvenio.this.textPercentual);
                }
            }
        });
    }

    private void carregaTipos() {
        Statement st;
        block5: {
            this.comboTipo.removeAllItems();
            st = Conexao.getStatement();
            try {
                ResultSet rs;
                if (st == null || (rs = Conexao.executeQuery(st, "select tpu_codigo, tpu_descricao from tipousuario order by tpu_descricao")) == null) break block5;
                while (rs.next()) {
                    this.comboTipo.addItem(new DadosTipoUsuario(rs.getString("tpu_codigo"), rs.getString("tpu_descricao")));
                }
            }
            catch (SQLException sqlex) {
                try {
                    ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "TiposUsuarioConvenio: 5467");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    private void adicionarDesconto() {
        if (Funcoes.isNumeric(this.textPercentual.getText()) && this.comboTipo.getSelectedItem() != null) {
            DadosTipoUsuario dados = (DadosTipoUsuario)this.comboTipo.getSelectedItem();
            String valor = Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())));
            if (this.editandoLinha > -1) {
                this.modelo.setValueAt(valor, this.editandoLinha, 0);
                this.modelo.setValueAt(this.comboTipo.getSelectedItem(), this.editandoLinha, 1);
                this.editandoLinha = -1;
            } else {
                int pos = this.modelo.localizar(1, this.comboTipo.getSelectedItem().toString());
                if (pos < 0) {
                    this.modelo.addLine(new Object[]{valor, this.comboTipo.getSelectedItem()});
                } else {
                    this.modelo.setValueAt(valor, pos, 0);
                }
            }
        }
        this.textPercentual.clear();
        ScreenUtil.requisitarFoco(this.textPercentual);
    }

    private int tipoAdicionado(DadosTipoUsuario d) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!(this.modelo.getValueAt(i, 1) instanceof DadosTipoUsuario) || !((DadosTipoUsuario)this.modelo.getValueAt(i, 1)).getCodigo().equals(d.getCodigo())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKDesconto) {
            this.adicionarDesconto();
        } else {
            super.actionPerformed(e);
        }
    }

    public void adicionaPercentual(String percentual, DadosTipoUsuario tipo) {
        if (tipo != null && this.tipoAdicionado(tipo) < 0) {
            String valor = Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), Double.parseDouble(Funcoes.limpaDecimal(percentual)));
            this.modelo.addLine(new Object[]{valor, tipo});
        }
    }

    public HashMap<DadosTipoUsuario, String> getPercentuais() {
        HashMap<DadosTipoUsuario, String> retorno = new HashMap<DadosTipoUsuario, String>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!(this.modelo.getValueAt(i, 1) instanceof DadosTipoUsuario)) continue;
            retorno.put((DadosTipoUsuario)this.modelo.getValueAt(i, 1), this.modelo.getValueAt(i, 0).toString());
        }
        return retorno;
    }
}

