/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.exame.TipoMaterialColetaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.TipoMaterialColetaVO;
import jalis.service.cadastro.exame.TipoMaterialColetaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.JLabel;

public class TipoMaterialColeta
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo: ");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelIncerteza = new JLabel("Incerteza: ");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(80, 3);
    private TTextField textIncerteza = new TTextField(12, 2);
    private TipoMaterialColetaBean tmc;
    private String retornoParaPesquisa = null;

    public TipoMaterialColeta() {
        this.montaTela();
        this.service = new TipoMaterialColetaService();
        this.tmc = new TipoMaterialColetaBean();
    }

    private void montaTela() {
        this.setName("TipoMaterialColeta");
        this.setLabelFormulario("Cadastro de tipo de material coletado");
        this.setLabelDescricao("Cadastro de tipos dos materiais de coleta");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_mat_coleta.jpg"));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.fill = 0;
        g.gridx = 0;
        g.gridy = 0;
        g.weighty = 0.0;
        g.weightx = 0.0;
        this.painelCentral.add((Component)this.labelCodigo, g);
        ++g.gridx;
        this.textCodigo.setPreferredSize(new Dimension(100, 20));
        this.textCodigo.setMinimumSize(new Dimension(100, 20));
        this.textCodigo.setName("textCodigo");
        this.painelCentral.add((Component)this.textCodigo, g);
        g.gridx = 0;
        ++g.gridy;
        this.labelDescricao.setDisplayedMnemonic('E');
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.textDescricao.setName("textDescricao");
        this.painelCentral.add((Component)this.labelDescricao, g);
        ++g.gridx;
        g.gridwidth = 2;
        g.weightx = 1.0;
        g.fill = 2;
        this.painelCentral.add((Component)this.textDescricao, g);
        this.labelIncerteza.setDisplayedMnemonic('I');
        this.labelIncerteza.setLabelFor(this.textIncerteza);
        g.gridwidth = 1;
        g.weightx = 0.0;
        g.fill = 0;
        g.gridx = 0;
        ++g.gridy;
        this.painelCentral.add((Component)this.labelIncerteza, g);
        ++g.gridx;
        this.textIncerteza.setPreferredSize(new Dimension(100, 20));
        this.textIncerteza.setMinimumSize(new Dimension(100, 20));
        this.painelCentral.add((Component)this.textIncerteza, g);
        this.textIncerteza.setName("textIncerteza");
        g.gridx = 0;
        ++g.gridy;
        g.weightx = 1.0;
        g.weighty = 1.0;
        g.fill = 1;
        g.gridwidth = 3;
        this.painelCentral.add((Component)new JLabel(), g);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.controlaCampos();
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(TipoMaterialColeta.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901601"));
        this.setModuloEdita(Long.parseLong("0101901602"));
        this.setModuloApaga(Long.parseLong("0101901603"));
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void salvar() {
        TipoMaterialColetaBean bean;
        if (this.validaCampos() && (bean = (TipoMaterialColetaBean)this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e1.getStackTrace());
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar tipo de material de coleta.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "tmc_codigo";
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.textIncerteza.setText("");
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textIncerteza.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901600");
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        TipoMaterialColetaService service = new TipoMaterialColetaService();
        TipoMaterialColetaVO vo = (TipoMaterialColetaVO)service.pesquisaVO(Laboratorio.getInstancia(), new TipoMaterialColetaVO(), "Pesquisando tipo de material coletado", false);
        if (vo != null) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", vo.getFilial().getCodigo());
            chaves.put("tmc_codigo", vo.getCodigo());
            try {
                return (TipoMaterialColetaBean)service.getBean(chaves);
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        TipoMaterialColetaBean bean = new TipoMaterialColetaBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setFilial(filial);
        if (!Funcoes.textoVazio(this.textCodigo)) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setDescricao(this.textDescricao.getText());
        if (!Funcoes.textoVazio(this.textIncerteza)) {
            bean.setIncerteza(Double.parseDouble(Funcoes.limpaDecimal(this.textIncerteza.getText())));
        }
        return bean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean != null && bean instanceof TipoMaterialColetaBean) {
            TipoMaterialColetaBean tipo = (TipoMaterialColetaBean)bean;
            this.textCodigo.setText(tipo.getCodigo().toString());
            this.textDescricao.setText(tipo.getDescricao());
            this.textIncerteza.setText(Funcoes.formataDecimal(tipo.getIncerteza()));
        }
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaTipoMaterialColeta();
    }
}

