/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JLabel;

public class TipoMaterial
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private String retornoParaPesquisa = "";

    public TipoMaterial() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TipoMaterial");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("TipoMaterial");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtDescricao = new TTextField(80);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.setLabelDescricao("Cadastro de tipos de material para controle de estoque");
        this.setLabelFormulario("Cadastro de tipos de material");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_tipo_material.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TipoMaterial.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(TipoMaterial.this.txtCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            ResultSet rs = Conexao.executeQuery(st, "select tpm_codigo, tpm_descricao from tipomaterial where fil_codigo = " + Variaveis.filialPadrao + " and tpm_codigo=" + TipoMaterial.this.txtCodigo.getText());
                            if (rs.next()) {
                                TipoMaterial.this.txtDescricao.setText(rs.getString("tpm_descricao"));
                                TipoMaterial.this.txtCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(TipoMaterial.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                TipoMaterial.this.setStatus(1);
                                TipoMaterial.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(TipoMaterial.this, sqlex.getMessage(), sqlex.getStackTrace(), "TipoMaterial");
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(TipoMaterial.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101300101"));
        this.setModuloEdita(Long.parseLong("0101300102"));
        this.setModuloApaga(Long.parseLong("0101300103"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.tipoMaterial(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("tpm_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("tipomaterial", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("tpm_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTipoMaterial());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TipoMaterial");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "tipomaterial", true);
                }
                SalvaDados salvar = new SalvaDados("tipomaterial", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("tpm_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("tpm_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTipoMaterial(), "tipomaterial", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TipoMaterial");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101300100");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "tpm_codigo";
    }
}

