/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.layout.TiposImpressao;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirTermoConsentimento;
import jalis.model.bean.cadastro.exame.LayoutBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.ModeloTermoConsentimentoVO;
import jalis.model.vo.cadastro.auxiliares.TermoConsentimentoVO;
import jalis.relatorio.Editor;
import jalis.service.cadastro.auxiliares.TermoConsentimentoService;
import jalis.service.cadastro.exame.LayoutService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TermoConsentimento
extends FrmCadPadrao {
    private ModeloGridTable modelosTermo = null;
    private JTable tableTermo = null;
    private JScrollPane scroll = null;
    private TTextField txtCodTermo = ComponenteFactory.novoTTextField(20, 1);
    private TTextField txtDescTermo = ComponenteFactory.novoTTextField(80, 3);
    private TTextField txtCodModelo = new TTextField(9, 1);
    private TTextField txtDescModelo = ComponenteFactory.novoTTextField(80, 3);
    private JLabel jLabelCodigoTermo = new JLabel("C\u00f3digo:");
    private JLabel jLabelDescricaoTermo = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel jLabelModelo = new JLabel("Modelo");
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    private JButton buttonDefPadrao = new JButton();
    private JButton buttonModelo = new JButton();
    private JButton buttonPesq = new JButton();
    private JButton buttonOK = new JButton();
    private TiposImpressao tipoImpressaoSelecionado = TiposImpressao.GRAFICA;
    private JPopupMenu menuModelo = new JPopupMenu("");
    private JMenu menuTipo = new JMenu("Tipo");
    private JCheckBoxMenuItem itemFormatoRelatorio = new JCheckBoxMenuItem("Formato Relat\u00f3rio");
    private JCheckBoxMenuItem itemFormatoExame = new JCheckBoxMenuItem("Formato Exame");
    private JMenu menuNovoAlterar = new JMenu("Novo/Alterar");
    private JMenuItem itemCabecalho = new JMenuItem("Cabe\u00e7alho");
    private JMenuItem itemCorpo = new JMenuItem("Corpo");
    private JMenuItem menuCopiar = new JMenuItem("Copiar modelo");
    private int linhaAlterada = -1;
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_MODELO = 1;
    private static final int COLUNA_PADRAO = 2;
    private static final int COLUNA_OBJETO = 3;
    private static final String TERMO_TIPO_RELATORIO = "R";
    private static final String TERMO_TIPO_EXAME = "E";
    private static final String TERMO_VAZIO = "";
    private String retornoParaPesquisa = "";
    private String modeloPadrao = "";
    private final TermoConsentimentoService service = new TermoConsentimentoService();
    private final ImprimirTermoConsentimento imprimirTermoConsentimento = new ImprimirTermoConsentimento();
    private TermoConsentimentoVO termoConsentimento = null;
    private ModeloTermoConsentimentoVO modeloSelecionado;

    public TermoConsentimento() {
        this.montaTela();
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(TermoConsentimento.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0105500104"));
        this.setModuloEdita(Long.parseLong("0105500102"));
        this.setModuloApaga(Long.parseLong("0105500103"));
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0105500101");
    }

    public void montaTela() {
        this.setName("Termo de Consentimento");
        this.painelCentral.setLayout(new GridBagLayout());
        this.setLabelDescricao("Cadastro de termo de Consentimento");
        this.setLabelFormulario("Cadastro de termo de Consentimento");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_termo_consentimento.jpg"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 13;
        c.anchor = 17;
        c.insets = new Insets(1, 5, 0, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.jLabelCodigoTermo, c);
        ++c.gridx;
        c.insets = new Insets(1, 25, 0, 1);
        this.txtCodTermo.setPreferredSize(new Dimension(70, 20));
        this.txtCodTermo.setMinimumSize(new Dimension(70, 20));
        this.txtCodTermo.setEnabled(false);
        this.txtCodTermo.setName("txtCodTermo");
        this.painelCentral.add((Component)this.txtCodTermo, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = new Insets(1, 350, 0, 1);
        c.fill = 2;
        this.checkInativo.setEnabled(false);
        this.painelCentral.add((Component)this.checkInativo, c);
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(1, 5, 0, 1);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        this.painelCentral.add((Component)this.jLabelDescricaoTermo, c);
        ++c.gridx;
        c.insets = new Insets(0, 25, 0, 50);
        c.fill = 0;
        this.txtDescTermo.setPreferredSize(new Dimension(500, 20));
        this.txtDescTermo.setMinimumSize(new Dimension(500, 20));
        this.txtDescTermo.setName("txtDescTermo");
        this.txtDescTermo.setEnabled(false);
        this.painelCentral.add((Component)this.txtDescTermo, c);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Modelos para termo de consentimento"));
        panel.setPreferredSize(new Dimension(400, 400));
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.insets = new Insets(10, 60, 0, 150);
        c.fill = 2;
        c.anchor = 17;
        this.painelCentral.add((Component)panel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.gridx = 0;
        c.anchor = 13;
        c.fill = 0;
        c.insets = new Insets(1, 0, 0, 230);
        this.buttonDefPadrao.setText("Definir como padr\u00e3o");
        this.buttonDefPadrao.setMnemonic('D');
        this.buttonDefPadrao.setEnabled(false);
        this.painelCentral.add((Component)this.buttonDefPadrao, c);
        ++c.gridx;
        ++c.gridx;
        c.insets = new Insets(1, 0, 0, 150);
        c.fill = 0;
        this.buttonModelo.setText("Modelo");
        this.buttonModelo.setMnemonic('M');
        this.buttonModelo.setEnabled(false);
        this.painelCentral.add((Component)this.buttonModelo, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 17;
        JLabel dsd = new JLabel();
        this.painelCentral.add((Component)dsd, c);
        GridBagConstraints p = new GridBagConstraints();
        p.fill = 13;
        p.anchor = 17;
        p.gridx = 0;
        p.gridy = 0;
        p.weightx = 0.0;
        p.weighty = 0.0;
        p.insets = new Insets(1, 3, 0, 1);
        panel.add((Component)this.jLabelModelo, p);
        p.gridx = 0;
        ++p.gridy;
        p.insets = new Insets(1, 0, 0, 0);
        this.txtCodModelo.setPreferredSize(new Dimension(80, 20));
        this.txtCodModelo.setMinimumSize(new Dimension(80, 20));
        this.txtCodModelo.setEnabled(false);
        panel.add((Component)this.txtCodModelo, p);
        p.insets = new Insets(1, 0, 0, 1);
        ++p.gridx;
        Funcoes.imagemPesquisa(this.buttonPesq);
        this.buttonPesq.setFocusable(false);
        this.buttonPesq.setMaximumSize(null);
        this.buttonPesq.setEnabled(false);
        this.buttonPesq.setPreferredSize(new Dimension(20, 20));
        this.buttonPesq.setMinimumSize(new Dimension(20, 20));
        panel.add((Component)this.buttonPesq, p);
        ++p.gridx;
        p.weightx = 1.0;
        p.insets = new Insets(1, 0, 0, 0);
        p.fill = 2;
        p.anchor = 13;
        this.txtDescModelo.setPreferredSize(new Dimension(510, 20));
        this.txtDescModelo.setMinimumSize(new Dimension(510, 20));
        this.txtDescModelo.setEnabled(false);
        panel.add((Component)this.txtDescModelo, p);
        ++p.gridx;
        p.weightx = 0.0;
        p.fill = 0;
        p.insets = new Insets(1, 0, 0, 2);
        this.buttonOK.setMargin(new Insets(1, 0, 1, 1));
        this.buttonOK.setText("OK");
        this.buttonOK.setMnemonic('O');
        this.buttonOK.setPreferredSize(new Dimension(30, 20));
        this.buttonOK.setMinimumSize(new Dimension(30, 20));
        this.buttonOK.setEnabled(false);
        panel.add((Component)this.buttonOK, p);
        this.modelosTermo = new ModeloGridTable(new String[]{"C\u00f3digo", "Modelo", "MP"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] valores = new Class[]{Integer.class, String.class, String.class};
                return valores[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                boolean[] valores = new boolean[]{false, false, false};
                return valores[columnIndex];
            }
        };
        this.tableTermo = new JTable(this.modelosTermo);
        this.modelosTermo.setColumnSize(new int[]{72, 0, 72}, this.tableTermo);
        this.tableTermo.getTableHeader().addMouseListener(this.modelosTermo);
        this.scroll = new JScrollPane(this.tableTermo);
        this.scroll.setPreferredSize(new Dimension(100, 100));
        this.scroll.setMinimumSize(new Dimension(100, 100));
        p.insets = new Insets(1, 0, 0, 1);
        p.weightx = 1.0;
        p.weighty = 1.0;
        ++p.gridy;
        p.gridx = 0;
        p.gridwidth = 5;
        p.fill = 1;
        panel.add((Component)this.scroll, p);
        this.menuTipo.add(this.itemFormatoRelatorio);
        this.menuTipo.add(this.itemFormatoExame);
        this.menuModelo.add(this.menuTipo);
        this.menuModelo.add(this.menuNovoAlterar);
        this.menuModelo.add(this.menuCopiar);
        this.tableTermo.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TermoConsentimento.this.modelosTermo.getRowCount() > 0 && TermoConsentimento.this.tableTermo.getSelectedRow() > -1) {
                    TermoConsentimento.this.modeloSelecionado = (ModeloTermoConsentimentoVO)TermoConsentimento.this.modelosTermo.getValueAt(TermoConsentimento.this.tableTermo.getSelectedRow(), 3);
                    TermoConsentimento.this.itemFormatoRelatorio.setSelected(!Funcoes.textoVazio(TermoConsentimento.this.modeloSelecionado.getTipo()) && TermoConsentimento.this.modeloSelecionado.getTipo().equals(TermoConsentimento.TERMO_TIPO_RELATORIO));
                    TermoConsentimento.this.itemFormatoExame.setSelected(!Funcoes.textoVazio(TermoConsentimento.this.modeloSelecionado.getTipo()) && TermoConsentimento.this.modeloSelecionado.getTipo().equals(TermoConsentimento.TERMO_TIPO_EXAME));
                }
            }
        });
        this.tableTermo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127) {
                    int row2 = ((JTable)e.getSource()).getSelectedRow();
                    if (row2 >= 0) {
                        int resp = 0;
                        resp = Funcoes.mensagem(TermoConsentimento.this.painelCentral, "Deseja remover o modelo?", 4);
                        if (resp == 0) {
                            TermoConsentimento.this.modelosTermo.removeLine(row2);
                        }
                    }
                } else if (e.getKeyCode() == 32 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    TermoConsentimento.this.linhaAlterada = row;
                    TermoConsentimento.this.txtCodModelo.setText(TermoConsentimento.this.modelosTermo.getValueAt(row, 0).toString());
                    TermoConsentimento.this.txtDescModelo.setText(TermoConsentimento.this.modelosTermo.getValueAt(row, 1).toString());
                    ScreenUtil.requisitarFoco(TermoConsentimento.this.txtCodModelo);
                    TermoConsentimento.this.txtDescModelo.setEditable(false);
                }
            }
        });
        this.txtCodModelo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TermoConsentimento.this.txtCodModelo.getText().isEmpty()) {
                    TermoConsentimento.this.txtDescModelo.setText(TermoConsentimento.TERMO_VAZIO);
                    return;
                }
                LayoutBean bean = null;
                if (TermoConsentimento.this.txtCodModelo.getText().trim().length() > 0 && Funcoes.isNumeric(TermoConsentimento.this.txtCodModelo.getText().trim())) {
                    try {
                        bean = (LayoutBean)new LayoutService().get(Variaveis.filialPadrao, TermoConsentimento.this.txtCodModelo.getText());
                    }
                    catch (Exception e1) {
                        TermoConsentimento.this.txtDescModelo.setText("N\u00e3o cadastrado");
                        return;
                    }
                    if (bean != null) {
                        TermoConsentimento.this.txtCodModelo.setText(bean.getCodigo().toString());
                        TermoConsentimento.this.txtDescModelo.setText(bean.getDescricao());
                    } else {
                        TermoConsentimento.this.txtDescModelo.setText("N\u00e3o cadastrado");
                    }
                }
            }
        });
        this.txtCodModelo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TermoConsentimento.this.pesquisarModelos();
                }
            }
        });
        this.txtCodTermo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TermoConsentimento.this.buttonPesq.doClick();
                }
            }
        });
        this.txtCodTermo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TermoConsentimento.this.txtCodTermo.getText().isEmpty()) {
                    TermoConsentimento.this.txtDescTermo.setText(TermoConsentimento.TERMO_VAZIO);
                    return;
                }
                TermoConsentimentoVO vo = null;
                if (Funcoes.isNumeric(TermoConsentimento.this.txtCodTermo.getText())) {
                    try {
                        vo = TermoConsentimento.this.service.getTermoConsentimento(Variaveis.filialPadrao.toString(), Integer.parseInt(TermoConsentimento.this.txtCodTermo.getText()));
                        if (vo != null) {
                            TermoConsentimento.this.preencherCampos(vo);
                        } else {
                            TermoConsentimento.this.txtDescTermo.grabFocus();
                        }
                    }
                    catch (Exception e1) {
                        TermoConsentimento.this.txtDescTermo.setText("N\u00e3o cadastrado");
                        return;
                    }
                }
            }
        });
        this.buttonPesq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermoConsentimento.this.pesquisarModelos();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermoConsentimento.this.validaModelo();
            }
        });
        this.buttonModelo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TermoConsentimento.this.tableTermo.getSelectedRow() > -1) {
                    if (TermoConsentimento.this.itemFormatoExame.isSelected()) {
                        TermoConsentimento.this.menuNovoAlterar.add(TermoConsentimento.this.itemCabecalho);
                        TermoConsentimento.this.menuNovoAlterar.add(TermoConsentimento.this.itemCorpo);
                    } else {
                        TermoConsentimento.this.menuNovoAlterar.add(TermoConsentimento.this.itemCorpo);
                        TermoConsentimento.this.menuNovoAlterar.remove(TermoConsentimento.this.itemCabecalho);
                    }
                    TermoConsentimento.this.menuModelo.show(TermoConsentimento.this.buttonModelo.getParent(), TermoConsentimento.this.buttonModelo.getX(), TermoConsentimento.this.buttonModelo.getY() + TermoConsentimento.this.buttonModelo.getHeight());
                }
            }
        });
        this.buttonDefPadrao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TermoConsentimento.this.tableTermo.getSelectedRow() > -1) {
                    int linhaAtual = -1;
                    for (int i = 0; i < TermoConsentimento.this.modelosTermo.getRowCount(); ++i) {
                        if (!((String)TermoConsentimento.this.modelosTermo.getValueAt(i, 2)).equals("SIM")) continue;
                        linhaAtual = i;
                        TermoConsentimento.this.modelosTermo.setValueAt(TermoConsentimento.TERMO_VAZIO, i, 2);
                        break;
                    }
                    TermoConsentimento.this.modelosTermo.setValueAt("SIM", TermoConsentimento.this.tableTermo.getSelectedRow(), 2);
                    TermoConsentimento.this.tableTermo.revalidate();
                    TermoConsentimento.this.tableTermo.repaint();
                }
                TermoConsentimento.this.tableTermo.grabFocus();
            }
        });
        this.itemFormatoExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TermoConsentimento.this.itemFormatoExame.isSelected()) {
                    if (!Funcoes.textoVazio(TermoConsentimento.this.modeloSelecionado.getTipo()) && TermoConsentimento.this.modeloSelecionado.getTipo().equals(TermoConsentimento.TERMO_TIPO_RELATORIO)) {
                        TermoConsentimento.this.modeloSelecionado.setLayout(TermoConsentimento.TERMO_VAZIO);
                    }
                    TermoConsentimento.this.modeloSelecionado.setTipo(TermoConsentimento.TERMO_TIPO_EXAME);
                    TermoConsentimento.this.itemFormatoRelatorio.setSelected(false);
                }
            }
        });
        this.itemFormatoRelatorio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TermoConsentimento.this.itemFormatoRelatorio.isSelected()) {
                    if (!Funcoes.textoVazio(TermoConsentimento.this.modeloSelecionado.getTipo()) && TermoConsentimento.this.modeloSelecionado.getTipo().equals(TermoConsentimento.TERMO_TIPO_EXAME)) {
                        TermoConsentimento.this.modeloSelecionado.setLayout(TermoConsentimento.TERMO_VAZIO);
                    }
                    TermoConsentimento.this.modeloSelecionado.setTipo(TermoConsentimento.TERMO_TIPO_RELATORIO);
                    TermoConsentimento.this.itemFormatoExame.setSelected(false);
                }
            }
        });
        this.itemCabecalho.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xml = TermoConsentimento.this.configurar(true);
                if (!Funcoes.textoVazio(xml)) {
                    TermoConsentimento.this.modeloSelecionado.setLayout(xml);
                }
            }
        });
        this.itemCorpo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xml = TermoConsentimento.this.configurar(false);
                if (!Funcoes.textoVazio(xml)) {
                    if (!TermoConsentimento.this.itemFormatoExame.isSelected() && !TermoConsentimento.this.itemFormatoRelatorio.isSelected()) {
                        TermoConsentimento.this.modeloSelecionado.setTipo(TermoConsentimento.TERMO_TIPO_RELATORIO);
                        TermoConsentimento.this.itemFormatoRelatorio.setSelected(true);
                    }
                    TermoConsentimento.this.modeloSelecionado.setLayout(xml);
                }
            }
        });
        this.menuCopiar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermoConsentimento.this.copiarModelo();
            }
        });
    }

    public void keyPressed(KeyEvent e) {
        Object o = e.getSource();
        if (e.getKeyCode() == 113 && o == this.txtCodModelo) {
            this.pesquisarModelos();
        }
    }

    private void controlaCampos() {
        this.txtDescTermo.setEnabled(this.habilitaDesabilitaCampo());
        this.txtCodTermo.setEditable(this.habilitaDesabilitaCampo());
        this.txtCodModelo.setEnabled(this.habilitaDesabilitaCampo());
        this.txtDescModelo.setEnabled(this.habilitaDesabilitaCampo());
        this.txtDescModelo.setEditable(false);
        this.buttonPesq.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonOK.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDefPadrao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonModelo.setEnabled(this.habilitaDesabilitaCampo());
        if (this.getStatus() == 3) {
            this.checkInativo.setEnabled(true);
            this.txtCodTermo.setEditable(false);
        } else if (this.getStatus() == 1) {
            this.checkInativo.setEnabled(false);
        }
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    private void limparCampos() {
        this.txtCodTermo.setText(TERMO_VAZIO);
        this.txtDescTermo.setText(TERMO_VAZIO);
        this.txtCodModelo.setText(TERMO_VAZIO);
        this.txtDescModelo.setText(TERMO_VAZIO);
        this.modelosTermo.clear();
        this.checkInativo.setSelected(false);
        this.itemFormatoExame.setSelected(false);
        this.itemFormatoRelatorio.setSelected(false);
    }

    private TermoConsentimentoVO pesquisarTermos() {
        try {
            Hashtable resultado = Pesquisas.termoConsentimento(this.getTopLevelAncestor(), false);
            if (resultado != null) {
                TermoConsentimentoVO termo = this.service.getTermoConsentimento(Variaveis.filialPadrao, Integer.parseInt(resultado.get("mtc_codigo").toString()));
                this.txtCodTermo.setText(termo.getCodigo().toString());
                this.txtDescTermo.setText(termo.getDescricao());
                this.checkInativo.setSelected(termo.getInativo());
                if (termo != null) {
                    this.buscarModelosTermo(this.txtCodTermo.getText());
                    return termo;
                }
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "Erro ao carregar Termos.", 2);
        }
        return null;
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.termoConsentimento(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodTermo.setText(resultado.get("mtc_codigo").toString());
        }
        this.txtCodTermo.requestFocus();
        return retorno;
    }

    private LayoutBean pesquisarModelos() {
        try {
            Hashtable resultado = Pesquisas.layout(this.getTopLevelAncestor(), false);
            if (resultado != null) {
                LayoutBean layout = (LayoutBean)new LayoutService().get(Variaveis.filialPadrao, resultado.get("lay_codigo").toString());
                this.txtCodModelo.setText(resultado.get("lay_codigo").toString());
                this.txtDescModelo.setText((String)resultado.get("lay_descricao"));
                this.modeloPadrao = (String)resultado.get("layoutpadrao");
                if (layout != null) {
                    return layout;
                }
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "Erro ao carregar modelos.", 2);
        }
        return null;
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.txtDescTermo.grabFocus();
        this.controlaCampos();
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        this.termoConsentimento = this.pesquisarTermos();
        if (this.termoConsentimento != null) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodTermo.setEditable(false);
            this.txtDescTermo.grabFocus();
        }
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodTermo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "termoconsentimento", true);
                }
                SalvaDados salvar = new SalvaDados("termoconsentimento", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(true);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("mtc_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("mtc_descricao", 0, true, false, this.txtDescTermo.getText());
                salvar.adicionaCampo("mtc_inativo", 4, true, false, this.checkInativo.isSelected());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTermoConsentimento(), "termoconsentimento", Integer.parseInt(codigo));
                salvar.limpar();
                salvar.setTabela("modelotermoconsentimento");
                salvar.setOperacao(1);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("mtc_codigo", 2, false, true, codigo);
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTermoConsentimento());
                if (this.modelosTermo.getRowCount() > 0) {
                    salvar.setOperacao(0);
                    for (int i = 0; i < this.modelosTermo.getRowCount(); ++i) {
                        SalvaDados select = new SalvaDados();
                        select.setTabela("termoconsentimento");
                        select.setOperacao(1);
                        select.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                        select.adicionaCampo("mtc_codigo", 2, false, true, codigo);
                        ModeloTermoConsentimentoVO modelo = (ModeloTermoConsentimentoVO)this.modelosTermo.getValueAt(i, 3);
                        String termo = this.validaModeloTermo(modelo.getLayout(), modelo.getTipo());
                        salvar.limpar();
                        salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                        salvar.adicionaCampo("mtc_codigo", 2, false, true, codigo);
                        salvar.adicionaCampo("lay_codigo", 2, false, true, modelo.getCodLayout());
                        salvar.adicionaCampo("mmt_padrao", 4, true, false, !Funcoes.textoVazio((String)this.modelosTermo.getValueAt(i, 2)));
                        salvar.adicionaCampo("mmt_formato", 0, true, false, termo);
                        salvar.adicionaCampo("mmt_tipo", 0, true, false, Funcoes.textoVazio(termo) ? null : modelo.getTipo());
                        DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTermoConsentimento(), select);
                    }
                }
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TermoConsentimento (650)");
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private String validaModeloTermo(String termo, String tipoTermo) {
        if (termo != null && tipoTermo != null) {
            if (tipoTermo.equals(TERMO_TIPO_EXAME) ? Funcoes.textoVazio(StringUtil.getValor(termo, "corpo")) && Funcoes.textoVazio(StringUtil.getValor(termo, "cabecalho")) : Funcoes.textoVazio(TermoConsentimento.getTagValue(termo, "bandas"))) {
                return TERMO_VAZIO;
            }
            return termo;
        }
        return TERMO_VAZIO;
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("termoconsentimento", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mtc_codigo", 2, false, true, this.txtCodTermo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTermoConsentimento());
                    Conexao.arquivaSQL();
                }
            }
            catch (SQLException sqlex) {
                try {
                    Conexao.anulaSQL();
                    Funcoes.mensagem(this, "Ocorreu uma situa\u00e7\u00e3o inesperada ao efetuar a opera\u00e7\u00e3o no banco de dados", 1);
                }
                catch (Exception ex) {
                    Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                }
            }
            catch (Exception ex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtDescTermo) && this.getStatus() == 2) {
            Funcoes.mensagem(this, "Informe a descri\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.txtDescTermo);
            return false;
        }
        if (this.validaMetodoPadrao()) {
            Funcoes.mensagem(this, "Defina um modelo como padr\u00e3o.", 2);
            return false;
        }
        if (this.itemFormatoExame.isSelected() && this.itemFormatoRelatorio.isSelected()) {
            Funcoes.mensagem(this, "Selecione apenas um formato de Termo consentimento.", 2);
            return false;
        }
        boolean layoutConfigurado = false;
        for (int i = 0; i < this.modelosTermo.getRowCount(); ++i) {
            ModeloTermoConsentimentoVO modeloTermo = (ModeloTermoConsentimentoVO)this.modelosTermo.getValueAt(i, 3);
            if (Funcoes.textoVazio(this.validaModeloTermo(modeloTermo.getLayout(), modeloTermo.getTipo()))) continue;
            layoutConfigurado = true;
            break;
        }
        if (!layoutConfigurado) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 modelo de Termo configurado.", 2);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "mtc_codigo";
    }

    private void validaModelo() {
        if (this.txtCodModelo.getText().isEmpty()) {
            Funcoes.mensagem(this, "O c\u00f3digo do modelo n\u00e3o foi informado.", 2);
            if (this.txtCodModelo.isEnabled() && this.txtCodModelo.isFocusable()) {
                this.txtCodModelo.grabFocus();
            }
            return;
        }
        if (this.txtDescModelo.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe um modelo cadastrado.", 2);
            ScreenUtil.requisitarFoco(this.txtCodModelo);
            this.txtCodModelo.setText(TERMO_VAZIO);
            this.txtDescModelo.setText(TERMO_VAZIO);
            return;
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        try {
            ModeloTermoConsentimentoVO modelo = new ModeloTermoConsentimentoVO();
            this.modeloPadrao = new LayoutService().buscaModeloPadrao(Variaveis.filialPadrao, this.txtCodModelo.getText());
            modelo.setFilial(filial);
            modelo.setCodLayout(Integer.parseInt(this.txtCodModelo.getText()));
            modelo.setDescricao(this.txtDescModelo.getText());
            modelo.setModeloPadrao(!Funcoes.textoVazio(this.modeloPadrao));
            for (int j = 0; j < this.modelosTermo.getRowCount(); ++j) {
                if (!((String)this.modelosTermo.getValueAt(j, 2)).equals("SIM") || Funcoes.textoVazio(this.modeloPadrao)) continue;
                this.modelosTermo.setValueAt(TERMO_VAZIO, j, 2);
            }
            this.adicionaModeloTermo(modelo, this.modeloPadrao);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.txtCodModelo.setText(TERMO_VAZIO);
        this.txtDescModelo.setText(TERMO_VAZIO);
        this.itemFormatoExame.setSelected(false);
        this.itemFormatoRelatorio.setSelected(false);
        ScreenUtil.requisitarFoco(this.txtCodModelo);
    }

    private void adicionaModeloTermo(ModeloTermoConsentimentoVO layout, String modeloPdr) {
        if (layout == null) {
            return;
        }
        for (int i = 0; i < this.modelosTermo.getRowCount(); ++i) {
            int aux;
            if (i == this.linhaAlterada || (aux = ((Integer)this.modelosTermo.getValueAt(i, 0)).intValue()) == 0 || aux != layout.getCodLayout()) continue;
            Funcoes.mensagem(this, "Modelo j\u00e1 inserido.", 2);
            if (this.txtCodModelo.isFocusable() && this.txtCodModelo.isEnabled()) {
                this.txtCodModelo.grabFocus();
            }
            return;
        }
        if (this.linhaAlterada > -1) {
            this.modelosTermo.setValueAt(layout.getCodLayout(), this.linhaAlterada, 0);
            this.modelosTermo.setValueAt(layout.getDescricao(), this.linhaAlterada, 1);
            this.modelosTermo.setValueAt(modeloPdr, this.linhaAlterada, 2);
        } else {
            this.modelosTermo.addLine(new Object[]{layout.getCodLayout(), layout.getDescricao(), modeloPdr, layout});
            this.modeloSelecionado = (ModeloTermoConsentimentoVO)this.modelosTermo.getValueAt(this.modelosTermo.getRowCount() - 1, 3);
        }
        int ordem = this.modelosTermo.getColunaOrdenacao() != -1 ? this.modelosTermo.getColunaOrdenacao() : 1;
        this.modelosTermo.ordenarColunaSemTrocarSentido(ordem);
        this.modelosTermo.fireTableDataChanged();
        TableUtil.selecionarLinha(this.tableTermo, this.tableTermo.getRowCount() - 1);
        this.controlaCampos();
        this.linhaAlterada = -1;
    }

    private String configurar(boolean isCabecalho) {
        String xml = this.modeloSelecionado != null && !Funcoes.textoVazio(this.modeloSelecionado.getLayout()) ? this.modeloSelecionado.getLayout() : TERMO_VAZIO;
        xml = this.itemFormatoExame.isSelected() ? this.editarFormatoExame(isCabecalho, xml) : this.editarFormatoRelatorio(xml);
        return xml;
    }

    private String editarFormatoExame(boolean isCabecalho, String xml) {
        String cabecalho = TERMO_VAZIO;
        String xmlCorpo = TERMO_VAZIO;
        DialogoConfigurador configurador = new DialogoConfigurador((Frame)Laboratorio.getInstancia(), "Configurando Termo de consentimento", true, true);
        configurador.setTipoConfiguracao(isCabecalho ? 1 : 0);
        configurador.setCamposBanco(Impressao.CAMPOS_TERMO_CONSENTIMENTO_TIPO_EXAME);
        if (!isCabecalho) {
            String string = cabecalho = Funcoes.textoVazio(TermoConsentimento.getTagValue(xml, "cabecalho")) ? TERMO_VAZIO : TermoConsentimento.removeTag(xml, "corpo");
            if (!Funcoes.textoVazio(xml)) {
                xmlCorpo = TermoConsentimento.getTagValue(xml, "corpo");
                cabecalho = TermoConsentimento.removeTag(cabecalho, "alturaRodape");
                cabecalho = TermoConsentimento.removeTag(cabecalho, "alturaSumario");
                if (!Funcoes.textoVazio(xmlCorpo)) {
                    xmlCorpo = TermoConsentimento.removeTag(xml, "cabecalho");
                    xmlCorpo = TermoConsentimento.removeTag(xmlCorpo, "propriedades");
                }
            }
            if (!Funcoes.textoVazio(cabecalho)) {
                configurador.setAtributosDaPagina(cabecalho);
            }
            configurador.setAtributos(xmlCorpo);
            configurador.setVisible(true);
            if (configurador.ok() && configurador.contemConfiguracao()) {
                xmlCorpo = TermoConsentimento.getTagValue(configurador.getAtributos(), "corpo");
                xml = Funcoes.textoVazio(xml) ? configurador.getAtributos() : TermoConsentimento.addValorTag(xml, "corpo", xmlCorpo);
            } else if (configurador.ok() && Funcoes.textoVazio(TermoConsentimento.getTagValue(configurador.getAtributos(), "corpo")) && !Funcoes.textoVazio(cabecalho)) {
                xml = cabecalho = TermoConsentimento.removeTag(cabecalho, "corpo");
            } else if (configurador.ok() && Funcoes.textoVazio(TermoConsentimento.getTagValue(configurador.getAtributos(), "corpo"))) {
                xml = configurador.getAtributos();
            }
        } else {
            if (!Funcoes.textoVazio(TermoConsentimento.getTagValue(xml, "cabecalho"))) {
                cabecalho = TermoConsentimento.removeTag(xml, "corpo");
            }
            configurador.setAtributos(cabecalho);
            configurador.setVisible(true);
            if (configurador.ok() && configurador.contemConfiguracao()) {
                if (!Funcoes.textoVazio(xml)) {
                    cabecalho = configurador.getAtributos();
                    xmlCorpo = TermoConsentimento.getTagValue(xml, "corpo");
                    xml = TermoConsentimento.addValorTag(cabecalho, "corpo", xmlCorpo);
                } else {
                    xml = configurador.getAtributos();
                }
            } else if (configurador.ok() && Funcoes.textoVazio(TermoConsentimento.getTagValue(configurador.getAtributos(), "cabecalho")) && !Funcoes.textoVazio(xml)) {
                xmlCorpo = TermoConsentimento.getTagValue(xml, "corpo");
                xml = TermoConsentimento.addValorTag(configurador.getAtributos(), "corpo", xmlCorpo);
            }
        }
        return xml;
    }

    private String editarFormatoRelatorio(String xml) {
        Editor relatorio = new Editor(Laboratorio.getInstancia(), "Configurando Termo de consentimento", true);
        String[] campos = this.imprimirTermoConsentimento.getCampos(ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante());
        if (campos != null) {
            relatorio.setCamposDoBanco(campos);
        }
        relatorio.setHabilitarQRCode();
        relatorio.setAtributos(xml);
        relatorio.setVisible(true);
        if (relatorio.ok() && !relatorio.vazio()) {
            xml = relatorio.getAtributos();
        } else if (relatorio.ok() && relatorio.vazio()) {
            xml = relatorio.getAtributos();
        }
        relatorio = null;
        return xml;
    }

    private void copiarModelo() {
        try {
            Hashtable resultado = Pesquisas.pesquisaLayoutTermoConsentimento(this.getTopLevelAncestor(), false);
            if (resultado != null) {
                ModeloTermoConsentimentoVO termoCopia = this.service.copiaModeloSelecionado(Variaveis.filialPadrao, resultado.get("lay_codigo").toString(), resultado.get("mtc_codigo").toString());
                this.modeloSelecionado.setLayout(termoCopia.getLayout());
                this.modeloSelecionado.setTipo(termoCopia.getTipo());
                this.itemFormatoRelatorio.setSelected(this.modeloSelecionado.getTipo().equals(TERMO_TIPO_RELATORIO));
                this.itemFormatoExame.setSelected(this.modeloSelecionado.getTipo().equals(TERMO_TIPO_EXAME));
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "Erro ao copiar Termos.", 2);
        }
    }

    private void preencherCampos(TermoConsentimentoVO termo) {
        if (termo == null) {
            return;
        }
        this.txtCodTermo.setEditable(false);
        this.txtCodTermo.setText(String.valueOf(termo.getCodigo()));
        this.txtDescTermo.setText(termo.getDescricao());
        this.checkInativo.setEnabled(true);
        this.checkInativo.setSelected(termo.getInativo());
        try {
            this.buscarModelosTermo(this.txtCodTermo.getText());
        }
        catch (Exception e1) {
            Funcoes.mensagem(this, "Erro ao carregar modelos.", 2);
        }
    }

    public static String getTagValue(String xml, String tagName) {
        if (Funcoes.textoVazio(xml)) {
            return null;
        }
        return xml.split("<" + tagName + ">")[1].split("</" + tagName + ">")[0];
    }

    public static String removeTag(String xml, String tag) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, TERMO_VAZIO);
        return sb.toString();
    }

    public static String addValorTag(String xml, String tag, String valor) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, valor);
        return sb.toString();
    }

    private void buscarModelosTermo(String codigo) throws Exception {
        ArrayList<Object> modelos = new ArrayList();
        if (Funcoes.isNumeric(this.txtCodTermo.getText())) {
            modelos = this.service.buscarModelosTermo(Variaveis.filialPadrao, codigo);
            for (ModeloTermoConsentimentoVO modeloTermoConsentimentoVO : modelos) {
                this.modelosTermo.addLine(new Object[]{modeloTermoConsentimentoVO.getCodLayout(), modeloTermoConsentimentoVO.getDescricao(), modeloTermoConsentimentoVO.getModeloPadrao() == true ? "SIM" : TERMO_VAZIO, modeloTermoConsentimentoVO});
            }
            this.modelosTermo.fireTableDataChanged();
            TableUtil.selecionarLinha(this.tableTermo, 0);
        }
    }

    private boolean validaMetodoPadrao() {
        for (int i = 0; i < this.modelosTermo.getRowCount(); ++i) {
            if (Funcoes.textoVazio((String)this.modelosTermo.getValueAt(i, 2))) continue;
            return false;
        }
        return true;
    }
}

