/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;

class TelaAssinatura
extends JDialog
implements ActionListener {
    JPanel panelCentral = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonAdicionar = ComponenteFactory.novoJButton("Alterar", 'A', this);
    JButton buttonRemover = ComponenteFactory.novoJButton("Remover", 'R', this);
    JLabel labelImagem = new JLabel("");
    private boolean ok = false;

    public static TelaAssinatura novaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new TelaAssinatura((Dialog)owner);
        }
        if (owner instanceof Frame) {
            return new TelaAssinatura((Frame)owner);
        }
        return null;
    }

    public TelaAssinatura(Dialog owner) {
        super(owner, "Assinatura");
        this.montaTela(owner);
    }

    public TelaAssinatura(Frame owner) {
        super(owner, "Assinatura");
        this.montaTela(owner);
    }

    public boolean isOK() {
        return this.ok;
    }

    public void setImagem(String imagem) {
        if (!Funcoes.textoVazio(imagem)) {
            this.labelImagem.setIcon(new ImageIcon(new Base64().decode(imagem)));
        }
    }

    public String getImagem() {
        if (this.labelImagem.getIcon() != null) {
            return new Base64().encodeAsString(ImagemUtils.imageToByte(((ImageIcon)this.labelImagem.getIcon()).getImage()));
        }
        return "";
    }

    private void montaTela(Component owner) {
        this.setSize(300, 300);
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        Funcoes.montaEnter((JComponent)this.panelCentral);
        this.add((Component)this.panelCentral, "Center");
        this.panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelCentral.add((Component)this.buttonAdicionar, c);
        c.gridx = 1;
        this.panelCentral.add((Component)this.buttonRemover, c);
        c.gridwidth = 2;
        c.gridy = 2;
        c.gridx = 0;
        this.panelCentral.add((Component)this.panelBotoes, c);
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 1;
        this.labelImagem.setPreferredSize(new Dimension(200, 200));
        this.labelImagem.setMinimumSize(this.labelImagem.getPreferredSize());
        this.panelCentral.add((Component)this.labelImagem, c);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAdicionar) {
            this.adicionar();
        } else if (e.getSource() == this.buttonRemover) {
            this.remover();
        } else {
            this.ok = e.getSource() == this.buttonSalvar;
            this.setVisible(false);
        }
    }

    private void adicionar() {
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
        if (file.showOpenDialog(this) == 0) {
            this.labelImagem.setIcon(new ImageIcon(file.getSelectedFile().getAbsolutePath()));
        }
    }

    private void remover() {
        if (this.labelImagem.getIcon() != null && Funcoes.mensagem(this, "Confirma a retirada da assinatura?", 4) == 0) {
            this.labelImagem.setIcon(null);
        }
    }
}

