/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.TaxaBean;
import jalis.model.vo.cadastro.TaxaVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.TaxaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class Taxa
extends FrmCadPadraoBean {
    private TTextField textFieldCodigoTaxa = ComponenteFactory.novoTTextField(20, 1);
    private TTextField textFieldDescricaoTaxa = ComponenteFactory.novoTTextField(80, 3);
    private TTextField textFieldValorTaxa = new TTextField(15, 2, 2);
    private JLabel jLabelCodigoTaxa = new JLabel("C\u00f3digo:");
    private JLabel jLabelDescricaoTaxa = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel jLabelValorTaxa = new JLabel("Valor R$:");
    private TaxaBean taxaBean = new TaxaBean();
    private TaxaVO taxaVO = new TaxaVO();
    private TaxaService serviceTaxa = new TaxaService();
    private String retornoParaPesquisa = "";

    public Taxa() {
        try {
            this.setModuloAcesso(Taxa.getModuloAcesso());
            this.setModuloInsere(Long.parseLong("0105100101"));
            this.setModuloEdita(Long.parseLong("0105100102"));
            this.setModuloApaga(Long.parseLong("0105100103"));
            this.jbInit();
            this.controlaCampos();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Taxa");
        }
    }

    private void jbInit() {
        this.setName("Taxa");
        this.painelCentral.setLayout(new GridBagLayout());
        this.setLabelDescricao("Cadastro de taxas");
        this.setLabelFormulario("Cadastro de taxa");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_taxa.jpg"));
        GridBagConstraints bagConstraintsTaxa = new GridBagConstraints();
        bagConstraintsTaxa.fill = 13;
        bagConstraintsTaxa.anchor = 17;
        bagConstraintsTaxa.gridx = 0;
        bagConstraintsTaxa.gridy = 0;
        bagConstraintsTaxa.insets = new Insets(1, 0, 0, 1);
        bagConstraintsTaxa.weightx = 0.0;
        bagConstraintsTaxa.weighty = 0.0;
        this.painelCentral.add((Component)this.jLabelCodigoTaxa, bagConstraintsTaxa);
        ++bagConstraintsTaxa.gridx;
        this.textFieldCodigoTaxa.setPreferredSize(new Dimension(70, 20));
        this.textFieldCodigoTaxa.setMinimumSize(new Dimension(70, 20));
        this.textFieldCodigoTaxa.setEnabled(false);
        this.painelCentral.add((Component)this.textFieldCodigoTaxa, bagConstraintsTaxa);
        this.textFieldCodigoTaxa.setName("textFieldCodigoTaxa");
        ++bagConstraintsTaxa.gridy;
        bagConstraintsTaxa.gridx = 0;
        this.painelCentral.add((Component)this.jLabelDescricaoTaxa, bagConstraintsTaxa);
        ++bagConstraintsTaxa.gridx;
        this.textFieldDescricaoTaxa.setPreferredSize(new Dimension(400, 20));
        this.textFieldDescricaoTaxa.setName("textFieldDescricaoTaxa");
        this.textFieldDescricaoTaxa.setMinimumSize(new Dimension(400, 20));
        bagConstraintsTaxa.fill = 2;
        bagConstraintsTaxa.weightx = 1.0;
        this.painelCentral.add((Component)this.textFieldDescricaoTaxa, bagConstraintsTaxa);
        bagConstraintsTaxa.fill = 13;
        bagConstraintsTaxa.gridwidth = 0;
        ++bagConstraintsTaxa.gridy;
        bagConstraintsTaxa.gridx = 0;
        this.painelCentral.add((Component)this.jLabelValorTaxa, bagConstraintsTaxa);
        ++bagConstraintsTaxa.gridx;
        this.textFieldValorTaxa.setPreferredSize(new Dimension(140, 20));
        this.textFieldValorTaxa.setMinimumSize(new Dimension(140, 20));
        this.painelCentral.add((Component)this.textFieldValorTaxa, bagConstraintsTaxa);
        this.textFieldValorTaxa.setName("textFieldValorTaxa");
        ++bagConstraintsTaxa.gridy;
        bagConstraintsTaxa.gridx = 0;
        bagConstraintsTaxa.weightx = 1.0;
        bagConstraintsTaxa.weighty = 1.0;
        bagConstraintsTaxa.fill = 1;
        bagConstraintsTaxa.anchor = 17;
        JLabel dsd = new JLabel();
        this.painelCentral.add((Component)dsd, bagConstraintsTaxa);
        Funcoes.defineUpperCase(this.painelCentral, ParametrosGerais.getUpperCase());
    }

    @Override
    protected void controlaCampos() {
        this.textFieldDescricaoTaxa.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldValorTaxa.setEnabled(this.habilitaDesabilitaCampo());
    }

    @Override
    protected void limparCampos() {
        this.textFieldCodigoTaxa.clear();
        this.textFieldDescricaoTaxa.clear();
        this.textFieldValorTaxa.clear();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        this.taxaVO = (TaxaVO)this.serviceTaxa.pesquisaVO(this.getTopLevelAncestor(), new TaxaVO(), "Consultando taxas", false);
        return this.taxaVO != null ? this.taxaVO.toBean() : null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        if (this.taxaBean == null) {
            this.taxaBean = new TaxaBean();
        }
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
        this.taxaBean.setFilial(filialVO);
        this.taxaBean.setDescricao(this.textFieldDescricaoTaxa.getText());
        if (!Funcoes.textoVazio(this.textFieldValorTaxa) && Funcoes.isNumeric(this.textFieldValorTaxa.getText())) {
            Double taxa = Double.parseDouble(this.textFieldValorTaxa.getText().replace(",", "."));
            if (taxa < 0.0) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Valor da taxa n\u00e3o pode ser negativo.", 2);
                return null;
            }
            this.taxaBean.setValor(taxa);
        }
        return this.taxaBean;
    }

    @Override
    public void salvar() {
        if (this.validarCampos()) {
            try {
                this.taxaBean = (TaxaBean)this.getBeanPreenchido();
                if (this.taxaBean == null) {
                    return;
                }
                if (this.getStatus() == 2) {
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
                    this.taxaBean.setFilial(filial);
                    this.serviceTaxa.gravaAutoCopiaSemCommit(this.taxaBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                } else if (this.getStatus() == 3) {
                    this.serviceTaxa.gravaAutoCopiaSemCommit(this.taxaBean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                }
                this.setStatus(1);
                Conexao.arquivaSQL();
                this.limparCampos();
                this.controlaCampos();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar dados da taxa.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean validarCampos() {
        if (Funcoes.textoVazio(this.textFieldDescricaoTaxa)) {
            Funcoes.mensagem(this, "Informe a descri\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textFieldDescricaoTaxa);
            return false;
        }
        if (Funcoes.textoVazio(this.textFieldValorTaxa)) {
            Funcoes.mensagem(this, "Informe o valor.", 2);
            ScreenUtil.requisitarFoco(this.textFieldValorTaxa);
            return false;
        }
        if (!Funcoes.textoVazio(this.textFieldValorTaxa) && this.textFieldValorTaxa.getText().trim().length() > 15) {
            Funcoes.mensagem(this, "O valor n\u00e3o pode ultrapassar os 15 caracteres.", 2);
            ScreenUtil.requisitarFoco(this.textFieldValorTaxa);
            return false;
        }
        return true;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (this.beanValido(bean)) {
            this.taxaBean = (TaxaBean)bean;
            this.textFieldCodigoTaxa.setText(this.taxaBean.getCodigo().toString());
            this.textFieldDescricaoTaxa.setText(this.taxaBean.getDescricao());
            this.textFieldValorTaxa.setText(Funcoes.formataDecimal(this.textFieldValorTaxa.getMaskDecimal(), this.taxaBean.getValor()));
        }
    }

    private boolean beanValido(AbstractThreadBean bean) {
        return bean != null && bean instanceof TaxaBean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaTaxa();
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "tax_codigo";
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0105100100");
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    public void novo() {
        super.novo();
        this.setStatus(2);
        ScreenUtil.requisitarFoco(this.textFieldDescricaoTaxa);
    }

    @Override
    public void excluir() {
        this.taxaBean = (TaxaBean)this.pesquisar();
        if (this.taxaBean != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Taxa.this.preencherCampos(Taxa.this.taxaBean);
                    if (Funcoes.mensagem(Taxa.this.getTopLevelAncestor(), "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            Taxa.this.serviceTaxa.gravaAutoCopiaSemCommit(Taxa.this.taxaBean, 2, Variaveis.filialPadrao, Taxa.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(Taxa.this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel excluir o registro de taxas.\n" + e.getMessage(), e.getStackTrace());
                        }
                    }
                    Taxa.this.limparCampos();
                    Taxa.this.taxaBean = new TaxaBean();
                }
            });
        }
    }
}

