/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.TabelaANS;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.cadastro.AlterarPrecosAMB;
import jalis.laboratorio.cadastro.AlterarPrecosAMBMetodologia;
import jalis.laboratorio.cadastro.AlterarPrecosCBHPM;
import jalis.laboratorio.cadastro.AlterarPrecosCBHPMMetodologia;
import jalis.laboratorio.cadastro.DialogoPortes;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.laboratorio.cadastro.tabelaPreco.AssistenteImportacaoTabelaPrecoDao;
import jalis.laboratorio.cadastro.tabelaPreco.HistoricoPrecos;
import jalis.laboratorio.cadastro.tabelaPreco.ModalAssistenteExportacaoTabelaPreco;
import jalis.laboratorio.cadastro.tabelaPreco.ModalAssistenteImportacaoTabelaPreco;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoExame;
import jalis.model.enums.EnumTabServico;
import jalis.model.vo.cadastro.DetalheTabelaPrecoMetodologiaVO;
import jalis.model.vo.cadastro.TabelaPrecoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.tabelaPreco.PrecosAlterados;
import jalis.model.vo.cadastro.tabelaPreco.TabelaPrecoExameUsuarioVO;
import jalis.service.cadastro.TabelaPrecoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TabelaPreco
extends FrmCadPadrao
implements ActionListener {
    private TTextField txtPrecoExame = new TTextField(10, 2, 5);
    private JLabel jLabel1 = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private TTextField txtDescricao = new TTextField(80);
    private JLabel jLabel2 = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel jLabel3 = new JLabel("Exame:");
    private TTextField txtMoeda = new TTextField(3);
    private JLabel jLabel5 = new JLabel("Moeda:");
    private JLabel labelANS = new JLabel("Padr\u00e3o ANS:");
    private JComboBox comboANS = new JComboBox<TabelaANS.TiposTabela>(TabelaANS.TiposTabela.getTipos());
    private JCheckBox checkCBHPM = ComponenteFactory.novoJCheckBox("Tabela CBHPM", this);
    private TTextField textUCO = new TTextField(8, 2, 2);
    private JLabel labelCBHPM = ComponenteFactory.novoJLabel("UCO:", 'U', null, this.textUCO);
    private JButton buttonCopiar = new JButton("Copiar de...");
    private JButton buttonPrecos = ComponenteFactory.novoJButton("Pre\u00e7os", 'r', this);
    private JButton buttonPorte = ComponenteFactory.novoJButton("Portes", 't', this);
    private JButton buttonHistorico = ComponenteFactory.novoJButton("Hist\u00f3rico", 'h', this);
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'm', this);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'e', this);
    private JPanel panelBotoesPrecos = new JPanel(new FlowLayout(2));
    private ArrayList<PrecosAlterados> precosAlterados = null;
    private ArrayList<PorteTabelaCBHPM> portes = new ArrayList();
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem itemCopiarDe = ComponenteFactory.novoJMenuItem(this.menu, "Copiar de...", (ActionListener)this);
    private JMenuItem itemCopiarCodigoDe = ComponenteFactory.novoJMenuItem(this.menu, "Copiar c\u00f3digos de...", (ActionListener)this);
    private JMenuItem itemCopiarValorDe = ComponenteFactory.novoJMenuItem(this.menu, "Copiar valores de...", (ActionListener)this);
    private String retornoParaPesquisa = "";
    private JLabel labelTabServico = new JLabel("Tab. Servi\u00e7o:");
    private JComboBox comboTabServico = new JComboBox<EnumTabServico>(EnumTabServico.values());
    List<TabelaPrecoExame> examesAtualizados;

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(TabelaPreco.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101700201"));
        this.setModuloEdita(Long.parseLong("0101700202"));
        this.setModuloApaga(Long.parseLong("0101700203"));
    }

    public TabelaPreco() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TabelaPreco (60)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("TabelaPreco");
        this.txtPrecoExame.setToolTipText("Valor padr\u00e3o do exame a ser utilizado nos conv\u00eanios");
        this.txtPrecoExame.setName("txtPrecoExame");
        this.setLabelDescricao("Cadastro de tabela de pre\u00e7os de exames");
        this.setLabelFormulario("Cadastro de tabela de pre\u00e7os");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_tab_preco.jpg"));
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setName("txtCodigo");
        this.txtCodigo.setBounds(new Rectangle(82, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(82, 28, 800, 20));
        this.txtDescricao.setName("txtDescricao");
        this.txtDescricao.setText("");
        this.txtMoeda.setBounds(new Rectangle(413, 49, 69, 20));
        this.txtMoeda.setName("txtMoeda");
        this.txtMoeda.clear();
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel3.setBounds(new Rectangle(7, 51, 50, 14));
        this.txtPrecoExame.setBounds(new Rectangle(82, 49, 120, 20));
        this.txtPrecoExame.setName("txtPrecoExame");
        this.jLabel5.setBounds(new Rectangle(365, 51, 50, 14));
        this.checkCBHPM.setBounds(new Rectangle(770, 7, 150, 20));
        this.checkCBHPM.setName("checkCBHPM");
        this.labelCBHPM.setBounds(new Rectangle(770, 51, 50, 14));
        this.textUCO.setBounds(new Rectangle(812, 49, 70, 20));
        this.textUCO.setName("textUCO");
        this.labelANS.setBounds(7, 73, 80, 14);
        this.comboANS.setBounds(82, 71, 800, 20);
        this.comboANS.setName("comboANS");
        this.panelBotoesPrecos.setBounds(new Rectangle(400, 110, 482, 35));
        this.labelTabServico.setBounds(7, 92, 82, 20);
        this.comboTabServico.setBounds(82, 92, 800, 20);
        this.panelBotoesPrecos.setBounds(new Rectangle(400, 112, 482, 35));
        this.controlaCampos();
        this.painelCentral.add(this.jLabel1);
        this.painelCentral.add(this.jLabel2);
        this.painelCentral.add(this.txtCodigo);
        this.painelCentral.add(this.txtDescricao);
        this.painelCentral.add(this.jLabel3);
        this.painelCentral.add(this.txtPrecoExame);
        this.painelCentral.add(this.txtMoeda);
        this.painelCentral.add(this.jLabel5);
        this.painelCentral.add(this.labelANS);
        this.painelCentral.add(this.comboANS);
        this.painelCentral.add(this.labelTabServico);
        this.painelCentral.add(this.comboTabServico);
        this.painelCentral.add(this.textUCO);
        this.painelCentral.add(this.labelCBHPM);
        this.painelCentral.add(this.checkCBHPM);
        this.painelCentral.add(this.panelBotoesPrecos);
        this.panelBotoesPrecos.add(this.buttonImportar);
        this.buttonImportar.setName("buttonImportar");
        this.panelBotoesPrecos.add(this.buttonExportar);
        this.buttonExportar.setName("buttonExportar");
        this.panelBotoesPrecos.add(this.buttonHistorico);
        this.buttonHistorico.setName("buttonHistorico");
        this.panelBotoesPrecos.add(this.buttonCopiar);
        this.buttonCopiar.setName("buttonCopiar");
        this.panelBotoesPrecos.add(this.buttonPrecos);
        this.buttonPrecos.setName("buttonPrecos");
        this.panelBotoesPrecos.add(this.buttonPorte);
        this.buttonPorte.setName("buttonPorte");
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusLost(FocusEvent e) {
                if (TabelaPreco.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(TabelaPreco.this.txtCodigo.getText().trim())) {
                    Statement st;
                    block12: {
                        st = Conexao.getStatement();
                        try {
                            if (st == null) break block12;
                            StringBuffer buf = new StringBuffer("select tpe_descricao, tpe_valorch, tpe_moeda, ");
                            buf.append("tpe_tabelaans, tpe_tipocbhpm, tpe_uco, tpe_tabservicotiss ");
                            buf.append("from tabelaprecoexames where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and tpe_codigo = ");
                            buf.append(TabelaPreco.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                TabelaPreco.this.txtDescricao.setText(rs.getString("tpe_descricao"));
                                TabelaPreco.this.txtPrecoExame.setText(rs.getString("tpe_valorch") == "null" ? "" : Funcoes.formataDecimal("0.00000", rs.getDouble("tpe_valorch")));
                                TabelaPreco.this.txtMoeda.setText(rs.getString("tpe_moeda"));
                                TabelaPreco.this.checkCBHPM.setSelected(rs.getBoolean("tpe_tipocbhpm"));
                                TabelaPreco.this.textUCO.setText(rs.getString("tpe_uco") == null || rs.getString("tpe_uco").equals("null") ? "" : Funcoes.formataDecimal(TabelaPreco.this.textUCO.getMaskDecimal(), rs.getDouble("tpe_uco")));
                                String tabelaANS = rs.getString("tpe_tabelaans");
                                if (!Funcoes.textoVazio(tabelaANS)) {
                                    TabelaPreco.this.comboANS.setSelectedItem((Object)TabelaANS.TiposTabela.getTipo(tabelaANS));
                                } else {
                                    TabelaPreco.this.comboANS.setSelectedItem("");
                                }
                                String tabServico = rs.getString("tpe_tabservicotiss");
                                if (!Funcoes.textoVazio(tabServico)) {
                                    TabelaPreco.this.comboTabServico.setSelectedItem((Object)EnumTabServico.getEnum(tabServico));
                                }
                                if (TabelaPreco.this.checkCBHPM.isSelected()) {
                                    TabelaPreco.this.checkCBHPMPressionado();
                                    TabelaPreco.this.portes.clear();
                                    buf.delete(0, buf.length());
                                    buf.append("select tpp_porte, tpp_valor ");
                                    buf.append("from tabelaprecoexamesporte ");
                                    buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                                    buf.append(" and tpe_codigo = ").append(TabelaPreco.this.txtCodigo.getText());
                                    buf.append(" order by tpp_porte ");
                                    rs = Conexao.executeQuery(st, buf.toString());
                                    while (rs.next()) {
                                        TabelaPreco.this.portes.add(new PorteTabelaCBHPM(rs.getString("tpp_porte"), rs.getDouble("tpp_valor")));
                                    }
                                    if (TabelaPreco.this.portes.size() == 0) {
                                        TabelaPreco.this.adicionaPortesPadroes();
                                    }
                                }
                                TabelaPreco.this.txtCodigo.setEnabled(false);
                                break block12;
                            }
                            Funcoes.mensagem(TabelaPreco.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                            TabelaPreco.this.setStatus(1);
                            TabelaPreco.this.controlaCampos();
                        }
                        catch (SQLException sqlex) {
                            try {
                                ErrorLogger.mostraMensagem(TabelaPreco.this, sqlex.getMessage(), sqlex.getStackTrace(), "TabelaPreco");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                    }
                    Conexao.fecharStatement(st);
                }
            }
        });
        this.buttonCopiar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.isNumeric(TabelaPreco.this.txtCodigo.getText())) {
                    return;
                }
                TabelaPreco.this.menu.show(TabelaPreco.this.buttonCopiar.getParent(), TabelaPreco.this.buttonCopiar.getX(), TabelaPreco.this.buttonCopiar.getY() + TabelaPreco.this.buttonCopiar.getHeight());
            }
        });
        this.buttonHistorico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.isNumeric(TabelaPreco.this.txtCodigo.getText())) {
                    return;
                }
                TabelaPreco.this.mostrarHistorico();
            }
        });
        this.buttonImportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabelaPreco.this.criaImportacao();
            }
        });
        this.buttonExportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabelaPreco.this.criaExportacao();
            }
        });
    }

    private void criaExportacao() {
        ModalAssistenteExportacaoTabelaPreco assistente = new ModalAssistenteExportacaoTabelaPreco(this.getTopLevelAncestor(), this.checkCBHPM.isSelected(), Variaveis.filialPadrao, this.txtCodigo.getText());
        assistente.setVisible(true);
    }

    private void criaImportacao() {
        ModalAssistenteImportacaoTabelaPreco assistente = new ModalAssistenteImportacaoTabelaPreco(this.getTopLevelAncestor(), this.checkCBHPM.isSelected(), Variaveis.filialPadrao, this.txtCodigo.getText());
        assistente.setVisible(true);
        if (assistente.getOK() && assistente.getExamesAtualizados() != null && assistente.getExamesAtualizados().size() > 0) {
            this.examesAtualizados = assistente.getExamesAtualizados();
            if (this.precosAlterados == null) {
                this.precosAlterados = new ArrayList();
                this.precosAlterados = !ParametrosGerais.getPrecoMetodologia() ? AssistenteImportacaoTabelaPrecoDao.buscaDadosPreco(Integer.valueOf(this.txtCodigo.getText()), this.checkCBHPM.isSelected()) : AssistenteImportacaoTabelaPrecoDao.buscaDadosPrecoMetodologia(Integer.valueOf(this.txtCodigo.getText()), this.checkCBHPM.isSelected());
            }
            for (TabelaPrecoExame exame : this.examesAtualizados) {
                Double valor = this.checkCBHPM.isSelected() ? exame.getCustoNovo() : exame.getValorCHNovo();
                PrecosAlterados exameAlterado = new PrecosAlterados();
                exameAlterado.setCodigoAMB(exame.getCodigoAmb());
                exameAlterado.setCodigoExame(exame.getCodigoExame());
                exameAlterado.setValorCusto(valor);
                exameAlterado.setInserindoExame(true);
                exameAlterado.setPercentual(exame.getPercentualNovo());
                exameAlterado.setPorte(exame.getPorteNovo());
                exameAlterado.setProibido(exame.getProibido());
                exameAlterado.setDescricaoExame(exame.getDescricaoExame());
                exameAlterado.setDescricaoMetodologia(exame.getDescricaoMetodologia());
                DadosMaterial materialExame = new DadosMaterial(exame.getCodigoMaterial(), AssistenteImportacaoTabelaPrecoDao.obterDadosMaterial(exame.getCodigoMaterial()), false, false);
                exameAlterado.setMaterial(materialExame);
                int posicaoExame = IntStream.range(0, this.precosAlterados.size()).filter(i -> exame.getCodigoAmb().equals(this.precosAlterados.get(i).getCodigoAMB())).findFirst().getAsInt();
                if (posicaoExame >= 0) {
                    this.precosAlterados.set(posicaoExame, exameAlterado);
                    continue;
                }
                this.precosAlterados.add(exameAlterado);
            }
        }
    }

    private void mostrarHistorico() {
        HistoricoPrecos historicoPrecos = HistoricoPrecos.novaInstancia(this.getTopLevelAncestor(), this.txtCodigo.getText());
        historicoPrecos.setVisible(true);
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.tabelaPreco(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("tpe_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("tabelaprecoexames", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("tpe_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaPreco");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            boolean precoMetodologia = ParametrosGerais.getPrecoMetodologia();
            Statement statement = Conexao.getStatement();
            Statement inserir = Conexao.getStatement();
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            if (statement != null) {
                try {
                    StringBuilder buf;
                    String codigo = this.txtCodigo.getText();
                    if (this.getStatus() == 2) {
                        codigo = DBUtil.getSequencia(statement, "tabelaprecoexames", true);
                    }
                    SalvaDados salvar = new SalvaDados("tabelaprecoexames", this.getStatus() == 2 ? 0 : 2);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("tpe_codigo", 2, false, true, codigo);
                    salvar.adicionaCampo("tpe_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                    salvar.adicionaCampo("tpe_valorch", 2, true, false, Funcoes.limpaDecimal(this.txtPrecoExame.getText()));
                    salvar.adicionaCampo("tpe_uco", 2, true, false, Funcoes.textoVazio(this.textUCO.getText()) ? null : Funcoes.limpaDecimal(this.textUCO.getText()));
                    salvar.adicionaCampo("tpe_tipocbhpm", 4, true, false, this.checkCBHPM.isSelected());
                    salvar.adicionaCampo("tpe_moeda", 0, true, false, this.txtMoeda.getTextDBEscape());
                    String tabelaANS = "";
                    if (this.comboANS.getSelectedItem() instanceof TabelaANS.TiposTabela) {
                        tabelaANS = ((TabelaANS.TiposTabela)((Object)this.comboANS.getSelectedItem())).codigo;
                    }
                    salvar.adicionaCampo("tpe_tabelaans", 0, true, false, StringUtil.textoDBEscape(tabelaANS));
                    String tabServico = ((EnumTabServico)((Object)this.comboTabServico.getSelectedItem())).getCodigo();
                    salvar.adicionaCampo("tpe_tabservicotiss", 0, true, false, StringUtil.textoDBEscape(tabServico));
                    new TabelaPrecoService().registrarHistorico(this.getTabelaPreco(codigo));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco(), "tabelaprecoexames", Integer.parseInt(codigo));
                    if (this.getStatus() == 2) {
                        buf = new StringBuilder("select exa_codigo, mco_codigo, met_codigo from examematcoleta where fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        ResultSet rs = Conexao.executeQuery(statement, buf.toString());
                        splash.mostrar("Adicionando exames \u00e0 nova tabela...");
                        if (precoMetodologia) {
                            salvar.setTabela("detalhetabelaprecometodologia");
                        } else {
                            salvar.setTabela("detalhetabelapreco");
                        }
                        salvar.setOperacao(0);
                        while (rs.next()) {
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("tpe_codigo", 2, false, true, codigo);
                            salvar.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDBEscape(rs.getString("exa_codigo")));
                            salvar.adicionaCampo("mco_codigo", 2, false, true, rs.getInt("mco_codigo"));
                            if (precoMetodologia) {
                                salvar.adicionaCampo("met_codigo", 2, false, true, rs.getInt("met_codigo"));
                            }
                            DBUtil.gravaAutoCopia(inserir, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                        }
                        splash.apagar();
                    }
                    buf = new StringBuilder("select con_codigo, exa_codigo, mco_codigo, cpr_valor, cpr_percentual, tpe_codigo, tpp_porte from conveniospreco ");
                    buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("   and tpe_codigo = ").append(codigo);
                    ResultSet rsConvenioPreco = Conexao.executeQuery(statement, buf.toString());
                    salvar.setTabela("conveniospreco");
                    salvar.limpar();
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("tpe_codigo", 2, false, true, codigo);
                    salvar.setOperacao(1);
                    DBUtil.gravaAutoCopia(inserir, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    salvar.setTabela("tabelaprecoexamesporte");
                    salvar.limpar();
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("tpe_codigo", 2, false, true, codigo);
                    List<PorteTabelaCBHPM> listaPorte = null;
                    if (!Funcoes.textoVazio(codigo)) {
                        listaPorte = new TabelaPrecoService().buscaPorte(Variaveis.filialPadrao, codigo);
                    }
                    salvar.setOperacao(1);
                    DBUtil.gravaAutoCopia(inserir, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    salvar.adicionaCampo("tpp_porte", 0, false, true);
                    salvar.adicionaCampo("tpp_valor", 2, true, false);
                    salvar.setOperacao(0);
                    for (PorteTabelaCBHPM porteTabelaCBHPM : this.portes) {
                        salvar.setValor("tpp_porte", StringUtil.textoDBEscape(porteTabelaCBHPM.getPorte()));
                        salvar.setValor("tpp_valor", Funcoes.limpaDecimal(String.valueOf(porteTabelaCBHPM.getValor())));
                        if (this.getStatus() == 3) {
                            new TabelaPrecoService().registrarHistoricoPorte(porteTabelaCBHPM, Variaveis.filialPadrao, codigo);
                        }
                        DBUtil.gravaAutoCopia(inserir, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    }
                    if (rsConvenioPreco.next()) {
                        salvar.setTabela("conveniospreco");
                        salvar.setOperacao(0);
                        do {
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true);
                            salvar.adicionaCampo("con_codigo", 2, false, true);
                            salvar.adicionaCampo("exa_codigo", 0, false, true);
                            salvar.adicionaCampo("mco_codigo", 2, false, true);
                            salvar.adicionaCampo("cpr_valor", 2, true, false);
                            salvar.adicionaCampo("cpr_percentual", 2, true, false);
                            salvar.adicionaCampo("tpe_codigo", 2, true, false);
                            salvar.adicionaCampo("tpp_porte", 0, true, false);
                            salvar.setValor("fil_codigo", Variaveis.filialPadrao);
                            salvar.setValor("con_codigo", rsConvenioPreco.getString("con_codigo"));
                            salvar.setValor("exa_codigo", StringUtil.textoDBEscape(rsConvenioPreco.getString("exa_codigo")));
                            salvar.setValor("mco_codigo", rsConvenioPreco.getInt("mco_codigo"));
                            salvar.setValor("cpr_valor", rsConvenioPreco.getInt("cpr_valor"));
                            salvar.setValor("cpr_percentual", rsConvenioPreco.getInt("cpr_percentual"));
                            salvar.setValor("tpe_codigo", rsConvenioPreco.getInt("tpe_codigo"));
                            salvar.setValor("tpp_porte", StringUtil.textoDBEscape(rsConvenioPreco.getString("tpp_porte")));
                            DBUtil.gravaAutoCopia(inserir, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                        } while (rsConvenioPreco.next());
                    }
                    rsConvenioPreco.close();
                    if (this.precosAlterados != null && this.precosAlterados.size() > 0) {
                        splash.mostrar("Atualizando tabela de pre\u00e7os...");
                        if (precoMetodologia) {
                            salvar.setTabela("detalhetabelaprecometodologia");
                        } else {
                            salvar.setTabela("detalhetabelapreco");
                        }
                        salvar.limpar();
                        salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                        salvar.adicionaCampo("tpe_codigo", 2, false, true, codigo);
                        salvar.adicionaCampo("exa_codigo", 0, false, true);
                        salvar.adicionaCampo("mco_codigo", 2, false, true);
                        if (precoMetodologia) {
                            salvar.adicionaCampo("dtm_codamb", 0, true, false);
                            salvar.adicionaCampo("dtm_valor", 2, true, false);
                            salvar.adicionaCampo("dtm_proibido", 4, true, false);
                            salvar.adicionaCampo("met_codigo", 2, false, true);
                            if (this.checkCBHPM.isSelected()) {
                                salvar.adicionaCampo("dtm_percentual", 2, true, false);
                                salvar.adicionaCampo("tpp_porte", 0, true, false);
                            }
                        } else {
                            salvar.adicionaCampo("dtp_codamb", 0, true, false);
                            salvar.adicionaCampo("dtp_valor", 2, true, false);
                            salvar.adicionaCampo("dtp_proibido", 4, true, false);
                            if (this.checkCBHPM.isSelected()) {
                                salvar.adicionaCampo("dtp_percentual", 2, true, false);
                                salvar.adicionaCampo("tpp_porte", 0, true, false);
                            }
                        }
                        for (PrecosAlterados precosAlterados : this.precosAlterados) {
                            if (!precosAlterados.isInserindoExame()) continue;
                            salvar.setValor("exa_codigo", StringUtil.textoDBEscape(precosAlterados.getCodigoExame()));
                            salvar.setValor("mco_codigo", precosAlterados.getMaterial().getCodigo());
                            TabelaPrecoExameUsuarioVO tabelaPrecoExameUsuario = new TabelaPrecoExameUsuarioVO();
                            tabelaPrecoExameUsuario.setCodigoFilial(Integer.valueOf(Variaveis.filialPadrao));
                            if (precoMetodologia) {
                                salvar.setValor("dtm_codamb", StringUtil.textoDBEscape(precosAlterados.getCodigoAMB()));
                                salvar.setValor("dtm_valor", Funcoes.limpaDecimal(String.valueOf(precosAlterados.getValorCusto())));
                                salvar.setValor("dtm_proibido", precosAlterados.isProibido());
                                salvar.setValor("met_codigo", precosAlterados.getCodigoMetodologia());
                                if (this.checkCBHPM.isSelected()) {
                                    salvar.setValor("dtm_percentual", precosAlterados.getPercentual());
                                    salvar.setValor("tpp_porte", Funcoes.textoVazio(precosAlterados.getPorte()) ? null : StringUtil.textoDBEscape(precosAlterados.getPorte()));
                                }
                            } else {
                                salvar.setValor("dtp_codamb", StringUtil.textoDBEscape(precosAlterados.getCodigoAMB()));
                                salvar.setValor("dtp_valor", Funcoes.limpaDecimal(String.valueOf(precosAlterados.getValorCusto())));
                                salvar.setValor("dtp_proibido", precosAlterados.isProibido());
                                if (this.checkCBHPM.isSelected()) {
                                    salvar.setValor("dtp_percentual", precosAlterados.getPercentual());
                                    salvar.setValor("tpp_porte", Funcoes.textoVazio(precosAlterados.getPorte()) ? null : StringUtil.textoDBEscape(precosAlterados.getPorte()));
                                }
                            }
                            List<DetalheTabelaPrecoMetodologiaVO> listaDtp = new TabelaPrecoService().buscarPreco(Conexao.getStatement(), Integer.valueOf(Variaveis.filialPadrao), this.txtCodigo.getText(), precoMetodologia);
                            new TabelaPrecoService().registrarHistoricoExame(precosAlterados, this.txtCodigo.getText(), precoMetodologia, listaDtp);
                            salvar.setOperacao(1);
                            DBUtil.gravaAutoCopia(inserir, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                            salvar.setOperacao(0);
                            DBUtil.gravaAutoCopia(inserir, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                        }
                    }
                    if (this.examesAtualizados != null && !this.examesAtualizados.isEmpty()) {
                        AssistenteImportacaoTabelaPrecoDao.atualizaExames(Variaveis.filialPadrao, this.txtCodigo.getText(), this.checkCBHPM.isSelected(), this.examesAtualizados);
                        this.examesAtualizados.clear();
                    }
                    if (this.getStatus() == 2) {
                        StringBuilder bu = new StringBuilder();
                        bu.append("Tabela de pre\u00e7os ").append(this.txtDescricao.getText());
                        bu.append(" cadastrada em ").append(Funcoes.formataData("dd/MM/yyyy HH:mm:ssss", new Date()));
                        new TabelaPrecoService().inserirHistorico(bu.toString(), codigo);
                    }
                    this.retornoParaPesquisa = codigo;
                    Conexao.arquivaSQL();
                    new TabelaPrecoService().registrarHistoricoPorte(listaPorte, Variaveis.filialPadrao, this.txtCodigo.getText());
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaPreco");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            splash.apagar();
            Conexao.fecharStatement(inserir);
            Conexao.fecharStatement(statement);
        }
    }

    private TabelaPrecoVO getTabelaPreco(String codigo) {
        TabelaPrecoVO tabelaPreco = new TabelaPrecoVO();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
        tabelaPreco.setFilial(filial);
        tabelaPreco.setCodigo(Integer.valueOf(codigo));
        tabelaPreco.setDescricao(this.txtDescricao.getText());
        tabelaPreco.setValorCh(Double.valueOf(this.txtPrecoExame.getText()));
        tabelaPreco.setMoeda(this.txtMoeda.getText());
        tabelaPreco.setTipoCbhpm(this.checkCBHPM.isSelected());
        Double valor = 0.0;
        if (!Funcoes.textoVazio(this.textUCO.getText())) {
            valor = Double.valueOf(this.textUCO.getText());
        }
        tabelaPreco.setValorUco(valor);
        if (this.comboANS.getSelectedItem() instanceof TabelaANS.TiposTabela) {
            tabelaPreco.setTabelaANS(((TabelaANS.TiposTabela)((Object)this.comboANS.getSelectedItem())).codigo);
        }
        return tabelaPreco;
    }

    private void adicionaPortesPadroes() {
        this.portes.add(new PorteTabelaCBHPM("01A", 8.0));
        this.portes.add(new PorteTabelaCBHPM("01B", 16.0));
        this.portes.add(new PorteTabelaCBHPM("01C", 24.0));
        this.portes.add(new PorteTabelaCBHPM("02A", 32.0));
        this.portes.add(new PorteTabelaCBHPM("02B", 42.0));
        this.portes.add(new PorteTabelaCBHPM("02C", 50.0));
        this.portes.add(new PorteTabelaCBHPM("03A", 69.0));
        this.portes.add(new PorteTabelaCBHPM("03B", 88.0));
        this.portes.add(new PorteTabelaCBHPM("03C", 100.0));
        this.portes.add(new PorteTabelaCBHPM("04A", 120.0));
        this.portes.add(new PorteTabelaCBHPM("04B", 132.0));
        this.portes.add(new PorteTabelaCBHPM("04C", 148.0));
        this.portes.add(new PorteTabelaCBHPM("05A", 160.0));
        this.portes.add(new PorteTabelaCBHPM("05B", 172.0));
        this.portes.add(new PorteTabelaCBHPM("05C", 184.0));
        this.portes.add(new PorteTabelaCBHPM("06A", 200.0));
        this.portes.add(new PorteTabelaCBHPM("06B", 220.0));
        this.portes.add(new PorteTabelaCBHPM("06C", 240.0));
        this.portes.add(new PorteTabelaCBHPM("07A", 260.0));
        this.portes.add(new PorteTabelaCBHPM("07B", 280.0));
        this.portes.add(new PorteTabelaCBHPM("07C", 340.0));
        this.portes.add(new PorteTabelaCBHPM("08A", 368.0));
        this.portes.add(new PorteTabelaCBHPM("08B", 384.0));
        this.portes.add(new PorteTabelaCBHPM("08C", 408.0));
        this.portes.add(new PorteTabelaCBHPM("09A", 436.0));
        this.portes.add(new PorteTabelaCBHPM("09B", 476.0));
        this.portes.add(new PorteTabelaCBHPM("09C", 524.0));
        this.portes.add(new PorteTabelaCBHPM("10A", 560.0));
        this.portes.add(new PorteTabelaCBHPM("10B", 608.0));
        this.portes.add(new PorteTabelaCBHPM("10C", 676.0));
        this.portes.add(new PorteTabelaCBHPM("11A", 716.0));
        this.portes.add(new PorteTabelaCBHPM("11B", 784.0));
        this.portes.add(new PorteTabelaCBHPM("11C", 860.0));
        this.portes.add(new PorteTabelaCBHPM("12A", 892.0));
        this.portes.add(new PorteTabelaCBHPM("12B", 960.0));
        this.portes.add(new PorteTabelaCBHPM("12C", 1176.0));
        this.portes.add(new PorteTabelaCBHPM("13A", 1292.0));
        this.portes.add(new PorteTabelaCBHPM("13B", 1420.0));
        this.portes.add(new PorteTabelaCBHPM("13C", 1570.0));
        this.portes.add(new PorteTabelaCBHPM("14A", 1750.0));
        this.portes.add(new PorteTabelaCBHPM("14B", 1900.0));
        this.portes.add(new PorteTabelaCBHPM("14C", 2100.0));
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtPrecoExame.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtMoeda.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboANS.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTabServico.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkCBHPM.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textUCO.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonHistorico.setVisible(this.getStatus() == 3);
        this.buttonCopiar.setVisible(this.getStatus() == 3);
        this.buttonPrecos.setVisible(this.getStatus() == 3);
        this.buttonImportar.setVisible(this.getStatus() == 3);
        this.buttonExportar.setVisible(this.getStatus() == 3);
        this.checkCBHPMPressionado();
    }

    private void limparCampos() {
        this.txtCodigo.clear();
        this.txtDescricao.clear();
        this.txtPrecoExame.clear();
        this.txtMoeda.clear();
        this.checkCBHPM.setSelected(false);
        this.precosAlterados = null;
        this.comboANS.setSelectedIndex(0);
        this.comboTabServico.setSelectedIndex(0);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.checkCBHPM.isSelected()) {
            boolean porteErrado = false;
            boolean percErrado = false;
            if (this.precosAlterados != null) {
                for (PrecosAlterados aux : this.precosAlterados) {
                    if (aux.getPorte() == null || Funcoes.textoVazio(aux.getPorte())) {
                        porteErrado = true;
                    }
                    if (aux.getPercentual() == 0.0) {
                        percErrado = true;
                    }
                    if (!porteErrado || !percErrado) continue;
                    break;
                }
            }
            StringBuilder buf = new StringBuilder();
            if (porteErrado || percErrado) {
                if (porteErrado && percErrado) {
                    buf.append("O porte e o percentual n\u00e3o est\u00e3o configurados para todos os exames.");
                } else if (percErrado) {
                    buf.append("O percentual n\u00e3o est\u00e1 configurado para todos os exames.");
                } else if (porteErrado) {
                    buf.append("O porte n\u00e3o est\u00e1 configurado para todos os exames.");
                }
                buf.append("\nDeseja configurar os valores dos exames?");
                int resp = Funcoes.mensagem(this, buf.toString(), 4, true);
                if (resp == 0) {
                    this.buttonPrecos.doClick();
                    return false;
                }
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtPrecoExame.getText())) {
            Funcoes.mensagem(this, "Campo pre\u00e7o n\u00e3o informado", 1);
            this.txtPrecoExame.selectAll();
            this.txtPrecoExame.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101700200");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonPrecos) {
            this.alterarPrecos();
        } else if (e.getSource() == this.checkCBHPM) {
            this.checkCBHPMPressionado();
        } else if (e.getSource() == this.buttonPorte) {
            this.alterarPortes();
        } else if (e.getSource() == this.itemCopiarDe) {
            this.copiarTabelaDe();
        } else if (e.getSource() == this.itemCopiarCodigoDe) {
            this.copiarCodigoTabelaDe();
        } else if (e.getSource() == this.itemCopiarValorDe) {
            this.copiarValorTabelaDe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copiarTabelaDe() {
        block15: {
            block16: {
                Hashtable resultado = Pesquisas.tabelaPreco(this.getTopLevelAncestor(), false);
                if (resultado == null) break block15;
                String codigo = resultado.get("tpe_codigo").toString();
                String descricao = resultado.get("tpe_descricao").toString();
                if (Funcoes.mensagem(this, "A c\u00f3pia da tabela " + codigo + " apagar\u00e1 todos os valores e c\u00f3digos da tabela " + this.txtCodigo.getText() + ".\nConfirma a c\u00f3pia dos dados?", 4) != 0) {
                    return;
                }
                if (Integer.parseInt(codigo) == Integer.parseInt(this.txtCodigo.getText())) break block16;
                SplashMensagem splash = SplashMensagem.getInstancia(this);
                splash.mostrar("Copiando c\u00f3digos e valores de exames...");
                Statement st = Conexao.getStatement();
                Statement st2 = Conexao.getStatement();
                try {
                    boolean precoMetodologia = ParametrosGerais.getPrecoMetodologia();
                    List<DetalheTabelaPrecoMetodologiaVO> listaDtp = new TabelaPrecoService().buscarPreco(st, Integer.valueOf(Variaveis.filialPadrao), this.txtCodigo.getText(), precoMetodologia);
                    SalvaDados salvar = new SalvaDados(precoMetodologia ? "detalhetabelaprecometodologia" : "detalhetabelapreco", 1);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("tpe_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select * ");
                    if (precoMetodologia) {
                        buf.append("   from detalhetabelaprecometodologia ");
                    } else {
                        buf.append("   from detalhetabelapreco ");
                    }
                    buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("    and tpe_codigo = ").append(codigo);
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        String porte = !Funcoes.textoVazio(rs.getString("tpp_porte")) ? StringUtil.textoDBEscape(rs.getString("tpp_porte")) : null;
                        salvar.limpar();
                        salvar.setOperacao(0);
                        salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                        salvar.adicionaCampo("tpe_codigo", 2, false, true, this.txtCodigo.getText());
                        salvar.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDBEscape(rs.getString("exa_codigo")));
                        salvar.adicionaCampo("mco_codigo", 2, false, true, rs.getInt("mco_codigo"));
                        salvar.adicionaCampo("tpp_porte", 0, true, false, porte);
                        double valorTotal = 0.0;
                        double percentual = 0.0;
                        String codigoAmb = "";
                        boolean proibido = false;
                        Integer metodo = 0;
                        if (precoMetodologia) {
                            valorTotal = !DBUtil.campoNull(rs.getString("dtm_valor")) ? rs.getDouble("dtm_valor") : 0.0;
                            percentual = !DBUtil.campoNull(rs.getString("dtm_percentual")) ? rs.getDouble("dtm_percentual") : 0.0;
                            codigoAmb = rs.getString("dtm_codamb");
                            proibido = rs.getBoolean("dtm_proibido");
                            metodo = rs.getInt("met_codigo");
                            salvar.adicionaCampo("met_codigo", 2, false, true, metodo);
                            salvar.adicionaCampo("dtm_valor", 2, true, false, valorTotal);
                            salvar.adicionaCampo("dtm_codamb", 0, true, false, StringUtil.textoDBEscape(codigoAmb));
                            salvar.adicionaCampo("dtm_proibido", 4, true, false, proibido);
                            salvar.adicionaCampo("dtm_percentual", 2, true, false, percentual);
                        } else {
                            valorTotal = !DBUtil.campoNull(rs.getString("dtp_valor")) ? rs.getDouble("dtp_valor") : 0.0;
                            percentual = !DBUtil.campoNull(rs.getString("dtp_percentual")) ? rs.getDouble("dtp_percentual") : 0.0;
                            codigoAmb = rs.getString("dtp_codamb");
                            proibido = rs.getBoolean("dtp_proibido");
                            salvar.adicionaCampo("dtp_valor", 2, true, false, valorTotal);
                            salvar.adicionaCampo("dtp_codamb", 0, true, false, StringUtil.textoDBEscape(codigoAmb));
                            salvar.adicionaCampo("dtp_proibido", 4, true, false, proibido);
                            salvar.adicionaCampo("dtp_percentual", 2, true, false, percentual);
                        }
                        PrecosAlterados precos = new PrecosAlterados();
                        precos.setCodigoAMB(codigoAmb);
                        precos.setPercentual(percentual);
                        precos.setCodigoExame(rs.getString("exa_codigo"));
                        precos.setProibido(proibido);
                        precos.setValorCusto(valorTotal);
                        precos.setPercentual(percentual);
                        if (rs.getInt("mco_codigo") > 0) {
                            precos.setMaterial(new DadosMaterial(rs.getInt("mco_codigo"), rs.getString("mco_codigo"), false, false));
                        }
                        if (metodo > 0) {
                            precos.setCodigoMetodologia(metodo);
                        }
                        new TabelaPrecoService().registrarHistoricoExame(precos, this.txtCodigo.getText(), precoMetodologia, listaDtp);
                        DBUtil.gravaAutoCopia(st2, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    }
                    StringBuilder bu = new StringBuilder();
                    bu.append("Copiado tabela ");
                    bu.append(codigo).append(" - ").append(descricao);
                    new TabelaPrecoService().inserirHistorico(bu.toString(), this.txtCodigo.getText());
                    salvar = new SalvaDados("tabelaprecoexamesporte", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("tpe_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    this.portes.clear();
                    buf.delete(0, buf.length());
                    buf.append("select fil_codigo, tpe_codigo, tpp_porte, tpp_valor ");
                    buf.append("from tabelaprecoexamesporte ");
                    buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and tpe_codigo = ").append(codigo);
                    rs = Conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        salvar.limpar();
                        salvar = new SalvaDados("tabelaprecoexamesporte", 0);
                        salvar.setOperacao(0);
                        salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                        salvar.adicionaCampo("tpe_codigo", 2, false, true, this.txtCodigo.getText());
                        salvar.adicionaCampo("tpp_porte", 0, true, false, StringUtil.textoDB(rs.getString("tpp_porte")));
                        salvar.adicionaCampo("tpp_valor", 2, true, false, !DBUtil.campoNull(rs.getString("tpp_valor")) ? rs.getDouble("tpp_valor") : 0.0);
                        DBUtil.gravaAutoCopia(st2, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                        this.portes.add(new PorteTabelaCBHPM(rs.getString("tpp_porte"), rs.getDouble("tpp_valor")));
                    }
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaPreco (655)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st, st2);
                        splash.apagar();
                        throw throwable;
                    }
                    Conexao.fecharStatement(st, st2);
                    splash.apagar();
                    break block15;
                }
                Conexao.fecharStatement(st, st2);
                splash.apagar();
                break block15;
            }
            Funcoes.mensagem(this, "A tabela n\u00e3o pode ser copiada para ela mesma", 2);
        }
        ScreenUtil.requisitarFoco(this.txtDescricao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copiarCodigoTabelaDe() {
        block12: {
            block13: {
                Hashtable resultado = Pesquisas.tabelaPreco(this.getTopLevelAncestor(), false);
                if (resultado == null) break block12;
                String codigo = resultado.get("tpe_codigo").toString();
                String descricao = resultado.get("tpe_descricao").toString();
                if (Funcoes.mensagem(this, "A c\u00f3pia da tabela " + codigo + " apagar\u00e1 todos os c\u00f3digos da tabela " + this.txtCodigo.getText() + ".\nConfirma a c\u00f3pia dos c\u00f3digos?", 4) != 0) {
                    return;
                }
                if (Integer.parseInt(codigo) == Integer.parseInt(this.txtCodigo.getText())) break block13;
                SplashMensagem splash = SplashMensagem.getInstancia(this);
                splash.mostrar("Copiando c\u00f3digos de exames...");
                Statement st = Conexao.getStatement();
                Statement st2 = Conexao.getStatement();
                try {
                    boolean precoMetodologia = ParametrosGerais.getPrecoMetodologia();
                    List<DetalheTabelaPrecoMetodologiaVO> listaDtp = new TabelaPrecoService().buscarPreco(st2, Integer.valueOf(Variaveis.filialPadrao), this.txtCodigo.getText(), precoMetodologia);
                    SalvaDados salvar = new SalvaDados(precoMetodologia ? "detalhetabelaprecometodologia" : "detalhetabelapreco", 2);
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select fil_codigo ");
                    buf.append("       ,tpe_codigo ");
                    buf.append("       ,exa_codigo ");
                    buf.append("       ,mco_codigo ");
                    if (precoMetodologia) {
                        buf.append("       ,met_codigo ");
                        buf.append("       ,dtm_codamb ");
                        buf.append("   from detalhetabelaprecometodologia ");
                    } else {
                        buf.append("       ,dtp_codamb ");
                        buf.append("   from detalhetabelapreco ");
                    }
                    buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("    and tpe_codigo = ").append(codigo);
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        salvar.limpar();
                        salvar.setOperacao(2);
                        salvar.setAdicionarAspasSimplesString(false);
                        salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                        salvar.adicionaCampo("tpe_codigo", 2, false, true, this.txtCodigo.getText());
                        salvar.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDBEscape(rs.getString("exa_codigo")));
                        salvar.adicionaCampo("mco_codigo", 2, false, true, rs.getInt("mco_codigo"));
                        String codigoAmb = "";
                        if (precoMetodologia) {
                            codigoAmb = rs.getString("dtm_codamb");
                            salvar.adicionaCampo("dtm_codamb", 0, true, false, StringUtil.textoDBEscape(rs.getString("dtm_codamb")));
                            salvar.adicionaCampo("met_codigo", 2, false, true, rs.getInt("met_codigo"));
                        } else {
                            codigoAmb = rs.getString("dtp_codamb");
                            salvar.adicionaCampo("dtp_codamb", 0, true, false, StringUtil.textoDBEscape(rs.getString("dtp_codamb")));
                        }
                        PrecosAlterados precos = new PrecosAlterados();
                        precos.setCodigoAMB(codigoAmb);
                        precos.setCodigoExame(rs.getString("exa_codigo"));
                        precos.setMaterial(new DadosMaterial(rs.getInt("mco_codigo"), "", false, false));
                        new TabelaPrecoService().registraHistoricoExameCodigoAMB(precos, this.txtCodigo.getText(), precoMetodologia, listaDtp);
                        DBUtil.gravaAutoCopia(st2, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    }
                    StringBuilder bu = new StringBuilder();
                    bu.append("Copiado os C\u00f3digos dos Exames da Tabela ");
                    bu.append(codigo).append(" - ").append(descricao);
                    new TabelaPrecoService().inserirHistorico(bu.toString(), this.txtCodigo.getText());
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaPreco (721)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st, st2);
                        splash.apagar();
                        throw throwable;
                    }
                    Conexao.fecharStatement(st, st2);
                    splash.apagar();
                    break block12;
                }
                Conexao.fecharStatement(st, st2);
                splash.apagar();
                break block12;
            }
            Funcoes.mensagem(this, "A tabela n\u00e3o pode ser copiada para ela mesma", 2);
        }
        ScreenUtil.requisitarFoco(this.txtDescricao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void copiarValorTabelaDe() {
        block19: {
            block20: {
                block18: {
                    resultado = Pesquisas.tabelaPreco(this.getTopLevelAncestor(), false);
                    if (resultado == null) break block19;
                    codigo = resultado.get("tpe_codigo").toString();
                    descricao = resultado.get("tpe_descricao").toString();
                    if (Funcoes.mensagem(this, "A c\u00f3pia da tabela " + codigo + " apagar\u00e1 todos os valores da tabela " + this.txtCodigo.getText() + ".\nConfirma a c\u00f3pia dos valores?", 4) != 0) {
                        return;
                    }
                    if (Integer.parseInt(codigo) == Integer.parseInt(this.txtCodigo.getText())) break block20;
                    splash = SplashMensagem.getInstancia(this);
                    splash.mostrar("Copiando valores de exames...");
                    st = Conexao.getStatement();
                    st2 = Conexao.getStatement();
                    originalCBHPM = false;
                    atualCBHPM = this.checkCBHPM.isSelected();
                    precoMetodologia = ParametrosGerais.getPrecoMetodologia();
                    listaDtp = new TabelaPrecoService().buscarPreco(st, Integer.valueOf(Variaveis.filialPadrao), this.txtCodigo.getText(), precoMetodologia);
                    bui = new StringBuilder();
                    bui.append(" select tpe_tipocbhpm ");
                    bui.append("   from tabelaprecoexames ");
                    bui.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    bui.append("    and tpe_codigo = ").append(codigo);
                    rsCopia = Conexao.executeQuery(st, bui.toString());
                    if (rsCopia.next()) {
                        originalCBHPM = rsCopia.getBoolean("tpe_tipocbhpm");
                    }
                    copiarApenasCalculoFinal = false;
                    if (!originalCBHPM || atualCBHPM) ** GOTO lbl40
                    if (Funcoes.mensagem(this, "O tipo de c\u00e1lculo das tabelas origem/destino n\u00e3o s\u00e3o iguais, deseja copiar apenas o valor calculado para a tabela destino?", 4) != 1) break block18;
                    Funcoes.mensagem(this, "A c\u00f3pia foi cancelada", 2);
                    Conexao.fecharStatement(new Statement[]{st, st2});
                    splash.apagar();
                    return;
                }
                try {
                    copiarApenasCalculoFinal = true;
lbl40:
                    // 2 sources

                    salvar = new SalvaDados(precoMetodologia != false ? "detalhetabelaprecometodologia" : "detalhetabelapreco", 2);
                    salvar.setAdicionarAspasSimplesString(false);
                    buf = new StringBuilder();
                    buf.append(" select a.fil_codigo ");
                    buf.append("       ,a.tpe_codigo ");
                    buf.append("       ,a.exa_codigo ");
                    buf.append("       ,a.mco_codigo ");
                    buf.append("       ,a.tpp_porte ");
                    buf.append("       ,b.tpe_uco ");
                    buf.append("       ,b.tpe_tipocbhpm ");
                    buf.append("       ,c.tpp_valor ");
                    if (precoMetodologia) {
                        buf.append("       ,a.dtm_valor ");
                        buf.append("       ,a.dtm_percentual ");
                        buf.append("       ,a.met_codigo ");
                        buf.append("   from detalhetabelaprecometodologia a ");
                    } else {
                        buf.append("       ,a.dtp_valor ");
                        buf.append("       ,a.dtp_percentual ");
                        buf.append("   from detalhetabelapreco a ");
                    }
                    buf.append("   left join tabelaprecoexames b on a.fil_codigo = b.fil_codigo and a.tpe_codigo = b.tpe_codigo ");
                    buf.append("   left join tabelaprecoexamesporte c on a.fil_codigo = c.fil_codigo and a.tpe_codigo = c.tpe_codigo and a.tpp_porte = c.tpp_porte ");
                    buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("    and a.tpe_codigo = ").append(codigo);
                    rs = Conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        salvar.limpar();
                        salvar.setOperacao(2);
                        salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                        salvar.adicionaCampo("tpe_codigo", 2, false, true, this.txtCodigo.getText());
                        salvar.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDBEscape(rs.getString("exa_codigo")));
                        salvar.adicionaCampo("mco_codigo", 2, false, true, rs.getInt("mco_codigo"));
                        total = 0.0;
                        percentual = 0.0;
                        if (precoMetodologia) {
                            salvar.adicionaCampo("met_codigo", 2, false, true, rs.getInt("met_codigo"));
                            if (copiarApenasCalculoFinal) {
                                total = rs.getDouble("dtm_percentual") * rs.getDouble("tpp_valor") + rs.getDouble("dtm_valor") * rs.getDouble("tpe_uco");
                                percentual = rs.getDouble("dtm_percentual");
                                salvar.adicionaCampo("dtm_valor", 2, true, false, total);
                            } else {
                                salvar.adicionaCampo("dtm_valor", 2, true, false, DBUtil.campoNull(rs.getString("dtm_valor")) == false ? rs.getDouble("dtm_valor") : 0.0);
                            }
                            salvar.adicionaCampo("dtm_percentual", 2, true, false, DBUtil.campoNull(rs.getString("dtm_valor")) == false ? rs.getDouble("dtm_percentual") : 0.0);
                        } else {
                            if (copiarApenasCalculoFinal) {
                                total = rs.getDouble("dtp_percentual") * rs.getDouble("tpp_valor") + rs.getDouble("dtp_valor") * rs.getDouble("tpe_uco");
                                salvar.adicionaCampo("dtp_valor", 2, true, false, total);
                            } else {
                                total = DBUtil.campoNull(rs.getString("dtp_valor")) == false ? rs.getDouble("dtp_valor") : 0.0;
                                salvar.adicionaCampo("dtp_valor", 2, true, false, DBUtil.campoNull(rs.getString("dtp_valor")) == false ? rs.getDouble("dtp_valor") : 0.0);
                            }
                            percentual = rs.getDouble("dtp_percentual");
                            salvar.adicionaCampo("dtp_percentual", 2, true, false, DBUtil.campoNull(rs.getString("dtp_valor")) == false ? rs.getDouble("dtp_percentual") : 0.0);
                        }
                        precos = new PrecosAlterados();
                        precos.setValorCusto(total);
                        precos.setPercentual(percentual);
                        precos.setCodigoExame(rs.getString("exa_codigo"));
                        precos.setMaterial(new DadosMaterial(rs.getInt("mco_codigo"), "", false, false));
                        new TabelaPrecoService().registrarHistoricoExameValores(precos, this.txtCodigo.getText(), precoMetodologia, listaDtp);
                        salvar.adicionaCampo("tpp_porte", 0, true, false, StringUtil.textoDBEscape(rs.getString("tpp_porte")));
                        DBUtil.gravaAutoCopia(st2, salvar, "fil_codigo", ParametrosGerais.getCopiaTabelaPreco());
                    }
                    bu = new StringBuilder();
                    bu.append("Copiado Pre\u00e7os/Valores dos exames da tabela ");
                    bu.append(codigo).append(" - ").append(descricao);
                    new TabelaPrecoService().inserirHistorico(bu.toString(), this.txtCodigo.getText());
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception var8_10) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaPreco (776)");
                    }
                    catch (Throwable var22_23) {
                        Conexao.fecharStatement(new Statement[]{st, st2});
                        splash.apagar();
                        throw var22_23;
                    }
                    Conexao.fecharStatement(new Statement[]{st, st2});
                    splash.apagar();
                    break block19;
                }
                Conexao.fecharStatement(new Statement[]{st, st2});
                splash.apagar();
                break block19;
            }
            Funcoes.mensagem(this, "A tabela n\u00e3o pode ser copiada para ela mesma", 2);
        }
        ScreenUtil.requisitarFoco(this.txtDescricao);
    }

    private void alterarPortes() {
        DialogoPortes p = DialogoPortes.novaInstancia(this.getTopLevelAncestor());
        if (this.portes.size() == 0) {
            this.adicionaPortesPadroes();
        }
        p.setPortes(this.portes);
        p.setLocationRelativeTo(this.getTopLevelAncestor());
        p.setVisible(true);
        if (p.getOK()) {
            this.portes = p.getPortes();
        }
    }

    private void checkCBHPMPressionado() {
        boolean checked = this.checkCBHPM.isSelected();
        this.textUCO.setEnabled(checked);
        this.buttonPorte.setVisible(checked);
        if (checked && this.portes.size() == 0) {
            this.adicionaPortesPadroes();
        }
    }

    private void alterarPrecos() {
        SplashMensagem splash = new SplashMensagem();
        splash.mostrar("Carregando exames...");
        if (this.checkCBHPM.isSelected()) {
            if (ParametrosGerais.getPrecoMetodologia()) {
                AlterarPrecosCBHPMMetodologia alterar = AlterarPrecosCBHPMMetodologia.novaInstancia((Window)this.getTopLevelAncestor());
                alterar.setPortes(this.portes);
                alterar.setValorUCO(Funcoes.isNumeric(this.textUCO.getText()) ? Double.parseDouble(this.textUCO.getText()) : 0.0);
                if (this.precosAlterados != null) {
                    alterar.setPrecos(this.precosAlterados);
                } else if (Funcoes.isNumeric(this.txtCodigo.getText())) {
                    alterar.setTabela(Integer.parseInt(this.txtCodigo.getText()));
                }
                splash.apagar();
                alterar.setVisible(true);
                if (alterar.getOK()) {
                    this.precosAlterados = alterar.getPrecosAlterados();
                }
            } else {
                AlterarPrecosCBHPM alterar = AlterarPrecosCBHPM.novaInstancia(this.getTopLevelAncestor());
                alterar.setPortes(this.portes);
                alterar.setValorUCO(Funcoes.isNumeric(this.textUCO.getText()) ? Double.parseDouble(this.textUCO.getText()) : 0.0);
                if (this.precosAlterados != null) {
                    alterar.setPrecos(this.precosAlterados);
                } else if (Funcoes.isNumeric(this.txtCodigo.getText())) {
                    alterar.setTabela(Integer.parseInt(this.txtCodigo.getText()));
                }
                splash.apagar();
                alterar.setVisible(true);
                if (alterar.getOK()) {
                    this.precosAlterados = alterar.getPrecosAlterados();
                }
            }
        } else if (ParametrosGerais.getPrecoMetodologia()) {
            AlterarPrecosAMBMetodologia alterar = AlterarPrecosAMBMetodologia.novaInstancia((Window)this.getTopLevelAncestor());
            if (this.precosAlterados != null) {
                alterar.setPrecos(this.precosAlterados);
            } else if (Funcoes.isNumeric(this.txtCodigo.getText())) {
                alterar.setTabela(Integer.parseInt(this.txtCodigo.getText()));
            }
            splash.apagar();
            alterar.setVisible(true);
            if (alterar.getOK()) {
                this.precosAlterados = alterar.getPrecosAlterados();
            }
        } else {
            AlterarPrecosAMB alterar = AlterarPrecosAMB.novaInstancia(this.getTopLevelAncestor());
            if (this.precosAlterados != null) {
                alterar.setPrecos(this.precosAlterados);
            } else if (Funcoes.isNumeric(this.txtCodigo.getText())) {
                alterar.setTabela(Integer.parseInt(this.txtCodigo.getText()));
            }
            splash.apagar();
            alterar.setVisible(true);
            if (alterar.getOK()) {
                this.precosAlterados = alterar.getPrecosAlterados();
            }
        }
        if (this.precosAlterados != null && this.precosAlterados.isEmpty()) {
            this.precosAlterados = null;
        }
        splash.apagar();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "tpe_codigo";
    }
}

