/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SolicitarPercentual
extends JDialog
implements ActionListener {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonAlterar = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private TTextField txtPercentual = new TTextField(8, 2, 4);
    private JLabel label = new JLabel("Percentual:");
    private JCheckBox checkArrendondar = new JCheckBox("Arredondar centavos ao calcular o percentual");
    private JCheckBox checkSelecao = new JCheckBox("Atualizar apenas exames selecionados");
    private boolean ok = false;

    public static SolicitarPercentual novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new SolicitarPercentual((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new SolicitarPercentual((Dialog)pai);
        }
        return null;
    }

    public SolicitarPercentual(Frame owner) {
        super(owner, "Percentual");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarPercentual(Dialog owner) {
        super(owner, "Percentual");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(325, 155);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonAlterar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelTopo.add(this.label);
        this.panelTopo.add(this.txtPercentual);
        this.panelTopo.add(this.checkArrendondar);
        this.panelTopo.add(this.checkSelecao);
        this.label.setBounds(5, 5, 130, 14);
        this.txtPercentual.setBounds(5, 20, 130, 20);
        this.checkArrendondar.setBounds(5, 45, 360, 20);
        this.checkSelecao.setBounds(5, 66, 360, 20);
        this.buttonAlterar.setMnemonic('A');
        this.buttonCancelar.setMnemonic('C');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.buttonAlterar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarPercentual.this.txtPercentual.selectAll();
                SolicitarPercentual.this.txtPercentual.grabFocus();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ok = e.getSource() == this.buttonAlterar;
        this.setVisible(false);
    }

    public double getPercentual() {
        return Funcoes.isNumeric(this.txtPercentual.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.txtPercentual.getText())) : 0.0;
    }

    public boolean ok() {
        return this.ok;
    }

    public boolean isArredondarCentavos() {
        return this.checkArrendondar.isSelected();
    }

    public boolean isApenasExamesSelecionados() {
        return this.checkSelecao.isSelected();
    }

    public void setApenasExamesSelecionados(boolean b) {
        this.checkSelecao.setSelected(b);
    }
}

