/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.cadastro.util.situacao.CoberturaEspecial;
import jalis.laboratorio.cadastro.util.situacao.SaudeOcupacional;
import jalis.laboratorio.cadastro.util.situacao.TipoAtendimento;
import jalis.laboratorio.util.faturamento.eletronico.tiss.RegimeAtendimento;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class Situacao
extends FrmCadPadrao {
    private JLabel labelCodigo;
    private TTextField textCodigo;
    private TTextField textDescricao;
    private JLabel labelDescricao;
    private JLabel labelExportacao = new JLabel("C\u00f3d. Exporta\u00e7\u00e3o:");
    private TTextField textExportacao = new TTextField(2, 1);
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    private JComboBox comboTipoAtendimento = new JComboBox<TipoAtendimento>(TipoAtendimento.values());
    private JComboBox comboRegimeAtendimento = new JComboBox<RegimeAtendimento>(RegimeAtendimento.values());
    private JComboBox comboSaudeOcupacional = new JComboBox<SaudeOcupacional>(SaudeOcupacional.values());
    private JComboBox comboCoberturaEspecial = new JComboBox<CoberturaEspecial>(CoberturaEspecial.values());
    private String retornoParaPesquisa = "";

    public Situacao() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Situacao");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Situacao");
        this.labelCodigo = new JLabel("C\u00f3digo:");
        this.textCodigo = new TTextField(5, 1);
        this.textCodigo.setName("textCodigo");
        this.textDescricao = new TTextField(80);
        this.textDescricao.setName("textDescricao");
        this.labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
        this.setLabelDescricao("Cadastro de situa\u00e7\u00f5es para exames");
        this.setLabelFormulario("Cadastro de situa\u00e7\u00f5es");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_situacao.jpg"));
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelCodigo.setDisplayedMnemonic('C');
        this.labelCodigo.setLabelFor(this.textCodigo);
        this.labelDescricao.setDisplayedMnemonic('r');
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.textCodigo.setText("");
        this.textCodigo.setPreferredSize(new Dimension(70, 20));
        this.textCodigo.setMinimumSize(new Dimension(70, 20));
        this.textExportacao.setName("textExportacao");
        this.textExportacao.setPreferredSize(new Dimension(70, 20));
        this.textExportacao.setMinimumSize(new Dimension(70, 20));
        this.textDescricao.setText("");
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.labelDescricao.setDisplayedMnemonic('R');
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.labelCodigo, c);
        Dimension tamanhoTela = Toolkit.getDefaultToolkit().getScreenSize();
        JPanel painelAux = new JPanel(new BorderLayout((int)tamanhoTela.getWidth(), 0));
        painelAux.add((Component)this.textCodigo, "Before");
        painelAux.add((Component)this.checkInativo, "After");
        ++c.gridx;
        this.painelCentral.add((Component)painelAux, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelExportacao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textExportacao, c);
        JPanel painelFaturamento = this.construirPainelFaturamento();
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.gridwidth = 2;
        c.insets = new Insets(20, 0, 0, 0);
        this.painelCentral.add((Component)painelFaturamento, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.painelCentral.add((Component)new JLabel(), c);
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Situacao.this.textCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Situacao.this.textCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select sit_codigo, sit_descricao, sit_xmlintegracao, sit_inativo, ");
                            buf.append(" sit_tipoatendimento, sit_regimeatendimento, sit_idcoberturaespecial, sit_saudeocupacional ");
                            buf.append(" from situacao where fil_codigo = ").append(Variaveis.filialPadrao);
                            buf.append(" and sit_codigo = ").append(Situacao.this.textCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                CoberturaEspecial ce;
                                SaudeOcupacional so;
                                Situacao.this.textDescricao.setText(rs.getString("sit_descricao"));
                                Situacao.this.checkInativo.setSelected(rs.getBoolean("sit_inativo"));
                                String tipoAtendimento = rs.getString("sit_tipoatendimento");
                                if (!Funcoes.textoVazio(tipoAtendimento)) {
                                    TipoAtendimento tipoAtendimentoAux = TipoAtendimento.getTipoAtendimento(tipoAtendimento);
                                    if (tipoAtendimentoAux != null) {
                                        Situacao.this.comboTipoAtendimento.setSelectedItem((Object)tipoAtendimentoAux);
                                    } else {
                                        Situacao.this.comboTipoAtendimento.setSelectedItem((Object)TipoAtendimento.EXAME_AMBULATORIAL);
                                    }
                                } else {
                                    Situacao.this.comboTipoAtendimento.setSelectedItem((Object)TipoAtendimento.EXAME_AMBULATORIAL);
                                }
                                Situacao.this.comboSaudeOcupacional.setSelectedItem(null);
                                String codSaudeOcupacional = rs.getString("sit_saudeocupacional");
                                if (!Funcoes.textoVazio(codSaudeOcupacional) && (so = SaudeOcupacional.getSaudeOcupacionalPorCodigo(codSaudeOcupacional)) != null) {
                                    Situacao.this.comboSaudeOcupacional.setSelectedItem((Object)so);
                                }
                                String codRegimeAtendimento = rs.getString("sit_regimeatendimento");
                                Situacao.this.comboRegimeAtendimento.setSelectedItem((Object)RegimeAtendimento.AMBULATORIAL);
                                if (!Funcoes.textoVazio(codRegimeAtendimento)) {
                                    RegimeAtendimento ra = RegimeAtendimento.getRegimeAtendimentoPorCodigo(codRegimeAtendimento);
                                    Situacao.this.comboRegimeAtendimento.setSelectedItem((Object)ra);
                                }
                                String codCoberturaEspecial = rs.getString("sit_idcoberturaespecial");
                                Situacao.this.comboCoberturaEspecial.setSelectedItem(null);
                                if (!Funcoes.textoVazio(codCoberturaEspecial) && (ce = CoberturaEspecial.getCoberturaEspecialPorCodigo(codCoberturaEspecial)) != null) {
                                    Situacao.this.comboCoberturaEspecial.setSelectedItem((Object)ce);
                                }
                                if (rs.getString("sit_xmlintegracao") != null && !Funcoes.textoVazio(rs.getString("sit_xmlintegracao"))) {
                                    Situacao.this.textExportacao.setText(StringUtil.getValor(rs.getString("sit_xmlintegracao"), "soc"));
                                }
                                Situacao.this.textCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(Situacao.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Situacao.this.setStatus(1);
                                Situacao.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Situacao.this, sqlex.getMessage(), sqlex.getStackTrace(), "Situacao");
                    }
                }
            }
        });
        this.controlaCampos();
    }

    private JPanel construirPainelFaturamento() {
        JPanel painelFaturamento = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Faturamento Eletr\u00f4nico padr\u00e3o TISS"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        Dimension medidaPadraoCombo = new Dimension(170, 20);
        this.comboTipoAtendimento.setPreferredSize(medidaPadraoCombo);
        this.comboTipoAtendimento.setMinimumSize(medidaPadraoCombo);
        this.comboTipoAtendimento.setName("comboTipoAtendimento");
        this.comboSaudeOcupacional.setPreferredSize(medidaPadraoCombo);
        this.comboSaudeOcupacional.setMinimumSize(medidaPadraoCombo);
        this.comboSaudeOcupacional.setName("comboSaudeOcupacional");
        this.comboSaudeOcupacional.setSelectedItem(null);
        this.comboRegimeAtendimento.setPreferredSize(medidaPadraoCombo);
        this.comboRegimeAtendimento.setMinimumSize(medidaPadraoCombo);
        this.comboRegimeAtendimento.setName("comboRegimeAtendimento");
        this.comboCoberturaEspecial.setPreferredSize(medidaPadraoCombo);
        this.comboCoberturaEspecial.setMinimumSize(medidaPadraoCombo);
        this.comboCoberturaEspecial.setName("comboCoberturaEspecial");
        this.comboCoberturaEspecial.setSelectedItem(null);
        c.insets = new Insets(10, 10, 0, 0);
        painelFaturamento.add((Component)new JLabel("Tipo de Atendimento: "), c);
        ++c.gridx;
        c.insets = new Insets(10, 0, 0, 0);
        painelFaturamento.add((Component)this.comboTipoAtendimento, c);
        ++c.gridx;
        c.weightx = 1.0;
        painelFaturamento.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 0.0;
        painelFaturamento.add((Component)new JLabel("C\u00f3d. Sa\u00fade Ocupacional: "), c);
        ++c.gridx;
        c.insets = new Insets(10, 0, 0, 10);
        painelFaturamento.add((Component)this.comboSaudeOcupacional, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(2, 10, 10, 0);
        painelFaturamento.add((Component)new JLabel("C\u00f3d. Regime Atendimento: "), c);
        ++c.gridx;
        c.insets = new Insets(2, 0, 10, 0);
        painelFaturamento.add((Component)this.comboRegimeAtendimento, c);
        ++c.gridx;
        c.weightx = 1.0;
        painelFaturamento.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 0.0;
        painelFaturamento.add((Component)new JLabel("ID Cobertura Especial: "), c);
        ++c.gridx;
        c.insets = new Insets(2, 0, 10, 10);
        painelFaturamento.add((Component)this.comboCoberturaEspecial, c);
        return painelFaturamento;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Situacao.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900201"));
        this.setModuloEdita(Long.parseLong("0101900202"));
        this.setModuloApaga(Long.parseLong("0101900203"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.situacao(this.getTopLevelAncestor(), false, true);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.textCodigo.setText(resultado.get("sit_codigo").toString());
        }
        this.textCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.textCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("situacao", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("sit_codigo", 2, false, true, this.textCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaSetor());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Situacao");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.textDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                CoberturaEspecial coberturaEspecial;
                RegimeAtendimento regimeAtendimento;
                String codigo = this.textCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "situacao", true);
                }
                SalvaDados salvar = new SalvaDados("situacao", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("sit_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("sit_descricao", 0, true, false, this.textDescricao.getTextDBEscape());
                salvar.adicionaCampo("sit_inativo", 4, true, false, this.checkInativo.isSelected());
                TipoAtendimento tipoAtendimento = (TipoAtendimento)((Object)this.comboTipoAtendimento.getSelectedItem());
                salvar.adicionaCampo("sit_tipoatendimento", 0, false, false, StringUtil.textoDBEscape(tipoAtendimento.getCodigo()));
                SaudeOcupacional saudeOcupacional = (SaudeOcupacional)((Object)this.comboSaudeOcupacional.getSelectedItem());
                if (saudeOcupacional != null) {
                    salvar.adicionaCampo("sit_saudeocupacional", 0, true, false, StringUtil.textoDBEscape(saudeOcupacional.getCodigo()));
                }
                if ((regimeAtendimento = (RegimeAtendimento)((Object)this.comboRegimeAtendimento.getSelectedItem())) != null) {
                    salvar.adicionaCampo("sit_regimeatendimento", 0, true, false, StringUtil.textoDBEscape(regimeAtendimento.getCodigo()));
                }
                if ((coberturaEspecial = (CoberturaEspecial)((Object)this.comboCoberturaEspecial.getSelectedItem())) != null) {
                    salvar.adicionaCampo("sit_idcoberturaespecial", 0, true, false, StringUtil.textoDBEscape(coberturaEspecial.getCodigo()));
                }
                if (!Funcoes.textoVazio(this.textExportacao)) {
                    salvar.adicionaCampo("sit_xmlintegracao", 0, true, false, StringUtil.textoDBEscape("<soc>" + this.textExportacao.getText() + "</soc>"));
                }
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaSituacao(), "situacao", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Situacao");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.textCodigo.setEnabled(this.getStatus() == 3);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textExportacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkInativo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoAtendimento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboSaudeOcupacional.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboRegimeAtendimento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboCoberturaEspecial.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.textCodigo.clear();
        this.textDescricao.clear();
        this.textExportacao.clear();
        this.checkInativo.setSelected(false);
        this.comboTipoAtendimento.setSelectedItem((Object)TipoAtendimento.EXAME_AMBULATORIAL);
        this.comboSaudeOcupacional.setSelectedItem(null);
        this.comboRegimeAtendimento.setSelectedItem((Object)RegimeAtendimento.AMBULATORIAL);
        this.comboCoberturaEspecial.setSelectedItem(null);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.textCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.textCodigo.grabFocus();
                return false;
            }
            if (this.textCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.textCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.textCodigo.selectAll();
                this.textCodigo.grabFocus();
                return false;
            }
        }
        if (this.textDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.textDescricao.selectAll();
            this.textDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900200");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "sit_codigo";
    }
}

