/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class Sinonimos
extends JDialog
implements DisposeListener {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panel = new JPanel(this.grid);
    private TTextField txtSinonimo = new TTextField(100);
    private JButton botaoOK = new JButton("OK");
    private JLabel label1 = new JLabel("Sin\u00f4nimo");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Sinonimo"});
    private JButton botaoFechar = new JButton("Fechar");
    private JTable tabelaSinonimo = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.tabelaSinonimo);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private int linhaAlterada = -1;

    public Sinonimos(JDialog owner, String title) {
        super((Dialog)owner, title);
        this.montaTela(owner);
    }

    public Sinonimos(JFrame owner, String title) {
        super((Frame)owner, title);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.montaTela(owner);
    }

    private void montaTela(Window owner) {
        this.getContentPane().setLayout(new BorderLayout());
        this.modelo.setColumnSize(new int[]{100, 230, 80}, this.tabelaSinonimo);
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.scroll.setBounds(new Rectangle(5, 41, 413, 217));
        this.botaoFechar.setMnemonic('F');
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.panelBotoes.add(this.botaoFechar);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.panel.add((Component)this.label1, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.botaoOK.setPreferredSize(new Dimension(40, 20));
        this.botaoOK.setMinimumSize(new Dimension(40, 20));
        this.panel.add((Component)this.botaoOK, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.txtSinonimo.setPreferredSize(new Dimension(100, 20));
        this.txtSinonimo.setMinimumSize(new Dimension(100, 20));
        this.panel.add((Component)this.txtSinonimo, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.constraints.weighty = 1.0;
        this.constraints.gridwidth = 2;
        this.panel.add((Component)this.scroll, this.constraints);
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.setSize(426, 322);
        this.setLocation(ScreenUtil.getCentralizado(owner.getBounds(), this.getSize()));
        this.setModal(true);
        Funcoes.montaEnter((JComponent)this.panel);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.botaoOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(Sinonimos.this.txtSinonimo.getText())) {
                    int localizado = Sinonimos.this.modelo.localizar(0, Sinonimos.this.txtSinonimo.getText());
                    if (localizado < 0 && Sinonimos.this.linhaAlterada > -1) {
                        Sinonimos.this.modelo.setValueAt(Sinonimos.this.txtSinonimo.getText(), Sinonimos.this.linhaAlterada, 0);
                        Sinonimos.this.linhaAlterada = -1;
                    } else if (localizado < 0) {
                        Sinonimos.this.modelo.addLine(new String[]{Sinonimos.this.txtSinonimo.getText()});
                    }
                }
                Sinonimos.this.txtSinonimo.clear();
                Sinonimos.this.txtSinonimo.grabFocus();
            }
        });
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sinonimos.this.setVisible(false);
            }
        });
        this.tabelaSinonimo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && Sinonimos.this.tabelaSinonimo.getSelectedRow() > -1 && Funcoes.mensagem(Sinonimos.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Sinonimos.this.modelo.removeLine(Sinonimos.this.tabelaSinonimo.getSelectedRow());
                } else if (e.getKeyCode() == 32 && Sinonimos.this.tabelaSinonimo.getSelectedRow() > -1) {
                    Sinonimos.this.alteraLinha(Sinonimos.this.tabelaSinonimo.getSelectedRow());
                }
            }
        });
        this.tabelaSinonimo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && Sinonimos.this.tabelaSinonimo.getSelectedRow() > -1) {
                    Sinonimos.this.alteraLinha(Sinonimos.this.tabelaSinonimo.getSelectedRow());
                }
            }
        });
    }

    private void alteraLinha(int linha) {
        if (linha < this.modelo.getRowCount()) {
            this.linhaAlterada = linha;
            this.txtSinonimo.setText(this.modelo.getValueAt(linha, 0).toString());
            this.txtSinonimo.grabFocus();
        }
    }

    public String getSinominos() {
        String convenios = "";
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (convenios.trim().length() > 0) {
                convenios = convenios + ";";
            }
            convenios = convenios + (String)this.modelo.getValueAt(i, 0);
        }
        return convenios;
    }

    public void setSinonimos(String sinonimos) {
        this.modelo.clear();
        if (!Funcoes.textoVazio(sinonimos)) {
            String[] sinonimo;
            for (String s : sinonimo = sinonimos.split(";")) {
                this.modelo.addLine(new String[]{s});
            }
        }
    }
}

