/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.util.AvisarExameRetificado;
import jalis.model.bean.cadastro.IdentificadorLaminaBean;
import jalis.model.enums.EnumTipoRateio;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.IdentificadorLaminaVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorUsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.IdentificadorLaminaService;
import jalis.service.cadastro.exame.SetorService;
import jalis.util.CorComboBox;
import jalis.util.DBUtil;
import jalis.util.DialogoCor;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class Setor
extends FrmCadPadrao {
    private static String OK = "OK";
    private static String CANCELADO = "CANCELADO";
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel11;
    private JLabel labelImpressora = new JLabel("Impressora:");
    private JLabel labelIdentificadorLamina = new JLabel("Ident. L\u00e2mina:");
    private JLabel labelDescricaoIdentificadorLamina = new JLabel();
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private TTextField txtResponsavel;
    private TTextField txtCodUsuario;
    private TTextField txtDescUsuario;
    private TTextField txtSigla;
    private TTextField textIdentificadorLamina = new TTextField(10, 1);
    private JButton jButton2;
    private JButton buttonIdentificadorLamina = new JButton();
    private CorComboBox comboCor;
    private JComboBox comboImpressora = ComponenteFactory.novoJComboBox(Funcoes.getNomeImpressorasLocais());
    private JCheckBox checkMensagem = new JCheckBox("Enviar mensagens para o respons\u00e1vel");
    private JCheckBox checkMensagemLaudo = new JCheckBox("Enviar mensagens de laudo retificado");
    private JCheckBox checkAssinaDigital = new JCheckBox("Utiliza certificado/assinatura digital do T\u00e9cnico");
    private JButton buttonUsuarios;
    private JLabel labelTipoRateioSetor = new JLabel("Tipo:");
    private JComboBox comboTipoRateioSetor = new JComboBox<String>(new String[]{"Outros-terceiros", "F\u00edsico-qu\u00edmico", "Microbiol\u00f3gico", "Cromatografia"});
    private String retornoParaPesquisa = "Tipo";
    private SetorService service = null;
    private List<SetorUsuarioVO> listaUsuario = new ArrayList<SetorUsuarioVO>();
    private JButton buttonBuscaUsuarioAssinatura = new JButton();
    private TTextField textUsuarioAssinatura = new TTextField(20, 3);
    private JLabel labelDescUsuarioAssinatura = new JLabel();
    private UsuarioVO usuarioAssinaturaAux = null;

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Setor.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900301"));
        this.setModuloEdita(Long.parseLong("0101900302"));
        this.setModuloApaga(Long.parseLong("0101900303"));
    }

    public Setor() {
        try {
            this.service = new SetorService();
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Setor");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtCodUsuario.setUpperCase(false);
    }

    public void jbInit() throws Exception {
        this.setName("Setor");
        this.setLabelDescricao("Cadastro de setores para realiza\u00e7\u00e3o de exames");
        this.setLabelFormulario("Cadastro de setores");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_setor.jpg"));
        this.jLabel1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.txtResponsavel = new TTextField(80);
        this.txtResponsavel.setName("txtResponsavel");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel6 = new JLabel();
        this.txtCodUsuario = new TTextField(20);
        this.txtCodUsuario.setName("txtCodUsuario");
        this.txtDescUsuario = new TTextField();
        this.txtDescUsuario.setName("txtDescUsuario");
        this.jLabel7 = new JLabel();
        this.txtSigla = new TTextField(3);
        this.txtSigla.setName("txtSigla");
        this.comboCor = new CorComboBox();
        this.comboCor.setName("comboCor");
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(5, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(97, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(97, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(5, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel11.setBounds(new Rectangle(5, 51, 90, 14));
        this.jLabel11.setText("Respons\u00e1vel:");
        this.txtResponsavel.setText("");
        this.txtResponsavel.setBounds(new Rectangle(97, 49, 400, 20));
        this.jLabel3.setText("Cor:");
        this.jLabel3.setBounds(new Rectangle(346, 72, 50, 14));
        this.comboCor.setBounds(new Rectangle(375, 70, 123, 20));
        this.jLabel7.setBounds(new Rectangle(5, 72, 35, 14));
        this.jLabel7.setText("Sigla:");
        this.txtSigla.setBounds(new Rectangle(97, 70, 116, 20));
        this.txtSigla.setText("");
        this.jLabel6.setText("Usu\u00e1rio:");
        this.jLabel6.setBounds(new Rectangle(5, 93, 63, 14));
        this.txtCodUsuario.setText("");
        this.txtCodUsuario.setBounds(new Rectangle(97, 91, 69, 20));
        this.jButton2.setBounds(new Rectangle(167, 91, 20, 20));
        this.jButton2.setFocusable(false);
        this.jButton2.setText("");
        Funcoes.imagemPesquisa(this.jButton2);
        this.txtDescUsuario.setText("");
        this.txtDescUsuario.setEditable(false);
        this.txtDescUsuario.setFocusable(false);
        this.txtDescUsuario.setBounds(new Rectangle(188, 91, 309, 20));
        this.labelImpressora.setBounds(new Rectangle(5, 114, 90, 14));
        this.comboImpressora.setBounds(new Rectangle(97, 112, 400, 20));
        this.comboImpressora.setName("comboImpressora");
        Funcoes.imagemPesquisa(this.buttonIdentificadorLamina);
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoIdentificadorLamina}, new TitledBorder(""));
        this.labelIdentificadorLamina.setBounds(new Rectangle(5, 136, 90, 14));
        this.textIdentificadorLamina.setBounds(new Rectangle(97, 134, 69, 20));
        this.textIdentificadorLamina.setName("textIdentificadorLamina");
        this.buttonIdentificadorLamina.setFocusable(false);
        this.buttonIdentificadorLamina.setName("buttonIdentificadorLamina");
        this.buttonIdentificadorLamina.setBounds(167, 134, 20, 20);
        this.labelDescricaoIdentificadorLamina.setBounds(new Rectangle(188, 134, 309, 20));
        this.checkMensagem.setBounds(new Rectangle(97, 156, 400, 20));
        this.checkMensagemLaudo.setBounds(new Rectangle(97, 177, 247, 20));
        this.buttonUsuarios = new JButton("Usu\u00e1rios");
        this.buttonUsuarios.setBounds(new Rectangle(350, 177, 90, 20));
        this.buttonUsuarios.setEnabled(false);
        this.comboTipoRateioSetor.setName("comboTipoRateioSetor");
        this.checkMensagem.setName("checkMensagem");
        if (this.isFilialAlimentos()) {
            this.labelTipoRateioSetor.setBounds(new Rectangle(5, 158, 90, 14));
            this.comboTipoRateioSetor.setBounds(new Rectangle(97, 156, 200, 20));
            this.checkMensagem.setBounds(new Rectangle(97, 177, 400, 20));
            this.checkMensagemLaudo.setBounds(new Rectangle(97, 198, 247, 20));
            this.buttonUsuarios.setBounds(new Rectangle(350, 198, 90, 20));
            this.painelCentral.add(this.labelTipoRateioSetor);
            this.painelCentral.add(this.comboTipoRateioSetor);
            this.buttonBuscaUsuarioAssinatura = new JButton();
            this.buttonBuscaUsuarioAssinatura.addActionListener(Laboratorio.getInstancia());
            this.buttonBuscaUsuarioAssinatura.setBounds(70, 0, 20, 20);
            Funcoes.imagemPesquisa(this.buttonBuscaUsuarioAssinatura);
            this.textUsuarioAssinatura.setPreferredSize(new Dimension(80, 20));
            this.textUsuarioAssinatura.setName("textUsuarioCompras");
            this.textUsuarioAssinatura.setMinimumSize(new Dimension(80, 20));
            this.checkAssinaDigital.setBounds(0, 5, 300, 20);
            this.checkAssinaDigital.setSelected(false);
            this.textUsuarioAssinatura = new TTextField(20);
            this.textUsuarioAssinatura.setBounds(0, 0, 69, 20);
            this.labelDescUsuarioAssinatura = new JLabel();
            this.labelDescUsuarioAssinatura.setBounds(91, 0, 260, 20);
            JPanel panelCertificadoDigital = new JPanel(null);
            panelCertificadoDigital.setBorder(BorderFactory.createTitledBorder(""));
            panelCertificadoDigital.setBounds(97, 220, 400, 75);
            panelCertificadoDigital.add(this.checkAssinaDigital);
            JPanel panelPesquisaUsuario = new JPanel(null);
            panelPesquisaUsuario.setBounds(18, 32, 360, 30);
            panelPesquisaUsuario.add(this.textUsuarioAssinatura);
            panelPesquisaUsuario.add(this.buttonBuscaUsuarioAssinatura);
            panelPesquisaUsuario.add(this.labelDescUsuarioAssinatura);
            panelCertificadoDigital.add(panelPesquisaUsuario);
            ScreenUtil.setBorda(new JComponent[]{this.labelDescUsuarioAssinatura}, new TitledBorder(""));
            this.painelCentral.add(panelCertificadoDigital);
        }
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel6, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.jLabel11, null);
        this.painelCentral.add((Component)this.txtCodUsuario, null);
        this.painelCentral.add((Component)this.jButton2, null);
        this.painelCentral.add((Component)this.txtDescUsuario, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.txtResponsavel, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.jLabel7, null);
        this.painelCentral.add((Component)this.txtSigla, null);
        this.painelCentral.add((Component)this.comboCor, null);
        this.painelCentral.add(this.labelImpressora);
        this.painelCentral.add(this.comboImpressora);
        this.painelCentral.add(this.checkMensagem);
        this.painelCentral.add(this.checkMensagemLaudo);
        this.painelCentral.add(this.buttonUsuarios);
        this.painelCentral.add(this.labelIdentificadorLamina);
        this.painelCentral.add(this.textIdentificadorLamina);
        this.painelCentral.add(this.buttonIdentificadorLamina);
        this.painelCentral.add(this.labelDescricaoIdentificadorLamina);
        this.controlaCampos();
        this.checkAssinaDigital.addItemListener(listener -> {
            if (!this.checkAssinaDigital.isSelected()) {
                this.textUsuarioAssinatura.setText("");
                this.labelDescUsuarioAssinatura.setText("");
            }
            this.textUsuarioAssinatura.setEnabled(this.checkAssinaDigital.isSelected());
            this.buttonBuscaUsuarioAssinatura.setEnabled(this.checkAssinaDigital.isSelected());
            this.labelDescUsuarioAssinatura.setEnabled(this.checkAssinaDigital.isSelected());
        });
        this.textUsuarioAssinatura.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Setor.this.buscandoInfoUsuarioAssinaDigital();
            }
        });
        this.textUsuarioAssinatura.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Setor.this.buttonBuscaUsuarioAssinatura.doClick();
                }
            }
        });
        this.buttonBuscaUsuarioAssinatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Setor.this.buscaUsuarioAssinatura();
            }
        });
        this.buttonIdentificadorLamina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Setor.this.pesquisaIdentificadorLamina();
            }
        });
        this.textIdentificadorLamina.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    if (!Funcoes.textoVazio(Setor.this.textIdentificadorLamina)) {
                        Setor.this.buscaIdentificadorLamina();
                    } else {
                        Setor.this.labelDescricaoIdentificadorLamina.setText("");
                    }
                }
            }
        });
        this.textIdentificadorLamina.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Setor.this.buttonIdentificadorLamina.doClick();
                }
            }
        });
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Setor.this.buscaUsuario();
            }
        });
        this.comboCor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Setor.this.comboCor.getActionCommand() == OK && Setor.this.comboCor.getSelectedIndex() == Setor.this.comboCor.getIndiceCorPersonalizada()) {
                    DialogoCor dc = new DialogoCor((Frame)Setor.this.getTopLevelAncestor(), "Configurar cor", true);
                    dc.setCor(Setor.this.comboCor.getCorSelecionada());
                    dc.setVisible(true);
                    if (dc.ok()) {
                        Setor.this.comboCor.setActionCommand(CANCELADO);
                        Setor.this.comboCor.setCorPersonalizada(dc.getCor());
                        Setor.this.comboCor.setActionCommand(OK);
                    }
                }
            }
        });
        this.buttonUsuarios.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarExameRetificado avisarRetificado = new AvisarExameRetificado(Laboratorio.getInstancia(), "Avisar exame retificado");
                avisarRetificado.setListaUsuarios(Setor.this.listaUsuario);
                avisarRetificado.setVisible(true);
                List<SetorUsuarioVO> usuarios = avisarRetificado.getListaUsuarios();
                Setor.this.listaUsuario.clear();
                for (SetorUsuarioVO setorUsuario : usuarios) {
                    boolean adicionar = true;
                    setorUsuario.setCodigoFilial(Integer.valueOf(Variaveis.filialPadrao));
                    Setor.this.listaUsuario.add(setorUsuario);
                }
            }
        });
        this.checkMensagemLaudo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Setor.this.buttonUsuarios.setEnabled(Setor.this.checkMensagemLaudo.isSelected());
            }
        });
        this.txtCodUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Setor.this.txtCodUsuario.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select usr_codigo, usr_nome from usuario where upper(usr_codigo)=upper(" + Setor.this.txtCodUsuario.getTextDBEscape() + ")");
                        if (rs.next()) {
                            Setor.this.txtDescUsuario.setText(rs.getString("usr_nome"));
                            Setor.this.txtCodUsuario.setText(rs.getString("usr_codigo"));
                        } else {
                            Setor.this.txtDescUsuario.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Setor.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Setor.this.setStatus(1);
                        Setor.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Setor.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Setor.this.txtCodigo.getText().trim())) {
                    try {
                        SetorVO setor = Setor.this.service.loadVO(Variaveis.filialPadrao, Setor.this.txtCodigo.getText());
                        if (Funcoes.carregouVO(setor)) {
                            Setor.this.txtDescricao.setText(setor.getDescricao());
                            Setor.this.txtResponsavel.setText(setor.getResponsavel());
                            Setor.this.txtCodUsuario.setText(setor.getUsuario().getCodigo());
                            Setor.this.txtDescUsuario.setText(setor.getUsuario().getNome());
                            Setor.this.txtSigla.setText(setor.getSigla());
                            Setor.this.checkMensagem.setSelected(setor.getEnviarMensagem());
                            Setor.this.checkMensagemLaudo.setSelected(setor.getEnviarMensagemRetificado());
                            Setor.this.buttonUsuarios.setEnabled(setor.getEnviarMensagemRetificado());
                            if (Setor.this.isFilialAlimentos()) {
                                Setor.this.checkAssinaDigital.setSelected(setor.getAssinarLaudoDigital());
                                Setor.this.textUsuarioAssinatura.setText(setor.getUsuarioAssinaLaudoDigital());
                                Setor.this.buscandoInfoUsuarioAssinaDigital();
                            }
                            if (!Funcoes.textoVazio(setor.getCor())) {
                                Setor.this.comboCor.setActionCommand(CANCELADO);
                                Setor.this.comboCor.setCorSelecionada(Color.decode(setor.getCor()));
                                Setor.this.comboCor.setActionCommand(OK);
                            }
                            if (!Funcoes.textoVazio(setor.getImpressora())) {
                                Setor.this.comboImpressora.setSelectedItem(setor.getImpressora());
                            }
                            if (Setor.this.isFilialAlimentos()) {
                                Setor.this.comboTipoRateioSetor.setSelectedItem(EnumTipoRateio.getDescricao(setor.getTipoAlimentos()));
                            }
                            SetorService setorService = new SetorService();
                            Setor.this.listaUsuario = setorService.buscaUsuarioSetor(Variaveis.filialPadrao, Setor.this.txtCodigo.getText());
                            Integer codigoIdentificadorLamina = setor.getIdentificacaoLamina();
                            if (this.contemLamina(codigoIdentificadorLamina)) {
                                this.carregaDadosLamina(codigoIdentificadorLamina);
                            }
                            Setor.this.txtCodigo.setEnabled(false);
                        } else {
                            Funcoes.mensagem(Setor.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                            Setor.this.setStatus(1);
                            Setor.this.controlaCampos();
                        }
                    }
                    catch (Exception sqlex) {
                        ErrorLogger.mostraMensagem(Setor.this, sqlex.getMessage(), sqlex.getStackTrace(), "Setor");
                    }
                }
            }

            private void carregaDadosLamina(Integer codigoIdentificadorLamina) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", Variaveis.filialPadrao);
                chaves.put("ide_codigo", codigoIdentificadorLamina);
                try {
                    IdentificadorLaminaBean identificador = (IdentificadorLaminaBean)new IdentificadorLaminaService().getBean(chaves);
                    if (identificador != null) {
                        Setor.this.textIdentificadorLamina.setText(identificador.getCodigo().toString());
                        Setor.this.labelDescricaoIdentificadorLamina.setText(identificador.getDescricao());
                    }
                }
                catch (ThreadDaoException e1) {
                    ErrorLogger.mostraMensagem(Setor.this, "N\u00e3o foi poss\u00edvel carregar dados do identificador de l\u00e3mina.\n" + e1.getMessage(), e1.getStackTrace());
                }
            }

            private boolean contemLamina(Integer codigoIdentificadorLamina) {
                return codigoIdentificadorLamina != null;
            }
        });
    }

    private void buscandoInfoUsuarioAssinaDigital() {
        Statement st;
        if (this.textUsuarioAssinatura.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
            try {
                ResultSet rs = Conexao.executeQuery(st, "select usr_codigo, usr_nome from usuario where upper(usr_codigo)=upper(" + this.textUsuarioAssinatura.getTextDBEscape() + ")");
                if (rs.next()) {
                    this.labelDescUsuarioAssinatura.setText(rs.getString("usr_nome"));
                    this.textUsuarioAssinatura.setText(rs.getString("usr_codigo"));
                } else {
                    this.txtDescUsuario.setText("N\u00e3o cadastrado");
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                this.setStatus(1);
                this.controlaCampos();
            }
        }
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.setor(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("set_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("setores", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("set_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaSetor());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Setor");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.comboCor.setCorPersonalizada(new Color(0, 0, 0));
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            Statement statement = Conexao.getStatement();
            if (statement != null) {
                try {
                    String codigo = this.txtCodigo.getText();
                    if (this.getStatus() == 2) {
                        codigo = DBUtil.getSequencia(statement, "setores", true);
                    }
                    SalvaDados salvar = new SalvaDados("setores", this.getStatus() == 2 ? 0 : 2);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("set_codigo", 2, false, true, codigo);
                    salvar.adicionaCampo("set_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                    salvar.adicionaCampo("set_responsavel", 0, true, false, this.txtResponsavel.getTextDBEscape());
                    salvar.adicionaCampo("set_sigla", 0, true, false, this.txtSigla.getTextDBEscape());
                    salvar.adicionaCampo("set_cor", 0, true, false, StringUtil.textoDBEscape(String.valueOf(this.comboCor.getCorSelecionada().getRGB())));
                    salvar.adicionaCampo("set_impressora", 0, true, false, this.comboImpressora.getSelectedItem() != null ? StringUtil.textoDBEscape(this.comboImpressora.getSelectedItem().toString()) : "");
                    salvar.adicionaCampo("usr_codigo", 0, true, false, Funcoes.textoVazio(this.txtCodUsuario.getText()) ? null : StringUtil.textoDBEscape(this.txtCodUsuario.getTextDB()));
                    salvar.adicionaCampo("set_enviarmensagem", 4, true, false, this.checkMensagem.isSelected());
                    salvar.adicionaCampo("set_enviarmensagemretificado", 4, true, false, this.checkMensagemLaudo.isSelected());
                    salvar.adicionaCampo("ide_codigo", 2, true, false, this.textIdentificadorLamina.getText());
                    if (this.isFilialAlimentos()) {
                        salvar.adicionaCampo("set_tipoalimentos", 0, true, false, StringUtil.textoDBEscape(this.getTipoRateio()));
                        salvar.adicionaCampo("set_assinarlaudodigital", 4, false, false, this.checkAssinaDigital.isSelected());
                        salvar.adicionaCampo("usr_codlaudodigital", 0, false, false, StringUtil.isEmpty(this.textUsuarioAssinatura.getText()) ? "null" : StringUtil.textoDBEscape(this.textUsuarioAssinatura.getText()));
                    }
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaSetor(), "setores", Integer.parseInt(codigo));
                    Util.gravaAlteracaoSetor(statement, codigo);
                    this.retornoParaPesquisa = codigo;
                    if (this.checkMensagemLaudo.isSelected()) {
                        this.salvarAssociacaoUsuario(Integer.valueOf(codigo));
                    }
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Setor");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            Conexao.fecharStatement(statement);
        }
    }

    private String getTipoRateio() {
        return EnumTipoRateio.getCodigo(this.comboTipoRateioSetor.getSelectedItem().toString());
    }

    private boolean isFilialAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtResponsavel.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodUsuario.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtSigla.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton2.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboCor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboImpressora.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkMensagem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkMensagemLaudo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonUsuarios.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textIdentificadorLamina.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonIdentificadorLamina.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoRateioSetor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkAssinaDigital.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaUsuarioAssinatura.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.checkAssinaDigital.isSelected());
        this.textUsuarioAssinatura.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.checkAssinaDigital.isSelected());
        this.labelDescUsuarioAssinatura.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.checkAssinaDigital.isSelected());
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.txtResponsavel.setText("");
        this.txtCodUsuario.setText("");
        this.txtDescUsuario.setText("");
        this.txtSigla.setText("");
        this.checkMensagem.setSelected(true);
        this.checkMensagemLaudo.setSelected(true);
        this.textIdentificadorLamina.clear();
        this.labelDescricaoIdentificadorLamina.setText("");
        this.comboImpressora.setSelectedIndex(0);
        this.comboTipoRateioSetor.setSelectedIndex(0);
        this.checkAssinaDigital.setSelected(false);
        this.textUsuarioAssinatura.setText("");
        this.labelDescUsuarioAssinatura.setText("");
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.isFilialAlimentos() && this.checkAssinaDigital.isSelected() && Funcoes.textoVazio(this.textUsuarioAssinatura)) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar o T\u00e9cnico do certificado/assinatura digital.", 2);
            this.textUsuarioAssinatura.selectAll();
            this.textUsuarioAssinatura.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodUsuario.getText())) {
            Funcoes.mensagem(this, "Usu\u00e1rio n\u00e3o informado", 1);
            this.txtCodUsuario.selectAll();
            this.txtCodUsuario.grabFocus();
            return false;
        }
        if (this.txtCodUsuario.getText().trim().length() > 0 && this.txtDescUsuario.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Usu\u00e1rio n\u00e3o localizado", 1);
            this.txtCodUsuario.selectAll();
            this.txtCodUsuario.grabFocus();
            return false;
        }
        if (this.checkMensagemLaudo.isSelected() && this.listaUsuario.isEmpty()) {
            Funcoes.mensagem(this, "Selecione usu\u00e1rio para enviar mensagem de retifica\u00e7\u00e3o", 1);
            return false;
        }
        return true;
    }

    private void buscaUsuario() {
        Hashtable resultado = Pesquisas.usuario(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodUsuario.setText(resultado.get("usr_codigo").toString());
        }
        this.txtCodUsuario.requestFocus();
    }

    private void buscaUsuarioAssinatura() {
        Hashtable resultado = Pesquisas.usuario(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.textUsuarioAssinatura.setText(resultado.get("usr_codigo").toString());
        }
        this.textUsuarioAssinatura.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodUsuario.hasFocus()) {
            this.buscaUsuario();
        } else if (this.textUsuarioAssinatura.hasFocus()) {
            this.buscaUsuarioAssinatura();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900300");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "set_codigo";
    }

    private void buscaIdentificadorLamina() {
        if (!Funcoes.textoVazio(this.textIdentificadorLamina)) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("ide_codigo", this.textIdentificadorLamina.getText());
            try {
                IdentificadorLaminaBean bean = (IdentificadorLaminaBean)new IdentificadorLaminaService().getBean(chaves);
                if (bean != null) {
                    this.labelDescricaoIdentificadorLamina.setText(bean.getDescricao());
                } else {
                    Funcoes.mensagem(this, "Identificador de l\u00e2mina n\u00e3o localizado.", 2);
                    this.textIdentificadorLamina.selectAll();
                    ScreenUtil.requisitarFoco(this.textIdentificadorLamina);
                }
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do identificador de l\u00e2mina.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void pesquisaIdentificadorLamina() {
        IdentificadorLaminaVO vo = new IdentificadorLaminaVO();
        vo = (IdentificadorLaminaVO)new IdentificadorLaminaService().pesquisaVO(this.getTopLevelAncestor(), vo, "Pesquisando Identificadores de L\u00e2mina", true);
        if (vo != null) {
            this.textIdentificadorLamina.setText(vo.getCodigo().toString());
            this.labelDescricaoIdentificadorLamina.setText(vo.getDescricao());
        }
    }

    private void salvarAssociacaoUsuario(Integer codigo) throws SQLException {
        SetorService service = new SetorService();
        this.removerUsuarios(service, codigo);
        for (SetorUsuarioVO setorUsuarioVO : this.listaUsuario) {
            setorUsuarioVO.setCodigoSetor(codigo);
            setorUsuarioVO.setTipo("R");
            service.inserirSetorUsuario(setorUsuarioVO);
        }
    }

    private void removerUsuarios(SetorService service, Integer codigo) throws SQLException {
        ArrayList<SetorUsuarioVO> removidos = new ArrayList<SetorUsuarioVO>();
        for (SetorUsuarioVO materialUsuario : this.listaUsuario) {
            if (this.checkMensagemLaudo.isSelected()) continue;
            removidos.add(materialUsuario);
        }
        for (SetorUsuarioVO materialUsuarioVO : removidos) {
            this.listaUsuario.remove(materialUsuarioVO);
        }
        service.removeUsuarios(this.listaUsuario, new SetorUsuarioVO(Integer.valueOf(Variaveis.filialPadrao), codigo));
    }
}

