/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.financeiro.util.Impostos;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ServicoImpostos
extends AbstractDialogoOKCancelar {
    public static final String COLUNA_INICIAL = "valorinicial";
    public static final String COLUNA_FINAL = "valorfinal";
    public static final String COLUNA_PERCENTUAL = "percentual";
    private JComboBox comboImposto = ComponenteFactory.novoJComboBox((Object[])Impostos.getImpostos(), this, true, null);
    private TTextField textValorInicial = new TTextField(10, 2, 3);
    private TTextField textValorFinal = new TTextField(10, 2, 3);
    private TTextField textPercentual = new TTextField(10, 2, 4);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Inicial", "Final", "Percentual"});
    private JTable table = new JTable(this.modelo);
    private Hashtable<String, Registro[]> impostos = new Hashtable();

    public static ServicoImpostos novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new ServicoImpostos((Frame)owner, "Impostos");
        }
        if (owner instanceof Dialog) {
            return new ServicoImpostos((Dialog)owner, "Impostos");
        }
        return null;
    }

    public ServicoImpostos(Frame owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
    }

    public ServicoImpostos(Dialog owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(400, 400));
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ServicoImpostos.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ServicoImpostos.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Impostos imp = (Impostos)((Object)ServicoImpostos.this.comboImposto.getSelectedItem());
                    if (ServicoImpostos.this.impostos.get(imp.getCodigo()) != null) {
                        ServicoImpostos.this.impostos.put(imp.getCodigo(), ArraysUtil.remover((Registro[])ServicoImpostos.this.impostos.get(imp.getCodigo()), ServicoImpostos.this.table.getSelectedRow()));
                    }
                    ServicoImpostos.this.modelo.removeLine(ServicoImpostos.this.table.getSelectedRow());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (ServicoImpostos.this.impostos.size() > 0) {
                    ServicoImpostos.this.buscaImposto();
                }
            }
        });
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 1, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 4;
        panel.add((Component)ComponenteFactory.novoJLabel("Imposto", 'I', null, this.comboImposto), c);
        ++c.gridy;
        this.comboImposto.setPreferredSize(new Dimension(100, 20));
        panel.add((Component)this.comboImposto, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        ++c.gridy;
        c.anchor = 17;
        panel.add((Component)ComponenteFactory.novoJLabel("Valor inicial", 'n', null, this.textValorInicial), c);
        c.gridx = 1;
        panel.add((Component)ComponenteFactory.novoJLabel("Valor final", 'f', null, this.textValorFinal), c);
        c.gridx = 2;
        panel.add((Component)ComponenteFactory.novoJLabel("Percentual", 'p', null, this.textPercentual), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.textValorInicial.setPreferredSize(new Dimension(100, 20));
        this.textValorInicial.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.textValorInicial, c);
        c.gridx = 1;
        this.textValorFinal.setPreferredSize(new Dimension(100, 20));
        this.textValorFinal.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.textValorFinal, c);
        c.gridx = 2;
        this.textPercentual.setPreferredSize(new Dimension(100, 20));
        this.textPercentual.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.textPercentual, c);
        c.weightx = 0.0;
        c.gridx = 3;
        c.fill = 0;
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setMnemonic('K');
        panel.add((Component)this.buttonOK, c);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 4;
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.table), c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.adicionarValor();
        } else if (e.getSource() == this.comboImposto) {
            this.buscaImposto();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarValor() {
        if (Funcoes.isNumeric(this.textValorInicial.getText()) && Funcoes.isNumeric(this.textValorFinal.getText()) && Funcoes.isNumeric(this.textPercentual.getText())) {
            this.modelo.addLine(new String[]{Funcoes.formataDecimal(this.textValorInicial.getMaskDecimal(), Double.parseDouble(this.textValorInicial.getText())), Funcoes.formataDecimal(this.textValorFinal.getMaskDecimal(), Double.parseDouble(this.textValorFinal.getText())), Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), Double.parseDouble(this.textPercentual.getText()))});
            Impostos imp = (Impostos)((Object)this.comboImposto.getSelectedItem());
            Registro r = new Registro();
            r.setValor(COLUNA_INICIAL, Double.parseDouble(this.textValorInicial.getText()));
            r.setValor(COLUNA_FINAL, Double.parseDouble(this.textValorFinal.getText()));
            r.setValor(COLUNA_PERCENTUAL, Double.parseDouble(this.textPercentual.getText()));
            if (this.impostos.get(imp.getCodigo()) != null) {
                Registro[] reg = this.impostos.get(imp.getCodigo());
                this.impostos.put(imp.getCodigo(), ArraysUtil.concatenar(reg, new Registro[]{r}));
            } else {
                this.impostos.put(imp.getCodigo(), new Registro[]{r});
            }
        }
        this.textValorInicial.clear();
        this.textValorFinal.clear();
        this.textPercentual.clear();
        this.textValorInicial.grabFocus();
    }

    private void buscaImposto() {
        this.modelo.clear();
        Impostos imp = (Impostos)((Object)this.comboImposto.getSelectedItem());
        if (this.impostos.get(imp.getCodigo()) != null) {
            Registro[] registros;
            for (Registro r : registros = this.impostos.get(imp.getCodigo())) {
                this.modelo.addLine(new String[]{Funcoes.formataDecimal(this.textValorInicial.getMaskDecimal(), r.getDouble(COLUNA_INICIAL)), Funcoes.formataDecimal(this.textValorFinal.getMaskDecimal(), r.getDouble(COLUNA_FINAL)), Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), r.getDouble(COLUNA_PERCENTUAL))});
            }
        }
    }

    public void adicionarImposto(Impostos imposto, Registro[] registros) {
        if (this.impostos != null) {
            this.impostos.put(imposto.getCodigo(), registros);
        }
    }

    public Registro[] pegaValoresImposto(Impostos imposto) {
        if (this.impostos.get(imposto.getCodigo()) != null) {
            return this.impostos.get(imposto.getCodigo());
        }
        return null;
    }

    public Hashtable<String, Registro[]> getImpostos() {
        return this.impostos;
    }
}

