/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.ServicoImpostos;
import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisCombo;
import jalis.laboratorio.financeiro.faturamento.integracao.SistemaEmissaoNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.remover.IntegracaoG2KA;
import jalis.laboratorio.financeiro.faturamento.integracao.remover.Padrao;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.laboratorio.financeiro.util.Impostos;
import jalis.laboratorio.financeiro.util.TipoServico;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.cadastro.financeiro.ServicoImpostoBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.financeiro.ServicoService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Servico
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelTipoServico = new JLabel("Tipo Servi\u00e7o:");
    private JLabel labelNaturezaOperacao = new JLabel("Natureza Opera\u00e7\u00e3o:");
    private JLabel labelTributacao = new JLabel("Tributa\u00e7\u00e3o:");
    private JLabel labelTributavel = new JLabel("Tribut\u00e1vel:");
    private JLabel labelCodigoTributacaoMunicipio = new JLabel("C\u00f3d. Tributa\u00e7\u00e3o Municipal:");
    private JLabel labelItemListaServico = new JLabel("Item da Lista de Servi\u00e7os:");
    private JLabel labelTipoCalculo = new JLabel("Tipo de C\u00e1lculo:");
    private JLabel labelTipoDeducao = new JLabel("Tipo de Dedu\u00e7\u00e3o:");
    private JLabel labelPercentual = new JLabel("Percentual da Base de C\u00e1lculo:");
    private JLabel labelExigibilidadeISS = new JLabel("Exigibilidade de ISS:");
    private JLabel labelPercentualIbpt = new JLabel("Percentual IBPT:");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(150, 3);
    private TTextField textCodigoTributacaoMunicipio = new TTextField(20, 3);
    private TTextField textItemListaServico = new TTextField(5, 3);
    private TTextField textPercentual = new TTextField(6, 2);
    private TTextField textPercentualIbtp = new TTextField(6, 2);
    private JComboBox comboNaturezaOperacao = new JComboBox();
    private JComboBox comboTributacao = new JComboBox();
    private JComboBox comboTributavel = new JComboBox();
    private JComboBox comboExigibilidadeISS = new JComboBox();
    private JComboBox comboTipoServico = new JComboBox();
    private JCheckBox checkEnviaDeducaoNfe = new JCheckBox("Enviar informa\u00e7\u00f5es de dedu\u00e7\u00e3o para NFSe");
    private JPanel panelDeducaoMaterial = new JPanel(new GridBagLayout());
    private JButton buttonImpostos = new JButton("Impostos");
    private FilialBean filialBean = null;
    private Padrao padraoG2ka = null;
    private TecnospeedUtil.Padrao padraoTecnospeed = null;
    private String retornoParaPesquisa = "";
    Hashtable<String, Registro[]> impostos = new Hashtable();
    private SistemaEmissaoNFSe sistemaEmissaoNFSe = Laboratorio.sistemaEmissorNFSe;
    private final String ACESSO_IMPOSTOS = "0600300604";

    public Servico() {
        this.setName("Servico");
        this.setLabelDescricao("Cadastro de servi\u00e7os para nota fiscal");
        this.setLabelFormulario("Cadastro de servi\u00e7o");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_servico.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (this.sistemaEmissaoNFSe != null) {
            if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
                this.getDadosFilialG2ka();
                this.getItensNaturezaOperacaoG2ka();
                this.getItensTributacaoG2ka();
                this.getItensTributavelG2ka();
                this.getItensExigibilidadeISSG2ka();
            } else if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.TECNOSPEED || this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS) {
                this.comboTipoServico = new JComboBox<TipoServico>(TipoServico.values());
                this.getDadosFilialTecnospeed();
                this.getItensNaturezaOperacaoTecnospeed();
                this.getItensTributacaoTecnospeed();
                this.getItensTributavelTecnospeed();
                this.getItensExigibilidadeISSTecnospeed();
            }
        } else {
            this.comboTipoServico = new JComboBox<TipoServico>(TipoServico.values());
            this.getDadosFilialTecnospeed();
            this.getItensTributacaoTecnospeed();
            this.getItensTributavelTecnospeed();
            this.getItensExigibilidadeISSTecnospeed();
            this.comboNaturezaOperacao = new JComboBox();
        }
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.labelDescricao.setDisplayedMnemonic('r');
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.labelNaturezaOperacao.setLabelFor(this.comboTipoServico);
        this.labelNaturezaOperacao.setDisplayedMnemonic('N');
        this.painelCentral.add((Component)this.labelTipoServico, c);
        ++c.gridx;
        c.fill = 2;
        this.painelCentral.add((Component)this.comboTipoServico, c);
        this.comboTipoServico.setName("comboTipoServico");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.labelNaturezaOperacao.setLabelFor(this.comboNaturezaOperacao);
        this.labelNaturezaOperacao.setDisplayedMnemonic('N');
        this.painelCentral.add((Component)this.labelNaturezaOperacao, c);
        ++c.gridx;
        c.fill = 2;
        this.painelCentral.add((Component)this.comboNaturezaOperacao, c);
        this.comboNaturezaOperacao.setName("comboNaturezaOperacao");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.labelTributacao.setLabelFor(this.comboTributacao);
        this.labelTributacao.setDisplayedMnemonic('T');
        this.painelCentral.add((Component)this.labelTributacao, c);
        ++c.gridx;
        c.fill = 2;
        this.painelCentral.add((Component)this.comboTributacao, c);
        this.comboTributacao.setName("comboTributacao");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.labelTributavel.setLabelFor(this.comboTributavel);
        this.labelTributavel.setDisplayedMnemonic('v');
        this.painelCentral.add((Component)this.labelTributavel, c);
        ++c.gridx;
        c.fill = 2;
        this.painelCentral.add((Component)this.comboTributavel, c);
        this.comboTributavel.setName("comboTributavel");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.labelExigibilidadeISS.setLabelFor(this.comboExigibilidadeISS);
        this.labelExigibilidadeISS.setDisplayedMnemonic('x');
        this.painelCentral.add((Component)this.labelExigibilidadeISS, c);
        ++c.gridx;
        c.fill = 2;
        this.painelCentral.add((Component)this.comboExigibilidadeISS, c);
        this.comboExigibilidadeISS.setName("comboExigibilidadeISS");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.labelCodigoTributacaoMunicipio.setLabelFor(this.textCodigoTributacaoMunicipio);
        this.labelCodigoTributacaoMunicipio.setDisplayedMnemonic('M');
        this.painelCentral.add((Component)this.labelCodigoTributacaoMunicipio, c);
        ++c.gridx;
        c.fill = 2;
        this.textCodigoTributacaoMunicipio.setPreferredSize(new Dimension(20, 20));
        this.textCodigoTributacaoMunicipio.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.textCodigoTributacaoMunicipio, c);
        this.textCodigoTributacaoMunicipio.setName("textCodigoTributacaoMunicipio");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.labelItemListaServico.setLabelFor(this.textItemListaServico);
        this.labelItemListaServico.setDisplayedMnemonic('L');
        this.painelCentral.add((Component)this.labelItemListaServico, c);
        ++c.gridx;
        c.fill = 2;
        this.textItemListaServico.setPreferredSize(new Dimension(20, 20));
        this.textItemListaServico.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.textItemListaServico, c);
        this.textItemListaServico.setName("textItemListaServico");
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        this.labelPercentual.setLabelFor(this.textPercentual);
        this.labelPercentual.setDisplayedMnemonic('P');
        this.painelCentral.add((Component)this.labelPercentual, c);
        ++c.gridx;
        c.fill = 0;
        this.textPercentual.setPreferredSize(new Dimension(70, 20));
        this.textPercentual.setMinimumSize(new Dimension(70, 20));
        this.textPercentual.setName("textPercentual");
        this.painelCentral.add((Component)this.textPercentual, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelPercentualIbpt, c);
        ++c.gridx;
        c.fill = 0;
        this.textPercentualIbtp.setPreferredSize(new Dimension(70, 20));
        this.textPercentualIbtp.setMinimumSize(new Dimension(70, 20));
        this.painelCentral.add((Component)this.textPercentualIbtp, c);
        this.textPercentualIbtp.setName("textPercentualIbtp");
        ++c.gridy;
        c.gridx = 1;
        c.fill = 2;
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkEnviaDeducaoNfe, c);
        this.checkEnviaDeducaoNfe.setName("checkEnviaDeducaoNfe");
        ++c.gridy;
        c.gridx = 1;
        c.fill = 0;
        this.buttonImpostos.setMnemonic('I');
        this.painelCentral.add((Component)this.buttonImpostos, c);
        this.buttonImpostos.setName("buttonImpostos");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        this.buttonImpostos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Servico.this.configurarImpostos();
            }
        });
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new ServicoService();
        this.controlaCampos();
    }

    private void configurarImpostos() {
        ServicoImpostos imp = ServicoImpostos.novaInstancia(this.getTopLevelAncestor());
        if (imp != null) {
            for (String s : this.impostos.keySet()) {
                if (this.impostos.get(s) == null) continue;
                imp.adicionarImposto(Impostos.getImposto(s), this.impostos.get(s));
            }
            imp.setLocationRelativeTo(this.getTopLevelAncestor());
            imp.setVisible(true);
            if (imp.getOK()) {
                this.impostos = imp.getImpostos();
            }
        }
    }

    private void getDadosFilialG2ka() {
        try {
            this.filialBean = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
            this.padraoG2ka = Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da filial.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void getDadosFilialTecnospeed() {
        try {
            this.filialBean = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
            this.padraoTecnospeed = TecnospeedUtil.Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da filial.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void getItensTributavelG2ka() {
        if (this.filialBean != null && this.padraoG2ka != null) {
            IntegracaoG2KA.Tributavel[] itens = IntegracaoG2KA.Tributavel.getItens(this.padraoG2ka);
            this.comboTributavel = new JComboBox<IntegracaoG2KA.Tributavel>(itens);
        } else {
            this.comboTributavel = new JComboBox();
        }
    }

    private void getItensTributavelTecnospeed() {
        this.comboTributavel = new JComboBox<TecnospeedUtil.Tributavel>(TecnospeedUtil.Tributavel.values());
    }

    private void getItensExigibilidadeISSG2ka() {
        if (this.filialBean != null && this.padraoG2ka != null) {
            IntegracaoG2KA.ExigibilidadeISS[] itens = IntegracaoG2KA.ExigibilidadeISS.getItens(this.padraoG2ka);
            this.comboExigibilidadeISS = new JComboBox<IntegracaoG2KA.ExigibilidadeISS>(itens);
        } else {
            this.comboExigibilidadeISS = new JComboBox();
        }
    }

    private void getItensExigibilidadeISSTecnospeed() {
        this.comboExigibilidadeISS = new JComboBox<TecnospeedUtil.ExigibilidadeISS>(TecnospeedUtil.ExigibilidadeISS.values());
    }

    private void getItensTributacaoG2ka() {
        if (this.filialBean != null && this.padraoG2ka != null) {
            IntegracaoG2KA.Tributacao[] itens = IntegracaoG2KA.Tributacao.getItens(this.padraoG2ka);
            this.comboTributacao = new JComboBox<IntegracaoG2KA.Tributacao>(itens);
        } else {
            this.comboTributacao = new JComboBox();
        }
    }

    private void getItensTributacaoTecnospeed() {
        this.comboTributacao = new JComboBox<TecnospeedUtil.Tributacao>(TecnospeedUtil.Tributacao.values());
    }

    private void getItensNaturezaOperacaoG2ka() {
        if (this.filialBean != null && this.padraoG2ka != null) {
            IntegracaoG2KA.NaturezaOperacao[] itens = IntegracaoG2KA.NaturezaOperacao.getItens(this.padraoG2ka);
            this.comboNaturezaOperacao = new JComboBox<IntegracaoG2KA.NaturezaOperacao>(itens);
        } else {
            this.comboNaturezaOperacao = new JComboBox();
        }
    }

    private void getItensNaturezaOperacaoTecnospeed() {
        if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.TECNOSPEED) {
            this.comboNaturezaOperacao = new JComboBox<TecnospeedUtil.NaturezaOperacao>(TecnospeedUtil.NaturezaOperacao.values());
        }
        if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS) {
            this.comboNaturezaOperacao = new JComboBox();
        }
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTributacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTributavel.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboExigibilidadeISS.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoServico.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboNaturezaOperacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoTributacaoMunicipio.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textItemListaServico.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonImpostos.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textPercentual.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textPercentualIbtp.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkEnviaDeducaoNfe.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        if (this.comboNaturezaOperacao.getItemCount() == 0) {
            this.comboNaturezaOperacao.setEnabled(false);
        }
        if (this.comboTributacao.getItemCount() == 0) {
            this.comboTributacao.setEnabled(false);
        }
        if (this.comboTributavel.getItemCount() == 0) {
            this.comboTributavel.setEnabled(false);
        }
        if (this.comboExigibilidadeISS.getItemCount() == 0) {
            this.comboExigibilidadeISS.setEnabled(false);
        }
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        DadosEspeciaisCombo aux;
        ServicoBean bean = new ServicoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        if (this.comboNaturezaOperacao.getSelectedItem() != null) {
            aux = (DadosEspeciaisCombo)this.comboNaturezaOperacao.getSelectedItem();
            bean.setNaturezaOperacao(String.valueOf(aux.getCodigo().toString()));
        }
        if (this.comboTributacao.getSelectedItem() != null) {
            aux = (DadosEspeciaisCombo)this.comboTributacao.getSelectedItem();
            bean.setTipoTributacao(String.valueOf(aux.getCodigo().toString()));
        }
        if (this.comboTributavel.getSelectedItem() != null) {
            aux = (DadosEspeciaisCombo)this.comboTributavel.getSelectedItem();
            bean.setTributavel(String.valueOf(aux.getCodigo().toString()));
        }
        if (this.comboExigibilidadeISS.getSelectedItem() != null) {
            aux = (DadosEspeciaisCombo)this.comboExigibilidadeISS.getSelectedItem();
            bean.setExigibilidadeIss(aux.getCodigo() == null ? null : Integer.valueOf(Integer.parseInt(aux.getCodigo().toString())));
        }
        if (this.comboTipoServico.getSelectedItem() != null) {
            TipoServico tipoServico = (TipoServico)((Object)this.comboTipoServico.getSelectedItem());
            bean.setTipoServico(tipoServico.getCodigo());
        }
        if (!Funcoes.textoVazio(this.textPercentual)) {
            bean.setPercentualDeduzir(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())));
        } else {
            bean.setPercentualDeduzir(100.0);
        }
        if (!Funcoes.textoVazio(Funcoes.limpaDecimal(this.textPercentualIbtp.getText()))) {
            bean.setPercentualIbpt(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentualIbtp.getText())));
        }
        bean.setCodigoTributacaoMunicipio(this.textCodigoTributacaoMunicipio.getText());
        bean.setItemLista(this.textItemListaServico.getText());
        ArrayList<ServicoImpostoBean> listaImpostos = new ArrayList<ServicoImpostoBean>();
        for (String auxImp : this.impostos.keySet()) {
            Registro[] regs;
            for (Registro r : regs = this.impostos.get(auxImp)) {
                ServicoImpostoBean impostoBean = new ServicoImpostoBean();
                impostoBean.setFilial(filial);
                impostoBean.setImposto(auxImp);
                impostoBean.setValorAplicar(r.getDouble("percentual"));
                impostoBean.setValorInicial(r.getDouble("valorinicial"));
                impostoBean.setValorFinal(r.getDouble("valorfinal"));
                listaImpostos.add(impostoBean);
            }
        }
        bean.setImpostos(listaImpostos);
        bean.setEnviaDeducaoNfe(this.checkEnviaDeducaoNfe.isSelected());
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaServico();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.clear();
        this.textDescricao.clear();
        this.comboTipoServico.setSelectedIndex(-1);
        this.comboNaturezaOperacao.setSelectedIndex(-1);
        this.comboTributacao.setSelectedIndex(-1);
        this.comboTributavel.setSelectedIndex(-1);
        this.comboExigibilidadeISS.setSelectedIndex(-1);
        this.textPercentualIbtp.clear();
        this.textPercentual.clear();
        this.textCodigoTributacaoMunicipio.clear();
        this.textItemListaServico.clear();
        this.impostos.clear();
        this.checkEnviaDeducaoNfe.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            ServicoVO vo = (ServicoVO)this.service.pesquisaVO(this.getTopLevelAncestor(), new ServicoVO(), "Pesquisando Servi\u00e7os", false);
            if (vo != null) {
                HashMap<String, Object> chave = new HashMap<String, Object>();
                chave.put("fil_codigo", vo.getFilial().getCodigo());
                chave.put("svc_codigo", vo.getCodigo());
                ServicoBean bean = (ServicoBean)((ServicoService)this.service).getBean(chave);
                return bean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        ArrayList<ServicoImpostoBean> listaServicos;
        Enum aux;
        ServicoBean servicoBean = (ServicoBean)bean;
        this.textCodigo.setText(Integer.toString(servicoBean.getCodigo()));
        this.textDescricao.setText(servicoBean.getDescricao());
        if (this.sistemaEmissaoNFSe != null && this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
            if (servicoBean.getNaturezaOperacao() != null) {
                aux = IntegracaoG2KA.NaturezaOperacao.get(servicoBean.getNaturezaOperacao().toString());
                if (aux != null) {
                    this.comboNaturezaOperacao.setSelectedItem(aux);
                } else {
                    this.comboNaturezaOperacao.setSelectedIndex(-1);
                }
            } else {
                this.comboNaturezaOperacao.setSelectedIndex(-1);
            }
            if (servicoBean.getTributavel() != null) {
                aux = IntegracaoG2KA.Tributavel.get(servicoBean.getTributavel());
                if (aux != null) {
                    this.comboTributavel.setSelectedItem(aux);
                } else {
                    this.comboTributavel.setSelectedIndex(-1);
                }
            } else {
                this.comboTributavel.setSelectedIndex(-1);
            }
            if (servicoBean.getExigibilidadeIss() != null) {
                aux = IntegracaoG2KA.ExigibilidadeISS.get(servicoBean.getExigibilidadeIss().toString());
                if (aux != null) {
                    this.comboExigibilidadeISS.setSelectedItem(aux);
                } else {
                    this.comboExigibilidadeISS.setSelectedIndex(-1);
                }
            } else {
                this.comboExigibilidadeISS.setSelectedIndex(-1);
            }
            if (servicoBean.getTipoTributacao() != null) {
                aux = IntegracaoG2KA.Tributacao.get(servicoBean.getTipoTributacao());
                if (aux != null) {
                    this.comboTributacao.setSelectedItem(aux);
                } else {
                    this.comboTributacao.setSelectedIndex(-1);
                }
            } else {
                this.comboTributacao.setSelectedIndex(-1);
            }
        } else {
            if (servicoBean.getNaturezaOperacao() != null) {
                aux = TecnospeedUtil.NaturezaOperacao.get(servicoBean.getNaturezaOperacao());
                if (aux != null) {
                    this.comboNaturezaOperacao.setSelectedItem(aux);
                } else {
                    this.comboNaturezaOperacao.setSelectedIndex(-1);
                }
            } else {
                this.comboNaturezaOperacao.setSelectedIndex(-1);
            }
            if (servicoBean.getTributavel() != null) {
                aux = TecnospeedUtil.Tributavel.get(servicoBean.getTributavel());
                if (aux != null) {
                    this.comboTributavel.setSelectedItem(aux);
                } else {
                    this.comboTributavel.setSelectedIndex(-1);
                }
            } else {
                this.comboTributavel.setSelectedIndex(-1);
            }
            if (servicoBean.getExigibilidadeIss() != null) {
                aux = TecnospeedUtil.ExigibilidadeISS.get(servicoBean.getExigibilidadeIss().toString());
                if (aux != null) {
                    this.comboExigibilidadeISS.setSelectedItem(aux);
                } else {
                    this.comboExigibilidadeISS.setSelectedIndex(-1);
                }
            } else {
                this.comboExigibilidadeISS.setSelectedIndex(-1);
            }
            if (servicoBean.getTipoTributacao() != null) {
                aux = TecnospeedUtil.Tributacao.get(servicoBean.getTipoTributacao());
                if (aux != null) {
                    this.comboTributacao.setSelectedItem(aux);
                } else {
                    this.comboTributacao.setSelectedIndex(-1);
                }
            } else {
                this.comboTributacao.setSelectedIndex(-1);
            }
            if (!Funcoes.textoVazio(servicoBean.getTipoServico())) {
                TipoServico tipoServico = TipoServico.codigoToTipoServico(servicoBean.getTipoServico());
                this.comboTipoServico.setSelectedItem((Object)tipoServico);
            }
        }
        this.textCodigoTributacaoMunicipio.setText(servicoBean.getCodigoTributacaoMunicipio());
        this.textItemListaServico.setText(servicoBean.getItemLista());
        if (servicoBean.getPercentualDeduzir() != null) {
            this.textPercentual.setText(Funcoes.formataDecimal(servicoBean.getPercentualDeduzir()));
        } else {
            this.textPercentual.setText(Funcoes.formataDecimal(100.0));
        }
        if (servicoBean.getPercentualIbpt() != null) {
            this.textPercentualIbtp.setText(Funcoes.formataDecimal(servicoBean.getPercentualIbpt()));
        }
        if ((listaServicos = servicoBean.getImpostos()) != null) {
            for (int i = 0; i < listaServicos.size(); ++i) {
                ServicoImpostoBean aux2 = listaServicos.get(i);
                Registro r = new Registro();
                r.setValor("valorinicial", aux2.getValorInicial());
                r.setValor("valorfinal", aux2.getValorFinal());
                r.setValor("percentual", aux2.getValorAplicar());
                String key = aux2.getImposto();
                if (this.impostos.get(key) != null) {
                    Registro[] reg = this.impostos.get(key);
                    this.impostos.put(key, ArraysUtil.concatenar(reg, new Registro[]{r}));
                    continue;
                }
                this.impostos.put(aux2.getImposto(), new Registro[]{r});
            }
        }
        this.checkEnviaDeducaoNfe.setSelected(servicoBean.getEnviaDeducaoNfe());
        this.textCodigo.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            return false;
        }
        if (this.comboTipoServico.isEnabled() && this.comboTipoServico.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "Tipo do Servi\u00e7o n\u00e3o selecionado.", 2);
            ScreenUtil.requisitarFoco(this.comboTipoServico);
            return false;
        }
        if (this.comboExigibilidadeISS.isEnabled() && this.comboExigibilidadeISS.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "Exigibilidade ISS n\u00e3o selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (this.getStatus() == 3 && Funcoes.textoVazio(this.textCodigo)) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textPercentual)) {
            Funcoes.mensagem(this, "O percentual a deduzir deve ser informado.", 2);
            this.textPercentual.setText("100");
            this.textPercentual.selectAll();
            ScreenUtil.requisitarFoco(this.textPercentual);
            return false;
        }
        Double valor = Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText()));
        if (valor > 100.0) {
            Funcoes.mensagem(this, "O percentual a deduzir n\u00e3o pode ultrapassar 100%.", 2);
            this.textPercentual.setText("100");
            this.textPercentual.selectAll();
            ScreenUtil.requisitarFoco(this.textPercentual);
            return false;
        }
        if (!Funcoes.textoVazio(Funcoes.limpaDecimal(this.textPercentualIbtp.getText())) && (valor = Double.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentualIbtp.getText())))) > 100.0) {
            Funcoes.mensagem(this, "O percentual Ibtp n\u00e3o pode ultrapassar 100%.", 2);
            this.textPercentualIbtp.setText("100");
            this.textPercentualIbtp.selectAll();
            ScreenUtil.requisitarFoco(this.textPercentual);
            return false;
        }
        return true;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Servico.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300601"));
        this.setModuloEdita(Long.parseLong("0600300602"));
        this.setModuloApaga(Long.parseLong("0600300603"));
        this.buttonImpostos.setVisible(Acesso.getAcesso(Long.parseLong("0600300604")));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300600");
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        this.checkEnviaDeducaoNfe.setSelected(true);
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((ServicoBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "svc_codigo";
    }
}

