/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.SeriesBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.relatorio.Editor;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.matricial.EditorRelatorio;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Series
extends FrmCadPadraoBean
implements ActionListener {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JCheckBox checkImprimirNota = new JCheckBox("Imprimir Nota");
    private JCheckBox checkRelacionarNfse = new JCheckBox("N\u00e3o gerar NFSe");
    private JCheckBox checkSolicitarRps = new JCheckBox("Solicitar RPS");
    private TTextField textCodigo = new TTextField(2, 3);
    private TTextField textDescricao = new TTextField(100, 3);
    private JComboBox comboTipoNota = new JComboBox<String>(new String[]{Tipos.tipoLayoutImpressao("C"), Tipos.tipoLayoutImpressao("D")});
    private JComboBox comboTipoNotaCpf = new JComboBox<String>(new String[]{Tipos.tipoLayoutImpressao("C"), Tipos.tipoLayoutImpressao("D")});
    private JButton buttonNota = ComponenteFactory.novoJButton("Modelo Nota", this);
    private JButton buttonNotaCpf = ComponenteFactory.novoJButton("Modelo Nota", this);
    private JPopupMenu menu = new JPopupMenu("");
    private JPopupMenu menuCpf = new JPopupMenu("");
    private JMenuItem menuNovo = ComponenteFactory.novoJMenuItem(this.menu, "Novo/Alterar", (ActionListener)this);
    private JMenuItem menuCopiar = ComponenteFactory.novoJMenuItem(this.menu, "Copiar modelo", (ActionListener)this);
    private JMenuItem menuNovoCpf = ComponenteFactory.novoJMenuItem(this.menuCpf, "Novo/Alterar", (ActionListener)this);
    private JMenuItem menuCopiarCpf = ComponenteFactory.novoJMenuItem(this.menuCpf, "Copiar modelo", (ActionListener)this);
    private String modeloNota = "";
    private String modeloNotaCpf = "";
    String retornoParaPesquisa = "";

    public Series() {
        this.setName("Series");
        this.setLabelDescricao("Cadastro de s\u00e9ries");
        this.setLabelFormulario("Cadastro de s\u00e9ries fiscais");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_serie.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(Series.this.textCodigo.getText())) {
                    Series.this.textCodigo.setText(Series.this.verificaCodigoSerie(StringUtil.removerAcentos(Series.this.textCodigo.getText())));
                    Series.this.verificaSerie();
                }
            }
        });
        d = new Dimension(300, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)new JLabel("Nota P. Jur\u00eddica:"), c);
        ++c.gridx;
        this.comboTipoNota.setPreferredSize(new Dimension(200, 20));
        this.comboTipoNota.setName("comboTipoNota");
        this.buttonNota.setPreferredSize(new Dimension(100, 20));
        this.buttonNota.setName("buttonNota");
        this.painelCentral.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 0, 0, this.comboTipoNota, this.buttonNota), c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)new JLabel("Nota P. Fis\u00edca:"), c);
        ++c.gridx;
        this.comboTipoNotaCpf.setPreferredSize(new Dimension(200, 20));
        this.comboTipoNotaCpf.setName("comboTipoNotaCpf");
        this.buttonNotaCpf.setPreferredSize(new Dimension(100, 20));
        this.buttonNotaCpf.setName("buttonNotaCpf");
        this.painelCentral.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 0, 0, this.comboTipoNotaCpf, this.buttonNotaCpf), c);
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkImprimirNota, c);
        this.checkImprimirNota.setName("checkImprimirNota");
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkRelacionarNfse, c);
        this.checkRelacionarNfse.setName("checkRelacionarNfse");
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkSolicitarRps, c);
        this.checkSolicitarRps.setName("checkSolicitarRps");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.textCodigo.setUpperCase(true);
        this.service = new SeriesService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkImprimirNota.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkRelacionarNfse.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkSolicitarRps.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoNota.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonNota.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoNotaCpf.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonNotaCpf.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        boolean isNFSe;
        SeriesBean bean = new SeriesBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setCodigo(this.textCodigo.getText());
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setImprimirNota(this.checkImprimirNota.isSelected());
        bean.setTipoModeloNota(this.getTipoImpressao(this.comboTipoNota.getSelectedItem().toString()));
        bean.setModeloNota(this.modeloNota);
        bean.setTipoModeloNotaCpf(this.getTipoImpressao(this.comboTipoNotaCpf.getSelectedItem().toString()));
        bean.setModeloNotaCpf(this.modeloNotaCpf);
        bean.setSolicitarRps(this.checkSolicitarRps.isSelected());
        boolean bl = isNFSe = !Funcoes.textoVazio(ParametrosGerais.getIpWsNfse()) && !Funcoes.textoVazio(ParametrosGerais.getPortaWsNfse());
        if (this.getStatus() == 2 && isNFSe) {
            bean.setNumeroRps(0);
        }
        return bean;
    }

    private String getTipoImpressao(String tipoSelecionado) {
        if (tipoSelecionado.equals(Tipos.tipoLayoutImpressao("D"))) {
            return "D";
        }
        return "C";
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaSeries();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.checkImprimirNota.setSelected(false);
        this.checkRelacionarNfse.setSelected(false);
        this.checkSolicitarRps.setSelected(false);
        this.modeloNota = "";
        this.modeloNotaCpf = "";
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new SeriesVO(), "Pesquisando series ", false);
            if (vo != null) {
                SeriesBean seriesBean = (SeriesBean)this.service.voToBean((SeriesVO)vo, SeriesBean.class);
                return seriesBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Series:135");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        SeriesBean seriesBean = (SeriesBean)bean;
        this.textCodigo.setText(seriesBean.getCodigo());
        this.textDescricao.setText(seriesBean.getDescricao());
        this.checkImprimirNota.setSelected(seriesBean.getImprimirNota());
        this.modeloNota = seriesBean.getModeloNota();
        this.modeloNotaCpf = seriesBean.getModeloNotaCpf();
        this.comboTipoNota.setSelectedItem(Tipos.tipoLayoutImpressao(seriesBean.getTipoModeloNota()));
        this.comboTipoNotaCpf.setSelectedItem(Tipos.tipoLayoutImpressao(seriesBean.getTipoModeloNotaCpf()));
        this.textCodigo.setEnabled(false);
        this.checkRelacionarNfse.setSelected(!SeriesService.podeGerarNotaFiscalEletronica(seriesBean.getFilial().getCodigo(), seriesBean.getCodigo()));
        this.checkSolicitarRps.setSelected(seriesBean.getSolicitarRps());
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.textoVazio(this.textCodigo.getText()) && !Funcoes.textoVazio(this.textDescricao.getText())) {
            return true;
        }
        if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchida", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        return false;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Series.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300301"));
        this.setModuloEdita(Long.parseLong("0600300302"));
        this.setModuloApaga(Long.parseLong("0600300303"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300300");
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    private void verificaSerie() {
        try {
            AbstractThreadBean serie = ((SeriesService)this.service).get(Variaveis.filialPadrao, this.textCodigo.getText());
            if (serie == null) {
                return;
            }
            this.preencherCampos(serie);
            this.setStatus(3);
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textDescricao);
            this.textCodigo.setEnabled(false);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Series:200");
        }
    }

    private String verificaCodigoSerie(String serie) {
        char[] cSerie;
        StringBuilder retorno = new StringBuilder();
        for (char c : cSerie = serie.toCharArray()) {
            if (String.valueOf(c).matches("[a-zA-Z0-9]")) {
                retorno.append(c);
                continue;
            }
            retorno.append("");
        }
        return retorno.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonNota) {
            this.menu.show(this.buttonNota.getParent(), this.buttonNota.getX(), this.buttonNota.getY() + this.buttonNota.getHeight());
        } else if (e.getSource() == this.buttonNotaCpf) {
            this.menuCpf.show(this.buttonNotaCpf.getParent(), this.buttonNotaCpf.getX(), this.buttonNotaCpf.getY() + this.buttonNotaCpf.getHeight());
        } else if (e.getSource() == this.menuCopiar) {
            this.copiarNota();
        } else if (e.getSource() == this.menuNovo) {
            this.novaNota();
        }
        if (e.getSource() == this.menuCopiarCpf) {
            this.copiarNota();
        } else if (e.getSource() == this.menuNovoCpf) {
            this.novaNotaCpf();
        }
    }

    private void copiarNota() {
    }

    private void novaNota() {
        String tipoImpressao = this.comboTipoNota.getSelectedItem().toString();
        if (tipoImpressao.equals(Tipos.tipoLayoutImpressao("D"))) {
            EditorRelatorio editorRelatorio = new EditorRelatorio((Frame)this.getTopLevelAncestor(), "Configurando nota fiscal de sa\u00edda", true);
            editorRelatorio.setCampoDoBanco(Impressao.CAMPOS_NOTA_FISCAL_SAIDA);
            editorRelatorio.setCabecalhoRodape(this.modeloNota);
            editorRelatorio.setVisible(true);
            if (editorRelatorio.ok()) {
                this.modeloNota = editorRelatorio.getCabecalhoRodape();
            }
            editorRelatorio = null;
        } else {
            Editor relatorio = new Editor((JFrame)this.getTopLevelAncestor(), "Configurando nota fiscal de sa\u00edda", true);
            relatorio.setCamposDoBanco(Impressao.CAMPOS_NOTA_FISCAL_SAIDA);
            relatorio.setAtributos(this.modeloNota);
            relatorio.setVisible(true);
            if (relatorio.ok()) {
                this.modeloNota = relatorio.getAtributos();
            }
            Object var2_3 = null;
        }
    }

    private void novaNotaCpf() {
        String tipoImpressao = this.comboTipoNotaCpf.getSelectedItem().toString();
        if (tipoImpressao.equals(Tipos.tipoLayoutImpressao("D"))) {
            EditorRelatorio editorRelatorio = new EditorRelatorio((Frame)this.getTopLevelAncestor(), "Configurando nota fiscal de sa\u00edda para pessoa f\u00edsica", true);
            editorRelatorio.setCampoDoBanco(Impressao.CAMPOS_NOTA_FISCAL_PESSOA_FISICA);
            editorRelatorio.setCabecalhoRodape(this.modeloNotaCpf);
            editorRelatorio.setVisible(true);
            if (editorRelatorio.ok()) {
                this.modeloNotaCpf = editorRelatorio.getCabecalhoRodape();
            }
            editorRelatorio = null;
        } else {
            Editor relatorio = new Editor((JFrame)this.getTopLevelAncestor(), "Configurando nota fiscal de sa\u00edda para pessoa f\u00edsica", true);
            relatorio.setCamposDoBanco(Impressao.CAMPOS_NOTA_FISCAL_PESSOA_FISICA);
            relatorio.setAtributos(this.modeloNotaCpf);
            relatorio.setVisible(true);
            if (relatorio.ok()) {
                this.modeloNotaCpf = relatorio.getAtributos();
            }
            Object var2_3 = null;
        }
    }

    @Override
    public void salvar() {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                new SeriesService().gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                String[] codigosFiliais = !Funcoes.textoVazio(this.getCopiaFiliais()) ? StringUtil.getValor(this.getCopiaFiliais(), "filiais").split(",") : new String[]{};
                codigosFiliais = codigosFiliais == null || codigosFiliais.length == 0 ? new String[]{Variaveis.filialPadrao} : ArraysUtil.concatenar(codigosFiliais, new String[]{Variaveis.filialPadrao});
                SeriesService.atualizaRelacionarNfseSemCommit(codigosFiliais, Variaveis.filialPadrao, ((SeriesBean)bean).getCodigo(), this.checkRelacionarNfse.isSelected());
                this.retornoParaPesquisa = ((SeriesBean)bean).getCodigo();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar s\u00e9rie fiscal.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ser_codigo";
    }
}

