/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SenhaWeb
extends JDialog
implements DisposeListener {
    private JLabel lblSenha = new JLabel(" Senha: ");
    private TTextField txtSenha = new TTextField(12);
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton btnSalvar = new JButton("OK");
    private JButton btnFechar = new JButton("Cancelar");
    private JButton btnGerar = new JButton("Gerar");
    private JButton buttonEnviar = new JButton("Enviar \u25bc");
    private JPopupMenu menuEnviar = new JPopupMenu();
    private JMenuItem buttonSMS = new JMenuItem("SMS");
    private JMenuItem buttonEmail = new JMenuItem("E-mail");
    private JMenuItem buttonWhatsapp = new JMenuItem("WhatsApp");
    private boolean filialPodeEnviarEmailMedico = false;
    private boolean filialPodeEnviarEmail = false;
    private String senha = "";
    private boolean salvarPressionado = false;
    private boolean emailEnviado = false;
    private String celular = "";
    private String email = "";
    private String celularWhatsApp = "";
    private String codigoFilial = Variaveis.filialPadrao;
    private String codigoPaciente = "";
    private boolean acessoEmail = false;
    private boolean acessoSMS = false;
    private boolean acessoWhatsapp = false;
    private String crmMedico = "";
    private String conselho = "";
    private String ufMedico = "";
    private String emailMedico = "";
    private ArrayList<String> emailMedicoContato;
    private boolean enviarSms = false;
    private boolean enviarWhatsapp = false;
    private boolean isSenhaWebPaciente = false;
    private boolean filialEnviarSMSSenhaWeb = false;

    public static SenhaWeb novaInstancia(Component owner, boolean isSenhaWebPaciente) {
        if (owner instanceof Frame) {
            return new SenhaWeb((Frame)owner, isSenhaWebPaciente);
        }
        if (owner instanceof Dialog) {
            return new SenhaWeb((JDialog)owner, isSenhaWebPaciente);
        }
        return null;
    }

    public static SenhaWeb novaInstancia(Component owner, String codigoFilial, String codigoPaciente, String[] celular, boolean acessoEmail, boolean acessoSMS, boolean acessoWhatsapp, String email) {
        if (owner instanceof Frame) {
            return new SenhaWeb((Frame)owner, codigoFilial, codigoPaciente, celular, acessoEmail, acessoSMS, acessoWhatsapp, email);
        }
        if (owner instanceof Dialog) {
            return new SenhaWeb((JDialog)owner, codigoFilial, codigoPaciente, celular, acessoEmail, acessoSMS, acessoWhatsapp, email);
        }
        return null;
    }

    public SenhaWeb(Frame owner, boolean isSenhaWebPaciente) {
        super(owner);
        this.montaTela(isSenhaWebPaciente);
    }

    public SenhaWeb(JDialog owner, boolean isSenhaWebPaciente) {
        super(owner);
        this.montaTela(isSenhaWebPaciente);
    }

    public SenhaWeb(Frame owner, String codigoFilial, String codigoPaciente, String[] celular, boolean acessoEmail, boolean acessoSMS, boolean acessoWhatsapp, String email) {
        super(owner);
        this.codigoFilial = codigoFilial;
        this.codigoPaciente = codigoPaciente;
        this.celular = celular[0];
        this.celularWhatsApp = celular[1];
        this.acessoEmail = acessoEmail;
        this.acessoSMS = acessoSMS;
        this.acessoWhatsapp = acessoWhatsapp;
        this.email = email;
        this.montaTela(true);
    }

    public SenhaWeb(JDialog owner, String codigoFilial, String codigoPaciente, String[] celular, boolean acessoEmail, boolean acessoSMS, boolean acessoWhatsapp, String email) {
        super(owner);
        this.codigoFilial = codigoFilial;
        this.codigoPaciente = codigoPaciente;
        this.celular = celular[0];
        this.celularWhatsApp = celular[1];
        this.acessoEmail = acessoEmail;
        this.acessoSMS = acessoSMS;
        this.acessoWhatsapp = acessoWhatsapp;
        this.email = email;
        this.montaTela(true);
    }

    public SenhaWeb(Window owner, boolean isSenhaWebPaciente, String conselho, String crmMedico, String ufMedico) {
        super(owner);
        this.conselho = conselho;
        this.crmMedico = crmMedico;
        this.ufMedico = ufMedico;
        this.montaTela(isSenhaWebPaciente);
    }

    public SenhaWeb(Window owner, boolean isSenhaWebPaciente, String email, String celular, boolean acessoSMS, boolean acessoEmail) {
        super(owner);
        this.email = email;
        this.celular = celular;
        this.acessoEmail = acessoEmail;
        this.acessoSMS = acessoSMS;
        this.montaTela(isSenhaWebPaciente);
    }

    public SenhaWeb(Window owner, boolean isSenhaWebPaciente, String conselho, String crmMedico, String ufMedico, String email, ArrayList<String> contatos, String celular, boolean acessoSMS, boolean acessoEmail) {
        super(owner);
        this.conselho = conselho;
        this.crmMedico = crmMedico;
        this.ufMedico = ufMedico;
        this.emailMedico = email;
        this.emailMedicoContato = contatos;
        this.celular = celular;
        this.acessoEmail = acessoEmail;
        this.acessoSMS = acessoSMS;
        this.montaTela(isSenhaWebPaciente);
    }

    private void montaTela(final boolean isSenhaWebPaciente) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(335, 100);
        this.setTitle("Senha web");
        this.setModal(true);
        this.setResizable(false);
        this.isSenhaWebPaciente = isSenhaWebPaciente;
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.txtSenha.setPreferredSize(new Dimension(181, 20));
        this.btnSalvar.setMnemonic('O');
        this.btnFechar.setMnemonic('C');
        this.btnGerar.setMnemonic('G');
        this.buttonSMS.setMnemonic('M');
        this.buttonEmail.setMnemonic('E');
        this.buttonWhatsapp.setMnemonic('W');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 17;
        gridBagConstraints.insets.left = 5;
        this.panelCentro.add((Component)this.lblSenha, gridBagConstraints);
        gridBagConstraints.insets.left = 2;
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 6;
        this.panelCentro.add((Component)this.txtSenha, gridBagConstraints);
        this.addItensMenuEnviar();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panelBotoes.add((Component)this.buttonEnviar, gridBagConstraints);
        this.buttonEnviar.addActionListener(action -> this.menuEnviar.show(this.buttonEnviar.getParent(), this.buttonEnviar.getX(), this.buttonEnviar.getY() + this.buttonEnviar.getHeight()));
        this.buttonEnviar.setEnabled(this.validaOpcoesEnviar());
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        this.panelBotoes.add((Component)this.btnGerar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.panelBotoes.add((Component)this.btnSalvar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.panelBotoes.add((Component)this.btnFechar, gridBagConstraints);
        this.getContentPane().add((Component)this.panelCentro, "West");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                boolean isVisivel;
                super.windowOpened(e);
                if (isSenhaWebPaciente) {
                    isVisivel = SMSUtil.isFilialEnviarSMSSenhaWeb(SenhaWeb.this.codigoFilial, Conexao.getStatement(), true) && !Funcoes.textoVazio(SenhaWeb.this.codigoPaciente) && SenhaWeb.this.acessoSMS && !Funcoes.textoVazio(StringUtil.limpaString(SenhaWeb.this.celular, new String[]{"(", ")", "-", " ", ".", ";"}));
                    SenhaWeb.this.buttonSMS.setVisible(isVisivel);
                } else {
                    SenhaWeb.this.buttonSMS.setVisible(false);
                }
                if (isSenhaWebPaciente) {
                    isVisivel = WhatsAppUtil.isFilialEnviarWhatsappSenhaWeb(SenhaWeb.this.codigoFilial, Conexao.getStatement(), true) && !Funcoes.textoVazio(SenhaWeb.this.codigoPaciente) && SenhaWeb.this.acessoWhatsapp && this.validaCelularWhatsapp();
                    SenhaWeb.this.buttonWhatsapp.setVisible(isVisivel);
                } else {
                    SenhaWeb.this.buttonWhatsapp.setVisible(false);
                }
                try {
                    if (isSenhaWebPaciente) {
                        isVisivel = EmailUtil.getFilialPodeEnviarEmailSenhaWeb(SenhaWeb.this.codigoFilial, Conexao.getStatement(), true) && SenhaWeb.this.acessoEmail && !Funcoes.textoVazio(SenhaWeb.this.email);
                        SenhaWeb.this.buttonEmail.setVisible(isVisivel);
                    } else {
                        SenhaWeb.this.validaButtonEmail();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private boolean validaCelularWhatsapp() {
                String[] mascara = new String[]{"(", ")", "-", " ", ".", ";"};
                return !Funcoes.textoVazio(StringUtil.limpaString(SenhaWeb.this.celular, mascara)) || !Funcoes.textoVazio(StringUtil.limpaString(SenhaWeb.this.celularWhatsApp, mascara));
            }
        });
        this.btnSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SenhaWeb.this.salvarPressionado = true;
                SenhaWeb.this.setVisible(false);
            }
        });
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SenhaWeb.this.salvarPressionado = false;
                SenhaWeb.this.enviarSms = false;
                SenhaWeb.this.enviarWhatsapp = false;
                SenhaWeb.this.setVisible(false);
            }
        });
        this.btnGerar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SenhaWeb.this.gerarSenha();
                SenhaWeb.this.buttonEmail.setEnabled(!Funcoes.textoVazio(SenhaWeb.this.txtSenha.getText()));
                SenhaWeb.this.buttonWhatsapp.setEnabled(!Funcoes.textoVazio(SenhaWeb.this.txtSenha.getText()));
            }
        });
        this.buttonSMS.addActionListener(action -> {
            if (Funcoes.textoVazio(this.txtSenha.getText())) {
                this.gerarSenha();
            }
            this.enviarSms = true;
            this.setVisible(false);
        });
        this.buttonWhatsapp.addActionListener(action -> {
            if (Funcoes.textoVazio(this.txtSenha.getText())) {
                this.gerarSenha();
            }
            this.enviarWhatsapp = true;
            this.setVisible(false);
        });
        this.buttonEmail.addActionListener(action -> {
            if (Funcoes.textoVazio(this.txtSenha.getText())) {
                this.gerarSenha();
            }
            try {
                if (isSenhaWebPaciente) {
                    EmailUtil.criaLogEmailSemDadosRequisicao(this.codigoFilial, this.codigoPaciente, null, null, EmailUtil.TipoEmail.SENHA_WEB, true, Conexao.getStatement(), false);
                } else {
                    EmailUtil.criaLogEmailSenhaWebMedico(this.codigoFilial, this.emailMedicoContato, null, EmailUtil.TipoEmail.SENHA_WEB_MEDICO, true, Conexao.getStatement(), false, this.crmMedico, this.ufMedico, this.conselho);
                    this.setEmailEnviado(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(false);
        });
        this.txtSenha.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SenhaWeb.this.buttonEmail.setEnabled(!Funcoes.textoVazio(SenhaWeb.this.txtSenha.getText()));
                SenhaWeb.this.buttonWhatsapp.setEnabled(!Funcoes.textoVazio(SenhaWeb.this.txtSenha.getText()));
                ScreenUtil.requisitarFoco(SenhaWeb.this.btnSalvar);
            }
        });
        this.repaint();
    }

    private void validaButtonEmail() {
        try {
            this.filialPodeEnviarEmailMedico = EmailUtil.getFilialPodeEnviarEmailSenhaWebMedico(this.codigoFilial, this.crmMedico, this.ufMedico, this.emailMedico, Conexao.getStatement());
            this.filialPodeEnviarEmail = EmailUtil.getFilialPodeEnviarEmailSenhaWeb(this.codigoFilial, Conexao.getStatement(), true);
            this.buttonEmail.setVisible(this.filialPodeEnviarEmailMedico && (!Funcoes.textoVazio(this.emailMedico) || this.emailMedicoContato != null && !this.emailMedicoContato.isEmpty()));
            this.buttonEmail.setEnabled(!Funcoes.textoVazio(this.txtSenha.getText()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean validaOpcoesEnviar() {
        try {
            this.filialEnviarSMSSenhaWeb = SMSUtil.isFilialEnviarSMSSenhaWeb(this.codigoFilial, Conexao.getStatement(), true);
            this.filialPodeEnviarEmail = EmailUtil.getFilialPodeEnviarEmailSenhaWeb(this.codigoFilial, Conexao.getStatement(), true);
            this.filialPodeEnviarEmailMedico = EmailUtil.getFilialPodeEnviarEmailSenhaWebMedico(this.codigoFilial, this.crmMedico, this.ufMedico, this.emailMedico, Conexao.getStatement());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (this.isSenhaWebPaciente && (this.filialEnviarSMSSenhaWeb || this.filialPodeEnviarEmail) || !this.isSenhaWebPaciente && this.filialPodeEnviarEmailMedico) && (this.validaCelularWhatsapp() || !Funcoes.textoVazio(this.email) || !Funcoes.textoVazio(this.emailMedico) || this.emailMedicoContato != null && !this.emailMedicoContato.isEmpty());
    }

    private boolean validaCelularWhatsapp() {
        String[] mascara = new String[]{"(", ")", "-", " ", ".", ";"};
        return !Funcoes.textoVazio(StringUtil.limpaString(this.celular, mascara)) || !Funcoes.textoVazio(StringUtil.limpaString(this.celularWhatsApp, mascara));
    }

    private void addItensMenuEnviar() {
        this.menuEnviar.add(this.buttonEmail);
        this.menuEnviar.add(this.buttonSMS);
        this.menuEnviar.add(this.buttonWhatsapp);
    }

    private void gerarSenha() {
        this.senha = Funcoes.gerarSenhaWeb();
        this.txtSenha.setText(this.senha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void criarLogSms() {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            SMSUtil.criaLogSmsSemDadosRequisicao(this.codigoFilial, this.codigoPaciente, ExportaSMS.TipoSMS.SENHA_WEB, st, st2);
        }
        catch (Exception exception) {
            Conexao.fecharStatement(st, st2);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st, st2);
            throw throwable;
        }
        Conexao.fecharStatement(st, st2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void criarLogWhatsapp() {
        if (!Funcoes.textoVazio(this.txtSenha.getText())) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            try {
                WhatsAppUtil.criaLogWhatsappSemDadosRequisicao(this.codigoFilial, this.codigoPaciente, TipoWhatsapp.SENHA_WEB, st, st2);
            }
            catch (Exception exception) {
                Conexao.fecharStatement(st, st2);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    public void setSenha(String senha) {
        this.senha = senha;
        this.txtSenha.setText(senha);
    }

    public String getSenha() {
        this.senha = this.txtSenha.getText();
        return this.senha;
    }

    public boolean getSalvarPressionado() {
        return this.salvarPressionado;
    }

    public boolean isEmailEnviado() {
        return this.emailEnviado;
    }

    public void setEmailEnviado(boolean emailEnviado) {
        this.emailEnviado = emailEnviado;
    }

    public boolean isEnviarSms() {
        return this.enviarSms;
    }

    public boolean isEnviarWhatsapp() {
        return this.enviarWhatsapp;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public void setFilial(String filial) {
        this.codigoFilial = filial;
    }

    public void setCodigoPaciente(String codigo) {
        this.codigoPaciente = codigo;
    }

    public String getEmailMedico() {
        return this.emailMedico;
    }

    public void setEmailMedico(String emailMedico) {
        this.emailMedico = emailMedico;
    }

    public void setEmailMedicoContato(ArrayList<String> emailMedicoContato) {
        this.emailMedicoContato = emailMedicoContato;
    }
}

