/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.cadastro.CalcularIntervalo;
import jalis.laboratorio.cadastro.PanelIntervaloDia;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.SalaAtendimentoBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.SalaAtendimentoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.SalaAtendimentoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SalaAtendimento
extends FrmCadPadraoBean {
    private final JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private final JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private final JLabel labelIntervalo = new JLabel("<html>min. [<u>Calcular intervalo</u>]</html>");
    private final JLabel labelHoraInicial = new JLabel("Hora inicial:");
    private final JLabel labelHoraFinal = new JLabel("Hora final:");
    private final JLabel labelHoraInicialAlmoco = new JLabel("In\u00edcio almo\u00e7o:");
    private final JLabel labelHoraFinalAlmoco = new JLabel("Fim almo\u00e7o:");
    private final JLabel labelIntervaloPadrao = new JLabel("Intervalo padr\u00e3o:");
    private final TTextField textCodigo = new TTextField(3, 3);
    private final TTextField textDescricao = new TTextField(100, 3);
    private final TTextField textQtdeColetadores = new TTextField(3, 1);
    private final TTextField textIntervaloPadrao = new TTextField(3, 1);
    private final TTextField textHoraInicial = new TTextField(5, 6);
    private final TTextField textHoraFinal = new TTextField(5, 6);
    private final TTextField textHoraInicialAlmoco = new TTextField(5, 6);
    private final TTextField textHoraFinalAlmoco = new TTextField(5, 6);
    private final JCheckBox checkInativa = new JCheckBox("Inativa");
    private final JCheckBox checkHorarios = new JCheckBox("Utilizar hor\u00e1rios diferenciados");
    private final JCheckBox checkContador = new JCheckBox("Apresentar contadores na agenda");
    private final PanelIntervaloDia panelDomingo = new PanelIntervaloDia("Domingo");
    private final PanelIntervaloDia panelSegunda = new PanelIntervaloDia("Segunda-feira");
    private final PanelIntervaloDia panelTerca = new PanelIntervaloDia("Ter\u00e7a-feira");
    private final PanelIntervaloDia panelQuarta = new PanelIntervaloDia("Quarta-feira");
    private final PanelIntervaloDia panelQuinta = new PanelIntervaloDia("Quinta-feira");
    private final PanelIntervaloDia panelSexta = new PanelIntervaloDia("Sexta-feira");
    private final PanelIntervaloDia panelSabado = new PanelIntervaloDia("S\u00e1bado");
    public static final Long ACESSO_TELA = new Long(104700100L);
    public static final Long ACESSO_INSERIR = new Long(104700101L);
    public static final Long ACESSO_EDITAR = new Long(104700102L);
    public static final Long ACESSO_APAGAR = new Long(104700103L);
    private final int WIDTH_MENOR = 50;
    private final int WIDTH = 70;
    private final int WIDTH_DATA = 60;
    private String retornoParaPesquisa = "";

    public SalaAtendimento() {
        this.setName("SalaAtendimento");
        this.setLabelFormulario("Cadastro de sala de atendimento");
        this.setLabelDescricao("Cadastro de sala de atendimento para agendamento de exames e coleta");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_salaatendimento.jpg"));
        this.labelIntervalo.setCursor(Cursor.getPredefinedCursor(12));
        this.labelIntervalo.setFont(this.labelIntervalo.getFont().deriveFont(10.0f));
        this.labelIntervalo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SalaAtendimento.this.getStatus() == 3 || SalaAtendimento.this.getStatus() == 2) {
                    SalaAtendimento.this.calcularIntervalo();
                }
            }
        });
        this.textCodigo.setEnabled(false);
        this.textCodigo.setName("textCodigo");
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets insetNormal = new Insets(1, 1, 1, 1);
        Insets insetMenor = new Insets(0, 1, 0, 1);
        Insets insetSeparador = new Insets(1, 20, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.textCodigo.setPreferredSize(new Dimension(50, 20));
        this.textCodigo.setMinimumSize(new Dimension(50, 20));
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 7;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricao, c);
        this.textDescricao.setName("textDescricao");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel("Qtde coletadores:"), c);
        this.textQtdeColetadores.setPreferredSize(new Dimension(50, 20));
        this.textQtdeColetadores.setMinimumSize(new Dimension(50, 20));
        this.textQtdeColetadores.setName("textQtdeColetadores");
        ++c.gridx;
        this.painelCentral.add((Component)this.textQtdeColetadores, c);
        ++c.gridx;
        c.insets = insetSeparador;
        this.painelCentral.add((Component)this.labelIntervaloPadrao, c);
        ++c.gridx;
        c.insets = insetNormal;
        this.textIntervaloPadrao.setPreferredSize(new Dimension(50, 20));
        this.textIntervaloPadrao.setName("textIntervaloPadrao");
        this.textIntervaloPadrao.setMinimumSize(new Dimension(50, 20));
        this.painelCentral.add((Component)this.textIntervaloPadrao, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        this.labelIntervalo.setHorizontalAlignment(2);
        this.painelCentral.add((Component)this.labelIntervalo, c);
        JPanel panelHoras = new JPanel(new GridBagLayout());
        panelHoras.setBorder(new TitledBorder(""));
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.fill = 0;
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 0.0;
        g.weighty = 0.0;
        g.insets = insetMenor;
        panelHoras.add((Component)this.labelHoraInicial, g);
        ++g.gridx;
        this.textHoraInicial.setPreferredSize(new Dimension(60, 20));
        this.textHoraInicial.setName("textHoraInicialSA");
        this.textHoraInicial.setMinimumSize(new Dimension(60, 20));
        panelHoras.add((Component)this.textHoraInicial, g);
        ++g.gridx;
        g.insets = insetSeparador;
        panelHoras.add((Component)this.labelHoraFinal, g);
        ++g.gridx;
        g.insets = insetMenor;
        this.textHoraFinal.setPreferredSize(new Dimension(60, 20));
        this.textHoraFinal.setName("textHoraFinalSA");
        this.textHoraFinal.setMinimumSize(new Dimension(60, 20));
        panelHoras.add((Component)this.textHoraFinal, g);
        ++g.gridx;
        g.insets = insetSeparador;
        panelHoras.add((Component)this.labelHoraInicialAlmoco, g);
        ++g.gridx;
        g.insets = insetMenor;
        this.textHoraInicialAlmoco.setPreferredSize(new Dimension(60, 20));
        this.textHoraInicialAlmoco.setName("textHoraInicialAlmocoSA");
        this.textHoraInicialAlmoco.setMinimumSize(new Dimension(60, 20));
        panelHoras.add((Component)this.textHoraInicialAlmoco, g);
        ++g.gridx;
        g.insets = insetSeparador;
        panelHoras.add((Component)this.labelHoraFinalAlmoco, g);
        ++g.gridx;
        g.insets = insetMenor;
        this.textHoraFinalAlmoco.setPreferredSize(new Dimension(60, 20));
        this.textHoraFinalAlmoco.setName("textHoraFinalAlmocoSA");
        this.textHoraFinalAlmoco.setMinimumSize(new Dimension(60, 20));
        panelHoras.add((Component)this.textHoraFinalAlmoco, g);
        ++g.gridx;
        g.fill = 2;
        g.weightx = 1.0;
        panelHoras.add((Component)new JLabel(), g);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 8;
        this.painelCentral.add((Component)panelHoras, c);
        JPanel panelCheck = new JPanel(new GridBagLayout());
        GridBagConstraints cAux = new GridBagConstraints();
        cAux.anchor = 17;
        cAux.fill = 0;
        cAux.gridx = 0;
        cAux.gridy = 0;
        cAux.insets = insetMenor;
        cAux.weightx = 0.0;
        cAux.weighty = 0.0;
        panelCheck.add((Component)this.checkInativa, cAux);
        this.checkInativa.setName("checkInativa");
        ++cAux.gridx;
        panelCheck.add((Component)this.checkHorarios, cAux);
        this.checkHorarios.setName("checkHorarios");
        ++cAux.gridx;
        panelCheck.add((Component)this.checkContador, cAux);
        this.checkContador.setName("checkContador");
        ++cAux.gridx;
        cAux.weightx = 1.0;
        cAux.fill = 2;
        panelCheck.add((Component)new JLabel(), cAux);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 8;
        c.weightx = 1.0;
        this.painelCentral.add((Component)panelCheck, c);
        JPanel panelDias = new JPanel(new FlowLayout(0, 1, 1));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 8;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)panelDias, c);
        panelDias.add(this.panelDomingo);
        this.panelDomingo.setName("panelDomingo");
        panelDias.add(this.panelSegunda);
        this.panelSegunda.setName("panelSegunda");
        panelDias.add(this.panelTerca);
        this.panelTerca.setName("panelTerca");
        panelDias.add(this.panelQuarta);
        this.panelQuarta.setName("panelQuarta");
        panelDias.add(this.panelQuinta);
        this.panelQuinta.setName("panelQuinta");
        panelDias.add(this.panelSexta);
        this.panelSexta.setName("panelSexta");
        panelDias.add(this.panelSabado);
        this.panelSabado.setName("panelSabado");
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new SalaAtendimentoService();
        this.controlaCampos();
        this.checkHorarios.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelIntervaloDia[] p;
                SalaAtendimento.this.habilitarDiasSemana();
                for (PanelIntervaloDia d : p = new PanelIntervaloDia[]{SalaAtendimento.this.panelDomingo, SalaAtendimento.this.panelSegunda, SalaAtendimento.this.panelTerca, SalaAtendimento.this.panelQuarta, SalaAtendimento.this.panelQuinta, SalaAtendimento.this.panelSexta, SalaAtendimento.this.panelSabado}) {
                    d.setAgendar(SalaAtendimento.this.checkHorarios.isSelected());
                    if (d.getAgendar()) {
                        d.setHoraInicial(SalaAtendimento.this.textHoraInicial.getText());
                        d.setHoraFinal(SalaAtendimento.this.textHoraFinal.getText());
                        d.setHoraInicialAlmoco(SalaAtendimento.this.textHoraInicialAlmoco.getText());
                        d.setHoraFinalAlmoco(SalaAtendimento.this.textHoraFinalAlmoco.getText());
                        d.setIntervalo(SalaAtendimento.this.textIntervaloPadrao.getText());
                        continue;
                    }
                    d.limpar();
                }
            }
        });
    }

    @Override
    public void excluir() {
        final SalaAtendimentoBean beanDelete = (SalaAtendimentoBean)this.pesquisar();
        if (beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SalaAtendimento.this.preencherCampos(beanDelete);
                    if (Funcoes.mensagem(SalaAtendimento.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            SalaAtendimento.this.service.gravaAutoCopiaSemCommit(beanDelete, 2, Variaveis.filialPadrao, SalaAtendimento.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(SalaAtendimento.this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "SalaAtendimento: 136");
                        }
                    }
                    SalaAtendimento.this.limparCampos();
                }
            });
        }
    }

    @Override
    protected void controlaCampos() {
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkInativa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkHorarios.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkContador.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textQtdeColetadores.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textIntervaloPadrao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textHoraInicial.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textHoraFinal.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textHoraInicialAlmoco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textHoraFinalAlmoco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.habilitarDiasSemana();
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        boolean horariosDiferentes;
        SalaAtendimentoBean bean = new SalaAtendimentoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3 && Funcoes.isNumeric(this.textCodigo.getText())) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setInativa(this.checkInativa.isSelected());
        bean.setUtilizarHorariosDiferenciados(this.checkHorarios.isSelected());
        bean.setApresentarContador(this.checkContador.isSelected());
        bean.setQtdeColetadores(Funcoes.isNumeric(this.textQtdeColetadores.getText()) ? Integer.parseInt(this.textQtdeColetadores.getText()) : 0);
        bean.setIntervaloPadrao(Funcoes.isNumeric(this.textIntervaloPadrao.getText()) ? Integer.parseInt(this.textIntervaloPadrao.getText()) : 0);
        if (Funcoes.verificaHora(this.textHoraInicial.getText())) {
            bean.setHoraInicialPadrao(Funcoes.stringToDate("HH:mm", this.textHoraInicial.getText()));
        }
        if (Funcoes.verificaHora(this.textHoraFinal.getText())) {
            bean.setHoraFinalPadrao(Funcoes.stringToDate("HH:mm", this.textHoraFinal.getText()));
        }
        if (Funcoes.verificaHora(this.textHoraInicialAlmoco.getText())) {
            bean.setHoraInicialAlmocoPadrao(Funcoes.stringToDate("HH:mm", this.textHoraInicialAlmoco.getText()));
        }
        if (Funcoes.verificaHora(this.textHoraFinalAlmoco.getText())) {
            bean.setHoraFinalAlmocoPadrao(Funcoes.stringToDate("HH:mm", this.textHoraFinalAlmoco.getText()));
        }
        bean.setAgendarDomingo((horariosDiferentes = this.checkHorarios.isSelected()) && this.panelDomingo.getAgendar());
        bean.setAgendarSegunda(horariosDiferentes && this.panelSegunda.getAgendar());
        bean.setAgendarTerca(horariosDiferentes && this.panelTerca.getAgendar());
        bean.setAgendarQuarta(horariosDiferentes && this.panelQuarta.getAgendar());
        bean.setAgendarQuinta(horariosDiferentes && this.panelQuinta.getAgendar());
        bean.setAgendarSexta(horariosDiferentes && this.panelSexta.getAgendar());
        bean.setAgendarSabado(horariosDiferentes && this.panelSabado.getAgendar());
        if (horariosDiferentes) {
            bean.setIntervaloDomingo(Funcoes.isNumeric(this.panelDomingo.getIntervalo()) ? Integer.parseInt(this.panelDomingo.getIntervalo()) : 0);
            bean.setIntervaloSegunda(Funcoes.isNumeric(this.panelSegunda.getIntervalo()) ? Integer.parseInt(this.panelSegunda.getIntervalo()) : 0);
            bean.setIntervaloTerca(Funcoes.isNumeric(this.panelTerca.getIntervalo()) ? Integer.parseInt(this.panelTerca.getIntervalo()) : 0);
            bean.setIntervaloQuarta(Funcoes.isNumeric(this.panelQuarta.getIntervalo()) ? Integer.parseInt(this.panelQuarta.getIntervalo()) : 0);
            bean.setIntervaloQuinta(Funcoes.isNumeric(this.panelQuinta.getIntervalo()) ? Integer.parseInt(this.panelQuinta.getIntervalo()) : 0);
            bean.setIntervaloSexta(Funcoes.isNumeric(this.panelSexta.getIntervalo()) ? Integer.parseInt(this.panelSexta.getIntervalo()) : 0);
            bean.setIntervaloSabado(Funcoes.isNumeric(this.panelSabado.getIntervalo()) ? Integer.parseInt(this.panelSabado.getIntervalo()) : 0);
            bean.setHoraInicialDomingo(Funcoes.verificaHora(this.panelDomingo.getHoraInicial()) ? Funcoes.stringToDate("HH:mm", this.panelDomingo.getHoraInicial()) : null);
            bean.setHoraInicialSegunda(Funcoes.verificaHora(this.panelSegunda.getHoraInicial()) ? Funcoes.stringToDate("HH:mm", this.panelSegunda.getHoraInicial()) : null);
            bean.setHoraInicialTerca(Funcoes.verificaHora(this.panelTerca.getHoraInicial()) ? Funcoes.stringToDate("HH:mm", this.panelTerca.getHoraInicial()) : null);
            bean.setHoraInicialQuarta(Funcoes.verificaHora(this.panelQuarta.getHoraInicial()) ? Funcoes.stringToDate("HH:mm", this.panelQuarta.getHoraInicial()) : null);
            bean.setHoraInicialQuinta(Funcoes.verificaHora(this.panelQuinta.getHoraInicial()) ? Funcoes.stringToDate("HH:mm", this.panelQuinta.getHoraInicial()) : null);
            bean.setHoraInicialSexta(Funcoes.verificaHora(this.panelSexta.getHoraInicial()) ? Funcoes.stringToDate("HH:mm", this.panelSexta.getHoraInicial()) : null);
            bean.setHoraInicialSabado(Funcoes.verificaHora(this.panelSabado.getHoraInicial()) ? Funcoes.stringToDate("HH:mm", this.panelSabado.getHoraInicial()) : null);
            bean.setHoraFinalDomingo(Funcoes.verificaHora(this.panelDomingo.getHoraFinal()) ? Funcoes.stringToDate("HH:mm", this.panelDomingo.getHoraFinal()) : null);
            bean.setHoraFinalSegunda(Funcoes.verificaHora(this.panelSegunda.getHoraFinal()) ? Funcoes.stringToDate("HH:mm", this.panelSegunda.getHoraFinal()) : null);
            bean.setHoraFinalTerca(Funcoes.verificaHora(this.panelTerca.getHoraFinal()) ? Funcoes.stringToDate("HH:mm", this.panelTerca.getHoraFinal()) : null);
            bean.setHoraFinalQuarta(Funcoes.verificaHora(this.panelQuarta.getHoraFinal()) ? Funcoes.stringToDate("HH:mm", this.panelQuarta.getHoraFinal()) : null);
            bean.setHoraFinalQuinta(Funcoes.verificaHora(this.panelQuinta.getHoraFinal()) ? Funcoes.stringToDate("HH:mm", this.panelQuinta.getHoraFinal()) : null);
            bean.setHoraFinalSexta(Funcoes.verificaHora(this.panelSexta.getHoraFinal()) ? Funcoes.stringToDate("HH:mm", this.panelSexta.getHoraFinal()) : null);
            bean.setHoraFinalSabado(Funcoes.verificaHora(this.panelSabado.getHoraFinal()) ? Funcoes.stringToDate("HH:mm", this.panelSabado.getHoraFinal()) : null);
            bean.setHoraInicialAlmocoDomingo(Funcoes.verificaHora(this.panelDomingo.getHoraInicialAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelDomingo.getHoraInicialAlmoco()) : null);
            bean.setHoraInicialAlmocoSegunda(Funcoes.verificaHora(this.panelSegunda.getHoraInicialAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelSegunda.getHoraInicialAlmoco()) : null);
            bean.setHoraInicialAlmocoTerca(Funcoes.verificaHora(this.panelTerca.getHoraInicialAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelTerca.getHoraInicialAlmoco()) : null);
            bean.setHoraInicialAlmocoQuarta(Funcoes.verificaHora(this.panelQuarta.getHoraInicialAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelQuarta.getHoraInicialAlmoco()) : null);
            bean.setHoraInicialAlmocoQuinta(Funcoes.verificaHora(this.panelQuinta.getHoraInicialAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelQuinta.getHoraInicialAlmoco()) : null);
            bean.setHoraInicialAlmocoSexta(Funcoes.verificaHora(this.panelSexta.getHoraInicialAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelSexta.getHoraInicialAlmoco()) : null);
            bean.setHoraInicialAlmocoSabado(Funcoes.verificaHora(this.panelSabado.getHoraInicialAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelSabado.getHoraInicialAlmoco()) : null);
            bean.setHoraFinalAlmocoDomingo(Funcoes.verificaHora(this.panelDomingo.getHoraFinalAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelDomingo.getHoraFinalAlmoco()) : null);
            bean.setHoraFinalAlmocoSegunda(Funcoes.verificaHora(this.panelSegunda.getHoraFinalAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelSegunda.getHoraFinalAlmoco()) : null);
            bean.setHoraFinalAlmocoTerca(Funcoes.verificaHora(this.panelTerca.getHoraFinalAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelTerca.getHoraFinalAlmoco()) : null);
            bean.setHoraFinalAlmocoQuarta(Funcoes.verificaHora(this.panelQuarta.getHoraFinalAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelQuarta.getHoraFinalAlmoco()) : null);
            bean.setHoraFinalAlmocoQuinta(Funcoes.verificaHora(this.panelQuinta.getHoraFinalAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelQuinta.getHoraFinalAlmoco()) : null);
            bean.setHoraFinalAlmocoSexta(Funcoes.verificaHora(this.panelSexta.getHoraFinalAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelSexta.getHoraFinalAlmoco()) : null);
            bean.setHoraFinalAlmocoSabado(Funcoes.verificaHora(this.panelSabado.getHoraFinalAlmoco()) ? Funcoes.stringToDate("HH:mm", this.panelSabado.getHoraFinalAlmoco()) : null);
        }
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaSalaAtendimento();
    }

    private void habilitarDiasSemana() {
        this.panelDomingo.setEnabled(this.checkHorarios.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
        this.panelSegunda.setEnabled(this.checkHorarios.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
        this.panelTerca.setEnabled(this.checkHorarios.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
        this.panelQuarta.setEnabled(this.checkHorarios.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
        this.panelQuinta.setEnabled(this.checkHorarios.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
        this.panelSexta.setEnabled(this.checkHorarios.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
        this.panelSabado.setEnabled(this.checkHorarios.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.textQtdeColetadores.clear();
        this.textIntervaloPadrao.clear();
        this.textHoraInicial.clear();
        this.textHoraFinal.clear();
        this.textHoraInicialAlmoco.clear();
        this.textHoraFinalAlmoco.clear();
        this.panelDomingo.limpar();
        this.panelSegunda.limpar();
        this.panelTerca.limpar();
        this.panelQuarta.limpar();
        this.panelQuinta.limpar();
        this.panelSexta.limpar();
        this.panelSabado.limpar();
        this.checkInativa.setSelected(false);
        this.checkHorarios.setSelected(false);
        this.checkContador.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new SalaAtendimentoVO(), "Pesquisando salas de atendimento", false);
            if (vo != null) {
                SalaAtendimentoBean SalaAtendimentoBean2 = (SalaAtendimentoBean)this.service.voToBean(vo, SalaAtendimentoBean.class);
                return SalaAtendimentoBean2;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "SalaAtendimento:187");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        SalaAtendimentoBean salaBean = (SalaAtendimentoBean)bean;
        this.textCodigo.setText(String.valueOf(salaBean.getCodigo()));
        this.textDescricao.setText(salaBean.getDescricao());
        this.checkInativa.setSelected(salaBean.getInativa());
        this.checkHorarios.setSelected(salaBean.getUtilizarHorariosDiferenciados());
        this.checkContador.setSelected(salaBean.getApresentarContador() != null && salaBean.getApresentarContador() != false);
        this.textQtdeColetadores.setText(String.valueOf(salaBean.getQtdeColetadores()));
        this.textIntervaloPadrao.setText(String.valueOf(salaBean.getIntervaloPadrao()));
        this.textHoraInicial.setText(salaBean.getHoraInicialPadrao() != null ? Funcoes.formataData("HH:mm", salaBean.getHoraInicialPadrao()) : "");
        this.textHoraFinal.setText(salaBean.getHoraFinalPadrao() != null ? Funcoes.formataData("HH:mm", salaBean.getHoraFinalPadrao()) : "");
        this.textHoraInicialAlmoco.setText(salaBean.getHoraInicialAlmocoPadrao() != null ? Funcoes.formataData("HH:mm", salaBean.getHoraInicialAlmocoPadrao()) : "");
        this.textHoraFinalAlmoco.setText(salaBean.getHoraFinalAlmocoPadrao() != null ? Funcoes.formataData("HH:mm", salaBean.getHoraFinalAlmocoPadrao()) : "");
        this.habilitarDiasSemana();
        if (this.checkHorarios.isSelected()) {
            this.panelDomingo.setAgendar(salaBean.getAgendarDomingo() == null ? false : salaBean.getAgendarDomingo());
            this.panelSegunda.setAgendar(salaBean.getAgendarDomingo() == null ? false : salaBean.getAgendarSegunda());
            this.panelTerca.setAgendar(salaBean.getAgendarDomingo() == null ? false : salaBean.getAgendarTerca());
            this.panelQuarta.setAgendar(salaBean.getAgendarDomingo() == null ? false : salaBean.getAgendarQuarta());
            this.panelQuinta.setAgendar(salaBean.getAgendarDomingo() == null ? false : salaBean.getAgendarQuinta());
            this.panelSexta.setAgendar(salaBean.getAgendarDomingo() == null ? false : salaBean.getAgendarSexta());
            this.panelSabado.setAgendar(salaBean.getAgendarDomingo() == null ? false : salaBean.getAgendarSabado());
            this.panelDomingo.setIntervalo(String.valueOf(salaBean.getIntervaloDomingo() == null ? "" : salaBean.getIntervaloDomingo()));
            this.panelSegunda.setIntervalo(String.valueOf(salaBean.getIntervaloSegunda() == null ? "" : salaBean.getIntervaloSegunda()));
            this.panelTerca.setIntervalo(String.valueOf(salaBean.getIntervaloTerca() == null ? "" : salaBean.getIntervaloTerca()));
            this.panelQuarta.setIntervalo(String.valueOf(salaBean.getIntervaloQuarta() == null ? "" : salaBean.getIntervaloQuarta()));
            this.panelQuinta.setIntervalo(String.valueOf(salaBean.getIntervaloQuinta() == null ? "" : salaBean.getIntervaloQuinta()));
            this.panelSexta.setIntervalo(String.valueOf(salaBean.getIntervaloSexta() == null ? "" : salaBean.getIntervaloSexta()));
            this.panelSabado.setIntervalo(String.valueOf(salaBean.getIntervaloSabado() == null ? "" : salaBean.getIntervaloSabado()));
            this.panelDomingo.setHoraInicial(salaBean.getHoraInicialDomingo() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialDomingo(), false));
            this.panelSegunda.setHoraInicial(salaBean.getHoraInicialSegunda() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialSegunda(), false));
            this.panelTerca.setHoraInicial(salaBean.getHoraInicialTerca() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialTerca(), false));
            this.panelQuarta.setHoraInicial(salaBean.getHoraInicialQuarta() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialQuarta(), false));
            this.panelQuinta.setHoraInicial(salaBean.getHoraInicialQuinta() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialQuinta(), false));
            this.panelSexta.setHoraInicial(salaBean.getHoraInicialSexta() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialSexta(), false));
            this.panelSabado.setHoraInicial(salaBean.getHoraInicialSabado() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialSabado(), false));
            this.panelDomingo.setHoraFinal(salaBean.getHoraFinalDomingo() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalDomingo(), false));
            this.panelSegunda.setHoraFinal(salaBean.getHoraFinalSegunda() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalSegunda(), false));
            this.panelTerca.setHoraFinal(salaBean.getHoraFinalTerca() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalTerca(), false));
            this.panelQuarta.setHoraFinal(salaBean.getHoraFinalQuarta() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalQuarta(), false));
            this.panelQuinta.setHoraFinal(salaBean.getHoraFinalQuinta() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalQuinta(), false));
            this.panelSexta.setHoraFinal(salaBean.getHoraFinalSexta() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalSexta(), false));
            this.panelSabado.setHoraFinal(salaBean.getHoraFinalSabado() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalSabado(), false));
            this.panelDomingo.setHoraInicialAlmoco(salaBean.getHoraInicialAlmocoDomingo() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialAlmocoDomingo(), false));
            this.panelSegunda.setHoraInicialAlmoco(salaBean.getHoraInicialAlmocoSegunda() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialAlmocoSegunda(), false));
            this.panelTerca.setHoraInicialAlmoco(salaBean.getHoraInicialAlmocoTerca() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialAlmocoTerca(), false));
            this.panelQuarta.setHoraInicialAlmoco(salaBean.getHoraInicialAlmocoQuarta() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialAlmocoQuarta(), false));
            this.panelQuinta.setHoraInicialAlmoco(salaBean.getHoraInicialAlmocoQuinta() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialAlmocoQuinta(), false));
            this.panelSexta.setHoraInicialAlmoco(salaBean.getHoraInicialAlmocoSexta() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialAlmocoSexta(), false));
            this.panelSabado.setHoraInicialAlmoco(salaBean.getHoraInicialAlmocoSabado() == null ? "" : Funcoes.formataHora(salaBean.getHoraInicialAlmocoSabado(), false));
            this.panelDomingo.setHoraFinalAlmoco(salaBean.getHoraFinalAlmocoDomingo() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalAlmocoDomingo(), false));
            this.panelSegunda.setHoraFinalAlmoco(salaBean.getHoraFinalAlmocoSegunda() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalAlmocoSegunda(), false));
            this.panelTerca.setHoraFinalAlmoco(salaBean.getHoraFinalAlmocoTerca() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalAlmocoTerca(), false));
            this.panelQuarta.setHoraFinalAlmoco(salaBean.getHoraFinalAlmocoQuarta() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalAlmocoQuarta(), false));
            this.panelQuinta.setHoraFinalAlmoco(salaBean.getHoraFinalAlmocoQuinta() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalAlmocoQuinta(), false));
            this.panelSexta.setHoraFinalAlmoco(salaBean.getHoraFinalAlmocoSexta() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalAlmocoSexta(), false));
            this.panelSabado.setHoraFinalAlmoco(salaBean.getHoraFinalAlmocoSabado() == null ? "" : Funcoes.formataHora(salaBean.getHoraFinalAlmocoSabado(), false));
        }
        this.textCodigo.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (Funcoes.textoVazio(this.textQtdeColetadores) || Funcoes.isNumeric(this.textQtdeColetadores.getText()) && Integer.parseInt(this.textQtdeColetadores.getText()) == 0) {
            Funcoes.mensagem(this, "A quantidade de coletadores deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textQtdeColetadores);
            return false;
        }
        if (!this.checkHorarios.isSelected()) {
            if (Funcoes.textoVazio(this.textIntervaloPadrao) || Funcoes.isNumeric(this.textIntervaloPadrao.getText()) && Integer.parseInt(this.textIntervaloPadrao.getText()) == 0) {
                Funcoes.mensagem(this, "O intervalo padr\u00e3o deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textIntervaloPadrao);
                return false;
            }
            if (Funcoes.textoVazio(this.textHoraInicial)) {
                Funcoes.mensagem(this, "A hora inicial padr\u00e3o deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textHoraInicial);
                return false;
            }
            if (Funcoes.textoVazio(this.textHoraFinal)) {
                Funcoes.mensagem(this, "A hora final padr\u00e3o deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textHoraFinal);
                return false;
            }
            Date dataAtual = new Date();
            GregorianCalendar calendarIni = new GregorianCalendar();
            calendarIni.setTime(dataAtual);
            calendarIni.set(11, Integer.parseInt(this.textHoraInicial.getText().substring(0, 2)));
            calendarIni.set(12, Integer.parseInt(this.textHoraInicial.getText().substring(3, 5)));
            GregorianCalendar calendarFim = new GregorianCalendar();
            calendarFim.setTime(dataAtual);
            calendarFim.set(11, Integer.parseInt(this.textHoraFinal.getText().substring(0, 2)));
            calendarFim.set(12, Integer.parseInt(this.textHoraFinal.getText().substring(3, 5)));
            if (calendarIni.compareTo(calendarFim) >= 0) {
                Funcoes.mensagem(this, "A hora final padr\u00e3o deve ser maior que a hora inicial padr\u00e3o.", 2);
                ScreenUtil.requisitarFoco(this.textHoraFinal);
                return false;
            }
            if (!Funcoes.textoVazio(this.textHoraInicialAlmoco) && Funcoes.textoVazio(this.textHoraFinalAlmoco)) {
                Funcoes.mensagem(this, "A hora final do almo\u00e7o deve ser informada ou a hora inicial do almo\u00e7o deve ser removida.", 2);
                ScreenUtil.requisitarFoco(this.textHoraFinalAlmoco);
                return false;
            }
            if (!Funcoes.textoVazio(this.textHoraFinalAlmoco) && Funcoes.textoVazio(this.textHoraInicialAlmoco)) {
                Funcoes.mensagem(this, "A hora inicial do almo\u00e7o deve ser informada ou a hora final do almo\u00e7o deve ser removida.", 2);
                ScreenUtil.requisitarFoco(this.textHoraInicialAlmoco);
                return false;
            }
            if (!Funcoes.textoVazio(this.textHoraInicialAlmoco) && !Funcoes.textoVazio(this.textHoraFinalAlmoco)) {
                calendarIni.set(11, Integer.parseInt(this.textHoraInicialAlmoco.getText().substring(0, 2)));
                calendarIni.set(12, Integer.parseInt(this.textHoraInicialAlmoco.getText().substring(3, 5)));
                calendarFim.set(11, Integer.parseInt(this.textHoraFinalAlmoco.getText().substring(0, 2)));
                calendarFim.set(12, Integer.parseInt(this.textHoraFinalAlmoco.getText().substring(3, 5)));
                if (calendarIni.compareTo(calendarFim) >= 0) {
                    Funcoes.mensagem(this, "A hora final do almo\u00e7o deve ser maior que a hora inicial do almo\u00e7o.", 2);
                    ScreenUtil.requisitarFoco(this.textHoraFinalAlmoco);
                    return false;
                }
            }
        } else {
            if (!this.validaCamposDiasSemana(this.panelDomingo)) {
                return false;
            }
            if (!this.validaCamposDiasSemana(this.panelSegunda)) {
                return false;
            }
            if (!this.validaCamposDiasSemana(this.panelTerca)) {
                return false;
            }
            if (!this.validaCamposDiasSemana(this.panelQuarta)) {
                return false;
            }
            if (!this.validaCamposDiasSemana(this.panelQuinta)) {
                return false;
            }
            if (!this.validaCamposDiasSemana(this.panelSexta)) {
                return false;
            }
            if (!this.validaCamposDiasSemana(this.panelSabado)) {
                return false;
            }
        }
        return true;
    }

    private boolean validaCamposDiasSemana(PanelIntervaloDia dia) {
        if (dia.getAgendar()) {
            if (Funcoes.textoVazio(dia.getIntervalo())) {
                Funcoes.mensagem(this, "O intervalo de " + dia.getTitulo().toLowerCase() + " deve ser informado.", 2);
                dia.focalizarIntervalo();
                return false;
            }
            if (Funcoes.textoVazio(dia.getHoraInicial())) {
                Funcoes.mensagem(this, "A hora inicial de " + dia.getTitulo().toLowerCase() + " deve ser informada.", 2);
                dia.focalizarHoraInicial();
                return false;
            }
            if (Funcoes.textoVazio(dia.getHoraFinal())) {
                Funcoes.mensagem(this, "A hora final de " + dia.getTitulo().toLowerCase() + " deve ser informada.", 2);
                dia.focalizarHoraFinal();
                return false;
            }
            Date dataAtual = new Date();
            GregorianCalendar calendarIni = new GregorianCalendar();
            calendarIni.setTime(dataAtual);
            calendarIni.set(11, Integer.parseInt(dia.getHoraInicial().substring(0, 2)));
            calendarIni.set(12, Integer.parseInt(dia.getHoraInicial().substring(3, 5)));
            GregorianCalendar calendarFim = new GregorianCalendar();
            calendarFim.setTime(dataAtual);
            calendarFim.set(11, Integer.parseInt(dia.getHoraFinal().substring(0, 2)));
            calendarFim.set(12, Integer.parseInt(dia.getHoraFinal().substring(3, 5)));
            if (calendarIni.compareTo(calendarFim) >= 0) {
                Funcoes.mensagem(this, "A hora final de " + dia.getTitulo().toLowerCase() + " deve ser maior que a hora inicial.", 2);
                dia.focalizarHoraFinal();
                return false;
            }
            if (!Funcoes.textoVazio(dia.getHoraInicialAlmoco()) && Funcoes.textoVazio(dia.getHoraFinalAlmoco())) {
                Funcoes.mensagem(this, "A hora final do almo\u00e7o de " + dia.getTitulo().toLowerCase() + " deve ser informada ou a hora inicial do almo\u00e7o deve ser removida.", 2);
                dia.focalizarAlmocoFinal();
                return false;
            }
            if (!Funcoes.textoVazio(dia.getHoraFinalAlmoco()) && Funcoes.textoVazio(dia.getHoraInicialAlmoco())) {
                Funcoes.mensagem(this, "A hora inicial do almo\u00e7o de " + dia.getTitulo().toLowerCase() + " deve ser informada ou a hora final do almo\u00e7o deve ser removida.", 2);
                dia.focalizarAlmocoInicial();
                return false;
            }
            if (dia.getHoraInicialAlmoco().length() > 0 && dia.getHoraFinalAlmoco().length() > 0) {
                calendarIni.set(11, Integer.parseInt(dia.getHoraInicialAlmoco().substring(0, 2)));
                calendarIni.set(12, Integer.parseInt(dia.getHoraInicialAlmoco().substring(3, 5)));
                calendarFim.set(11, Integer.parseInt(dia.getHoraFinalAlmoco().substring(0, 2)));
                calendarFim.set(12, Integer.parseInt(dia.getHoraFinalAlmoco().substring(3, 5)));
            }
            if (calendarIni.compareTo(calendarFim) >= 0) {
                Funcoes.mensagem(this, "A hora final do almo\u00e7o de " + dia.getTitulo().toLowerCase() + " deve ser maior que a hora inicial de almo\u00e7o.", 2);
                dia.focalizarAlmocoFinal();
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(SalaAtendimento.getModuloAcesso());
        this.setModuloInsere(ACESSO_INSERIR);
        this.setModuloEdita(ACESSO_EDITAR);
        this.setModuloApaga(ACESSO_APAGAR);
    }

    public static long getModuloAcesso() {
        return ACESSO_TELA;
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void salvar() {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                new SalaAtendimentoService().gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((SalaAtendimentoBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar a sala de atendimento.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "sal_codigo";
    }

    private void calcularIntervalo() {
        if (!Funcoes.verificaHora(this.textHoraInicial.getText())) {
            Funcoes.mensagem(this, "A hora inicial de agendamento deve ser informada.", 2);
            return;
        }
        if (!Funcoes.verificaHora(this.textHoraFinal.getText())) {
            Funcoes.mensagem(this, "A hora final de agendamento deve ser informada.", 2);
            return;
        }
        CalcularIntervalo cal = CalcularIntervalo.novaInstancia(this.getTopLevelAncestor());
        if (cal != null) {
            Point aux;
            cal.setHoraInicial(this.textHoraInicial.getText());
            cal.setHoraFinal(this.textHoraFinal.getText());
            cal.setVisible(true);
            if (cal.getOK() && (aux = cal.getQuantidadeIntervalos()) != null) {
                if (aux.y > 0) {
                    Funcoes.mensagem(this, "Restou " + aux.y + " minuto(s).", 5);
                }
                this.textIntervaloPadrao.setText(String.valueOf(aux.x));
            }
        }
    }
}

