/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.convenio.RotaBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.RotaVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.RotaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Rota
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelResponsavel = new JLabel("Respons\u00e1vel:");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(100, 3);
    private TTextField textResponsavel = new TTextField(100);
    RotaBean beanDelete = null;
    private String retornoParaPesquisa = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Rota.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101700401"));
        this.setModuloEdita(Long.parseLong("0101700402"));
        this.setModuloApaga(Long.parseLong("0101700403"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101700400");
    }

    public Rota() {
        this.setName("Rota");
        this.setLabelDescricao("Cadastro de rotas para recebimento de materiais");
        this.setLabelFormulario("Cadastro de rotas");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_tab_preco.jpg"));
        this.textCodigo.setName("textCodigo");
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        this.textDescricao.setName("textDescricao");
        d = new Dimension(350, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        this.textResponsavel.setName("textResponsavel");
        d = new Dimension(350, 20);
        this.textResponsavel.setSize(d);
        this.textResponsavel.setPreferredSize(d);
        this.textResponsavel.setMinimumSize(d);
        this.textResponsavel.setMaximumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelResponsavel, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textResponsavel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        this.service = new RotaService();
        this.controlaCampos();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textResponsavel.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.textResponsavel.setText("");
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new RotaVO(), "Pesquisando rotas", false);
            if (vo != null) {
                RotaBean rotaBean = (RotaBean)this.service.voToBean((RotaVO)vo, RotaBean.class);
                return rotaBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Rota:216");
        }
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        RotaBean bean = new RotaBean();
        FilialVO filial = new FilialVO();
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setDescricao(this.textDescricao.getText());
        bean.setResponsavel(this.textResponsavel.getText());
        bean.setFilial(filial);
        return bean;
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Descri\u00e7\u00e3o n\u00e3o informada", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        return true;
    }

    @Override
    public void salvar() {
        RotaBean bean;
        RotaService service = new RotaService();
        if (this.validaCampos() && (bean = (RotaBean)this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar rota.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public void excluir() {
        this.beanDelete = (RotaBean)this.pesquisar();
        if (this.beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rota.this.preencherCampos(Rota.this.beanDelete);
                    if (Funcoes.mensagem(Rota.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            new RotaService().gravaAutoCopiaSemCommit(Rota.this.beanDelete, 2, Variaveis.filialPadrao, Rota.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel excluir rota.\n" + e.getMessage(), 2);
                        }
                    }
                    Rota.this.limparCampos();
                    Rota.this.beanDelete = null;
                }
            });
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        RotaBean rotaBean = (RotaBean)bean;
        this.textCodigo.setText(Integer.toString(rotaBean.getCodigo()));
        this.textDescricao.setText(rotaBean.getDescricao());
        this.textResponsavel.setText(rotaBean.getResponsavel());
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public String getCopiaFiliais() {
        return ParametrosGerais.getCopiaRota();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "rot_codigo";
    }
}

