/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.cadastro.ObjetoMetodo;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class RenderLabExterno
extends DefaultTableCellRenderer {
    final int COLUNA_VALOR = 4;
    final int COLUNA_PRAZO = 3;
    final int COLUNA_BLOQUEADO = 6;
    final int COLUNA_PADRAO = 8;

    RenderLabExterno() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c;
        boolean padrao;
        ModeloGridTable modelo = (ModeloGridTable)table.getModel();
        boolean bl = padrao = modelo.getValueAt(row, 8) != null && Boolean.parseBoolean(modelo.getValueAt(row, 8).toString());
        if (column != 6) {
            JLabel label = new JLabel(value instanceof String || value instanceof ObjetoMetodo ? value.toString() : "");
            if (column == 4 && Funcoes.isNumeric(value.toString()) && BigDecimal.valueOf(Double.parseDouble(value.toString().replace(",", "."))).compareTo(BigDecimal.valueOf(Double.parseDouble("0.0"))) < 0) {
                label.setText("");
            }
            if (column == 3 && Funcoes.isNumeric(value.toString()) && Integer.parseInt(value.toString()) < 0) {
                label.setText("");
            }
            label.setOpaque(padrao || isSelected);
            label.setFont(table.getFont());
            c = label;
        } else {
            JCheckBox check = new JCheckBox();
            check.setOpaque(padrao || isSelected);
            check.setSelected(value instanceof Boolean && (Boolean)value != false);
            check.setHorizontalAlignment(0);
            c = check;
        }
        if (padrao) {
            ((Component)c).setBackground(isSelected ? Color.GRAY : ScreenUtil.clarearCor(Color.GRAY, 30));
        } else {
            ((Component)c).setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        }
        return c;
    }
}

