/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.cadastro.ObjetoMetodo;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class RenderInterface
extends DefaultTableCellRenderer {
    final int COLUNA_DECIMAIS = 4;
    final int COLUNA_PADRAO = 10;
    final int COLUNA_BLOQUEAR = 8;

    RenderInterface() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean bloquear;
        JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ModeloGridTable modelo = (ModeloGridTable)table.getModel();
        boolean padrao = modelo.getValueAt(row, 10) != null && (Boolean)modelo.getValueAt(row, 10) != false;
        boolean bl = bloquear = modelo.getValueAt(row, 8) != null && (Boolean)modelo.getValueAt(row, 8) != false;
        if (column == 6 || column == 7 || column == 8) {
            JCheckBox j = new JCheckBox();
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                j.setSelected((Boolean)value);
            }
            j.setOpaque(true);
            j.setHorizontalAlignment(0);
            c = j;
        } else {
            JLabel label = new JLabel(value instanceof String || value instanceof ObjetoMetodo ? value.toString() : "");
            label.setOpaque(true);
            if (column == 4 && Funcoes.isNumeric(value.toString()) && Integer.parseInt(value.toString()) < 0) {
                label.setText("");
            }
            c = label;
        }
        c.setFont(table.getFont());
        if (bloquear) {
            c.setBackground(isSelected ? Color.RED : ScreenUtil.clarearCor(Color.RED, 100));
        } else if (padrao) {
            c.setBackground(isSelected ? Color.GRAY : ScreenUtil.clarearCor(Color.GRAY, 30));
        } else {
            c.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        }
        return c;
    }
}

