/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.MaterialService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class Recipiente
extends FrmCadPadrao {
    private JComboBox comboTipo;
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TTextField txtCodUnidade;
    private TTextField txtDescUnidade;
    private TTextField txtCapacidade;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JButton bBuscaUnidade;
    private TTextField textVolumeMinimo = new TTextField(8, 2, 3);
    private JPanel panelMat;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private TTextField txtCodMat;
    private TTextField txtDescMat;
    private TTextField txtQtdeMat;
    private JButton bBuscaMat;
    private JButton bOKMat;
    private JTable tableMat;
    private JScrollPane scrollPane;
    private ModeloGridTable modeloMat;
    private int linhaAlterada = -1;
    private String retornoParaPesquisa = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Recipiente.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900601"));
        this.setModuloEdita(Long.parseLong("0101900602"));
        this.setModuloApaga(Long.parseLong("0101900603"));
    }

    public Recipiente() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Recipiente");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtCodUnidade.setUpperCase(false);
    }

    public void jbInit() throws Exception {
        this.setName("Recipiente");
        this.comboTipo = new JComboBox<String>(new String[]{"Triagem", "Coleta"});
        this.comboTipo.setName("comboTipo");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtCodUnidade = new TTextField(8);
        this.txtCodUnidade.setName("txtCodUnidade");
        this.txtDescUnidade = new TTextField();
        this.txtDescUnidade.setName("txtDescUnidade");
        this.bBuscaUnidade = new JButton("");
        this.bBuscaUnidade.setName("bBuscaUnidade");
        Funcoes.imagemPesquisa(this.bBuscaUnidade);
        this.txtCapacidade = new TTextField(10, 2, 4);
        this.txtCapacidade.setName("txtCapacidade");
        this.panelMat = new JPanel();
        this.jLabel6 = new JLabel("Material");
        this.jLabel7 = new JLabel("Qtde");
        this.txtCodMat = new TTextField(5, 1);
        this.txtCodMat.setName("txtCodMat");
        this.txtDescMat = new TTextField();
        this.txtDescMat.setName("txtDescMat");
        this.txtQtdeMat = new TTextField(10, 2, 3);
        this.txtQtdeMat.setName("txtQtdeMat");
        this.bBuscaMat = new JButton("");
        this.bBuscaMat.setName("bBuscaMat");
        Funcoes.imagemPesquisa(this.bBuscaMat);
        this.bOKMat = new JButton("OK");
        this.bOKMat.setName("bOKMat");
        this.tableMat = new JTable();
        this.tableMat.setName("tableMat");
        this.scrollPane = new JScrollPane(this.tableMat);
        this.modeloMat = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Qtde"});
        this.tableMat.setModel(this.modeloMat);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.modeloMat.setColumnSize(new int[]{70, 0, 70}, this.tableMat);
        this.bOKMat.setMargin(new Insets(2, 2, 2, 2));
        this.txtDescMat.setEditable(false);
        this.txtDescMat.setName("txtDescMat");
        this.txtDescMat.setFocusable(false);
        this.jLabel6.setDisplayedMnemonic('M');
        this.jLabel6.setLabelFor(this.txtCodMat);
        this.setLabelDescricao("Cadastro de recipientes de coleta/triagem de exames");
        this.setLabelFormulario("Cadastro de recipientes");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_recipiente.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(83, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(83, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel3.setText("Tipo:");
        this.jLabel3.setBounds(new Rectangle(7, 72, 50, 14));
        this.comboTipo.setBounds(new Rectangle(83, 70, 100, 20));
        this.comboTipo.setSelectedIndex(1);
        JLabel labelVolume = new JLabel("Volume m\u00ednimo:");
        labelVolume.setBounds(new Rectangle(273, 70, 110, 20));
        this.textVolumeMinimo.setBounds(new Rectangle(383, 70, 100, 20));
        this.textVolumeMinimo.setName("textVolumeMinimo");
        this.jLabel4.setText("Unidade:");
        this.jLabel5.setText("Capacidade:");
        this.txtCodUnidade.clear();
        this.txtDescUnidade.clear();
        this.txtCapacidade.clear();
        this.jLabel4.setBounds(new Rectangle(160, 51, 63, 14));
        this.txtCodUnidade.setBounds(new Rectangle(220, 49, 69, 20));
        this.bBuscaUnidade.setBounds(new Rectangle(290, 49, 20, 20));
        this.bBuscaUnidade.setFocusable(false);
        this.txtDescUnidade.setBounds(new Rectangle(311, 49, 172, 20));
        this.jLabel5.setBounds(new Rectangle(7, 51, 80, 14));
        this.txtCapacidade.setBounds(new Rectangle(83, 49, 69, 20));
        this.txtDescUnidade.setEditable(false);
        this.txtDescUnidade.setFocusable(false);
        this.panelMat.setBounds(new Rectangle(7, 100, 476, 300));
        this.panelMat.setBorder(new TitledBorder("Materiais a serem considerados na utiliza\u00e7\u00e3o do recipiente"));
        this.panelMat.setLayout(null);
        this.jLabel6.setBounds(new Rectangle(7, 15, 69, 14));
        this.txtCodMat.setBounds(new Rectangle(7, 30, 69, 20));
        this.bBuscaMat.setBounds(new Rectangle(77, 30, 20, 20));
        this.bBuscaMat.setFocusable(false);
        this.txtDescMat.setBounds(new Rectangle(99, 30, 253, 20));
        this.txtQtdeMat.setBounds(new Rectangle(353, 30, 69, 20));
        this.jLabel7.setBounds(new Rectangle(353, 15, 69, 14));
        this.bOKMat.setBounds(new Rectangle(424, 30, 40, 20));
        this.scrollPane.setBounds(new Rectangle(7, 52, 458, 235));
        this.panelMat.add(this.jLabel6);
        this.panelMat.add(this.jLabel7);
        this.panelMat.add(this.txtCodMat);
        this.panelMat.add(this.txtDescMat);
        this.panelMat.add(this.txtQtdeMat);
        this.panelMat.add(this.bBuscaMat);
        this.panelMat.add(this.scrollPane);
        this.panelMat.add(this.bOKMat);
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.comboTipo, null);
        this.painelCentral.add((Component)this.jLabel4, null);
        this.painelCentral.add((Component)this.jLabel5, null);
        this.painelCentral.add((Component)this.txtCodUnidade, null);
        this.painelCentral.add((Component)this.txtDescUnidade, null);
        this.painelCentral.add((Component)this.bBuscaUnidade, null);
        this.painelCentral.add((Component)this.txtCapacidade, null);
        this.painelCentral.add(labelVolume);
        this.painelCentral.add(this.textVolumeMinimo);
        this.painelCentral.add((Component)this.panelMat, null);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Recipiente.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Recipiente.this.txtCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select a.rec_descricao, a.rec_tipo, a.rec_capacidade, a.unm_codigo, b.unm_descricao, a.rec_volumeminimo from recipientes a ");
                            buf.append("left join unidademedida b on a.fil_codigo = b.fil_codigo and upper(a.unm_codigo)=upper(b.unm_codigo) ");
                            buf.append(" where a.fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and a.rec_codigo = ");
                            buf.append(Recipiente.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                Recipiente.this.setStatus(3);
                                Recipiente.this.txtDescricao.setText(rs.getString("rec_descricao"));
                                Recipiente.this.txtCapacidade.setText(Funcoes.formataDecimal("0.0000", rs.getDouble("rec_capacidade")));
                                Recipiente.this.txtCodUnidade.setText(rs.getString("unm_codigo"));
                                Recipiente.this.txtDescUnidade.setText(rs.getString("unm_descricao"));
                                Recipiente.this.textVolumeMinimo.setText(Funcoes.formataDecimal("0.0000", rs.getDouble("rec_volumeminimo")));
                                String uf = rs.getString("rec_tipo");
                                if (uf.equals("T")) {
                                    Recipiente.this.comboTipo.setSelectedIndex(0);
                                } else {
                                    Recipiente.this.comboTipo.setSelectedIndex(1);
                                }
                                buf.delete(0, buf.length());
                                buf.append("select a.mat_codigo, a.rma_qtde, b.mat_descricao from recipmaterial a ");
                                buf.append("left join material b on a.fil_codigo=b.fil_codigo and a.mat_codigo=b.mat_codigo ");
                                buf.append("where a.fil_codigo = ");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and a.rec_codigo=");
                                buf.append(Recipiente.this.txtCodigo.getText());
                                buf.append(" order by a.mat_codigo");
                                ResultSet rsMaterial = Conexao.executeQuery(st, buf.toString());
                                if (rsMaterial != null) {
                                    while (rsMaterial.next()) {
                                        Recipiente.this.modeloMat.addLine(new String[]{rsMaterial.getString("mat_codigo"), rsMaterial.getString("mat_descricao"), Funcoes.formataDecimal(Recipiente.this.txtQtdeMat.getMaskDecimal(), rsMaterial.getDouble("rma_qtde"))});
                                    }
                                }
                                Recipiente.this.txtCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(Recipiente.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Recipiente.this.setStatus(1);
                                Recipiente.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Recipiente.this, sqlex.getMessage(), sqlex.getStackTrace(), "Recipiente");
                    }
                }
            }
        });
        this.bBuscaUnidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Recipiente.this.buscaUnidade();
            }
        });
        this.txtCodUnidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (!Funcoes.textoVazio(Recipiente.this.txtCodUnidade.getText()) && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select unm_codigo, unm_descricao from unidademedida where fil_codigo  = " + Variaveis.filialPadrao + " and upper(unm_codigo)=upper(" + Recipiente.this.txtCodUnidade.getTextDBEscape() + ") ");
                        if (rs.next()) {
                            Recipiente.this.txtCodUnidade.setText(rs.getString("unm_codigo"));
                            Recipiente.this.txtDescUnidade.setText(rs.getString("unm_descricao"));
                        } else {
                            Recipiente.this.txtDescUnidade.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Recipiente.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Recipiente.this.setStatus(1);
                        Recipiente.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodMat.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (!Funcoes.textoVazio(Recipiente.this.txtCodMat.getText()) && (st = Conexao.getStatement()) != null) {
                    try {
                        MaterialVO matVO = (MaterialVO)new MaterialService().getAtivoVO(Variaveis.filialPadrao, Recipiente.this.txtCodMat.getText());
                        if (matVO != null) {
                            Recipiente.this.txtDescMat.setText(matVO.getDescricao());
                        } else {
                            Recipiente.this.txtDescMat.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(Recipiente.this, "N\u00e3o foi poss\u00edvel buscar material.\n" + ex.getMessage(), ex.getStackTrace());
                    }
                }
            }
        });
        this.bOKMat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(Recipiente.this.txtCodMat.getText()) && !Recipiente.this.txtDescMat.getText().equals("N\u00e3o cadastrado") && !Funcoes.textoVazio(Recipiente.this.txtQtdeMat.getText()) && Float.parseFloat(Funcoes.limpaDecimal(Recipiente.this.txtQtdeMat.getText())) > 0.0f) {
                    int localizado = Recipiente.this.modeloMat.localizar(0, Recipiente.this.txtCodMat.getText());
                    if (localizado < 0 || localizado > -1 && localizado == Recipiente.this.linhaAlterada) {
                        if (Recipiente.this.linhaAlterada > -1) {
                            Recipiente.this.modeloMat.setValueAt(Recipiente.this.txtCodMat.getText(), Recipiente.this.linhaAlterada, 0);
                            Recipiente.this.modeloMat.setValueAt(Recipiente.this.txtDescMat.getText(), Recipiente.this.linhaAlterada, 1);
                            Recipiente.this.modeloMat.setValueAt(Funcoes.formataDecimal(Recipiente.this.txtQtdeMat.getMaskDecimal(), Double.parseDouble(Recipiente.this.txtQtdeMat.getText())), Recipiente.this.linhaAlterada, 2);
                            Recipiente.this.linhaAlterada = -1;
                        } else {
                            Recipiente.this.modeloMat.addLine(new String[]{Recipiente.this.txtCodMat.getText(), Recipiente.this.txtDescMat.getText(), Funcoes.formataDecimal(Recipiente.this.txtQtdeMat.getMaskDecimal(), Double.parseDouble(Recipiente.this.txtQtdeMat.getText()))});
                        }
                    }
                    Recipiente.this.txtCodMat.clear();
                    Recipiente.this.txtDescMat.clear();
                    Recipiente.this.txtQtdeMat.clear();
                }
                Recipiente.this.txtCodMat.grabFocus();
            }
        });
        this.tableMat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Recipiente.this.tableMat.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(Recipiente.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Recipiente.this.modeloMat.removeLine(Recipiente.this.tableMat.getSelectedRow());
                } else if (Recipiente.this.tableMat.getSelectedRow() > -1 && e.getKeyCode() == 32) {
                    Recipiente.this.alteraLinha(Recipiente.this.tableMat.getSelectedRow());
                }
            }
        });
        this.tableMat.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && Recipiente.this.tableMat.getSelectedRow() > -1) {
                    Recipiente.this.alteraLinha(Recipiente.this.tableMat.getSelectedRow());
                }
            }
        });
        this.bBuscaMat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Recipiente.this.buscaMat();
            }
        });
    }

    private void alteraLinha(int linha) {
        this.linhaAlterada = linha;
        this.txtCodMat.setText(this.modeloMat.getValueAt(linha, 0).toString());
        this.txtDescMat.setText(this.modeloMat.getValueAt(linha, 1).toString());
        this.txtQtdeMat.setText(this.modeloMat.getValueAt(linha, 2).toString());
        this.txtCodMat.grabFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodUnidade.hasFocus()) {
            this.buscaUnidade();
        } else if (this.txtCodMat.hasFocus()) {
            this.buscaMat();
        }
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.recipiente(this.getTopLevelAncestor(), "", false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("rec_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("recipientes", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("rec_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaRecipiente());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Recipiente");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "recipientes", true);
                }
                SalvaDados salvar = new SalvaDados("recipientes", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("rec_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("rec_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("rec_capacidade", 2, true, false, Funcoes.isNumeric(this.txtCapacidade.getText()) ? Funcoes.limpaDecimal(this.txtCapacidade.getText()) : "0");
                salvar.adicionaCampo("unm_codigo", 0, true, false, this.txtCodUnidade.getTextDBEscape());
                salvar.adicionaCampo("rec_tipo", 0, true, false, StringUtil.textoDBEscape(this.comboTipo.getSelectedItem().toString().substring(0, 1)));
                salvar.adicionaCampo("rec_volumeminimo", 2, true, false, Funcoes.isNumeric(this.textVolumeMinimo.getText()) ? Funcoes.limpaDecimal(this.textVolumeMinimo.getText()) : "0");
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaRecipiente(), "recipientes", Integer.parseInt(codigo));
                Util.gravaAlteracaoRecipiente(statement, codigo);
                salvar.limpar();
                salvar.setOperacao(1);
                salvar.setTabela("recipmaterial");
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("rec_codigo", 2, false, true, codigo);
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaRecipiente());
                salvar.setOperacao(0);
                for (int i = 0; i < this.modeloMat.getRowCount(); ++i) {
                    salvar.limpar();
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("rec_codigo", 2, false, true, codigo);
                    salvar.adicionaCampo("mat_codigo", 2, false, true, this.modeloMat.getValueAt(i, 0));
                    salvar.adicionaCampo("rma_qtde", 2, true, false, Funcoes.limpaDecimal(this.modeloMat.getValueAt(i, 2).toString()));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaRecipiente());
                }
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Recipiente");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodUnidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCapacidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bBuscaUnidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bBuscaMat.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bOKMat.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodMat.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtQtdeMat.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textVolumeMinimo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.clear();
        this.txtDescricao.clear();
        this.txtCapacidade.clear();
        this.txtCodUnidade.clear();
        this.txtDescUnidade.clear();
        this.txtQtdeMat.clear();
        this.txtCodMat.clear();
        this.txtDescMat.clear();
        this.textVolumeMinimo.clear();
        this.modeloMat.clear();
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo nome n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodUnidade.getText())) {
            Funcoes.mensagem(this, "Unidade n\u00e3o informada", 1);
            this.txtCodUnidade.selectAll();
            this.txtCodUnidade.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtDescUnidade.getText()) && this.txtDescUnidade.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Unidade n\u00e3o localizada", 1);
            this.txtCodUnidade.selectAll();
            this.txtCodUnidade.grabFocus();
            return false;
        }
        if (ParametrosGerais.getDigitosTuboTubo() < this.maxValorTubo().length() && this.getStatus() == 2) {
            Funcoes.mensagem(this, "Verifique a configura\u00e7\u00e3o de d\u00edgitos do tubo, os valores s\u00e3o incompat\u00edveis com os cadastros", 1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String maxValorTubo() {
        Statement st = Conexao.getStatement();
        String retorno = this.txtCodigo.getText();
        if (st != null) {
            try {
                ResultSet rs = Conexao.executeQuery(st, "select max(rec_codigo) +1 from recipientes");
                if (rs.next()) {
                    retorno = rs.getString(1);
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                this.setStatus(1);
                this.controlaCampos();
            }
            finally {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return retorno;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900600");
    }

    private void buscaUnidade() {
        Hashtable resultado = Pesquisas.unidadeMedida(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodUnidade.setText(resultado.get("unm_codigo").toString());
        }
        this.txtCodUnidade.requestFocus();
    }

    private void buscaMat() {
        Hashtable resultado = Pesquisas.materialAtivo(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodMat.setText(resultado.get("mat_codigo").toString());
        }
        this.txtCodMat.requestFocus();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "rec_codigo";
    }
}

