/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class Reajuste
extends AbstractDialogoOKCancelar {
    private TTextField textPercentual = new TTextField(3 + ParametrosGerais.getCasasPrecoExame(), 10, ParametrosGerais.getCasasPrecoExame());
    private JButton buttonOKPercentual = ComponenteFactory.novoJButton("OK", this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Percentual"});
    private JTable tabela = new JTable(this.modelo);

    public static Reajuste novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new Reajuste((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new Reajuste((Dialog)owner);
        }
        return null;
    }

    public Reajuste(Frame owner) {
        super(owner, "Reajustes");
        this.montaTela();
    }

    public Reajuste(Dialog owner) {
        super(owner, "Reajustes");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(200, 300));
        this.setLocationRelativeTo(this.getParent());
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        p.add((Component)new JLabel("Percentual:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textPercentual.setPreferredSize(new Dimension(70, 20));
        this.textPercentual.setMinimumSize(new Dimension(70, 20));
        p.add((Component)this.textPercentual, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonOKPercentual.setPreferredSize(new Dimension(40, 20));
        this.buttonOKPercentual.setMinimumSize(new Dimension(40, 20));
        this.buttonOKPercentual.setMaximumSize(new Dimension(40, 20));
        p.add((Component)this.buttonOKPercentual, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        p.add((Component)new JScrollPane(this.tabela), c);
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && Reajuste.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(Reajuste.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Reajuste.this.modelo.removeLine(Reajuste.this.tabela.getSelectedRow());
                }
            }
        });
        ScreenUtil.requisitarFoco(this.textPercentual);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKPercentual) {
            if (Funcoes.isNumeric(this.textPercentual.getText())) {
                this.modelo.addLine(new String[]{Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())))});
            }
            this.textPercentual.clear();
            this.textPercentual.grabFocus();
        } else {
            super.actionPerformed(e);
        }
    }

    public void setPercentuais(String valores) {
        this.modelo.clear();
        if (!Funcoes.textoVazio(valores)) {
            String[] v;
            for (String s : v = valores.split("\\+")) {
                this.modelo.addLine(new String[]{s});
            }
        }
    }

    public String getPercentuais() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (buf.length() > 0) {
                buf.append("+");
            }
            buf.append(this.modelo.getValueAt(i, 0));
        }
        return buf.toString();
    }

    @Override
    public boolean acaoOk() {
        String temp = this.getPercentuais();
        if (temp.length() > 80) {
            Funcoes.mensagem(this, "A quantidade de reajustes foi excedida", 1);
            return false;
        }
        return true;
    }
}

