/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class Prioridade
extends FrmCadPadrao {
    JLabel jLabel1;
    TTextField txtCodigo;
    TTextField txtDescricao;
    JLabel jLabel2;
    JLabel jLabel3;
    JComboBox comboImpressora;
    JCheckBox checkSeparar;
    private String retornoParaPesquisa = "";

    public Prioridade() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Priodidade");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Prioridade");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.comboImpressora = new JComboBox();
        this.comboImpressora.setName("comboImpressora");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.checkSeparar = new JCheckBox();
        this.checkSeparar.setName("checkSeparar");
        this.setLabelDescricao("Cadastro de prioridade de resultados");
        this.setLabelFormulario("Cadastro de prioridade");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_prioridade.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(83, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(83, 28, 297, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel3.setText("Impressora:");
        this.jLabel3.setBounds(new Rectangle(7, 51, 77, 14));
        this.comboImpressora.setEditable(true);
        this.comboImpressora.setBounds(new Rectangle(83, 49, 297, 20));
        this.checkSeparar.setText("Separar exames na impress\u00e3o");
        this.checkSeparar.setMnemonic('p');
        this.checkSeparar.setBounds(new Rectangle(80, 69, 228, 20));
        this.comboImpressora.removeAllItems();
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        this.comboImpressora.addItem("Impressora local");
        for (int i = 0; i < printService.length; ++i) {
            this.comboImpressora.addItem(printService[i].getName());
        }
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.comboImpressora, null);
        this.painelCentral.add((Component)this.checkSeparar, null);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Prioridade.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Prioridade.this.txtCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select pri_codigo, pri_descricao, pri_impressora, pri_separar from prioridade ");
                            buf.append("where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and pri_codigo = ");
                            buf.append(Prioridade.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                Prioridade.this.txtDescricao.setText(rs.getString("pri_descricao"));
                                Prioridade.this.comboImpressora.setSelectedItem(rs.getString("pri_impressora"));
                                Prioridade.this.checkSeparar.setSelected(rs.getBoolean("pri_separar"));
                                Prioridade.this.txtCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(Prioridade.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Prioridade.this.setStatus(1);
                                Prioridade.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Prioridade.this, sqlex.getMessage(), sqlex.getStackTrace(), "Priodidade");
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Prioridade.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101700101"));
        this.setModuloEdita(Long.parseLong("0101700102"));
        this.setModuloApaga(Long.parseLong("0101700103"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.prioridade(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("pri_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("prioridade", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("pri_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaPrioridade());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Priodidade");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            String impressora;
            Statement statement = Conexao.getStatement();
            String string = impressora = this.comboImpressora.getSelectedItem() != null ? (String)this.comboImpressora.getSelectedItem() : "";
            if (statement != null) {
                try {
                    String codigo = this.txtCodigo.getText();
                    if (this.getStatus() == 2) {
                        codigo = DBUtil.getSequencia(statement, "prioridade", true);
                    }
                    SalvaDados salvar = new SalvaDados("prioridade", this.getStatus() == 2 ? 0 : 2);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("pri_codigo", 2, false, true, codigo);
                    salvar.adicionaCampo("pri_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                    salvar.adicionaCampo("pri_impressora", 0, true, false, StringUtil.textoDBEscape(impressora));
                    salvar.adicionaCampo("pri_separar", 4, true, false, this.checkSeparar.isSelected());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaPrioridade(), "prioridade", Integer.parseInt(codigo));
                    this.retornoParaPesquisa = codigo;
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Priodidade");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboImpressora.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkSeparar.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.checkSeparar.setSelected(true);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101700100");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "pri_codigo";
    }
}

