/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class PrazoEntrega
extends FrmCadPadrao {
    private JLabel jLabel5 = new JLabel("Hora limite para entrada:");
    private JLabel jLabel7 = new JLabel("Rotina:");
    private TTextField txtHoraIni = new TTextField(5, 6);
    private TTextField txtHoraUtil = new TTextField(5, 6);
    private TTextField txtDias = new TTextField(2, 1);
    private TTextField txtHoraNaoUtil = new TTextField(5, 6);
    private JLabel jLabel1 = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private TTextField txtDescricao = new TTextField(80);
    private JLabel jLabel2 = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel jLabel3 = new JLabel("Dias:");
    private JLabel labelEntrega = new JLabel("Entrega:");
    private JLabel jLabel6 = new JLabel("Dias \u00fateis:");
    private JLabel labelNaoUteis = new JLabel("Dias n\u00e3o \u00fateis:");
    private JCheckBox checkAvisarPaciente = new JCheckBox("N\u00e3o calcular o prazo de entrega, marcar para avisar");
    private JLabel labelDomingo = new JLabel("");
    private JLabel labelSegunda = new JLabel("");
    private JLabel labelTerca = new JLabel("");
    private JLabel labelQuarta = new JLabel("");
    private JLabel labelQuinta = new JLabel("");
    private JLabel labelSexta = new JLabel("");
    private JLabel labelSabado = new JLabel("");
    private BotaoRotina domingo = new BotaoRotina("Domingo", this.labelDomingo);
    private BotaoRotina segunda = new BotaoRotina("Segunda", this.labelSegunda);
    private BotaoRotina terca = new BotaoRotina("Ter\u00e7a", this.labelTerca);
    private BotaoRotina quarta = new BotaoRotina("Quarta", this.labelQuarta);
    private BotaoRotina quinta = new BotaoRotina("Quinta", this.labelQuinta);
    private BotaoRotina sexta = new BotaoRotina("Sexta", this.labelSexta);
    private BotaoRotina sabado = new BotaoRotina("S\u00e1bado", this.labelSabado);
    private String retornoParaPesquisa = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(PrazoEntrega.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900901"));
        this.setModuloEdita(Long.parseLong("0101900902"));
        this.setModuloApaga(Long.parseLong("0101900903"));
    }

    public PrazoEntrega() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "PrazoEntrega");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("PrazoEntrega");
        this.setLabelDescricao("Cadastro de prazo para c\u00e1lculo da entrega dos exames");
        this.setLabelFormulario("Cadastro de prazo de entrega");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_prazo_entrega.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.checkAvisarPaciente.setBounds(new Rectangle(72, 51, 400, 16));
        this.checkAvisarPaciente.setName("checkAvisarPaciente");
        this.jLabel3.setBounds(new Rectangle(7, 72, 50, 16));
        this.txtDias.setBounds(new Rectangle(72, 70, 69, 20));
        this.txtDias.setName("txtDias");
        this.jLabel5.setBounds(new Rectangle(166, 72, 160, 14));
        this.txtHoraIni.setBounds(new Rectangle(323, 70, 70, 20));
        this.txtHoraIni.setName("txtHoraIni");
        this.labelEntrega.setBounds(new Rectangle(7, 93, 50, 16));
        this.jLabel6.setBounds(new Rectangle(72, 93, 120, 16));
        this.txtHoraUtil.setBounds(new Rectangle(142, 91, 70, 20));
        this.txtHoraUtil.setName("txtHoraUtil");
        this.labelNaoUteis.setBounds(new Rectangle(228, 93, 120, 16));
        this.txtHoraNaoUtil.setBounds(new Rectangle(323, 91, 70, 20));
        this.txtHoraNaoUtil.setName("txtHoraNaoUtil");
        this.jLabel7.setBounds(new Rectangle(7, 121, 50, 14));
        this.domingo.setBounds(new Rectangle(72, 121, 80, 20));
        this.segunda.setBounds(new Rectangle(72, 166, 80, 20));
        this.terca.setBounds(new Rectangle(72, 211, 80, 20));
        this.quarta.setBounds(new Rectangle(72, 256, 80, 20));
        this.quinta.setBounds(new Rectangle(72, 301, 80, 20));
        this.sexta.setBounds(new Rectangle(72, 346, 80, 20));
        this.sabado.setBounds(new Rectangle(72, 391, 80, 20));
        this.labelDomingo.setVerticalAlignment(1);
        this.labelDomingo.setBounds(new Rectangle(153, 121, 300, 50));
        this.labelSegunda.setVerticalAlignment(1);
        this.labelSegunda.setBounds(new Rectangle(153, 166, 300, 50));
        this.labelTerca.setVerticalAlignment(1);
        this.labelTerca.setBounds(new Rectangle(153, 211, 300, 50));
        this.labelQuarta.setVerticalAlignment(1);
        this.labelQuarta.setBounds(new Rectangle(153, 256, 300, 50));
        this.labelQuinta.setVerticalAlignment(1);
        this.labelQuinta.setBounds(new Rectangle(153, 301, 300, 50));
        this.labelSexta.setVerticalAlignment(1);
        this.labelSexta.setBounds(new Rectangle(153, 346, 300, 50));
        this.labelSabado.setVerticalAlignment(1);
        this.labelSabado.setBounds(new Rectangle(153, 391, 300, 50));
        this.domingo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrazoEntrega.this.mudaStatus(PrazoEntrega.this.domingo);
            }
        });
        this.domingo.setName("domingo");
        this.segunda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrazoEntrega.this.mudaStatus(PrazoEntrega.this.segunda);
            }
        });
        this.segunda.setName("segunda");
        this.terca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrazoEntrega.this.mudaStatus(PrazoEntrega.this.terca);
            }
        });
        this.terca.setName("terca");
        this.quarta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrazoEntrega.this.mudaStatus(PrazoEntrega.this.quarta);
            }
        });
        this.quarta.setName("quarta");
        this.quinta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrazoEntrega.this.mudaStatus(PrazoEntrega.this.quinta);
            }
        });
        this.quinta.setName("quinta");
        this.sexta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrazoEntrega.this.mudaStatus(PrazoEntrega.this.sexta);
            }
        });
        this.sexta.setName("sexta");
        this.sabado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrazoEntrega.this.mudaStatus(PrazoEntrega.this.sabado);
            }
        });
        this.sabado.setName("sabado");
        this.checkAvisarPaciente.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrazoEntrega.this.controlaCampos();
            }
        });
        this.checkAvisarPaciente.setName("checkAvisarPaciente");
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.txtDias, null);
        this.painelCentral.add((Component)this.jLabel5, null);
        this.painelCentral.add((Component)this.jLabel6, null);
        this.painelCentral.add((Component)this.jLabel7, null);
        this.painelCentral.add((Component)this.labelEntrega, null);
        this.painelCentral.add((Component)this.labelNaoUteis, null);
        this.painelCentral.add(this.txtHoraNaoUtil);
        this.painelCentral.add((Component)this.txtHoraIni, null);
        this.painelCentral.add((Component)this.txtHoraUtil, null);
        this.painelCentral.add(this.domingo);
        this.painelCentral.add(this.segunda);
        this.painelCentral.add(this.terca);
        this.painelCentral.add(this.quarta);
        this.painelCentral.add(this.quinta);
        this.painelCentral.add(this.sexta);
        this.painelCentral.add(this.sabado);
        this.painelCentral.add(this.labelDomingo);
        this.painelCentral.add(this.labelSegunda);
        this.painelCentral.add(this.labelTerca);
        this.painelCentral.add(this.labelQuarta);
        this.painelCentral.add(this.labelQuinta);
        this.painelCentral.add(this.labelSexta);
        this.painelCentral.add(this.labelSabado);
        this.painelCentral.add(this.checkAvisarPaciente);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PrazoEntrega.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(PrazoEntrega.this.txtCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select prz_descricao, prz_dias, prz_horaentrada, prz_horasaida, ");
                            buf.append("prz_prazo, prz_horasaidasabado, COALESCE(prz_avisar, false) as avisar from prazoentrega where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and prz_codigo = ");
                            buf.append(PrazoEntrega.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                PrazoEntrega.this.txtDescricao.setText(rs.getString("prz_descricao"));
                                PrazoEntrega.this.txtDias.setText(rs.getString("prz_dias"));
                                PrazoEntrega.this.txtHoraIni.setText(rs.getString("prz_horaentrada"));
                                PrazoEntrega.this.txtHoraUtil.setText(rs.getString("prz_horasaida"));
                                PrazoEntrega.this.txtHoraNaoUtil.setText(rs.getString("prz_horasaidasabado"));
                                PrazoEntrega.this.checkAvisarPaciente.setSelected(rs.getBoolean("avisar"));
                                String rotina = rs.getString("prz_prazo");
                                PrazoEntrega.this.mudaStatusEdicao(PrazoEntrega.this.domingo, rotina.substring(0, 1));
                                PrazoEntrega.this.mudaStatusEdicao(PrazoEntrega.this.segunda, rotina.substring(1, 2));
                                PrazoEntrega.this.mudaStatusEdicao(PrazoEntrega.this.terca, rotina.substring(2, 3));
                                PrazoEntrega.this.mudaStatusEdicao(PrazoEntrega.this.quarta, rotina.substring(3, 4));
                                PrazoEntrega.this.mudaStatusEdicao(PrazoEntrega.this.quinta, rotina.substring(4, 5));
                                PrazoEntrega.this.mudaStatusEdicao(PrazoEntrega.this.sexta, rotina.substring(5, 6));
                                PrazoEntrega.this.mudaStatusEdicao(PrazoEntrega.this.sabado, rotina.substring(6, 7));
                                PrazoEntrega.this.txtCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(PrazoEntrega.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                PrazoEntrega.this.setStatus(1);
                                PrazoEntrega.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(PrazoEntrega.this, sqlex.getMessage(), sqlex.getStackTrace(), "PrazoEntrega");
                    }
                }
            }
        });
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.prazoEntrega(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("prz_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("prazoentrega", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("prz_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaPrazo());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PrazoEntrega");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    private String pegaStatus(BotaoRotina botao) {
        String retorno = "N";
        switch (botao.getStatus()) {
            case 1: {
                retorno = "R";
                break;
            }
            case 2: {
                retorno = "C";
                break;
            }
            case 3: {
                retorno = "E";
                break;
            }
            case 4: {
                retorno = "S";
                break;
            }
            case 5: {
                retorno = "G";
                break;
            }
            default: {
                retorno = "N";
            }
        }
        return retorno;
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String prazo = "";
                prazo = prazo + this.pegaStatus(this.domingo) + this.pegaStatus(this.segunda) + this.pegaStatus(this.terca) + this.pegaStatus(this.quarta) + this.pegaStatus(this.quinta) + this.pegaStatus(this.sexta) + this.pegaStatus(this.sabado);
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "prazoentrega", true);
                }
                SalvaDados salvar = new SalvaDados("prazoentrega", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("prz_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("prz_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("prz_dias", 2, true, false, this.txtDias.getText());
                salvar.adicionaCampo("prz_prazo", 0, true, false, StringUtil.textoDBEscape(prazo));
                salvar.adicionaCampo("prz_horaentrada", 3, true, false, this.txtHoraIni.getText());
                salvar.adicionaCampo("prz_horasaida", 3, true, false, this.txtHoraUtil.getText());
                salvar.adicionaCampo("prz_horasaidasabado", 3, true, false, this.txtHoraNaoUtil.getText());
                salvar.adicionaCampo("prz_avisar", 4, false, false, this.checkAvisarPaciente.isSelected());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaPrazo(), "prazoentrega", Integer.parseInt(codigo));
                Util.gravaAlteracaoPrazoEntrega(statement, codigo);
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PrazoEntrega");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 3 || this.getStatus() == 2;
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(enabled);
        this.checkAvisarPaciente.setEnabled(enabled);
        enabled = enabled && !this.checkAvisarPaciente.isSelected();
        this.txtHoraIni.setEnabled(enabled);
        this.txtHoraUtil.setEnabled(enabled);
        this.txtHoraNaoUtil.setEnabled(enabled);
        this.txtDias.setEnabled(enabled);
        this.domingo.setEnabled(enabled);
        this.segunda.setEnabled(enabled);
        this.terca.setEnabled(enabled);
        this.quarta.setEnabled(enabled);
        this.quinta.setEnabled(enabled);
        this.sexta.setEnabled(enabled);
        this.sabado.setEnabled(enabled);
    }

    private void limparCampos() {
        this.txtCodigo.clear();
        this.txtDescricao.clear();
        this.txtDias.clear();
        this.txtHoraIni.clear();
        this.txtHoraUtil.clear();
        this.txtHoraNaoUtil.clear();
        this.checkAvisarPaciente.setSelected(false);
        this.domingo.setStatus(0);
        this.segunda.setStatus(0);
        this.terca.setStatus(0);
        this.quarta.setStatus(0);
        this.quinta.setStatus(0);
        this.sexta.setStatus(0);
        this.sabado.setStatus(0);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo nome n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (this.checkAvisarPaciente.isSelected()) {
            return true;
        }
        if (this.txtDias.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo dias n\u00e3o informado", 1);
            this.txtDias.selectAll();
            this.txtDias.grabFocus();
            return false;
        }
        if (this.txtHoraIni.getText().trim().length() > 0 && !Funcoes.verificaHora(this.txtHoraIni.getText())) {
            Funcoes.mensagem(this, "Campo hora inicial incorreto", 1);
            this.txtHoraIni.selectAll();
            this.txtHoraIni.grabFocus();
            return false;
        }
        if (this.txtHoraUtil.getText().trim().length() > 0 && !Funcoes.verificaHora(this.txtHoraUtil.getText())) {
            Funcoes.mensagem(this, "Campo hora dias \u00fateis incorreto", 1);
            this.txtHoraUtil.selectAll();
            this.txtHoraUtil.grabFocus();
            return false;
        }
        if (this.txtHoraNaoUtil.getText().trim().length() > 0 && !Funcoes.verificaHora(this.txtHoraNaoUtil.getText())) {
            Funcoes.mensagem(this, "Campo hora dias n\u00e3o \u00fateis incorreto", 1);
            this.txtHoraNaoUtil.selectAll();
            this.txtHoraNaoUtil.grabFocus();
            return false;
        }
        if (this.domingo.getStatus() == 0 && this.segunda.getStatus() == 0 && this.terca.getStatus() == 0 && this.quarta.getStatus() == 0 && this.quinta.getStatus() == 0 && this.sexta.getStatus() == 0 && this.sabado.getStatus() == 0) {
            Funcoes.mensagem(this, "N\u00e3o foi informado dia de rotina", 1);
            this.domingo.grabFocus();
            return false;
        }
        return true;
    }

    private void mudaStatus(BotaoRotina botao) {
        if (botao.getStatus() == 2) {
            botao.setStatus(0);
        } else if (botao.getStatus() == 0) {
            botao.setStatus(1);
        } else if (botao.getStatus() == 1) {
            botao.setStatus(3);
        } else if (botao.getStatus() == 3) {
            botao.setStatus(4);
        } else if (botao.getStatus() == 4) {
            botao.setStatus(5);
        } else {
            botao.setStatus(2);
        }
    }

    private void mudaStatusEdicao(BotaoRotina botao, String status) {
        if (botao != null) {
            if (status.equals("N")) {
                botao.setStatus(0);
            } else if (status.equals("R")) {
                botao.setStatus(1);
            } else if (status.equals("E")) {
                botao.setStatus(3);
            } else if (status.equals("C")) {
                botao.setStatus(2);
            } else if (status.equals("S")) {
                botao.setStatus(4);
            } else if (status.equals("G")) {
                botao.setStatus(5);
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900900");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "prz_codigo";
    }

    class BotaoRotina
    extends JButton {
        public static final int NAO_REALIZA = 0;
        public static final int REALIZA = 1;
        public static final int CONTA_DIA = 2;
        public static final int NAO_ENTREGA = 3;
        public static final int NAO_ENTREGA_NAO_SOMA = 4;
        public static final int REALIZA_NAO_ENTREGA = 5;
        private final String TEXTO_REALIZA = "<html><font size='8px'>Inicia a rotina<br>Soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
        private final String TEXTO_REALIZA_SEM_ENTREGA = "<html><font size='8px'>Inicia a rotina<br>Soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
        private final String TEXTO_CONTA_DIA = "<html><font size='8px'>N&atilde;o inicia a rotina<br>Soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
        private final String TEXTO_NAO_ENTREGA = "<html><font size='8px'>N&atilde;o inicia a rotina<br>Soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
        private final String TEXTO_NAO_REALIZA = "<html><font size='8px'>N&atilde;o faz parte da rotina<br>N&atilde;o soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
        private final String TEXTO_NAO_ENTREGA_NAO_SOMA = "<html><font size='8px'>N&atilde;o inicia a rotina<br>N&atilde;o soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
        private int status;
        private Color corOriginal;
        private Color corRealiza;
        private Color corConta;
        private Color corNaoEntrega;
        private Color corNaoEntregaNaoSoma;
        private Color corRealizaNaoEntrega;
        private JLabel labelSituacao;

        public BotaoRotina(String text, JLabel labelSituacao) {
            super(text);
            this.TEXTO_REALIZA = "<html><font size='8px'>Inicia a rotina<br>Soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
            this.TEXTO_REALIZA_SEM_ENTREGA = "<html><font size='8px'>Inicia a rotina<br>Soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
            this.TEXTO_CONTA_DIA = "<html><font size='8px'>N&atilde;o inicia a rotina<br>Soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
            this.TEXTO_NAO_ENTREGA = "<html><font size='8px'>N&atilde;o inicia a rotina<br>Soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
            this.TEXTO_NAO_REALIZA = "<html><font size='8px'>N&atilde;o faz parte da rotina<br>N&atilde;o soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
            this.TEXTO_NAO_ENTREGA_NAO_SOMA = "<html><font size='8px'>N&atilde;o inicia a rotina<br>N&atilde;o soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
            this.status = 0;
            this.corRealiza = new Color(0, 153, 204);
            this.corConta = new Color(240, 200, 36);
            this.corNaoEntrega = new Color(140, 200, 36);
            this.corNaoEntregaNaoSoma = new Color(140, 120, 20);
            this.corRealizaNaoEntrega = new Color(250, 200, 180);
            this.labelSituacao = null;
            this.corOriginal = this.getBackground();
            this.setMargin(new Insets(2, 2, 2, 2));
            this.labelSituacao = labelSituacao;
            this.setToolTipText("N\u00e3o \u00e9 realizado neste dia");
            this.setStatus(0);
            if (labelSituacao != null) {
                labelSituacao.setFont(new Font(labelSituacao.getFont().getFontName(), 0, 10));
                labelSituacao.setText("<html><font size='8px'>N&atilde;o faz parte da rotina<br>N&atilde;o soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>");
            }
        }

        public void setStatus(int newStatus) {
            if (this.status != newStatus) {
                this.status = newStatus;
                String texto = "";
                switch (this.status) {
                    case 1: {
                        this.setBackground(this.corRealiza);
                        this.setToolTipText("Dia de realiza\u00e7\u00e3o de exames");
                        texto = "<html><font size='8px'>Inicia a rotina<br>Soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
                        break;
                    }
                    case 2: {
                        this.setBackground(this.corConta);
                        this.setToolTipText("Conta o dia no processo de realiza\u00e7\u00e3o");
                        texto = "<html><font size='8px'>N&atilde;o inicia a rotina<br>Soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
                        break;
                    }
                    case 3: {
                        this.setBackground(this.corNaoEntrega);
                        this.setToolTipText("N\u00e3o marca entrega para este dia");
                        texto = "<html><font size='8px'>N&atilde;o inicia a rotina<br>Soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
                        break;
                    }
                    case 4: {
                        this.setBackground(this.corNaoEntregaNaoSoma);
                        this.setToolTipText("N\u00e3o marca entrega para este dia e n\u00e3o soma no prazo de entrega");
                        texto = "<html><font size='8px'>N&atilde;o inicia a rotina<br>N&atilde;o soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
                        break;
                    }
                    case 5: {
                        this.setBackground(this.corRealizaNaoEntrega);
                        this.setToolTipText("Dia de realiza\u00e7\u00e3o de exames mas n\u00e3o marca entrega para este dia");
                        texto = "<html><font size='8px'>Inicia a rotina<br>Soma ao prazo de entrega<br>N&atilde;o marca entrega para o dia</font></html>";
                        break;
                    }
                    default: {
                        this.setBackground(this.corOriginal);
                        this.setToolTipText("N\u00e3o \u00e9 realizado neste dia");
                        texto = "<html><font size='8px'>N&atilde;o faz parte da rotina<br>N&atilde;o soma ao prazo de entrega<br>Pode marcar entrega para o dia</font></html>";
                    }
                }
                if (this.labelSituacao != null) {
                    this.labelSituacao.setText(texto);
                }
            }
        }

        public int getStatus() {
            return this.status;
        }
    }
}

