/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.util.TiposApropriacao;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.CentroCustoPlanoContaBean;
import jalis.model.bean.cadastro.financeiro.PlanoContaBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.CentroCustoVO;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class PlanoConta
extends FrmCadPadraoBean {
    private JLabel labelReduzido = new JLabel("Reduzido:");
    private JLabel labelPai = new JLabel("Pai:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelConta = new JLabel("Conta:");
    private JLabel labelTipo = new JLabel("Tipo:");
    private JLabel labelApropriacao = new JLabel("Apropria\u00e7\u00e3o:");
    private TTextField textReduzido = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(100, 3);
    private TTextField textCodigoPai = new TTextField(5, 1);
    private TTextField textDescricaoPai = new TTextField();
    private TTextField textConta = new TTextField(50, 3);
    private TTextField textContaPai = new TTextField(50, 3);
    private JComboBox comboTipo = ComponenteFactory.novoJComboBox(new String[]{"Receita", "Despesa"});
    private JComboBox comboApropriacao = ComponenteFactory.novoJComboBox((Object[])TiposApropriacao.getTiposApropriacao());
    private JButton buttonBuscaPai = new JButton();
    private JPanel panelCentroCusto = new JPanel(new GridBagLayout());
    private DefaultTableModel modelCentroCusto;
    private JTable tableCentroCusto;
    private JScrollPane scrollCentroCusto;
    private JLabel labelCentroCusto = new JLabel("C\u00f3digo");
    private JLabel labelPercentual = new JLabel("Percentual");
    private TTextField textCodigoCentroCusto = new TTextField(5, 1);
    private JButton buttonBuscaCentroCusto = new JButton();
    private TTextField textDescricaoCentroCusto = new TTextField();
    private TTextField textPercentual = new TTextField(5, 10, 2);
    private JButton buttonAdicionarCentroCusto = new JButton("OK");
    private JComboBox comboTipoOperacao = ComponenteFactory.novoJComboBox(new String[]{"Adi\u00e7\u00e3o", "Subtra\u00e7\u00e3o"});
    private JLabel labelTipoOperacao = new JLabel("Tipo Opera\u00e7\u00e3o:");
    private ArrayList<CentroCustoPlanoContaBean> centrosCusto;
    private CentroCustoService centroCustoService = new CentroCustoService();
    private String retornoParaPesquisa = "";

    public PlanoConta() {
        this.setName("PlanoConta");
        this.setLabelDescricao("Cadastro de Planos de Contas");
        this.setLabelFormulario("Cadastro de Planos de Contas");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/plano_contas.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textReduzido.setPreferredSize(d);
        this.textReduzido.setName("textReduzido");
        this.textReduzido.setMinimumSize(d);
        d = new Dimension(450, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.textCodigoPai.setPreferredSize(d);
        this.textCodigoPai.setName("textCodigoPai");
        this.textCodigoPai.setMinimumSize(d);
        this.textCodigoPai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PlanoConta.this.buscaPai(PlanoConta.this.textCodigoPai.getText());
                if (!PlanoConta.this.validaUltimoNivel()) {
                    PlanoConta.this.comboTipoOperacao.setEnabled(false);
                } else {
                    PlanoConta.this.comboTipoOperacao.setEnabled(true);
                }
            }
        });
        this.buttonBuscaPai.setFocusable(false);
        this.buttonBuscaPai.setName("buttonBuscaPai");
        this.buttonBuscaPai.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaPai.setPreferredSize(d);
        this.buttonBuscaPai.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaPai);
        this.comboTipoOperacao.setName("comboTipoOperacao");
        this.buttonBuscaPai.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanoConta.this.buscaPai();
                if (!PlanoConta.this.validaUltimoNivel()) {
                    PlanoConta.this.comboTipoOperacao.setEnabled(false);
                } else {
                    PlanoConta.this.comboTipoOperacao.setEnabled(true);
                }
            }
        });
        d = new Dimension(370, 20);
        this.textDescricaoPai.setPreferredSize(d);
        this.textDescricaoPai.setName("textDescricaoPai");
        this.textDescricaoPai.setMinimumSize(d);
        this.textDescricaoPai.setEditable(false);
        this.textDescricaoPai.setFocusable(false);
        d = new Dimension(100, 20);
        this.textConta.setPreferredSize(d);
        this.textConta.setName("textConta");
        this.textConta.setMinimumSize(d);
        this.textConta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Funcoes.textoVazio(PlanoConta.this.textConta.getText())) {
                    PlanoConta.this.montaMascara();
                    PlanoConta.this.verificaProximaConta();
                    if (!PlanoConta.this.validaUltimoNivel()) {
                        PlanoConta.this.comboTipoOperacao.setEnabled(false);
                    } else {
                        PlanoConta.this.comboTipoOperacao.setEnabled(true);
                    }
                }
            }
        });
        d = new Dimension(80, 20);
        this.textContaPai.setPreferredSize(d);
        this.textContaPai.setName("textContaPai");
        this.textContaPai.setMinimumSize(d);
        this.textContaPai.setEditable(false);
        this.textContaPai.setFocusable(false);
        this.textContaPai.setHorizontalAlignment(4);
        d = new Dimension(100, 20);
        this.comboTipo.setPreferredSize(d);
        this.comboTipo.setName("comboTipo");
        this.comboTipo.setMinimumSize(d);
        this.comboApropriacao.setName("comboApropriacao");
        d = new Dimension(300, 20);
        this.comboApropriacao.setPreferredSize(d);
        this.comboApropriacao.setMinimumSize(d);
        this.comboApropriacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.comboTipoOperacao.setName("comboTipoOperacao");
        d = new Dimension(100, 20);
        this.comboTipoOperacao.setPreferredSize(d);
        this.comboTipoOperacao.setMinimumSize(d);
        this.comboTipoOperacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!PlanoConta.this.validaUltimoNivel()) {
                    PlanoConta.this.comboTipoOperacao.setEnabled(false);
                } else {
                    PlanoConta.this.comboTipoOperacao.setEnabled(true);
                }
            }
        });
        this.textCodigoCentroCusto.setName("textCodigoCentroCusto");
        d = new Dimension(60, 20);
        this.textCodigoCentroCusto.setPreferredSize(d);
        this.textCodigoCentroCusto.setMinimumSize(d);
        this.textCodigoCentroCusto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PlanoConta.this.buscaCentroCusto(PlanoConta.this.textCodigoCentroCusto.getText());
            }
        });
        this.buttonBuscaCentroCusto.setName("buttonBuscaCentroCusto");
        this.buttonBuscaCentroCusto.setFocusable(false);
        this.buttonBuscaCentroCusto.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaCentroCusto.setPreferredSize(d);
        this.buttonBuscaCentroCusto.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaCentroCusto);
        this.buttonBuscaCentroCusto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanoConta.this.buscaCentroCusto();
            }
        });
        this.textDescricaoCentroCusto.setName("textDescricaoCentroCusto");
        d = new Dimension(200, 20);
        this.textDescricaoCentroCusto.setPreferredSize(d);
        this.textDescricaoCentroCusto.setMinimumSize(d);
        this.textDescricaoCentroCusto.setEditable(false);
        this.textDescricaoCentroCusto.setFocusable(false);
        this.textPercentual.setName("textPercentual");
        d = new Dimension(70, 20);
        this.textPercentual.setPreferredSize(d);
        this.textPercentual.setMinimumSize(d);
        this.buttonAdicionarCentroCusto.setName("buttonAdicionarCentroCusto");
        d = new Dimension(40, 20);
        this.buttonAdicionarCentroCusto.setPreferredSize(d);
        this.buttonAdicionarCentroCusto.setMinimumSize(d);
        this.buttonAdicionarCentroCusto.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarCentroCusto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanoConta.this.adicionarCentroCusto();
            }
        });
        this.panelCentroCusto.setBorder(new TitledBorder("Centros de Custo Associados"));
        d = new Dimension(450, 250);
        this.panelCentroCusto.setPreferredSize(d);
        this.panelCentroCusto.setMinimumSize(d);
        this.modelCentroCusto = new DefaultTableModel(new Object[0][], new String[]{"C\u00f3digo", "Centro de Custo", "Conta", "Percentual"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }
        };
        this.tableCentroCusto = new JTable(this.modelCentroCusto);
        this.tableCentroCusto.setName("tableCentroCusto");
        TableRowSorter<TableModel> sorterPrateleiras = new TableRowSorter<TableModel>(this.tableCentroCusto.getModel());
        this.tableCentroCusto.setRowSorter(sorterPrateleiras);
        this.tableCentroCusto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    PlanoConta.this.removerCentroCusto();
                }
            }
        });
        this.tableCentroCusto.getColumnModel().getColumn(0).setMinWidth(55);
        this.tableCentroCusto.getColumnModel().getColumn(0).setMaxWidth(55);
        this.tableCentroCusto.getColumnModel().getColumn(0).setPreferredWidth(55);
        this.tableCentroCusto.getColumnModel().getColumn(0).setWidth(55);
        this.tableCentroCusto.getColumnModel().getColumn(2).setMinWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(2).setMaxWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(2).setPreferredWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(2).setWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(3).setMinWidth(70);
        this.tableCentroCusto.getColumnModel().getColumn(3).setMaxWidth(70);
        this.tableCentroCusto.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.tableCentroCusto.getColumnModel().getColumn(3).setWidth(70);
        this.scrollCentroCusto = new JScrollPane(this.tableCentroCusto);
        d = new Dimension(450, 150);
        this.scrollCentroCusto.setPreferredSize(d);
        this.scrollCentroCusto.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(1, 0, 1, 0);
        this.painelCentral.add((Component)this.labelReduzido, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textReduzido, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelPai, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoPai, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaPai, c);
        ++c.gridx;
        c.fill = 0;
        this.painelCentral.add((Component)this.textDescricaoPai, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)new JLabel(), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.fill = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelConta, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textContaPai, c);
        c.insets = new Insets(1, 0, 1, 1);
        c.gridx += 2;
        this.painelCentral.add((Component)this.textConta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelTipo, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.comboTipo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelTipoOperacao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.comboTipoOperacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelApropriacao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.comboApropriacao, c);
        ++c.gridy;
        JPanel aux1 = new JPanel();
        d = new Dimension(10, 20);
        aux1.setPreferredSize(d);
        aux1.setMaximumSize(d);
        this.painelCentral.add((Component)aux1, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.panelCentroCusto, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 17;
        c.gridwidth = 3;
        this.panelCentroCusto.add((Component)this.labelCentroCusto, c);
        c.gridwidth = 1;
        c.gridx += 3;
        this.panelCentroCusto.add((Component)this.labelPercentual, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelCentroCusto.add((Component)this.textCodigoCentroCusto, c);
        ++c.gridx;
        this.panelCentroCusto.add((Component)this.buttonBuscaCentroCusto, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelCentroCusto.add((Component)this.textDescricaoCentroCusto, c);
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridx;
        this.panelCentroCusto.add((Component)this.textPercentual, c);
        ++c.gridx;
        this.panelCentroCusto.add((Component)this.buttonAdicionarCentroCusto, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelCentroCusto.add((Component)this.scrollCentroCusto, c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new PlanoContaService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        this.textReduzido.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoPai.setEnabled(this.getStatus() == 2);
        this.textConta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboApropriacao.setEnabled(false);
        this.buttonBuscaPai.setEnabled(this.getStatus() == 2);
        this.textCodigoCentroCusto.setEnabled(this.getStatus() == 2);
        this.buttonBuscaCentroCusto.setEnabled(this.getStatus() == 2);
        this.textPercentual.setEnabled(this.getStatus() == 2);
        this.buttonAdicionarCentroCusto.setEnabled(this.getStatus() == 2);
        this.comboTipoOperacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        String conta;
        PlanoContaBean bean = new PlanoContaBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setReduzido(Integer.parseInt(this.textReduzido.getText()));
        }
        if ((conta = this.textContaPai.getText()).trim().length() > 0) {
            conta = conta + ".";
        }
        conta = conta + this.textConta.getText();
        int nivel = 0;
        if (!Funcoes.textoVazio(this.textContaPai.getText())) {
            nivel += this.textContaPai.getText().split("\\.").length;
        }
        if (!Funcoes.textoVazio(this.textConta.getText())) {
            nivel += this.textConta.getText().split("\\.").length;
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setConta(conta);
        bean.setTipo(this.comboTipo.getSelectedIndex() >= 0 ? ((String)this.comboTipo.getSelectedItem()).substring(0, 1) : "");
        Integer apropriar = null;
        if (this.comboApropriacao.getSelectedIndex() >= 0 && (TiposApropriacao)((Object)this.comboApropriacao.getSelectedItem()) != TiposApropriacao.Nenhuma) {
            apropriar = ((TiposApropriacao)((Object)this.comboApropriacao.getSelectedItem())).getTipo();
        }
        if (this.comboTipoOperacao.getSelectedIndex() >= 0 && this.validaUltimoNivel()) {
            bean.setOperacao(Tipos.getTipoOperacao(this.comboTipoOperacao.getSelectedItem().toString()));
        }
        bean.setApropriar(apropriar);
        bean.setNivel(nivel);
        if (!Funcoes.textoVazio(this.textCodigoPai.getText()) && !this.textDescricaoPai.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            bean.setPai(Integer.parseInt(this.textCodigoPai.getText()));
        }
        bean.setCentrosCusto(new HashSet<CentroCustoPlanoContaBean>(this.centrosCusto));
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaPlanoConta();
    }

    @Override
    protected void limparCampos() {
        this.textReduzido.setText("");
        this.textDescricao.setText("");
        this.textCodigoPai.setText("");
        this.textDescricaoPai.setText("");
        this.textConta.setText("");
        this.textContaPai.setText("");
        this.comboTipo.setSelectedIndex(0);
        this.comboApropriacao.setSelectedIndex(-1);
        this.comboTipoOperacao.setSelectedIndex(-1);
        this.textConta.setFormatterFactory(null);
        this.textCodigoCentroCusto.setText("");
        this.textDescricaoCentroCusto.setText("");
        this.textPercentual.setText("");
        this.limparCentrosCusto();
        this.centrosCusto = new ArrayList();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new PlanoContaVO(), "Pesquisando planos de contas", true);
            if (vo != null) {
                PlanoContaBean planoBean = (PlanoContaBean)this.service.voToBean((PlanoContaVO)vo, PlanoContaBean.class);
                return planoBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:153");
        }
        return null;
    }

    private void limparCentrosCusto() {
        while (this.modelCentroCusto.getRowCount() > 0) {
            this.modelCentroCusto.removeRow(0);
        }
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        int sM;
        int sP;
        PlanoContaBean planoBean = (PlanoContaBean)bean;
        this.textReduzido.setText(Integer.toString(planoBean.getReduzido()));
        if (planoBean.getPai() != null) {
            this.textCodigoPai.setText(planoBean.getPai().toString());
            this.buscaPai(Integer.toString(planoBean.getPai()));
        }
        this.montaMascara();
        this.textDescricao.setText(planoBean.getDescricao());
        String conta = planoBean.getConta();
        if (conta.indexOf(".") >= 0) {
            this.textContaPai.setText(conta.substring(0, conta.lastIndexOf(".")));
            this.textConta.setValue(conta.substring(conta.lastIndexOf(".") + 1, conta.length()));
        } else {
            this.textConta.setText(conta);
        }
        for (int i = 0; i < this.comboTipo.getItemCount(); ++i) {
            if (!((String)this.comboTipo.getItemAt(i)).substring(0, 1).equalsIgnoreCase(planoBean.getTipo())) continue;
            this.comboTipo.setSelectedIndex(i);
            break;
        }
        this.comboTipo.setEnabled(planoBean.getNivel() == 1);
        if (planoBean.getApropriar() != null) {
            this.comboApropriacao.setSelectedItem((Object)TiposApropriacao.getTipoApropriacao(planoBean.getApropriar()));
        }
        if (planoBean.getOperacao() != null) {
            this.comboTipoOperacao.setSelectedItem(Tipos.tipoOperacao(planoBean.getOperacao()));
        }
        this.textCodigoCentroCusto.setEnabled((sP = conta.split("\\.").length) == (sM = ParametrosGerais.getMascaraPlanoConta().split("\\.").length));
        this.buttonAdicionarCentroCusto.setEnabled(sP == sM);
        this.textPercentual.setEnabled(sP == sM);
        this.buttonBuscaCentroCusto.setEnabled(sP == sM);
        this.comboTipoOperacao.setEditable(sP == sM);
        this.limparCentrosCusto();
        this.centrosCusto = new ArrayList(planoBean.getCentrosCusto());
        this.popularCentrosCusto();
    }

    @Override
    public boolean validaCampos() {
        if (!this.validaConta()) {
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Descri\u00e7\u00e3o da conta n\u00e3o preenchida!", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (this.comboTipo.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "Tipo de Conta n\u00e3o definido!", 2);
            ScreenUtil.requisitarFoco(this.comboTipo);
            return false;
        }
        if (Funcoes.textoVazio(this.textConta.getText())) {
            Funcoes.mensagem(this, "Conta n\u00e3o definida!", 2);
            ScreenUtil.requisitarFoco(this.textConta);
            return false;
        }
        double t = 0.0;
        boolean temCentroCusto = false;
        for (CentroCustoPlanoContaBean c : this.centrosCusto) {
            if (c.isRemover()) continue;
            t += c.getPercentual().doubleValue();
            temCentroCusto = true;
        }
        if (temCentroCusto && this.validaUltimoNivel() && this.centrosCusto != null && this.centrosCusto.size() > 0 && t != 100.0) {
            Funcoes.mensagem(this, "Percentual total difere de 100%!", 2);
            return false;
        }
        if (this.validaUltimoNivel() && this.comboTipoOperacao.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Selecione um tipo de opera\u00e7\u00e3o para o Plano de Contas.", 2);
            if (this.comboTipoOperacao.isFocusable()) {
                this.comboTipoOperacao.grabFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(PlanoConta.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300101"));
        this.setModuloEdita(Long.parseLong("0600300102"));
        this.setModuloApaga(Long.parseLong("0600300103"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300100");
    }

    @Override
    public void editar() {
        this.limparCampos();
        PlanoContaVO voPlano = new PlanoContaVO();
        voPlano = (PlanoContaVO)new PlanoContaService().pesquisaVO(Laboratorio.getInstancia(), voPlano, "Planos de Contas", false);
        if (voPlano != null && voPlano.getReduzido() != null) {
            PlanoContaBean bean = null;
            try {
                bean = (PlanoContaBean)new PlanoContaService().get(Variaveis.filialPadrao, String.valueOf(voPlano.getReduzido()));
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do plano de contas.\n" + e.getMessage(), 2);
            }
            if (bean != null) {
                this.setStatus(3);
                this.controlaCampos();
                this.preencherCampos(bean);
                this.painelCentral.grabFocus();
            }
            ScreenUtil.requisitarFoco(this.textDescricao);
        }
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textCodigoPai);
    }

    private boolean validaConta() {
        boolean retorno = true;
        try {
            PlanoContaVO vo;
            String conta = this.textContaPai.getText().trim();
            if (!Funcoes.textoVazio(conta)) {
                conta = conta + ".";
            }
            conta = conta + this.textConta.getText().trim();
            if (!Funcoes.textoVazio(this.textReduzido.getText()) && (vo = (PlanoContaVO)this.service.getVO(this.textReduzido.getText())) != null && vo.getConta().equalsIgnoreCase(conta)) {
                return true;
            }
            if (((PlanoContaService)this.service).contaExiste(conta)) {
                Funcoes.mensagem(this, "Conta j\u00e1 cadastrada.", 2);
                ScreenUtil.requisitarFoco(this.textConta);
                return false;
            }
            if (!Funcoes.textoVazio(this.textReduzido.getText()) && ((PlanoContaService)this.service).contaExisteFilhos(this.textReduzido.getText())) {
                Funcoes.mensagem(this, "Conta possue filhos e n\u00e3o pode ser alterada.", 2);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:239");
            retorno = false;
            return retorno;
        }
    }

    @Override
    public void excluir() {
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            this.preencherCampos(bean);
            if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
                try {
                    String conta = Integer.toString(((PlanoContaBean)bean).getReduzido());
                    boolean retorno = ((PlanoContaService)this.service).contaExisteFilhos(conta);
                    if (retorno) {
                        Funcoes.mensagem(this, "Conta n\u00e3o pode ser excluida, po\u00eds existem contas filhas dependentes.", 2);
                        this.limparCampos();
                        return;
                    }
                    this.service.gravaAutoCopiaSemCommit(bean, 2, Variaveis.filialPadrao, this.getCopiaFiliais());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:59");
                }
            }
            this.limparCampos();
        }
    }

    private void buscaPai(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoPai.setText("");
            this.textDescricaoPai.setText("");
            return;
        }
        try {
            PlanoContaVO pai = (PlanoContaVO)((PlanoContaService)this.service).getVO(Variaveis.filialPadrao, codigo);
            this.validaPai(pai);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:358");
        }
    }

    private void buscaPai() {
        try {
            this.textCodigoPai.setText("");
            this.textDescricaoPai.setText("");
            PlanoContaVO pai = (PlanoContaVO)((PlanoContaService)this.service).pesquisaVO(this.getTopLevelAncestor(), new PlanoContaVO(), "Pesquisando planos de contas", false);
            this.validaPai(pai);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:374");
        }
    }

    private void validaPai(PlanoContaVO pai) {
        try {
            if (pai != null) {
                int sM;
                int sP = pai.getConta().split("\\.").length;
                if (sP == (sM = ParametrosGerais.getMascaraPlanoConta().split("\\.").length)) {
                    Funcoes.mensagem(this, "Conta do \u00daltimo Nivel n\u00e3o pode ser pai!", 2);
                    this.textCodigoPai.setText("");
                    this.textDescricaoPai.setText("");
                    ScreenUtil.requisitarFoco(this.textCodigoPai);
                    return;
                }
                this.textCodigoPai.setText(pai.getReduzido().toString());
                this.textDescricaoPai.setText(pai.getDescricao());
                this.textContaPai.setText(pai.getConta());
                PlanoContaBean p = (PlanoContaBean)this.service.voToBean(pai, PlanoContaBean.class);
                for (int i = 0; i < this.comboTipo.getItemCount(); ++i) {
                    if (!((String)this.comboTipo.getItemAt(i)).substring(0, 1).equalsIgnoreCase(p.getTipo())) continue;
                    this.comboTipo.setSelectedIndex(i);
                    break;
                }
                this.comboTipo.setEnabled(false);
                this.textCodigoCentroCusto.setEnabled(sP + 1 == sM);
                this.buttonAdicionarCentroCusto.setEnabled(sP + 1 == sM);
                this.textPercentual.setEnabled(sP + 1 == sM);
                this.buttonBuscaCentroCusto.setEnabled(sP + 1 == sM);
                this.comboTipoOperacao.setEnabled(sP + 1 == sM);
                String mascara = ParametrosGerais.getMascaraPlanoConta();
                this.textConta.setEnabled(p.getNivel() != mascara.split("\\.").length);
            } else {
                this.textDescricaoPai.setText("N\u00e3o cadastrado");
                this.comboTipo.setSelectedIndex(-1);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:358");
        }
    }

    private void montaMascara() {
        this.textConta.setText("");
        this.textConta.setFormatterFactory(null);
        try {
            this.textConta.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(this.getMascaraFilho())));
        }
        catch (ParseException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:417");
        }
    }

    private void verificaProximaConta() {
        PlanoContaVO plano = null;
        String maskConta = this.getMascaraFilho();
        int nivel = this.textContaPai.getText().length() + maskConta.length();
        if (!Funcoes.textoVazio(this.textContaPai.getText())) {
            ++nivel;
        }
        try {
            plano = ((PlanoContaService)this.service).getMaiorConta(this.textContaPai.getText(), Integer.toString(nivel));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:461");
        }
        int proximaConta = 1;
        String conta = "";
        if (plano != null) {
            conta = plano.getConta();
            conta = conta.substring(conta.lastIndexOf(".") + 1);
            proximaConta += Integer.parseInt(conta);
        }
        conta = Funcoes.preencheZero(proximaConta, this.getMascaraFilho().length());
        this.textConta.setText(conta);
    }

    public String getMascaraFilho() {
        String mascara = ParametrosGerais.getMascaraPlanoConta();
        String[] niveis = mascara.split("\\.");
        String mask = "";
        if (Funcoes.textoVazio(this.textCodigoPai.getText())) {
            mask = niveis[0];
        } else {
            String[] niveisPai = this.textContaPai.getText().split("\\.");
            mask = niveis[niveisPai.length];
        }
        return mask;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoPai.hasFocus()) {
            this.buscaPai();
        } else if (this.textCodigoCentroCusto.hasFocus()) {
            this.buscaCentroCusto();
        }
    }

    public void adicionarCentroCusto() {
        if (!this.validaUltimoNivel()) {
            Funcoes.mensagem(this, "Somente contas do \u00faltimo n\u00edvel podem possuir centros de custo", 2);
            return;
        }
        if (this.centrosCusto == null) {
            this.centrosCusto = new ArrayList();
        }
        CentroCustoPlanoContaBean centroCusto = null;
        if (Funcoes.textoVazio(this.textCodigoCentroCusto)) {
            Funcoes.mensagem(this, "Informe o c\u00f3digo do centro de custo.", 2);
            if (this.textCodigoCentroCusto.isFocusable()) {
                this.textCodigoCentroCusto.grabFocus();
            }
            return;
        }
        if (Funcoes.textoVazio(this.textPercentual)) {
            Funcoes.mensagem(this, "Informe o percentual do centro de custo.", 2);
            if (this.textPercentual.isFocusable()) {
                this.textPercentual.grabFocus();
            }
            return;
        }
        if (this.textDescricaoCentroCusto.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "C\u00f3digo do centro de custo inv\u00e1lido.", 2);
            if (this.textCodigoCentroCusto.isFocusable()) {
                this.textCodigoCentroCusto.grabFocus();
            }
            return;
        }
        if (!(Funcoes.textoVazio(this.textCodigoCentroCusto.getText()) || Funcoes.textoVazio(this.textDescricaoCentroCusto.getText()) || this.textDescricaoCentroCusto.getText().equalsIgnoreCase("N\u00e3o cadastrado") || Funcoes.textoVazio(this.textPercentual.getText()))) {
            for (CentroCustoPlanoContaBean centro : this.centrosCusto) {
                if (centro.getCentroCusto().getReduzido() != Integer.parseInt(this.textCodigoCentroCusto.getText())) continue;
                if (!centro.isRemover()) {
                    Funcoes.mensagem(this, "Centro de custo j\u00e1 cadastrado", 2);
                    return;
                }
                centroCusto = centro;
                centroCusto.setRemover(false);
                centroCusto.setAlterar(true);
                centroCusto.setPercentual(Double.valueOf(Funcoes.limpaDecimal(this.textPercentual.getText())));
            }
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            if (centroCusto == null) {
                CentroCustoVO cc = null;
                try {
                    cc = (CentroCustoVO)this.centroCustoService.getVO(Variaveis.filialPadrao, this.textCodigoCentroCusto.getText());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:737");
                }
                int sP = cc == null ? -1 : cc.getConta().split("\\.").length;
                int sM = ParametrosGerais.getMascaraCentroCusto().split("\\.").length;
                if (sP != sM) {
                    Funcoes.mensagem(this, "Somente centros de custo do \u00faltimo n\u00edvel podem ser adicionados", 2);
                    return;
                }
                if (cc != null && cc.getOperacao() == null) {
                    Funcoes.mensagem(this, "O tipo de opera\u00e7\u00e3o do Centro de Custo: \"" + cc.getDescricao() + "\"\nn\u00e3o foi configurada.\nConfigure o centro de custo antes de us\u00e1-lo.", 2);
                    return;
                }
                if (cc != null && !Tipos.tipoOperacao(cc.getOperacao()).equalsIgnoreCase(this.comboTipoOperacao.getSelectedItem().toString())) {
                    Funcoes.mensagem(this, "O tipo de opera\u00e7\u00e3o do Centro de Custo: \"" + cc.getDescricao() + "\"\n\u00e9 diferente do tipo de Opera\u00e7\u00e3o configurada para o Plano de Contas.", 2);
                    if (this.textCodigoCentroCusto.isFocusable()) {
                        this.textCodigoCentroCusto.selectAll();
                        this.textCodigoCentroCusto.grabFocus();
                    }
                    return;
                }
                centroCusto = new CentroCustoPlanoContaBean();
                centroCusto.setFilial(filial);
                centroCusto.setCentroCusto(cc);
                centroCusto.setPercentual(Double.valueOf(Funcoes.limpaDecimal(this.textPercentual.getText())));
                centroCusto.setInserir(true);
                this.centrosCusto.add(centroCusto);
            }
            this.limparCentrosCusto();
            this.popularCentrosCusto();
        }
        this.textCodigoCentroCusto.setText("");
        this.textDescricaoCentroCusto.setText("");
        this.textPercentual.setText("");
        ScreenUtil.requisitarFoco(this.textCodigoCentroCusto);
    }

    public void removerCentroCusto() {
        if (this.tableCentroCusto.getSelectedRowCount() > 0 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            int row = this.tableCentroCusto.getRowSorter().convertRowIndexToModel(this.tableCentroCusto.getSelectedRow());
            Integer ctro = (Integer)this.modelCentroCusto.getValueAt(row, 0);
            for (CentroCustoPlanoContaBean centro : this.centrosCusto) {
                if (ctro.intValue() != centro.getCentroCusto().getReduzido().intValue()) continue;
                centro.setRemover(true);
                this.limparCentrosCusto();
                this.popularCentrosCusto();
            }
        }
    }

    private void popularCentrosCusto() {
        for (CentroCustoPlanoContaBean centro : this.centrosCusto) {
            if (centro.isRemover()) continue;
            this.modelCentroCusto.addRow(new Object[]{centro.getCentroCusto().getReduzido(), centro.getCentroCusto().getDescricao(), centro.getCentroCusto().getConta(), Funcoes.formataDecimal(centro.getPercentual())});
        }
    }

    private void buscaCentroCusto(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoCentroCusto.setText("");
            this.textDescricaoCentroCusto.setText("");
            return;
        }
        try {
            CentroCustoVO centro = (CentroCustoVO)this.centroCustoService.getVO(Variaveis.filialPadrao, codigo);
            if (centro != null) {
                this.textCodigoCentroCusto.setText(centro.getReduzido().toString());
                this.textDescricaoCentroCusto.setText(centro.getDescricao());
            } else {
                this.textDescricaoCentroCusto.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:778");
        }
    }

    private void buscaCentroCusto() {
        try {
            this.textCodigoCentroCusto.setText("");
            this.textDescricaoCentroCusto.setText("");
            CentroCustoVO centro = (CentroCustoVO)this.centroCustoService.pesquisaVO(this.getTopLevelAncestor(), new CentroCustoVO(), "Pesquisando centros de custo", true);
            if (centro != null) {
                this.textCodigoCentroCusto.setText(centro.getReduzido().toString());
                this.textDescricaoCentroCusto.setText(centro.getDescricao());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PlanoConta:790");
        }
    }

    private boolean validaUltimoNivel() {
        int sM;
        int sP;
        String conta = this.textContaPai.getText();
        if (!Funcoes.textoVazio(conta)) {
            conta = conta + ".";
        }
        return (sP = (conta = conta + this.textConta.getText()).split("\\.").length) == (sM = ParametrosGerais.getMascaraPlanoConta().split("\\.").length);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((PlanoContaBean)bean).getReduzido().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:86");
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "plc_reduzido";
    }
}

