/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DialogoFiltroConvenio;
import jalis.laboratorio.cadastro.FiliaisConvenios;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class PesquisaFaturaPorFilial
extends AbstractDialogoOKCancelar {
    JLabel labelFiliais = new JLabel("Filial:");
    TTextField txtCodFilial = new TTextField(5, 1);
    JButton buscaFilial = new JButton();
    TTextField txtDescFilial = new TTextField();
    JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    TTextField txtCodConvenioFilial = new TTextField(5, 1);
    JButton bBuscaConvenioFilial = new JButton();
    JButton buscaSelecionadaConvenio = ComponenteFactory.novoJButton("+", this);
    TTextField txtDescConvenioFilial = new TTextField();
    JButton bOKFilial = new JButton("OK");
    ModeloGridTable modeloFilial = new ModeloGridTable(new String[]{"Filial", "Descri\u00e7\u00e3o", "Conv\u00eanio", "Fantasia"});
    JTable tableFilial = new JTable(this.modeloFilial);
    JScrollPane scrollFilial = new JScrollPane(this.tableFilial);
    private String filtroFiltro = null;
    private Map<String, String> convenioCodigoDescricao = new HashMap<String, String>();
    private static final int COLUNA_CODIGO_FILIAL = 0;
    private static final int COLUNA_DESCRICAO_FILIAL = 1;
    private static final int COLUNA_CODIGO_CONVENIO = 2;
    private static final int COLUNA_DESCRICAO_CONVENIO = 3;
    private int linhaTableFilial = -1;
    private String codigoConvenioAtual = "";

    public static PesquisaFaturaPorFilial novaInstancia(Object owner) {
        return owner instanceof Frame ? new PesquisaFaturaPorFilial((Frame)owner) : new PesquisaFaturaPorFilial((Dialog)owner);
    }

    public PesquisaFaturaPorFilial(Frame owner) {
        super(owner, "Filiais para faturar");
        this.montaTela();
        ScreenUtil.requisitarFoco(ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F") ? this.txtCodConvenioFilial : this.txtCodFilial);
    }

    public PesquisaFaturaPorFilial(Dialog owner) {
        super(owner, "Filiais para faturar");
        this.montaTela();
        ScreenUtil.requisitarFoco(ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F") ? this.txtCodConvenioFilial : this.txtCodFilial);
    }

    public void setCodigoConvenioAtual(String codigo) {
        this.codigoConvenioAtual = codigo;
        if (Funcoes.textoVazio(codigo)) {
            this.buscaSelecionadaConvenio.setEnabled(false);
        }
    }

    public void limparFiliais() {
        this.modeloFilial.clear();
    }

    public void adicionaFiliais(List<FiliaisConvenios> f) {
        for (FiliaisConvenios c : f) {
            this.modeloFilial.addLine(new String[]{c.codigoFilial, c.descricaoFilial, c.codigoConvenio, c.descricaoConvenio});
        }
    }

    public List<FiliaisConvenios> getFiliais() {
        ArrayList<FiliaisConvenios> retorno = new ArrayList<FiliaisConvenios>();
        for (int i = 0; i < this.modeloFilial.getRowCount(); ++i) {
            retorno.add(new FiliaisConvenios(this.modeloFilial.getValueAt(i, 0).toString(), this.modeloFilial.getValueAt(i, 1).toString(), this.modeloFilial.getValueAt(i, 2).toString(), this.modeloFilial.getValueAt(i, 3).toString()));
        }
        return retorno;
    }

    private void montaTela() {
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        if (!ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F")) {
            panel.add((Component)this.labelFiliais, c);
            ++c.gridx;
            this.txtCodFilial.setPreferredSize(new Dimension(49, 20));
            this.txtCodFilial.setMinimumSize(new Dimension(49, 20));
            panel.add((Component)this.txtCodFilial, c);
            ++c.gridx;
            this.buscaFilial.setPreferredSize(new Dimension(20, 20));
            this.buscaFilial.setMinimumSize(new Dimension(20, 20));
            ++c.gridx;
            Funcoes.imagemPesquisa(this.buscaFilial);
            this.buscaFilial.setFocusable(false);
            panel.add((Component)this.buscaFilial, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            this.txtDescFilial.setPreferredSize(new Dimension(20, 20));
            this.txtDescFilial.setMinimumSize(new Dimension(20, 20));
            this.txtDescFilial.setEditable(false);
            this.txtDescFilial.setFocusable(false);
            panel.add((Component)this.txtDescFilial, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            c.insets = new Insets(1, 20, 0, 0);
        } else {
            this.txtCodFilial.setText(Variaveis.filialPadrao);
        }
        panel.add((Component)this.labelConvenio, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        this.txtCodConvenioFilial.setPreferredSize(new Dimension(69, 20));
        this.txtCodConvenioFilial.setMinimumSize(new Dimension(69, 20));
        panel.add((Component)this.txtCodConvenioFilial, c);
        ++c.gridx;
        this.bBuscaConvenioFilial.setPreferredSize(new Dimension(20, 20));
        this.bBuscaConvenioFilial.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.bBuscaConvenioFilial);
        this.bBuscaConvenioFilial.setFocusable(false);
        panel.add((Component)this.bBuscaConvenioFilial, c);
        this.montaButtonSelecionarConvenios(panel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.txtDescConvenioFilial.setPreferredSize(new Dimension(20, 20));
        this.txtDescConvenioFilial.setMinimumSize(new Dimension(20, 20));
        this.txtDescConvenioFilial.setEditable(false);
        this.txtDescConvenioFilial.setFocusable(false);
        panel.add((Component)this.txtDescConvenioFilial, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.bOKFilial.setPreferredSize(new Dimension(40, 20));
        this.bOKFilial.setMinimumSize(new Dimension(40, 20));
        this.bOKFilial.setMargin(new Insets(0, 0, 0, 0));
        c.insets = new Insets(1, 1, 0, 1);
        this.bOKFilial.setMnemonic('K');
        panel.add((Component)this.bOKFilial, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 11;
        c.insets = new Insets(1, 1, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scrollFilial, c);
        this.modeloFilial.setColumnSize(new int[]{70, 0, 70, 0}, this.tableFilial);
        this.setSize(600, 300);
        this.setResizable(false);
        this.tableFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PesquisaFaturaPorFilial.this.tableFilial.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(PesquisaFaturaPorFilial.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    PesquisaFaturaPorFilial.this.modeloFilial.removeLine(PesquisaFaturaPorFilial.this.tableFilial.getSelectedRow());
                } else if (PesquisaFaturaPorFilial.this.tableFilial.getSelectedRow() > -1 && e.getKeyCode() == 32) {
                    PesquisaFaturaPorFilial.this.editaTableFilial(PesquisaFaturaPorFilial.this.tableFilial.getSelectedRow());
                }
            }
        });
        this.tableFilial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PesquisaFaturaPorFilial.this.tableFilial.getSelectedRow() > -1) {
                    PesquisaFaturaPorFilial.this.editaTableFilial(PesquisaFaturaPorFilial.this.tableFilial.getSelectedRow());
                }
            }
        });
        this.bOKFilial.addActionListener(action -> {
            if (this.convenioCodigoDescricao != null && !this.convenioCodigoDescricao.isEmpty()) {
                for (Map.Entry<String, String> entry : this.convenioCodigoDescricao.entrySet()) {
                    this.adicionaFilialConvenio(entry.getKey(), entry.getValue());
                }
                if (!ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F")) {
                    this.txtCodFilial.setText("");
                    this.txtDescFilial.setText("");
                }
                this.limpaCampos();
            } else if (!Funcoes.textoVazio(this.txtCodConvenioFilial.getText())) {
                this.adicionaFilialConvenio(this.txtCodConvenioFilial.getText(), this.txtDescConvenioFilial.getText());
                if (!ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F")) {
                    this.txtCodFilial.setText("");
                    this.txtDescFilial.setText("");
                }
                this.limpaCampos();
            }
            ScreenUtil.requisitarFoco(!ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F") ? this.txtCodFilial : this.txtCodConvenioFilial);
        });
        this.buscaFilial.addActionListener(action -> this.buscaFilial());
        this.bBuscaConvenioFilial.addActionListener(action -> this.buscaConvenioFilial());
        this.txtCodFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(PesquisaFaturaPorFilial.this.txtCodFilial.getText())) {
                    try {
                        StringBuilder buf = new StringBuilder("fil_codigo = ");
                        buf.append(PesquisaFaturaPorFilial.this.txtCodFilial.getText());
                        PesquisaFaturaPorFilial.this.txtDescFilial.setText(DBUtil.getDescricao("select fil_descricao from filiais_postocoleta", buf.toString(), "fil_descricao"));
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(PesquisaFaturaPorFilial.this, sqlex.getMessage(), sqlex.getStackTrace(), "FaturaPorFilial");
                    }
                }
            }
        });
        this.txtCodConvenioFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(PesquisaFaturaPorFilial.this.txtCodFilial.getText()) && !Funcoes.textoVazio(PesquisaFaturaPorFilial.this.txtCodConvenioFilial.getText())) {
                    try {
                        StringBuilder buf = new StringBuilder();
                        buf.append(" fil_codigo = ").append(PesquisaFaturaPorFilial.this.txtCodFilial.getText());
                        buf.append(" and con_codigo = ").append(PesquisaFaturaPorFilial.this.txtCodConvenioFilial.getText());
                        PesquisaFaturaPorFilial.this.txtDescConvenioFilial.setText(DBUtil.getDescricao("select con_fantasia from convenios", buf.toString(), "con_fantasia"));
                        PesquisaFaturaPorFilial.this.filtroFiltro = null;
                        PesquisaFaturaPorFilial.this.convenioCodigoDescricao = new HashMap();
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(PesquisaFaturaPorFilial.this, sqlex.getMessage(), sqlex.getStackTrace(), "FaturaPorFilial");
                    }
                }
            }
        });
        this.txtCodFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PesquisaFaturaPorFilial.this.buscaFilial();
                }
            }
        });
        this.txtCodConvenioFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PesquisaFaturaPorFilial.this.buscaConvenioFilial();
                }
            }
        });
    }

    private void montaButtonSelecionarConvenios(JPanel panel, GridBagConstraints c) {
        c.insets = new Insets(1, 0, 0, 0);
        this.buscaSelecionadaConvenio.setPreferredSize(new Dimension(20, 20));
        this.buscaSelecionadaConvenio.setMinimumSize(new Dimension(20, 20));
        ++c.gridx;
        this.buscaSelecionadaConvenio.setForeground(new Color(255, 103, 1));
        this.buscaSelecionadaConvenio.setFocusable(false);
        panel.add((Component)this.buscaSelecionadaConvenio, c);
        this.buscaSelecionadaConvenio.addActionListener(action -> {
            DialogoFiltroConvenio filtro;
            if (!Funcoes.textoVazio(this.txtCodFilial.getText()) && (filtro = DialogoFiltroConvenio.novaInstancia(Laboratorio.getInstancia(), this.filtroFiltro, this.txtCodFilial.getText())).ok()) {
                this.txtCodConvenioFilial.setText("");
                this.txtDescConvenioFilial.setText("");
                this.filtroFiltro = filtro.getConvenioSelecionadas();
                this.txtDescConvenioFilial.setText(this.filtroFiltro);
                this.convenioCodigoDescricao = filtro.getMapConvenioCodigoDescricao();
            }
        });
    }

    private void limpaCampos() {
        this.convenioCodigoDescricao.clear();
        this.filtroFiltro = null;
        this.txtCodConvenioFilial.setText("");
        this.txtDescConvenioFilial.setText("");
    }

    private void adicionaFilialConvenio(String conCodigo, String conDescricao) {
        if (ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F")) {
            this.txtCodFilial.setText(Variaveis.filialPadrao);
            this.txtDescFilial.setText(Variaveis.descricaoFilialPadrao);
        }
        if (this.txtCodFilial.getText().trim().length() > 0 && conCodigo.trim().length() > 0 && !this.txtDescFilial.getText().equals("N\u00e3o cadastrado") && !conDescricao.equals("N\u00e3o cadastrado")) {
            if (this.txtCodFilial.getText().equals(String.valueOf(Variaveis.filialPadrao)) && conCodigo.equals(this.codigoConvenioAtual)) {
                Funcoes.mensagem(this, "O conv\u00eanio n\u00e3o pode faturar ele mesmo", 1);
            } else if (!this.procuraFilial(this.txtCodFilial.getText(), conCodigo)) {
                if (this.linhaTableFilial > -1) {
                    this.modeloFilial.setValueAt(this.txtCodFilial.getText(), this.linhaTableFilial, 0);
                    this.modeloFilial.setValueAt(this.txtDescFilial.getText(), this.linhaTableFilial, 1);
                    this.modeloFilial.setValueAt(conCodigo, this.linhaTableFilial, 2);
                    this.modeloFilial.setValueAt(conDescricao, this.linhaTableFilial, 3);
                    this.linhaTableFilial = -1;
                } else {
                    this.modeloFilial.addLine(new String[]{this.txtCodFilial.getText(), this.txtDescFilial.getText(), conCodigo, conDescricao});
                }
            }
        }
    }

    private boolean procuraFilial(String filial, String convenio) {
        boolean retorno = false;
        for (int i = 0; i < this.modeloFilial.getRowCount(); ++i) {
            boolean bl = retorno = ((String)this.modeloFilial.getValueAt(i, 0)).equals(filial) && ((String)this.modeloFilial.getValueAt(i, 2)).equals(convenio);
            if (retorno) break;
        }
        return retorno;
    }

    private void editaTableFilial(int linha) {
        this.linhaTableFilial = linha;
        this.txtCodFilial.setText(this.modeloFilial.getValueAt(this.linhaTableFilial, 0).toString());
        this.txtDescFilial.setText(this.modeloFilial.getValueAt(this.linhaTableFilial, 1).toString());
        this.txtCodConvenioFilial.setText(this.modeloFilial.getValueAt(this.linhaTableFilial, 2).toString());
        this.txtDescConvenioFilial.setText(this.modeloFilial.getValueAt(this.linhaTableFilial, 3).toString());
        this.txtCodFilial.grabFocus();
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(this, true);
        if (resultado != null) {
            this.txtCodFilial.setText(resultado.get("fil_codigo").toString());
        }
        this.txtCodFilial.requestFocus();
    }

    private void buscaConvenioFilial() {
        if (this.txtCodFilial.getText().trim().length() > 0) {
            Hashtable resultado = Pesquisas.convenio(this, this.txtCodFilial.getText(), false, true);
            if (resultado != null) {
                this.txtCodConvenioFilial.setText(resultado.get("con_codigo").toString());
            }
            this.txtCodConvenioFilial.requestFocus();
        }
    }
}

