/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.DadosPatrimonio;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Patrimonio
extends AbstractDialogoOKCancelar
implements ActionListener {
    private TTextField textPatrimonio = new TTextField(13, 3);
    private TTextField textSerie = new TTextField(2, 3);
    private TTextField textNotaFiscal = new TTextField(8, 1);
    private JComboBox comboSetor = new JComboBox();
    private JButton buttonOKPatrimonio = ComponenteFactory.novoJButton("OK", 'K', this);
    private ModeloGridTable modelo = null;
    private JTable tabela = null;
    private JLabel labelQtdeRestante = new JLabel("Qtde restante:");
    private JLabel labelValorQtdeRestante = new JLabel();
    private JLabel labelQtdeTotal = new JLabel("Qtde total:");
    private JLabel labelValorQtdeTotal = new JLabel();
    private ArrayList<DadosPatrimonio> excluidos = new ArrayList();
    private static boolean isSelecionando = false;

    public static Patrimonio novaInstancia(Object owner, boolean isSelecionandoPatrimonio) {
        isSelecionando = isSelecionandoPatrimonio;
        if (owner instanceof Frame) {
            return new Patrimonio((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new Patrimonio((Dialog)owner);
        }
        return null;
    }

    public Patrimonio(Frame owner) {
        super(owner, "Patrim\u00f4nios");
        this.montaTela();
    }

    public Patrimonio(Dialog owner) {
        super(owner, "Patrim\u00f4nios");
        this.montaTela();
    }

    private void montaTela() {
        this.preencheSetores();
        this.setSize(new Dimension(510, 300));
        this.setLocationRelativeTo(this.getParent());
        if (isSelecionando) {
            this.modelo = new ModeloGridTable(new String[]{"Patrim\u00f4nio", "S\u00e9rie", "Nota Fiscal", "Setor", "Sel", "Pode Alterar"}){

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return columnIndex == Patrimonio.this.modelo.findColumn("Sel");
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    if (columnIndex == Patrimonio.this.modelo.findColumn("Sel")) {
                        return Boolean.class;
                    }
                    return Object.class;
                }

                @Override
                public void fireTableStructureChanged() {
                    super.fireTableStructureChanged();
                    try {
                        if (Patrimonio.this.tabela != null) {
                            Patrimonio.this.tabela.removeColumn(Patrimonio.this.tabela.getColumn("Pode Alterar"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.tabela = new JTable(this.modelo);
            this.tabela.getTableHeader().addMouseListener(this.modelo);
            this.modelo.setColumnSize(new int[]{100, 80, 90, 0, 30, 0}, this.tabela);
            this.tabela.removeColumn(this.tabela.getColumn("Pode Alterar"));
        } else {
            this.modelo = new ModeloGridTable(new String[]{"Patrim\u00f4nio", "S\u00e9rie", "Nota Fiscal", "Setor", "Pode Alterar", "Sel"}){

                @Override
                public void fireTableStructureChanged() {
                    super.fireTableStructureChanged();
                    try {
                        if (Patrimonio.this.tabela != null) {
                            Patrimonio.this.tabela.removeColumn(Patrimonio.this.tabela.getColumn("Pode Alterar"));
                            Patrimonio.this.tabela.removeColumn(Patrimonio.this.tabela.getColumn("Sel"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.tabela = new JTable(this.modelo);
            this.tabela.getTableHeader().addMouseListener(this.modelo);
            this.modelo.setColumnSize(new int[]{100, 80, 90, 0, 0, 0}, this.tabela);
            this.tabela.removeColumn(this.tabela.getColumn("Pode Alterar"));
            this.tabela.removeColumn(this.tabela.getColumn("Sel"));
        }
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Patrimonio.this.tabela.getSelectedRow() > -1) {
                    int linha;
                    if (e.getKeyCode() == 127 && Funcoes.mensagem(Patrimonio.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        linha = Patrimonio.this.tabela.getSelectedRow();
                        if (!((Boolean)Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Pode Alterar"))).booleanValue()) {
                            Funcoes.mensagem(Patrimonio.this, "N\u00e3o \u00e9 poss\u00edvel remover o patrim\u00f4nio, pois, ele est\u00e1 sendo utilizado.", 2);
                            return;
                        }
                        SetorVO vo = Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Setor")) != null && Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Setor")) instanceof SetorVO ? (SetorVO)Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Setor")) : null;
                        DadosPatrimonio p = new DadosPatrimonio(null, Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Patrim\u00f4nio")).toString(), Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("S\u00e9rie")).toString(), Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Nota Fiscal")).toString(), vo, (Boolean)Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Pode Alterar")), (Boolean)Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Sel")));
                        Patrimonio.this.excluidos.add(p);
                        Patrimonio.this.modelo.removeLine(linha);
                        if (Patrimonio.this.tabela.getRowCount() > 0) {
                            Patrimonio.this.tabela.grabFocus();
                        } else {
                            Patrimonio.this.textPatrimonio.grabFocus();
                        }
                    } else if (e.getKeyCode() == 32) {
                        linha = Patrimonio.this.tabela.getSelectedRow();
                        Patrimonio.this.textPatrimonio.setText(Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Patrim\u00f4nio")).toString());
                        Patrimonio.this.textSerie.setText(Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("S\u00e9rie")).toString());
                        Patrimonio.this.textNotaFiscal.setText(Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Nota Fiscal")).toString());
                        SetorVO vo = (SetorVO)Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Setor"));
                        Patrimonio.this.comboSetor.setSelectedItem("");
                        for (int i = 0; i < Patrimonio.this.comboSetor.getItemCount(); ++i) {
                            if (!(Patrimonio.this.comboSetor.getItemAt(i) instanceof SetorVO) || ((SetorVO)Patrimonio.this.comboSetor.getItemAt(i)).getCodigo().intValue() != vo.getCodigo().intValue()) continue;
                            Patrimonio.this.comboSetor.setSelectedIndex(i);
                            break;
                        }
                        if (!isSelecionando) {
                            ScreenUtil.requisitarFoco(Patrimonio.this.textSerie);
                        } else {
                            ScreenUtil.requisitarFoco(Patrimonio.this.comboSetor);
                        }
                    }
                    Double valor = 0.0;
                    if (!Funcoes.textoVazio(Patrimonio.this.labelValorQtdeRestante.getText())) {
                        valor = Double.parseDouble(Patrimonio.this.labelValorQtdeRestante.getText());
                    }
                    if (!Funcoes.textoVazio(Patrimonio.this.labelValorQtdeTotal.getText()) && (double)Patrimonio.this.modelo.getRowCount() <= Double.parseDouble(Patrimonio.this.labelValorQtdeTotal.getText())) {
                        Patrimonio.this.labelValorQtdeRestante.setText(String.valueOf(valor + 1.0));
                    }
                }
            }
        });
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int linha = Patrimonio.this.tabela.getSelectedRow();
                    Patrimonio.this.textPatrimonio.setText(Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Patrim\u00f4nio")).toString());
                    Patrimonio.this.textSerie.setText(Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("S\u00e9rie")).toString());
                    Patrimonio.this.textNotaFiscal.setText(Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Nota Fiscal")).toString());
                    SetorVO vo = (SetorVO)Patrimonio.this.modelo.getValueAt(linha, Patrimonio.this.modelo.findColumn("Setor"));
                    Patrimonio.this.comboSetor.setSelectedItem("");
                    for (int i = 0; i < Patrimonio.this.comboSetor.getItemCount(); ++i) {
                        if (!(Patrimonio.this.comboSetor.getItemAt(i) instanceof SetorVO) || ((SetorVO)Patrimonio.this.comboSetor.getItemAt(i)).getCodigo().intValue() != vo.getCodigo().intValue()) continue;
                        Patrimonio.this.comboSetor.setSelectedIndex(i);
                        break;
                    }
                    if (!isSelecionando) {
                        ScreenUtil.requisitarFoco(Patrimonio.this.textSerie);
                    } else {
                        ScreenUtil.requisitarFoco(Patrimonio.this.comboSetor);
                    }
                }
            }
        });
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        JLabel labelPatrimonio = new JLabel("Patrim\u00f4nio");
        labelPatrimonio.setDisplayedMnemonic('P');
        labelPatrimonio.setLabelFor(this.textPatrimonio);
        panel.add((Component)labelPatrimonio, c);
        ++c.gridx;
        JLabel labelSerie = new JLabel("S\u00e9rie");
        labelSerie.setDisplayedMnemonic('S');
        labelSerie.setLabelFor(this.textSerie);
        panel.add((Component)labelSerie, c);
        ++c.gridx;
        JLabel labelNota = new JLabel("Nota Fiscal");
        labelNota.setDisplayedMnemonic('N');
        labelNota.setLabelFor(this.textNotaFiscal);
        panel.add((Component)labelNota, c);
        ++c.gridx;
        JLabel labelSetor = new JLabel("Setor");
        labelSetor.setDisplayedMnemonic('e');
        labelSetor.setLabelFor(this.comboSetor);
        panel.add((Component)labelSetor, c);
        c.gridx = 0;
        ++c.gridy;
        this.textPatrimonio.setPreferredSize(new Dimension(100, 20));
        this.textPatrimonio.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.textPatrimonio, c);
        ++c.gridx;
        this.textSerie.setPreferredSize(new Dimension(80, 20));
        this.textSerie.setMinimumSize(new Dimension(80, 20));
        panel.add((Component)this.textSerie, c);
        ++c.gridx;
        this.textNotaFiscal.setPreferredSize(new Dimension(80, 20));
        this.textNotaFiscal.setMinimumSize(new Dimension(80, 20));
        panel.add((Component)this.textNotaFiscal, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.comboSetor.setPreferredSize(new Dimension(120, 20));
        this.comboSetor.setMinimumSize(new Dimension(120, 20));
        panel.add((Component)this.comboSetor, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKPatrimonio.setPreferredSize(new Dimension(40, 20));
        this.buttonOKPatrimonio.setMinimumSize(new Dimension(40, 20));
        this.buttonOKPatrimonio.setMaximumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKPatrimonio, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane scroll = new JScrollPane(this.tabela);
        scroll.setPreferredSize(new Dimension(10, 20));
        panel.add((Component)scroll, c);
        this.controlaCampos();
        try {
            this.modelo.ordenarColunaSemTrocarSentido(this.modelo.findColumn("Patrim\u00f4nio"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isSelecionando) {
            ScreenUtil.requisitarFoco(this.textPatrimonio);
        } else {
            ScreenUtil.requisitarFoco(this.tabela);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        ScreenUtil.requisitarFoco(this.textPatrimonio);
        super.setVisible(visible);
    }

    private void controlaCampos() {
        this.textPatrimonio.setEnabled(!isSelecionando);
        this.textNotaFiscal.setEnabled(!isSelecionando);
        this.textSerie.setEnabled(!isSelecionando);
    }

    @Override
    public boolean acaoOk() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKPatrimonio) {
            this.adicionarPatrimonio();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarPatrimonio() {
        boolean excluido = false;
        for (int i = 0; i < this.excluidos.size(); ++i) {
            DadosPatrimonio dados;
            if (this.excluidos.get(i) == null || !(dados = this.excluidos.get(i)).getPatrimonio().equalsIgnoreCase(this.textPatrimonio.getText())) continue;
            excluido = true;
            this.excluidos.set(i, null);
            break;
        }
        if (this.textPatrimonio.getText().isEmpty()) {
            Funcoes.mensagem(this, "O n\u00famero do patrim\u00f4nio deve ser informado.", 2);
            if (this.textPatrimonio.isEnabled() && this.textPatrimonio.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textPatrimonio);
            }
            return;
        }
        if (this.comboSetor.getSelectedIndex() == 0) {
            Funcoes.mensagem(this, "O setor deve ser selecionado.", 2);
            if (this.comboSetor.isEnabled() && this.comboSetor.isFocusable()) {
                ScreenUtil.requisitarFoco(this.comboSetor);
            }
            return;
        }
        if (Funcoes.textoVazio(this.textNotaFiscal)) {
            Funcoes.mensagem(this, "N\u00famero da nota fiscal deve ser informado!", 2);
            ScreenUtil.requisitarFoco(this.textNotaFiscal);
            return;
        }
        try {
            if (new MaterialPatrimonioService().patrimonioJaUsado(Variaveis.filialPadrao, this.textPatrimonio.getText()) && !isSelecionando) {
                Funcoes.mensagem(this, "O c\u00f3digo do patrim\u00f4nio informado j\u00e1 foi utilizado.", 2);
                if (this.textPatrimonio.isEnabled() && this.textPatrimonio.isFocusable()) {
                    ScreenUtil.requisitarFoco(this.textPatrimonio);
                }
                return;
            }
        }
        catch (SQLException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel verificar se o patrim\u00f4nio est\u00e1 dispon\u00edvel.", 2);
            return;
        }
        int pos = this.modelo.localizar(this.modelo.findColumn("Patrim\u00f4nio"), this.textPatrimonio.getText());
        if (pos < 0 || excluido) {
            if (!isSelecionando) {
                this.modelo.addLine(new Object[]{this.textPatrimonio.getText(), this.textSerie.getText(), this.textNotaFiscal.getText(), this.comboSetor.getSelectedItem(), true, true});
                Double valor = null;
                if (!Funcoes.textoVazio(this.labelValorQtdeRestante.getText())) {
                    valor = Double.parseDouble(this.labelValorQtdeRestante.getText()) - 1.0;
                }
                if (valor != null) {
                    this.labelValorQtdeRestante.setText(valor.toString());
                }
            }
        } else {
            this.modelo.setValueAt(this.textSerie.getText(), pos, this.modelo.findColumn("S\u00e9rie"));
            this.modelo.setValueAt(this.textNotaFiscal.getText(), pos, this.modelo.findColumn("Nota Fiscal"));
            this.modelo.setValueAt(this.comboSetor.getSelectedItem(), pos, this.modelo.findColumn("Setor"));
        }
        this.textPatrimonio.clear();
        this.textSerie.clear();
        this.textNotaFiscal.clear();
        if (!isSelecionando) {
            ScreenUtil.requisitarFoco(this.textPatrimonio);
        } else {
            ScreenUtil.requisitarFoco(this.comboSetor);
        }
    }

    private void preencheSetores() {
        SetorService service = new SetorService();
        try {
            Set setores = service.loadVO(" where fil_codigo = " + Variaveis.filialPadrao);
            ArrayList set = new ArrayList(setores);
            Collections.sort(set, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1 instanceof SetorVO && o2 instanceof SetorVO ? ((SetorVO)o1).getDescricao().compareToIgnoreCase(((SetorVO)o2).getDescricao()) : 0;
                }
            });
            this.comboSetor.removeAllItems();
            this.comboSetor.addItem("");
            for (SetorVO s : set) {
                this.comboSetor.addItem(s);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Patrimonio: 894");
        }
    }

    public void setPatrimonios(ArrayList<DadosPatrimonio> patrimonios) {
        this.modelo.clear();
        if (patrimonios != null) {
            for (DadosPatrimonio p : patrimonios) {
                if (!isSelecionando) {
                    this.modelo.addLine(new Object[]{p.getPatrimonio(), p.getSerie(), p.getNotaFiscal(), p.getSetor(), p.isPodeAlterar(), false});
                    continue;
                }
                this.modelo.addLine(new Object[]{p.getPatrimonio(), p.getSerie(), p.getNotaFiscal(), p.getSetor(), p.isSelecionado(), p.isPodeAlterar()});
            }
            try {
                this.modelo.ordenarColunaSemTrocarSentido(this.modelo.findColumn("Patrim\u00f4nio"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tabela.getSelectionModel().setSelectionInterval(0, 0);
            ScreenUtil.requisitarFoco(this.tabela);
        }
    }

    public ArrayList<DadosPatrimonio> getPatrimonios() {
        ArrayList<DadosPatrimonio> retorno = new ArrayList<DadosPatrimonio>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            SetorVO vo = this.modelo.getValueAt(i, this.modelo.findColumn("Setor")) != null && this.modelo.getValueAt(i, this.modelo.findColumn("Setor")) instanceof SetorVO ? (SetorVO)this.modelo.getValueAt(i, this.modelo.findColumn("Setor")) : null;
            DadosPatrimonio p = new DadosPatrimonio(null, this.modelo.getValueAt(i, this.modelo.findColumn("Patrim\u00f4nio")).toString(), (String)this.modelo.getValueAt(i, this.modelo.findColumn("S\u00e9rie")), (String)this.modelo.getValueAt(i, this.modelo.findColumn("Nota Fiscal")), vo, (Boolean)this.modelo.getValueAt(i, this.modelo.findColumn("Pode Alterar")), (Boolean)this.modelo.getValueAt(i, this.modelo.findColumn("Sel")));
            retorno.add(p);
        }
        return retorno;
    }

    public void setNotaFiscalEntrada(NotaFiscalMaterialBean notaMat) {
        this.labelValorQtdeTotal.setText(notaMat.getQuantidade().toString());
        this.labelValorQtdeRestante.setText(notaMat.getQuantidade().toString());
        this.textNotaFiscal.setText(notaMat.getNotaFiscal().getNumero().toString());
        this.textSerie.setText(notaMat.getNotaFiscal().getSerie().getCodigo());
    }

    public void setQuantidadeRecebida(Double qtde) {
        if (qtde != null && qtde > 0.0) {
            this.labelValorQtdeTotal.setText(qtde.toString());
            this.labelValorQtdeRestante.setText(String.valueOf((double)this.modelo.getRowCount() - qtde));
        } else {
            this.labelValorQtdeRestante.setText("0.0");
        }
    }
}

