/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.cadastro.DocumentoStyledHistorico;
import jalis.laboratorio.cadastro.EditorKitNoWrap;
import jalis.laboratorio.cadastro.Historico;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class PanelEdicao
extends JToolBar
implements ActionListener {
    private JToggleButton buttonNegrito = new JToggleButton("N");
    private JToggleButton buttonItalico = new JToggleButton("I");
    private JToggleButton buttonSublinhado = new JToggleButton("<html><u>S</u></html>");
    private JToggleButton buttonSup = new JToggleButton("Sup");
    private JToggleButton buttonSub = new JToggleButton("Sub");
    private JTextPane editor = null;
    private JTextPane editorAux = null;
    private int maxLength = 0;

    public PanelEdicao(final JTextPane editor, int maxLength) {
        this.setFloatable(false);
        this.editor = editor;
        this.editorAux = editor;
        this.maxLength = maxLength;
        this.buttonNegrito.setFont(new Font(this.buttonNegrito.getFont().getFontName(), 1, 12));
        this.buttonItalico.setFont(new Font(this.buttonItalico.getFont().getFontName(), 2, 12));
        this.buttonSublinhado.setFont(new Font(this.buttonSublinhado.getFont().getFontName(), 0, 12));
        this.buttonSub.setFont(new Font(this.buttonSub.getFont().getFontName(), 0, 12));
        this.buttonSup.setFont(new Font(this.buttonSup.getFont().getFontName(), 0, 12));
        this.buttonNegrito.setPreferredSize(new Dimension(20, 20));
        this.buttonItalico.setPreferredSize(new Dimension(20, 20));
        this.buttonSublinhado.setPreferredSize(new Dimension(20, 20));
        this.buttonSub.setPreferredSize(new Dimension(35, 20));
        this.buttonSup.setPreferredSize(new Dimension(35, 20));
        this.buttonNegrito.setMargin(new Insets(0, 0, 0, 0));
        this.buttonItalico.setMargin(new Insets(0, 0, 0, 0));
        this.buttonSublinhado.setMargin(new Insets(0, 0, 0, 0));
        this.buttonSub.setMargin(new Insets(0, 0, 0, 0));
        this.buttonSup.setMargin(new Insets(0, 0, 0, 0));
        this.buttonNegrito.setOpaque(false);
        this.buttonItalico.setOpaque(true);
        this.buttonNegrito.addActionListener(this);
        this.buttonItalico.addActionListener(this);
        this.buttonSublinhado.addActionListener(this);
        this.buttonSub.addActionListener(this);
        this.buttonSup.addActionListener(this);
        this.buttonNegrito.setFocusable(false);
        this.buttonItalico.setFocusable(false);
        this.buttonSublinhado.setFocusable(false);
        this.buttonSub.setFocusable(false);
        this.buttonSup.setFocusable(false);
        this.add(this.buttonNegrito);
        this.add(this.buttonItalico);
        this.add(this.buttonSublinhado);
        this.add(this.buttonSub);
        this.add(this.buttonSup);
        if (editor != null) {
            editor.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    PanelEdicao.this.buttonNegrito.setSelected(StyleConstants.isBold(editor.getStyledDocument().getCharacterElement(e.getDot()).getAttributes()));
                    PanelEdicao.this.buttonItalico.setSelected(StyleConstants.isItalic(editor.getStyledDocument().getCharacterElement(e.getDot()).getAttributes()));
                    PanelEdicao.this.buttonSublinhado.setSelected(StyleConstants.isUnderline(editor.getStyledDocument().getCharacterElement(e.getDot()).getAttributes()));
                    PanelEdicao.this.buttonSub.setSelected(StyleConstants.isSubscript(editor.getStyledDocument().getCharacterElement(e.getDot()).getAttributes()));
                    PanelEdicao.this.buttonSup.setSelected(StyleConstants.isSuperscript(editor.getStyledDocument().getCharacterElement(e.getDot()).getAttributes()));
                }
            });
        }
        this.setBorder(new TitledBorder(""));
    }

    public void desabilitar() {
        this.buttonNegrito.setEnabled(false);
        this.buttonItalico.setEnabled(false);
        this.buttonSublinhado.setEnabled(false);
        this.buttonSub.setEnabled(false);
        this.buttonSup.setEnabled(false);
    }

    public void habilitar() {
        this.buttonNegrito.setEnabled(true);
        this.buttonItalico.setEnabled(true);
        this.buttonSublinhado.setEnabled(true);
        this.buttonSub.setEnabled(true);
        this.buttonSup.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.editor != null && this.editor.getSelectedText() != null) {
            if (e.getSource() == this.buttonNegrito) {
                this.adicionarRemoverEstilo(StyleConstants.Bold, this.buttonNegrito.isSelected());
            } else if (e.getSource() == this.buttonItalico) {
                this.adicionarRemoverEstilo(StyleConstants.Italic, this.buttonItalico.isSelected());
            } else if (e.getSource() == this.buttonSublinhado) {
                this.adicionarRemoverEstilo(StyleConstants.Underline, this.buttonSublinhado.isSelected());
            } else if (e.getSource() == this.buttonSub) {
                this.adicionarRemoverEstilo(StyleConstants.Subscript, this.buttonSub.isSelected());
                this.adicionarRemoverEstilo(StyleConstants.Superscript, false);
            } else if (e.getSource() == this.buttonSup) {
                this.adicionarRemoverEstilo(StyleConstants.Superscript, this.buttonSup.isSelected());
                this.adicionarRemoverEstilo(StyleConstants.Subscript, false);
            }
        }
        if (e.getSource() == this.buttonSub) {
            this.buttonSup.setSelected(false);
        } else if (e.getSource() == this.buttonSup) {
            this.buttonSub.setSelected(false);
        }
    }

    private void adicionarRemoverEstilo(Object estilo, boolean adicionar) {
        if (adicionar) {
            try {
                String textoAux = Historico.descricao2Texto(this.editor);
                JTextPane textAux = new JTextPane();
                textAux.setEditorKit(new EditorKitNoWrap());
                DocumentoStyledHistorico style = new DocumentoStyledHistorico(textAux);
                style.setMaxLength(this.maxLength);
                textAux.setDocument(style);
                textAux.setText(textoAux);
                SimpleAttributeSet mat = new SimpleAttributeSet();
                mat.addAttribute(estilo, new Boolean(true));
                textAux.getStyledDocument().setCharacterAttributes(this.editor.getSelectionStart(), this.editor.getSelectionEnd() - this.editor.getSelectionStart(), mat, false);
                textoAux = Historico.descricao2Texto(textAux);
                if (this.maxLength > 0 && textoAux.length() < this.maxLength) {
                    this.editor.getStyledDocument().setCharacterAttributes(this.editor.getSelectionStart(), this.editor.getSelectionEnd() - this.editor.getSelectionStart(), mat, false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            for (int i = this.editor.getSelectionStart(); i < this.editor.getSelectionEnd(); ++i) {
                SimpleAttributeSet mat = new SimpleAttributeSet(this.editor.getStyledDocument().getCharacterElement(i).getAttributes());
                mat.removeAttribute(estilo);
                this.editor.getStyledDocument().setCharacterAttributes(i, 1, mat, true);
            }
        }
    }
}

