/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.PaisBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.PaisVO;
import jalis.service.cadastro.auxiliares.PaisService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class Pais
extends FrmCadPadraoBean
implements ActionListener {
    private JLabel jLabelCodigo = new JLabel("C\u00f3digo:");
    private JLabel jLabelFilial = new JLabel("Filial:");
    private JLabel jLabelNome = new JLabel("Nome:");
    private TTextField txtCodigo = new TTextField();
    private TTextField txtFilial = new TTextField();
    private TTextField txtNome = new TTextField(80);
    private PaisService paisService = new PaisService();
    private PaisBean paisBean = new PaisBean();

    public Pais() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel abrir a tela de pa\u00edses.", 1);
        }
    }

    public void jbInit() throws Exception {
        this.setName("Pais");
        this.setLabelDescricao("Cadastro de pa\u00edses");
        this.setLabelFormulario("Cadastro de pa\u00edses");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_bairro.jpg"));
        this.jLabelCodigo.setDisplayedMnemonic('C');
        this.jLabelCodigo.setLabelFor(this.txtCodigo);
        this.jLabelCodigo.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtFilial.setBounds(new Rectangle(0, 0, 0, 0));
        this.txtCodigo.setHorizontalAlignment(4);
        this.txtCodigo.setName("txtCodigo");
        this.txtNome.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtNome.setName("txtNome");
        this.jLabelNome.setBounds(new Rectangle(7, 28, 63, 14));
        this.jLabelNome.setLabelFor(this.txtNome);
        this.jLabelNome.setDisplayedMnemonic('N');
        this.jLabelFilial.setBounds(new Rectangle(0, 0, 0, 0));
        this.jLabelFilial.setLabelFor(this.txtFilial);
        this.jLabelFilial.setDisplayedMnemonic('F');
        this.painelCentral.add((Component)this.jLabelCodigo, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.jLabelNome, null);
        this.painelCentral.add((Component)this.txtNome, null);
        this.painelCentral.add((Component)this.jLabelFilial, null);
        this.painelCentral.add((Component)this.txtFilial, null);
        this.txtFilial.setVisible(false);
        this.txtFilial.setName("txtFilial");
        this.jLabelFilial.setVisible(false);
        this.controlaCampos();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0100400000");
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Pais.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0100400001"));
        this.setModuloEdita(Long.parseLong("0100400002"));
        this.setModuloApaga(Long.parseLong("0100400003"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    protected void controlaCampos() {
        this.txtCodigo.setEnabled(false);
        this.txtFilial.setEnabled(false);
        this.txtNome.setEnabled(this.habilitaDesabilitaCampo());
    }

    @Override
    protected void limparCampos() {
        this.txtCodigo.setText("");
        this.txtFilial.setText("");
        this.txtNome.setText("");
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            PaisVO vo = (PaisVO)this.paisService.pesquisaVO(this.getTopLevelAncestor(), new PaisVO(), "Pesquisando pa\u00edses", false);
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("pai_codigo", vo.getCodigo());
                this.paisBean = (PaisBean)this.paisService.getBean(chaves);
                return this.paisBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        this.paisBean = new PaisBean();
        if (!Funcoes.textoVazio(this.txtCodigo.getText())) {
            this.paisBean.setCodigo(Integer.parseInt(this.txtCodigo.getText()));
        } else {
            this.paisBean.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        }
        this.paisBean.setFilial(filialVO);
        this.paisBean.setNome(this.txtNome.getText());
        return this.paisBean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (this.beanValido(bean)) {
            PaisBean paisBean = (PaisBean)bean;
            this.txtCodigo.setText(paisBean.getCodigo().toString());
            this.txtFilial.setText(paisBean.getFilial().getCodigo().toString());
            this.txtNome.setText(paisBean.getNome());
        }
    }

    private boolean beanValido(AbstractThreadBean bean) {
        return bean != null && bean instanceof PaisBean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaPais();
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtNome)) {
            Funcoes.mensagem(this, "Informe o campo nome.", 5);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            try {
                this.paisBean = (PaisBean)this.getBeanPreenchido();
                if (this.paisBean != null) {
                    this.paisService.gravaAutoCopiaSemCommit(this.paisBean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                    Conexao.arquivaSQL();
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel reverter opera\u00e7\u00e3o ao salvar o pa\u00eds.\n" + e1.getMessage(), e1.getStackTrace());
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar o pa\u00eds.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.txtNome);
    }

    @Override
    public void editar() {
        super.editar();
    }

    @Override
    public void excluir() {
        this.paisBean = (PaisBean)this.pesquisar();
        if (this.paisBean != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Pais.this.preencherCampos(Pais.this.paisBean);
                    if (Funcoes.mensagem(Pais.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            Pais.this.paisService.gravaAutoCopiaSemCommit(Pais.this.paisBean, 2, Variaveis.filialPadrao, Pais.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel excluir.\n" + e.getMessage(), 2);
                        }
                    }
                    Pais.this.limparCampos();
                    Pais.this.paisBean = null;
                }
            });
        }
    }
}

