/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.OrigemNaoConformidadeBean;
import jalis.model.vo.cadastro.OrigemNaoConformidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.OrigemNaoConformidadeService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JLabel;

public class OrigemNaoConformidade
extends FrmCadPadraoBean
implements ActionListener {
    private JLabel labelCodigoOrigem = new JLabel("C\u00f3digo:");
    private JLabel labelDescricaoOrigem = new JLabel("Descri\u00e7\u00e3o:");
    private TTextField textoDescricaoOrigem = new TTextField(100, 3);
    private TTextField textoCodigoOrigem = new TTextField(12);
    private String retornoParaPesquisa;

    public OrigemNaoConformidade() {
        try {
            this.jbInit();
            this.controlaCampos();
            this.service = new OrigemNaoConformidadeService();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textoDescricaoOrigem);
    }

    public void jbInit() throws Exception {
        this.setName("OrigemNaoConformidade");
        this.setLabelFormulario("Origem de n\u00e3o conformidade");
        this.setLabelDescricao("Origem de n\u00e3o conformidade");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_origemnaoconformidade.jpg"));
        this.painelCentral.setLayout(new GridBagLayout());
        this.textoCodigoOrigem.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 0, 0, 1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 17;
        gridBagConstraints.anchor = 17;
        this.painelCentral.add((Component)this.labelCodigoOrigem, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.textoCodigoOrigem.setPreferredSize(new Dimension(80, 20));
        this.textoCodigoOrigem.setName("textoCodigoOrigem");
        this.textoCodigoOrigem.setMinimumSize(new Dimension(80, 20));
        this.painelCentral.add((Component)this.textoCodigoOrigem, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.painelCentral.add((Component)this.labelDescricaoOrigem, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.textoDescricaoOrigem.setPreferredSize(new Dimension(150, 20));
        this.textoDescricaoOrigem.setName("textoDescricaoOrigem");
        this.textoDescricaoOrigem.setMinimumSize(new Dimension(150, 20));
        this.painelCentral.add((Component)this.textoDescricaoOrigem, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)new JLabel(), gridBagConstraints);
        this.setModuloInsere(Long.valueOf("0105200101"));
        this.setModuloEdita(Long.valueOf("0105200102"));
        this.setModuloApaga(Long.valueOf("0105200103"));
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0105200100");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    protected void controlaCampos() {
        this.textoDescricaoOrigem.setEnabled(this.habilitaDesabilitaCampo());
    }

    @Override
    protected void limparCampos() {
        this.textoDescricaoOrigem.setText("");
        this.textoCodigoOrigem.setText("");
        this.textoCodigoOrigem.setEnabled(false);
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return this.service.pesquisaVO(this.getTopLevelAncestor(), new OrigemNaoConformidadeVO(), "Pesquisando origem de n\u00e3o conformidade", false);
    }

    @Override
    public void salvar() {
        OrigemNaoConformidadeBean bean;
        if (this.validaCampos() && (bean = (OrigemNaoConformidadeBean)this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                this.retornoParaPesquisa = bean.getCodigo().toString();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
        OrigemNaoConformidadeBean naoConformidadeBean = new OrigemNaoConformidadeBean();
        if (Funcoes.textoVazio(this.textoCodigoOrigem)) {
            naoConformidadeBean.setCodigo(null);
        } else {
            naoConformidadeBean.setCodigo(Integer.parseInt(this.textoCodigoOrigem.getText()));
        }
        naoConformidadeBean.setDescricao(this.textoDescricaoOrigem.getText());
        naoConformidadeBean.setFilial(filial);
        return naoConformidadeBean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean != null) {
            OrigemNaoConformidadeVO conformidadeBean = (OrigemNaoConformidadeVO)bean;
            this.textoCodigoOrigem.setText(conformidadeBean.getCodigo().toString());
            this.textoDescricaoOrigem.setText(conformidadeBean.getDescricao());
        }
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaOrigemNaoConformidade();
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textoDescricaoOrigem.getText())) {
            Funcoes.mensagem(this, "Informe a descri\u00e7\u00e3o", 2);
            ScreenUtil.requisitarFoco(this.textoDescricaoOrigem);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "onc_codigo";
    }
}

