/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.OrigemBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.OrigemVO;
import jalis.service.cadastro.financeiro.OrigemService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Origem
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private TTextField textCodigo = new TTextField(3, 3);
    private TTextField textDescricao = new TTextField(100, 3);
    private JCheckBox checkPadrao = new JCheckBox("Padr\u00e3o");
    private String retornoParaPesquisa = "";

    public Origem() {
        this.setName("Origem");
        this.setLabelFormulario("Cadastro de origem");
        this.setLabelDescricao("Cadastro de origens para identificar plano de contas ou centro de custo de lan\u00e7amentos");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_origem.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        this.textCodigo.setUpperCase(true);
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(Origem.this.textCodigo.getText())) {
                    Origem.this.textCodigo.setText(Origem.this.verificaCodigoOrigem(StringUtil.removerAcentos(Origem.this.textCodigo.getText())));
                    Origem.this.verificaOrigem();
                }
            }
        });
        d = new Dimension(300, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkPadrao, c);
        this.checkPadrao.setName("checkPadrao");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new OrigemService();
        this.controlaCampos();
    }

    @Override
    public void excluir() {
        final OrigemBean beanDelete = (OrigemBean)this.pesquisar();
        if (beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Origem.this.preencherCampos(beanDelete);
                    if (Funcoes.mensagem(Origem.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            if (!((OrigemService)Origem.this.service).verificaOutraOrigemPadrao(beanDelete)) {
                                int resposta = JOptionPane.showOptionDialog(Origem.this, "N\u00e3o h\u00e1 origem padr\u00e3o.\nDeseja cancelar a exclus\u00e3o ou escolher outra origem?", "Origem padr\u00e3o", 0, 2, null, new String[]{"Cancelar exclus\u00e3o", "Escolher outra origem"}, "Cancelar exclus\u00e3o");
                                if (resposta == 0) {
                                    Origem.this.limparCampos();
                                    return;
                                }
                                AbstractThreadVO vo = ((OrigemService)Origem.this.service).pesquisaVO(Origem.this.getTopLevelAncestor(), new OrigemVO(), "Escolha a nova origem padr\u00e3o", false, beanDelete.getCodigo());
                                OrigemBean bean = null;
                                if (vo != null) {
                                    try {
                                        bean = (OrigemBean)Origem.this.service.voToBean((OrigemVO)vo, OrigemBean.class);
                                        if (bean != null) {
                                            bean.setPadrao(true);
                                            Origem.this.service.update(bean, null, bean.getFilial().getCodigo().toString(), null);
                                            Conexao.arquivaSQL();
                                        }
                                    }
                                    catch (Exception e) {
                                        try {
                                            Conexao.anulaSQL();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel configurar a origem padr\u00e3o. - " + e.getMessage() + " - Origem:validaCampos:203", e.getStackTrace());
                                    }
                                } else {
                                    Funcoes.mensagem(Origem.this, "Nenhuma origem foi selecionada.\nA exclus\u00e3o ser\u00e1 cancelada.", 2);
                                    Origem.this.limparCampos();
                                    return;
                                }
                            }
                            Origem.this.service.gravaAutoCopiaSemCommit(beanDelete, 2, Variaveis.filialPadrao, Origem.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(Origem.this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel excluir a origem.\n" + e.getMessage(), e.getStackTrace());
                        }
                    }
                    Origem.this.limparCampos();
                }
            });
        }
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkPadrao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        OrigemBean bean = new OrigemBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setCodigo(this.textCodigo.getText());
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setPadrao(this.checkPadrao.isSelected());
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaOrigemPlanoCusto();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.checkPadrao.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new OrigemVO(), "Pesquisando origens", false);
            if (vo != null) {
                OrigemBean OrigemBean2 = (OrigemBean)this.service.voToBean((OrigemVO)vo, OrigemBean.class);
                return OrigemBean2;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Origem:152");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        OrigemBean origemBean = (OrigemBean)bean;
        this.textCodigo.setText(origemBean.getCodigo());
        this.textDescricao.setText(origemBean.getDescricao());
        this.checkPadrao.setSelected(origemBean.getPadrao() != null && origemBean.getPadrao() != false);
        this.textCodigo.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchida", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (this.checkPadrao.isSelected() && ((OrigemService)this.service).verificaOutraOrigemPadrao((OrigemBean)this.getBeanPreenchido())) {
            int resposta = Funcoes.mensagem(this, "Outra origem j\u00e1 est\u00e1 definida como padr\u00e3o.\nDeseja que a origem corrente seja a nova origem padr\u00e3o?", 4, true);
            if (resposta == 1) {
                this.checkPadrao.setSelected(false);
            }
        } else if (!this.checkPadrao.isSelected() && !((OrigemService)this.service).verificaOutraOrigemPadrao((OrigemBean)this.getBeanPreenchido())) {
            int resposta = JOptionPane.showOptionDialog(this, "N\u00e3o h\u00e1 origem padr\u00e3o.\nDeseja manter essa origem como padr\u00e3o ou escolher outra origem?", "Origem padr\u00e3o", 0, 2, null, new String[]{"Manter", "Escolher outra origem"}, "Manter");
            if (resposta == 0) {
                this.checkPadrao.setSelected(true);
            } else {
                AbstractThreadVO vo = ((OrigemService)this.service).pesquisaVO(this.getTopLevelAncestor(), new OrigemVO(), "Escolha a nova origem padr\u00e3o", true, this.textCodigo.getText().trim());
                OrigemBean bean = null;
                if (vo != null) {
                    try {
                        bean = (OrigemBean)this.service.voToBean((OrigemVO)vo, OrigemBean.class);
                        if (bean != null) {
                            bean.setPadrao(true);
                            this.service.update(bean, null, bean.getFilial().getCodigo().toString(), null);
                            Conexao.arquivaSQL();
                        }
                    }
                    catch (Exception e) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel configurar a origem padr\u00e3o. - " + e.getMessage() + " - Origem:validaCampos:203", e.getStackTrace());
                    }
                } else {
                    Funcoes.mensagem(this, "Nenhuma origem foi selecionada.\nA origem corrente ser\u00e1 marcada como padr\u00e3o novamente.", 2);
                    this.checkPadrao.setSelected(true);
                }
            }
        }
        return true;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Origem.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300701"));
        this.setModuloEdita(Long.parseLong("0600300702"));
        this.setModuloApaga(Long.parseLong("0600300703"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300700");
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    private void verificaOrigem() {
        try {
            AbstractThreadBean origem = ((OrigemService)this.service).get(Variaveis.filialPadrao, this.textCodigo.getText());
            if (origem == null) {
                return;
            }
            this.preencherCampos(origem);
            this.setStatus(3);
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textDescricao);
            this.textCodigo.setEnabled(false);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Origem:227");
        }
    }

    private String verificaCodigoOrigem(String origem) {
        char[] cOrigem;
        StringBuilder retorno = new StringBuilder();
        for (char c : cOrigem = origem.toCharArray()) {
            if (String.valueOf(c).matches("[a-zA-Z0-9]")) {
                retorno.append(c);
                continue;
            }
            retorno.append("");
        }
        return retorno.toString();
    }

    @Override
    public void salvar() {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                new OrigemService().gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((OrigemBean)bean).getCodigo();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar a origem.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "opc_codigo";
    }
}

