/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.exame.MotivoRecoletaBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.MotivoRecoletaVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.exame.MotivoRecoletaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MotivoRecoleta
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JCheckBox checkExigeJustificativa = new JCheckBox("Exige Justificativa");
    private TTextField textCodigo = new TTextField(2, 3);
    private TTextField textDescricao = new TTextField(100, 3);
    private JComboBox comboCodigoMotivo = new JComboBox();
    private String retornoParaPesquisa = "";

    public MotivoRecoleta() {
        this.setLabelDescricao("Cadastro de motivos de recoleta");
        this.setLabelFormulario("Cadastro de motivos de recoleta");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_motivo_cancel.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setUpperCase(true);
        d = new Dimension(20, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        d = new Dimension(400, 20);
        this.comboCodigoMotivo.setPreferredSize(d);
        this.comboCodigoMotivo.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkExigeJustificativa, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new MotivoRecoletaService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        boolean enabled = this.getStatus() == 3 || this.getStatus() == 2;
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(enabled);
        this.checkExigeJustificativa.setEnabled(enabled);
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.checkExigeJustificativa.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new MotivoRecoletaVO(), "Pesquisando Motivos Recoleta", false);
            if (vo != null) {
                MotivoRecoletaBean motivoBean = (MotivoRecoletaBean)this.service.voToBean((MotivoRecoletaVO)vo, MotivoRecoletaBean.class);
                return motivoBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "MotivoRecoleta:130");
        }
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        MotivoRecoletaBean bean = new MotivoRecoletaBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setExigirJustificativa(this.checkExigeJustificativa.isSelected());
        return bean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        MotivoRecoletaBean motivoBean = (MotivoRecoletaBean)bean;
        this.textCodigo.setText(Integer.toString(motivoBean.getCodigo()));
        this.textDescricao.setText(motivoBean.getDescricao());
        this.checkExigeJustificativa.setSelected(motivoBean.getExigirJustificativa());
        this.textCodigo.setEnabled(false);
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaMotivoRecoleta();
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.textoVazio(this.textDescricao.getText())) {
            return true;
        }
        if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchida", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        return false;
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((MotivoRecoletaBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "mrc_codigo";
    }

    private void preencheCodigosMotivoCancelamento() {
        try {
            FilialBean filialBean = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da filial.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(MotivoRecoleta.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901801"));
        this.setModuloEdita(Long.parseLong("0101901802"));
        this.setModuloApaga(Long.parseLong("0101901803"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901800");
    }
}

