/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.MotivoDeContatoBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.MotivoDeContatoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.MotivoDeContatoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MotivoContato
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JCheckBox checkExigeObservacao = new JCheckBox("Exige Observa\u00e7\u00e3o");
    private TTextField textCodigo = new TTextField(2, 3);
    private TTextField textDescricao = new TTextField(100, 3);
    private String retornoParaPesquisa = "";

    public MotivoContato() {
        this.setName("MotivoContato");
        this.setLabelDescricao("Cadastro de motivo de contato");
        this.setLabelFormulario("Cadastro de motivo de contato");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_motivo_contato.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        this.textCodigo.setUpperCase(true);
        d = new Dimension(300, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkExigeObservacao, c);
        this.checkExigeObservacao.setName("checkExigeObservacao");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new MotivoDeContatoService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkExigeObservacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        MotivoDeContatoBean bean = new MotivoDeContatoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setExigirMotivo(this.checkExigeObservacao.isSelected());
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaMotivoDeContato();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.checkExigeObservacao.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new MotivoDeContatoVO(), "Pesquisando Motivos de Contato", false);
            if (vo != null) {
                MotivoDeContatoBean motivoBean = (MotivoDeContatoBean)this.service.voToBean((MotivoDeContatoVO)vo, MotivoDeContatoBean.class);
                return motivoBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        MotivoDeContatoBean motivoBean = (MotivoDeContatoBean)bean;
        this.textCodigo.setText(Integer.toString(motivoBean.getCodigo()));
        this.textDescricao.setText(motivoBean.getDescricao());
        this.checkExigeObservacao.setSelected(motivoBean.getExigirMotivo());
        this.textCodigo.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.textoVazio(this.textDescricao.getText())) {
            return true;
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchida", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        return false;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(MotivoContato.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0105600101"));
        this.setModuloEdita(Long.parseLong("0105600102"));
        this.setModuloApaga(Long.parseLong("0105600103"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0105600100");
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((MotivoDeContatoBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "MotivoDeContato:86");
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "mct_codigo";
    }
}

