/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.SistemaEmissaoNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.remover.IntegracaoG2KA;
import jalis.laboratorio.financeiro.faturamento.integracao.remover.Padrao;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.financeiro.MotivoCancelamentoBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.financeiro.MotivoCancelamentoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MotivoCancelamento
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelCodigoMotivo = new JLabel("Motivo NFSE:");
    private JCheckBox checkExigeJustificativa = new JCheckBox("Exige Justificativa");
    private TTextField textCodigo = new TTextField(2, 3);
    private TTextField textDescricao = new TTextField(100, 3);
    private JComboBox comboCodigoMotivo = new JComboBox();
    private String retornoParaPesquisa = "";
    private SistemaEmissaoNFSe sistemaEmissaoNFSe = Laboratorio.sistemaEmissorNFSe;

    public MotivoCancelamento() {
        this.setName("MotivoCancelamento");
        this.setLabelDescricao("Cadastro de motivos de cancelamento para estorno de lan\u00e7amentos");
        this.setLabelFormulario("Cadastro de motivos de cancelamento");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_motivo_cancel.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setUpperCase(true);
        d = new Dimension(20, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setMinimumSize(d);
        d = new Dimension(400, 20);
        this.comboCodigoMotivo.setPreferredSize(d);
        this.comboCodigoMotivo.setName("comboCodigoMotivo");
        this.comboCodigoMotivo.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        this.painelCentral.add((Component)this.labelCodigoMotivo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.comboCodigoMotivo, c);
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkExigeJustificativa, c);
        this.checkExigeJustificativa.setName("checkExigeJustificativa");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
            this.preencheCodigosMotivoCancelamento();
        }
        this.service = new MotivoCancelamentoService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        boolean enabled = this.getStatus() == 3 || this.getStatus() == 2;
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(enabled);
        this.checkExigeJustificativa.setEnabled(enabled);
        this.comboCodigoMotivo.setEnabled(enabled && this.comboCodigoMotivo.getItemCount() > 0);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        IntegracaoG2KA.MotivoCancelamento motivo;
        MotivoCancelamentoBean bean = new MotivoCancelamentoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setExigeJustificativa(this.checkExigeJustificativa.isSelected());
        String codigoMotivo = null;
        if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID && (motivo = (IntegracaoG2KA.MotivoCancelamento)((Object)this.comboCodigoMotivo.getSelectedItem())) != null) {
            codigoMotivo = motivo.getCodigo();
        }
        if (!Funcoes.textoVazio(codigoMotivo)) {
            bean.setCodigoNfse(codigoMotivo);
        } else {
            bean.setCodigoNfse(null);
        }
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaMotivoCancelamento();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.checkExigeJustificativa.setSelected(false);
        this.comboCodigoMotivo.setSelectedIndex(-1);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new MotivoCancelamentoVO(), "Pesquisando Motivos Cancelamentos", false);
            if (vo != null) {
                MotivoCancelamentoBean motivoBean = (MotivoCancelamentoBean)this.service.voToBean((MotivoCancelamentoVO)vo, MotivoCancelamentoBean.class);
                return motivoBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "MotivoCancelamento:130");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        MotivoCancelamentoBean motivoBean = (MotivoCancelamentoBean)bean;
        this.textCodigo.setText(Integer.toString(motivoBean.getCodigo()));
        this.textDescricao.setText(motivoBean.getDescricao());
        this.checkExigeJustificativa.setSelected(motivoBean.getExigeJustificativa());
        if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
            if (((MotivoCancelamentoBean)bean).getCodigoNfse() != null) {
                IntegracaoG2KA.MotivoCancelamento aux = IntegracaoG2KA.MotivoCancelamento.get(((MotivoCancelamentoBean)bean).getCodigoNfse());
                if (aux != null) {
                    this.comboCodigoMotivo.setSelectedItem((Object)aux);
                } else {
                    this.comboCodigoMotivo.setSelectedIndex(-1);
                }
            } else {
                this.comboCodigoMotivo.setSelectedIndex(-1);
            }
        }
        this.textCodigo.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.textoVazio(this.textDescricao.getText())) {
            return true;
        }
        if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchida", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        return false;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(MotivoCancelamento.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300501"));
        this.setModuloEdita(Long.parseLong("0600300502"));
        this.setModuloApaga(Long.parseLong("0600300503"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300500");
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((MotivoCancelamentoBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "mov_codigo";
    }

    private void preencheCodigosMotivoCancelamento() {
        try {
            IntegracaoG2KA.MotivoCancelamento[] motivos;
            FilialBean filial = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
            if (filial.getPadraoLayoutNFSe() != null && (motivos = IntegracaoG2KA.MotivoCancelamento.getItens(Padrao.get(filial.getPadraoLayoutNFSe()))) != null && motivos.length > 0) {
                for (int i = 0; i < motivos.length; ++i) {
                    this.comboCodigoMotivo.addItem(motivos[i]);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da filial.\n" + e.getMessage(), e.getStackTrace());
        }
    }
}

