/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Metodologia
extends FrmCadPadrao {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private TTextField txtDescricao = new TTextField(200);
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelReferencia = new JLabel("Refer\u00eancia:");
    private JTextArea textReferencia = new JTextArea(new TTextAreaDocument(500));
    private JScrollPane scroll = new JScrollPane(this.textReferencia);
    private String retornoParaPesquisa = "";

    public Metodologia() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Metodologia");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Metodologia");
        this.setLabelDescricao("Cadastro de m\u00e9todos de realiza\u00e7\u00e3o de exames");
        this.setLabelFormulario("Cadastro de metodologia");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_metodologia.jpg"));
        this.labelCodigo.setDisplayedMnemonic('D');
        this.labelCodigo.setLabelFor(this.txtCodigo);
        this.labelCodigo.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setBounds(new Rectangle(90, 7, 69, 20));
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao.setBounds(new Rectangle(90, 28, 400, 20));
        this.txtDescricao.setName("txtDescricao");
        this.labelDescricao.setBounds(new Rectangle(7, 30, 63, 14));
        this.labelDescricao.setLabelFor(this.txtDescricao);
        this.labelDescricao.setDisplayedMnemonic('R');
        this.labelReferencia.setBounds(new Rectangle(7, 51, 80, 14));
        this.scroll.setBounds(new Rectangle(90, 49, 400, 80));
        this.controlaCampos();
        this.textReferencia.setName("textReferencia");
        ScreenUtil.montaSaidaTextArea(this.textReferencia);
        this.painelCentral.add((Component)this.labelCodigo, null);
        this.painelCentral.add((Component)this.labelDescricao, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add(this.labelReferencia);
        this.painelCentral.add(this.scroll);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Metodologia.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Metodologia.this.txtCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select met_codigo, met_descricao, met_referencia from metodologia ");
                            buf.append("where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and met_codigo = ");
                            buf.append(Metodologia.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                Metodologia.this.txtDescricao.setText(rs.getString("met_descricao"));
                                Metodologia.this.textReferencia.setText(rs.getString("met_referencia"));
                                Metodologia.this.txtCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(Metodologia.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Metodologia.this.setStatus(1);
                                Metodologia.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Metodologia.this, sqlex.getMessage(), sqlex.getStackTrace(), "Metodologia");
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Metodologia.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900401"));
        this.setModuloEdita(Long.parseLong("0101900402"));
        this.setModuloApaga(Long.parseLong("0101900403"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.metodologia(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("met_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("metodologia", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("met_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMetodologia());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Metodologia");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "metodologia", true);
                }
                SalvaDados salvar = new SalvaDados("metodologia", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("met_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("met_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("met_referencia", 0, true, false, StringUtil.textoDBEscape(this.textReferencia.getText()));
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMetodologia(), "metodologia", Integer.parseInt(codigo));
                Util.gravaAlteracaoMetodologia(statement, codigo);
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Metodologia");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textReferencia.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.textReferencia.setText("");
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900400");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "met_codigo";
    }
}

