/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Pesquisas;
import jalis.laboratorio.cadastro.ObjetoMedicoExame;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class MedicoExame
extends JPanel
implements ActionListener {
    public static final int HABILITADO = 1;
    public static final int DESABILITADO = 2;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_PACIENTE = 2;
    private final int COLUNA_MEDICO = 3;
    private final int COLUNA_CONVENIO = 4;
    private TTextField textExame = new TTextField(5);
    private JLabel labelExame = ComponenteFactory.novoJLabel("", new Dimension(10, 20), new TitledBorder(""));
    private JButton buttonBuscaExame = ComponenteFactory.novoJButton(this, true);
    private ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Destino", "Paciente", "M\u00e9dico", "Conv\u00eanio"});
    private JTable tableExame = new JTable(this.modeloExame){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 2 && col <= 4;
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    };
    private JButton buttonOKExame = ComponenteFactory.novoJButton("OK", '\u0000', this);
    private int situacaoCampos = 2;

    public MedicoExame() {
        this.montaTela();
        this.setSituacaoCampos(2);
    }

    public void limparExames() {
        this.modeloExame.clear();
    }

    public void definirUpperCase() {
        this.textExame.setUpperCase(true);
    }

    private void montaTela() {
        this.setName("MedicoExame");
        this.setSize(new Dimension(400, 400));
        this.setLayout(new GridBagLayout());
        this.buttonBuscaExame.setFocusable(false);
        this.buttonBuscaExame.setName("buttonBuscaExame");
        this.modeloExame.setColumnSize(new int[]{70, 0, 60, 60, 60}, this.tableExame);
        this.montaControles();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        this.add((Component)new JLabel("Exame"), c);
        c.gridx = 3;
        this.add((Component)new JLabel(""), c);
        c.gridy = 1;
        c.gridx = 0;
        this.textExame.setPreferredSize(new Dimension(69, 20));
        this.textExame.setName("textExame");
        this.textExame.setMinimumSize(new Dimension(69, 20));
        this.add((Component)this.textExame, c);
        c.gridx = 1;
        this.buttonBuscaExame.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaExame.setPreferredSize(new Dimension(20, 20));
        this.add((Component)this.buttonBuscaExame, c);
        c.gridx = 3;
        this.buttonOKExame.setMinimumSize(new Dimension(40, 20));
        this.buttonOKExame.setName("buttonOKExame");
        this.buttonOKExame.setPreferredSize(new Dimension(40, 20));
        this.add((Component)this.buttonOKExame, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelExame.setMinimumSize(new Dimension(100, 20));
        this.add((Component)this.labelExame, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 4;
        this.tableExame.setName("tableExame");
        this.add((Component)new JScrollPane(this.tableExame), c);
    }

    private void montaControles() {
        this.textExame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(MedicoExame.this.textExame.getText())) {
                        MedicoExame.this.labelExame.setText(DBUtil.getDescricao("exa_codigo", "exa_descricao", MedicoExame.this.textExame.getText(), "exames"));
                    }
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(MedicoExame.this, e1.getMessage(), e1.getStackTrace(), "MedicoExame (2153)");
                }
            }
        });
        this.textExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113 && MedicoExame.this.situacaoCampos == 1) {
                    MedicoExame.this.buscaExame();
                }
            }
        });
        this.tableExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && MedicoExame.this.situacaoCampos == 1 && MedicoExame.this.tableExame.getSelectedRow() > -1 && Funcoes.mensagem(MedicoExame.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    MedicoExame.this.modeloExame.removeLine(MedicoExame.this.tableExame.getSelectedRow());
                }
            }
        });
    }

    private void buscaExame() {
        Hashtable resultado = Pesquisas.exame(this.getTopLevelAncestor(), true, false);
        if (resultado != null) {
            this.textExame.setText(resultado.get("exa_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textExame);
    }

    private void incluirExame() {
        int pos;
        boolean limpar = true;
        if (!Funcoes.textoVazio(this.textExame.getText()) && !this.labelExame.getText().equals("N\u00e3o cadastrado") && (pos = this.modeloExame.localizar(0, this.textExame.getText())) == -1) {
            this.modeloExame.addLine(new Object[]{this.textExame.getText(), this.labelExame.getText(), new Boolean(false), new Boolean(false), new Boolean(false)});
        }
        if (limpar) {
            this.textExame.clear();
            this.labelExame.setText("");
            ScreenUtil.requisitarFoco(this.textExame);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaExame && this.situacaoCampos == 1) {
            this.buscaExame();
        } else if (e.getSource() == this.buttonOKExame && this.situacaoCampos == 1) {
            this.incluirExame();
        }
    }

    public ArrayList<ObjetoMedicoExame> getExames() {
        ArrayList<ObjetoMedicoExame> o = new ArrayList<ObjetoMedicoExame>();
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            o.add(new ObjetoMedicoExame(this.modeloExame.getValueAt(i, 0).toString(), this.modeloExame.getValueAt(i, 1).toString(), (Boolean)this.modeloExame.getValueAt(i, 2), (Boolean)this.modeloExame.getValueAt(i, 3), (Boolean)this.modeloExame.getValueAt(i, 4)));
        }
        return o;
    }

    public void setExames(ArrayList<ObjetoMedicoExame> exames) {
        this.modeloExame.clear();
        for (ObjetoMedicoExame o : exames) {
            this.modeloExame.addLine(new Object[]{o.codigoExame, o.descricaoExame, o.paciente, o.medico, o.convenio});
        }
    }

    public void setSituacaoCampos(int situacao) {
        this.situacaoCampos = situacao;
        this.textExame.setEnabled(situacao == 1);
        this.buttonBuscaExame.setEnabled(situacao == 1);
        this.buttonOKExame.setEnabled(situacao == 1);
    }
}

