/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosME;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

class MedicoEspecialidades
extends JDialog
implements DisposeListener {
    private ArrayList especialidades;
    private JPanel panel;
    private TTextField txtCodEsp;
    private TTextField txtDescEsp;
    private JButton botaoEsp;
    private JTable tabelaEsp;
    private JScrollPane scroll;
    private JButton botaoOK;
    private JLabel labelEsp;
    private ModeloGridTable modelo;
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonOK = new JButton("OK");
    private boolean ok = false;

    public static MedicoEspecialidades novaInstancia(Component owner) {
        if (owner instanceof Dialog) {
            return new MedicoEspecialidades((Dialog)owner, "Especialidades");
        }
        if (owner instanceof Frame) {
            return new MedicoEspecialidades((Frame)owner, "Especialidades");
        }
        return null;
    }

    public MedicoEspecialidades(Dialog owner, String title) {
        super(owner, title);
        this.montaTela(owner);
    }

    public MedicoEspecialidades(Frame owner, String title) {
        super(owner, title);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.montaTela(owner);
    }

    private void montaTela(Component owner) {
        this.setName("MedicoEspecialidades");
        this.getContentPane().setLayout(new BorderLayout());
        this.especialidades = new ArrayList();
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(ScreenUtil.criarBordaVazia());
        this.botaoEsp = new JButton("");
        Funcoes.imagemPesquisa(this.botaoEsp);
        this.txtCodEsp = new TTextField(5, 1);
        this.txtCodEsp.setName("txtCodEsp");
        this.txtDescEsp = new TTextField(80);
        this.txtDescEsp.setEditable(false);
        this.txtDescEsp.setName("txtDescEsp");
        this.txtDescEsp.setFocusable(false);
        this.botaoOK = new JButton("OK");
        this.botaoOK.setName("botaoOK");
        this.modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Especialidade"});
        this.tabelaEsp = new JTable(this.modelo);
        this.tabelaEsp.setName("tabelaEsp");
        this.modelo.setColumnSize(new int[]{70, 0}, this.tabelaEsp);
        this.scroll = new JScrollPane(this.tabelaEsp);
        this.labelEsp = new JLabel("Especialidade");
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.botaoEsp.setFocusable(false);
        this.buttonCancelar.setName("botaoFechar");
        this.buttonCancelar.setMnemonic('C');
        this.buttonOK.setName("botaoOK");
        this.buttonOK.setMnemonic('O');
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.anchor = 17;
        this.panel.add((Component)this.labelEsp, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.txtCodEsp.setPreferredSize(new Dimension(50, 20));
        this.txtCodEsp.setMinimumSize(new Dimension(50, 20));
        this.txtCodEsp.setMaximumSize(new Dimension(50, 20));
        this.panel.add((Component)this.txtCodEsp, c);
        ++c.gridx;
        this.botaoEsp.setPreferredSize(new Dimension(20, 20));
        this.botaoEsp.setMinimumSize(new Dimension(20, 20));
        this.botaoEsp.setMaximumSize(new Dimension(20, 20));
        this.panel.add((Component)this.botaoEsp, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.txtDescEsp.setPreferredSize(new Dimension(100, 20));
        this.txtDescEsp.setMinimumSize(new Dimension(100, 20));
        this.txtDescEsp.setMaximumSize(new Dimension(100, 20));
        this.panel.add((Component)this.txtDescEsp, c);
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridx;
        this.botaoOK.setPreferredSize(new Dimension(40, 20));
        this.botaoOK.setMinimumSize(this.botaoOK.getPreferredSize());
        this.botaoOK.setMaximumSize(this.botaoOK.getPreferredSize());
        this.panel.add((Component)this.botaoOK, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        c.fill = 1;
        this.panel.add((Component)this.scroll, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.panel.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), c);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setSize(424, 322);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        Funcoes.montaEnter((JComponent)this.panel);
        this.txtCodEsp.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0, true), "F2_PRESSIONADO");
        this.txtCodEsp.getActionMap().put("F2_PRESSIONADO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedicoEspecialidades.this.buscaEsp();
            }
        });
        this.botaoOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MedicoEspecialidades.this.txtDescEsp.getText().equals("N\u00e3o cadastrado") && !Funcoes.textoVazio(MedicoEspecialidades.this.txtCodEsp.getText()) && MedicoEspecialidades.this.modelo.localizar(0, MedicoEspecialidades.this.txtCodEsp.getText()) < 0) {
                    MedicoEspecialidades.this.modelo.addLine(new String[]{MedicoEspecialidades.this.txtCodEsp.getText(), MedicoEspecialidades.this.txtDescEsp.getText()});
                }
                MedicoEspecialidades.this.txtCodEsp.clear();
                MedicoEspecialidades.this.txtDescEsp.clear();
                MedicoEspecialidades.this.txtCodEsp.grabFocus();
            }
        });
        this.botaoEsp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedicoEspecialidades.this.buscaEsp();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedicoEspecialidades.this.ok = false;
                MedicoEspecialidades.this.setVisible(false);
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedicoEspecialidades.this.ok = true;
                MedicoEspecialidades.this.setVisible(false);
            }
        });
        this.tabelaEsp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && Funcoes.mensagem(MedicoEspecialidades.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    MedicoEspecialidades.this.modelo.removeLine(MedicoEspecialidades.this.tabelaEsp.getSelectedRow());
                }
            }
        });
        this.txtCodEsp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block6: {
                    if (MedicoEspecialidades.this.txtCodEsp.getText().trim().length() > 0) {
                        try {
                            Statement st = Conexao.getStatement();
                            if (st == null) break block6;
                            try {
                                ResultSet rs = Conexao.executeQuery(st, "select esp_descricao from especialidades where fil_codigo = " + Variaveis.filialPadrao + " and esp_codigo=" + MedicoEspecialidades.this.txtCodEsp.getText());
                                if (rs.next()) {
                                    MedicoEspecialidades.this.txtDescEsp.setText(rs.getString("esp_descricao"));
                                    break block6;
                                }
                                MedicoEspecialidades.this.txtDescEsp.setText("N\u00e3o cadastrado");
                            }
                            catch (SQLException sqlex) {
                                Funcoes.mensagem(MedicoEspecialidades.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                            }
                        }
                        catch (Exception ex) {
                            Funcoes.mensagem(MedicoEspecialidades.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                        }
                    }
                }
            }
        });
    }

    public boolean isOK() {
        return this.ok;
    }

    public ArrayList getEspecialidades() {
        this.especialidades.clear();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            DadosME dados = new DadosME(Integer.parseInt((String)this.modelo.getLine(i).get("C\u00f3digo")), (String)this.modelo.getLine(i).get("Especialidade"));
            this.especialidades.add(dados);
        }
        return this.especialidades;
    }

    public void setEspecialidades(ArrayList esp) {
        if (esp != null) {
            this.especialidades = esp;
        }
        for (int i = 0; i < this.especialidades.size(); ++i) {
            this.modelo.addLine(new Object[]{String.valueOf(((DadosME)this.especialidades.get(i)).getCodEspecialidade()), ((DadosME)this.especialidades.get(i)).getNomeEspecialidade()});
        }
    }

    private void buscaEsp() {
        Hashtable resultado = Pesquisas.especialidade(this, true);
        if (resultado != null) {
            this.txtCodEsp.setText(resultado.get("esp_codigo").toString());
        }
        this.txtCodEsp.requestFocus();
    }
}

