/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.laboratorio.cadastro.ObjetoMedicoDestino;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class MedicoDestino
extends JPanel
implements ActionListener {
    public static final int HABILITADO = 1;
    public static final int DESABILITADO = 2;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_SITUACAO = 2;
    private String[] situacoes = new String[]{Tipos.tipoMedicoDestino("D"), Tipos.tipoMedicoDestino("T"), Tipos.tipoMedicoDestino("P")};
    private TTextField textDestino = new TTextField(5);
    private JLabel labelDestino = ComponenteFactory.novoJLabel("", new Dimension(10, 20), new TitledBorder(""));
    private JButton buttonBuscaDestino = ComponenteFactory.novoJButton(this, true);
    private ModeloGridTable modeloDestino = new ModeloGridTable(new String[]{"C\u00f3digo", "Destino", "Situa\u00e7\u00e3o"});
    private JTable tableDestino = new JTable(this.modeloDestino);
    private JComboBox comboSituacao = new JComboBox<String>(this.situacoes);
    private JButton buttonOKDestino = ComponenteFactory.novoJButton("OK", '\u0000', this);
    private int situacaoCampos = 2;

    public MedicoDestino() {
        this.montaTela();
        this.setSituacaoCampos(2);
    }

    public void definirUpperCase() {
        this.textDestino.setUpperCase(true);
    }

    public void limparDestinos() {
        this.textDestino.clear();
        this.labelDestino.setText("");
        this.modeloDestino.clear();
    }

    private void montaTela() {
        this.setName("MedicoDestino");
        this.setSize(new Dimension(400, 400));
        this.setLayout(new GridBagLayout());
        this.buttonBuscaDestino.setFocusable(false);
        this.buttonBuscaDestino.setName("buttonBuscaDestino");
        this.modeloDestino.setColumnSize(new int[]{70, 0, 100}, this.tableDestino);
        this.montaControles();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        this.add((Component)new JLabel("Destino"), c);
        c.gridx = 3;
        this.add((Component)new JLabel("Situa\u00e7\u00e3o"), c);
        c.gridy = 1;
        c.gridx = 0;
        this.textDestino.setName("textDestino");
        this.textDestino.setPreferredSize(new Dimension(69, 20));
        this.textDestino.setMinimumSize(new Dimension(69, 20));
        this.add((Component)this.textDestino, c);
        c.gridx = 1;
        this.buttonBuscaDestino.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaDestino.setPreferredSize(new Dimension(20, 20));
        this.add((Component)this.buttonBuscaDestino, c);
        c.gridx = 3;
        this.comboSituacao.setPreferredSize(new Dimension(100, 20));
        this.comboSituacao.setMinimumSize(new Dimension(100, 20));
        this.comboSituacao.setName("comboSituacao");
        this.add((Component)this.comboSituacao, c);
        c.gridx = 4;
        this.buttonOKDestino.setMinimumSize(new Dimension(40, 20));
        this.buttonOKDestino.setPreferredSize(new Dimension(40, 20));
        this.buttonOKDestino.setName("buttonOKDestino");
        this.add((Component)this.buttonOKDestino, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelDestino.setMinimumSize(new Dimension(100, 20));
        this.add((Component)this.labelDestino, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 5;
        this.tableDestino.setName("tableDestino");
        this.add((Component)new JScrollPane(this.tableDestino), c);
    }

    private void montaControles() {
        this.textDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(MedicoDestino.this.textDestino.getText())) {
                        MedicoDestino.this.labelDestino.setText(DBUtil.getDescricao("des_codigo", "des_descricao", MedicoDestino.this.textDestino.getText(), "destino"));
                    }
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(MedicoDestino.this, e1.getMessage(), e1.getStackTrace(), "MedicoDestino (1678)");
                }
            }
        });
        this.textDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113 && MedicoDestino.this.situacaoCampos == 1) {
                    MedicoDestino.this.buscaDestino();
                }
            }
        });
        this.tableDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && MedicoDestino.this.situacaoCampos == 1 && MedicoDestino.this.tableDestino.getSelectedRow() > -1 && Funcoes.mensagem(MedicoDestino.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    MedicoDestino.this.modeloDestino.removeLine(MedicoDestino.this.tableDestino.getSelectedRow());
                }
            }
        });
    }

    private void buscaDestino() {
        Hashtable resultado = Pesquisas.destino(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.textDestino.setText(resultado.get("des_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textDestino);
    }

    private void incluirDestino() {
        boolean limpar = true;
        if (!Funcoes.textoVazio(this.textDestino.getText()) && !this.labelDestino.getText().equals("N\u00e3o cadastrado")) {
            int pos = this.modeloDestino.localizar(0, this.textDestino.getText());
            if (pos == -1 && this.comboSituacao.getSelectedItem().toString().equals(Tipos.tipoMedicoDestino("D")) && (pos = this.modeloDestino.localizar(2, this.comboSituacao.getSelectedItem().toString())) > -1) {
                Funcoes.mensagem(this, "J\u00e1 existe um destino padr\u00e3o adicionado, remova-o antes de adicionar um novo", 1);
                limpar = false;
            }
            if (pos == -1) {
                this.modeloDestino.addLine(new String[]{this.textDestino.getText(), this.labelDestino.getText(), this.comboSituacao.getSelectedItem().toString()});
            }
        }
        if (limpar) {
            this.textDestino.clear();
            this.labelDestino.setText("");
            ScreenUtil.requisitarFoco(this.textDestino);
        } else {
            ScreenUtil.requisitarFoco(this.comboSituacao);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaDestino && this.situacaoCampos == 1) {
            this.buscaDestino();
        } else if (e.getSource() == this.buttonOKDestino && this.situacaoCampos == 1) {
            this.incluirDestino();
        }
    }

    public ArrayList<ObjetoMedicoDestino> getDestinos() {
        ArrayList<ObjetoMedicoDestino> o = new ArrayList<ObjetoMedicoDestino>();
        for (int i = 0; i < this.modeloDestino.getRowCount(); ++i) {
            o.add(new ObjetoMedicoDestino(this.modeloDestino.getValueAt(i, 0).toString(), this.modeloDestino.getValueAt(i, 1).toString(), this.modeloDestino.getValueAt(i, 2).toString()));
        }
        return o;
    }

    public void setDestinos(ArrayList<ObjetoMedicoDestino> destinos) {
        this.modeloDestino.clear();
        for (ObjetoMedicoDestino o : destinos) {
            this.modeloDestino.addLine(new String[]{o.codigoDestino, o.descricaoDestino, o.situacao});
        }
    }

    public void setSituacaoCampos(int situacao) {
        this.situacaoCampos = situacao;
        this.textDestino.setEnabled(situacao == 1);
        this.buttonBuscaDestino.setEnabled(situacao == 1);
        this.comboSituacao.setEnabled(situacao == 1);
        this.buttonOKDestino.setEnabled(situacao == 1);
    }
}

