/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Pesquisas;
import jalis.laboratorio.cadastro.ObjetoMedicoConvenioProibido;
import jalis.laboratorio.cadastro.ObjetoMedicoConvenioTISS;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class MedicoConvenio2
extends JPanel
implements ActionListener {
    public static final int HABILITADO = 1;
    public static final int DESABILITADO = 2;
    public static final int PROIBIDOS = 1;
    public static final int TISS = 2;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_OPERADORA = 2;
    private TTextField textConvenio = new TTextField(5);
    private JLabel labelConvenio = ComponenteFactory.novoJLabel("", new Dimension(10, 20), new TitledBorder(""));
    private JButton buttonBuscaConvenio = ComponenteFactory.novoJButton(this, true);
    private ModeloGridTable modeloConvenio;
    private JTable tableConvenio = new JTable();
    private TTextField textOperadora = new TTextField(20);
    private JButton buttonOKConvenio = ComponenteFactory.novoJButton("OK", '\u0000', this);
    private int situacaoCampos = 2;
    private int tipo = 1;

    public MedicoConvenio2(int tipo) {
        int[] colunas;
        this.tipo = tipo;
        this.montaTela();
        this.setSituacaoCampos(2);
        if (tipo == 2) {
            this.modeloConvenio = new ModeloGridTable(new String[]{"C\u00f3digo", "Conv\u00eanio", "Operadora"});
            colunas = new int[]{70, 0, 120};
        } else {
            this.modeloConvenio = new ModeloGridTable(new String[]{"C\u00f3digo", "Conv\u00eanio"});
            colunas = new int[]{70, 0};
        }
        this.tableConvenio.setModel(this.modeloConvenio);
        this.modeloConvenio.setColumnSize(colunas, this.tableConvenio);
    }

    private void montaTela() {
        this.setName("MedicoConvenio2");
        this.setSize(new Dimension(400, 400));
        this.setLayout(new GridBagLayout());
        this.textConvenio.setUpperCase(true);
        this.textConvenio.setName("textConvenio");
        this.buttonBuscaConvenio.setFocusable(false);
        this.buttonBuscaConvenio.setName("buttonBuscaConvenio");
        this.montaControles();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        this.add((Component)new JLabel("Conv\u00eanio"), c);
        c.gridx = 3;
        this.add((Component)(this.tipo == 2 ? new JLabel("C\u00f3digo") : new JLabel("")), c);
        c.gridy = 1;
        c.gridx = 0;
        this.textConvenio.setPreferredSize(new Dimension(69, 20));
        this.textConvenio.setMinimumSize(new Dimension(69, 20));
        this.add((Component)this.textConvenio, c);
        c.gridx = 1;
        this.buttonBuscaConvenio.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaConvenio.setMinimumSize(new Dimension(20, 20));
        this.add((Component)this.buttonBuscaConvenio, c);
        if (this.tipo == 2) {
            c.gridx = 3;
            this.textOperadora.setPreferredSize(new Dimension(120, 20));
            this.textOperadora.setMinimumSize(new Dimension(120, 20));
            this.add((Component)this.textOperadora, c);
        }
        c.gridx = this.tipo == 2 ? 4 : 3;
        this.buttonOKConvenio.setName("buttonOKConvenio");
        this.buttonOKConvenio.setPreferredSize(new Dimension(40, 20));
        this.buttonOKConvenio.setMinimumSize(new Dimension(40, 20));
        this.add((Component)this.buttonOKConvenio, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelConvenio.setMinimumSize(new Dimension(100, 20));
        this.add((Component)this.labelConvenio, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = this.tipo == 1 ? 5 : 6;
        this.tableConvenio.setName("tableConvenio");
        this.add((Component)new JScrollPane(this.tableConvenio), c);
    }

    private void montaControles() {
        this.textConvenio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(MedicoConvenio2.this.textConvenio.getText()) && Funcoes.isNumeric(MedicoConvenio2.this.textConvenio.getText())) {
                        MedicoConvenio2.this.labelConvenio.setText(DBUtil.getDescricao("con_codigo", "con_fantasia", MedicoConvenio2.this.textConvenio.getText(), "convenios"));
                    } else if (!Funcoes.textoVazio(MedicoConvenio2.this.textConvenio.getText()) && !Funcoes.isNumeric(MedicoConvenio2.this.textConvenio.getText())) {
                        MedicoConvenio2.this.labelConvenio.setText("N\u00e3o cadastrado");
                    }
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(MedicoConvenio2.this, e1.getMessage(), e1.getStackTrace(), "MedicoConvenio2 (1964)");
                }
            }
        });
        this.textConvenio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113 && MedicoConvenio2.this.situacaoCampos == 1) {
                    MedicoConvenio2.this.buscaConvenio();
                }
            }
        });
        this.tableConvenio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && MedicoConvenio2.this.situacaoCampos == 1 && MedicoConvenio2.this.tableConvenio.getSelectedRow() > -1 && Funcoes.mensagem(MedicoConvenio2.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    MedicoConvenio2.this.modeloConvenio.removeLine(MedicoConvenio2.this.tableConvenio.getSelectedRow());
                }
            }
        });
    }

    public void limparConvenios() {
        this.modeloConvenio.clear();
    }

    private void buscaConvenio() {
        Hashtable resultado = Pesquisas.convenio(this.getTopLevelAncestor(), true, true);
        if (resultado != null) {
            this.textConvenio.setText(resultado.get("con_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textConvenio);
    }

    private void incluirConvenio() {
        boolean limpar = true;
        if (!Funcoes.textoVazio(this.textConvenio.getText()) && !this.labelConvenio.getText().equals("N\u00e3o cadastrado")) {
            int pos = this.modeloConvenio.localizar(0, this.textConvenio.getText());
            Object[] linha = this.tipo == 1 ? new String[]{this.textConvenio.getText(), this.labelConvenio.getText()} : new String[]{this.textConvenio.getText(), this.labelConvenio.getText(), this.textOperadora.getText()};
            if (pos == -1) {
                this.modeloConvenio.addLine(linha);
            }
        }
        if (limpar) {
            this.textConvenio.clear();
            this.labelConvenio.setText("");
            this.textOperadora.clear();
            ScreenUtil.requisitarFoco(this.textConvenio);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaConvenio && this.situacaoCampos == 1) {
            this.buscaConvenio();
        } else if (e.getSource() == this.buttonOKConvenio && this.situacaoCampos == 1) {
            this.incluirConvenio();
        }
    }

    public ArrayList<ObjetoMedicoConvenioProibido> getConveniosProibidos() {
        ArrayList<ObjetoMedicoConvenioProibido> o = new ArrayList<ObjetoMedicoConvenioProibido>();
        for (int i = 0; i < this.modeloConvenio.getRowCount(); ++i) {
            o.add(new ObjetoMedicoConvenioProibido(this.modeloConvenio.getValueAt(i, 0).toString(), this.modeloConvenio.getValueAt(i, 1).toString()));
        }
        return o;
    }

    public ArrayList<ObjetoMedicoConvenioTISS> getConveniosTISS() {
        ArrayList<ObjetoMedicoConvenioTISS> o = new ArrayList<ObjetoMedicoConvenioTISS>();
        for (int i = 0; i < this.modeloConvenio.getRowCount(); ++i) {
            o.add(new ObjetoMedicoConvenioTISS(this.modeloConvenio.getValueAt(i, 0).toString(), this.modeloConvenio.getValueAt(i, 1).toString(), this.modeloConvenio.getValueAt(i, 2).toString()));
        }
        return o;
    }

    public void setConveniosProibidos(ArrayList<ObjetoMedicoConvenioProibido> convenios) {
        this.modeloConvenio.clear();
        for (ObjetoMedicoConvenioProibido o : convenios) {
            this.modeloConvenio.addLine(new String[]{o.codigoConvenio, o.descricaoConvenio});
        }
    }

    public void setConveniosTiss(ArrayList<ObjetoMedicoConvenioTISS> convenios) {
        this.modeloConvenio.clear();
        for (ObjetoMedicoConvenioTISS o : convenios) {
            this.modeloConvenio.addLine(new String[]{o.codigoConvenio, o.descricaoConvenio, o.codigoOperadora});
        }
    }

    public void setSituacaoCampos(int situacao) {
        this.situacaoCampos = situacao;
        this.textConvenio.setEnabled(situacao == 1);
        this.buttonBuscaConvenio.setEnabled(situacao == 1);
        this.textOperadora.setEnabled(situacao == 1);
        this.buttonOKConvenio.setEnabled(situacao == 1);
    }

    public int getTipo() {
        return this.tipo;
    }
}

