/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.DisposeListener;
import jalis.model.vo.cadastro.MedicoContatoVO;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class MedicoContato
extends JDialog
implements DisposeListener,
ActionListener {
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_NOME = 1;
    private final int COLUNA_EMAIL = 2;
    private final int COLUNA_SELECIONADO = 3;
    private JLabel labelNome = new JLabel("Nome:");
    private JLabel labelEmail = new JLabel("E-mail:");
    private TTextField txtNome = new TTextField(80);
    private TTextField txtEmail = new TTextField(100, 15);
    private JPanel panelCampos = new JPanel(new GridBagLayout());
    private JPanel panelTable = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonOkAdd = ComponenteFactory.novoJButton("OK", this);
    private JButton buttonOkSalvar = ComponenteFactory.novoJButton("OK", 'O', null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', null);
    private ArrayList<MedicoContatoVO> listaContatos = new ArrayList();
    private ArrayList<MedicoContatoVO> listaContatosNovos = new ArrayList();
    private ArrayList<MedicoContatoVO> listaContatosAlterados = new ArrayList();
    private ArrayList<MedicoContatoVO> listaContatosRemovidos = new ArrayList();
    private boolean ok = false;
    private int linha = -1;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"", "Nome", "Email", "Enviar"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            if (columnIndex == 3) {
                MedicoContato.this.linha = row;
                MedicoContato.this.adicionaListaAlterados();
                return true;
            }
            return false;
        }
    };
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);

    public static MedicoContato novaInstancia(Component owner, ArrayList<MedicoContatoVO> contatos, ArrayList<MedicoContatoVO> contatosAlterados, ArrayList<MedicoContatoVO> contatosNovos, ArrayList<MedicoContatoVO> contatosRemovidos) {
        if (owner instanceof Frame) {
            return new MedicoContato((Frame)owner, contatos, contatosAlterados, contatosNovos, contatosRemovidos);
        }
        if (owner instanceof Dialog) {
            return new MedicoContato((JDialog)owner, contatos, contatosAlterados, contatosNovos, contatosRemovidos);
        }
        return null;
    }

    public MedicoContato(Frame owner, ArrayList<MedicoContatoVO> contatos, ArrayList<MedicoContatoVO> contatosAlterados, ArrayList<MedicoContatoVO> contatosNovos, ArrayList<MedicoContatoVO> contatosRemovidos) {
        super(owner);
        this.listaContatosAlterados.addAll(contatosAlterados);
        this.listaContatosNovos.addAll(contatosNovos);
        this.listaContatosRemovidos.addAll(contatosRemovidos);
        this.listaContatos.addAll(contatos);
        this.montaTela(contatos);
    }

    public MedicoContato(JDialog owner, ArrayList<MedicoContatoVO> contatos, ArrayList<MedicoContatoVO> contatosAlterados, ArrayList<MedicoContatoVO> contatosNovos, ArrayList<MedicoContatoVO> contatosRemovidos) {
        super(owner);
        this.listaContatosAlterados.addAll(contatosAlterados);
        this.listaContatosNovos.addAll(contatosNovos);
        this.listaContatosRemovidos.addAll(contatosRemovidos);
        this.listaContatos.addAll(contatos);
        this.montaTela(contatos);
    }

    private void montaTela(ArrayList<MedicoContatoVO> contatos) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(500, 300);
        this.setTitle("Contatos");
        this.setModal(true);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)this.panelCampos);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.buttonCancelar.addActionListener(this);
        this.buttonOkAdd.addActionListener(this);
        this.buttonOkSalvar.addActionListener(this);
        this.modelo.setColumnSize(new int[]{1, 150, 0, 50}, this.table);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 17;
        this.panelCampos.add((Component)this.labelNome, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        this.txtNome.setMinimumSize(new Dimension(175, 20));
        this.txtNome.setPreferredSize(new Dimension(175, 20));
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.panelCampos.add((Component)this.txtNome, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panelCampos.add((Component)this.labelEmail, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        this.txtEmail.setMinimumSize(new Dimension(200, 20));
        this.txtEmail.setPreferredSize(new Dimension(200, 20));
        this.panelCampos.add((Component)this.txtEmail, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.buttonOkAdd.setMinimumSize(new Dimension(40, 20));
        this.buttonOkAdd.setPreferredSize(new Dimension(40, 20));
        this.panelCampos.add((Component)this.buttonOkAdd, gridBagConstraints);
        this.panelTable.add((Component)this.scroll, "Center");
        this.panelBotoes.add((Component)this.buttonOkSalvar, null);
        this.panelBotoes.add((Component)this.buttonCancelar, null);
        this.getContentPane().add((Component)this.panelCampos, "North");
        this.getContentPane().add((Component)this.panelTable, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.carregarListaContatos(contatos);
        this.buttonOkAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedicoContato.this.adicionarDados();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    if (MedicoContato.this.table.getSelectedRow() > MedicoContato.this.linha) {
                        MedicoContato.this.linha = MedicoContato.this.table.getSelectedRow();
                        MedicoContato.this.editarLiha(MedicoContato.this.linha);
                    }
                } else if (e.getKeyChar() == '\u007f' && MedicoContato.this.table.getSelectedRow() > MedicoContato.this.linha) {
                    MedicoContato.this.linha = MedicoContato.this.table.getSelectedRow();
                    MedicoContato.this.removerContato();
                }
            }
        });
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MedicoContato.this.table.getSelectedRow() > MedicoContato.this.linha) {
                    MedicoContato.this.linha = MedicoContato.this.table.getSelectedRow();
                    MedicoContato.this.editarLiha(MedicoContato.this.linha);
                }
            }
        });
    }

    private void editarLiha(int selectedRow) {
        this.txtNome.setText(this.modelo.getValueAt(selectedRow, 1).toString());
        this.txtEmail.setText(this.modelo.getValueAt(selectedRow, 2).toString());
    }

    private void removerContato() {
        int conf = JOptionPane.showOptionDialog(this, "Deseja remover contato selecionado?", "Confirma\u00e7\u00e3o", 0, 2, ImagemUtils.carregaImagemJalis("warning.gif"), new Object[]{"Sim", "N\u00e3o"}, "N\u00e3o");
        if (this.isYesOption(conf)) {
            MedicoContatoVO con = new MedicoContatoVO();
            if (this.contemCodigo(this.linha)) {
                int codigo = (Integer)this.modelo.getValueAt(this.linha, 0);
                con.setCodigo(codigo);
                con.setContatoNome(this.modelo.getValueAt(this.linha, 1).toString());
                con.setContatoEmail(this.modelo.getValueAt(this.linha, 2).toString());
                this.listaContatosRemovidos.add(con);
                this.listaContatosAlterados.remove(con);
            }
            this.removeRegistroOutraLista();
            this.modelo.removeLine(this.linha);
        }
        this.linha = -1;
    }

    private boolean isYesOption(int conf) {
        return conf == 0;
    }

    private void removeRegistroOutraLista() {
        if (this.contemContatos(this.listaContatosNovos)) {
            String nome = this.modelo.getValueAt(this.linha, 1).toString();
            String email = this.modelo.getValueAt(this.linha, 2).toString();
            for (MedicoContatoVO con : this.listaContatosNovos) {
                if (!con.getContatoNome().equalsIgnoreCase(nome) || !con.getContatoEmail().equalsIgnoreCase(email)) continue;
                this.listaContatosNovos.remove(con);
                break;
            }
        }
    }

    private void limpaCampos() {
        this.txtNome.clear();
        this.txtEmail.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.ok = false;
            this.dispose();
        } else if (e.getSource() == this.buttonOkSalvar) {
            this.ok = true;
            this.salvar();
            this.dispose();
        }
    }

    private void carregarListaContatos(ArrayList<MedicoContatoVO> contatos) {
        if (this.contemContatos(contatos)) {
            for (MedicoContatoVO con : contatos) {
                this.modelo.addLine(new Object[]{con.getCodigo(), con.getContatoNome(), con.getContatoEmail(), con.getEnviarEmail()});
            }
        }
    }

    private boolean contemContatos(ArrayList<MedicoContatoVO> contatos) {
        return contatos != null && contatos.size() > 0;
    }

    private boolean contemCodigo(int i) {
        return this.modelo.getValueAt(i, 0) != null && !Funcoes.textoVazio(this.modelo.getValueAt(i, 0).toString());
    }

    private boolean contemRegistro() {
        return this.modelo.getRowCount() > 0;
    }

    private void salvar() {
        this.listaContatos.clear();
        this.listaContatosNovos.clear();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            MedicoContatoVO con = new MedicoContatoVO();
            con.setCodigo(null);
            String nome = this.modelo.getValueAt(i, 1).toString();
            String email = this.modelo.getValueAt(i, 2).toString();
            boolean enviarEmail = (Boolean)this.modelo.getValueAt(i, 3);
            con.setContatoNome(nome);
            con.setContatoEmail(email);
            con.setEnviarEmail(enviarEmail);
            if (this.contemCodigo(i)) {
                int codigo = (Integer)this.modelo.getValueAt(i, 0);
                con.setCodigo(codigo);
            } else {
                this.listaContatosNovos.add(con);
            }
            this.listaContatos.add(con);
        }
    }

    private void adicionaListaAlterados() {
        if (this.contemCodigo(this.linha)) {
            MedicoContatoVO con = new MedicoContatoVO();
            int codigo = (Integer)this.modelo.getValueAt(this.linha, 0);
            String nome = this.modelo.getValueAt(this.linha, 1).toString();
            String email = this.modelo.getValueAt(this.linha, 2).toString();
            boolean enviarEmail = (Boolean)this.modelo.getValueAt(this.linha, 3);
            con.setCodigo(codigo);
            con.setContatoNome(nome);
            con.setContatoEmail(email);
            con.setEnviarEmail(!enviarEmail);
            this.listaContatosAlterados.add(con);
        }
        this.linha = -1;
    }

    private void adicionarDados() {
        if (this.validaCampos()) {
            MedicoContatoVO con = null;
            if (this.isEdicao()) {
                this.modelo.setValueAt(this.txtNome.getText(), this.linha, 1);
                this.modelo.setValueAt(this.txtEmail.getText(), this.linha, 2);
                this.adicionaListaAlterados();
                this.limpaCampos();
            } else if (!this.isContatoExistente()) {
                this.modelo.addLine(new Object[]{null, this.txtNome.getText(), this.txtEmail.getText(), false});
                con = new MedicoContatoVO();
                con.setCodigo(null);
                con.setContatoNome(this.txtNome.getText());
                con.setContatoEmail(this.txtEmail.getText());
                con.setEnviarEmail(false);
                this.listaContatosNovos.add(con);
                this.limpaCampos();
            }
            this.linha = -1;
        }
    }

    private boolean isEdicao() {
        return this.linha > -1;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtNome) || Funcoes.textoVazio(this.txtEmail) || !this.txtEmail.isConteudoValido()) {
            Funcoes.mensagem(this, "Algum nome/e-mail deve ser informado", 2);
            ScreenUtil.requisitarFoco(this.txtNome);
            return false;
        }
        return true;
    }

    private boolean isContatoExistente() {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String nome = this.modelo.getValueAt(i, 1).toString();
            String email = this.modelo.getValueAt(i, 2).toString();
            if (!nome.trim().equalsIgnoreCase(this.txtNome.getText().trim()) || !email.trim().equalsIgnoreCase(this.txtEmail.getText().trim())) continue;
            Funcoes.mensagem(this, "Contato j\u00e1 adicionado.", 2);
            return true;
        }
        return false;
    }

    public boolean isOK() {
        return this.ok;
    }

    public ArrayList<MedicoContatoVO> getListaContatosNovos() {
        return this.listaContatosNovos;
    }

    public ArrayList<MedicoContatoVO> getListaContatosAlterados() {
        return this.listaContatosAlterados;
    }

    public ArrayList<MedicoContatoVO> getListaContatosRemovidos() {
        return this.listaContatosRemovidos;
    }

    public ArrayList<MedicoContatoVO> getListaContatos() {
        return this.listaContatos;
    }
}

