/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Acesso;
import jalis.comum.CBOS;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.CelulaEstoque;
import jalis.laboratorio.cadastro.ConveniosAutorizados;
import jalis.laboratorio.cadastro.DadosConvenio;
import jalis.laboratorio.cadastro.DadosME;
import jalis.laboratorio.cadastro.MedicoContato;
import jalis.laboratorio.cadastro.MedicoConvenio2;
import jalis.laboratorio.cadastro.MedicoDestino;
import jalis.laboratorio.cadastro.MedicoEnvioAutomaticoDTO;
import jalis.laboratorio.cadastro.MedicoEspecialidades;
import jalis.laboratorio.cadastro.MedicoExame;
import jalis.laboratorio.cadastro.MedicoSMSEmail;
import jalis.laboratorio.cadastro.Mensagem;
import jalis.laboratorio.cadastro.ObjetoCBO;
import jalis.laboratorio.cadastro.ObjetoMedicoConvenioProibido;
import jalis.laboratorio.cadastro.ObjetoMedicoConvenioTISS;
import jalis.laboratorio.cadastro.ObjetoMedicoDestino;
import jalis.laboratorio.cadastro.ObjetoMedicoExame;
import jalis.laboratorio.cadastro.SenhaWeb;
import jalis.model.AbstractThreadBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.MedicoContatoVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.service.cadastro.MedicoContatoService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.util.CEP;
import jalis.util.ComponenteUtils;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class Medico
extends FrmCadPadrao
implements ActionListener {
    private ArrayList<ObjetoMedicoConvenioProibido> convenioAutorizado = new ArrayList();
    private ArrayList convenioComissao = new ArrayList();
    private ArrayList<DadosME> medicoEspecialidade = new ArrayList();
    private ArrayList<ObjetoMedicoConvenioTISS> convenioTiss = new ArrayList();
    private ArrayList<ObjetoMedicoDestino> medicoDestino = new ArrayList();
    private ArrayList<ObjetoMedicoExame> medicoExame = new ArrayList();
    private JTabbedPane tabbed = new JTabbedPane();
    private JComboBox comboConselho = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    private TTextField txtCrm = new TTextField(10);
    private JComboBox comboUf = new JComboBox<String>(ConstantesGerais.ESTADOS);
    private JLabel labelConselho = new JLabel("Conselho:");
    private JLabel jLabel2 = new JLabel("Nome:");
    private TTextField txtNome = new TTextField(80);
    private JLabel jLabel3 = new JLabel("Tratamento:");
    private JLabel jLabel4 = new JLabel("Tipo:");
    private JComboBox comboTipo = new JComboBox<Object>(new Object[]{"Solicitante", "Realizante"});
    private JComboBox comboAbrev = new JComboBox<Object>(new Object[]{"Dr.", "Dra.", "Sr.", "Sra.", "Prof. Dr.", "Profa. Dra.", "Enf.", "Enfa."});
    private JComboBox comboTipoLogradouro = new JComboBox<String>(Tipos.arrayTiposLogradouro);
    private JLabel jLabel5 = new JLabel();
    private JButton jButton1 = new JButton();
    private JLabel jLabel6 = new JLabel();
    private TTextField txtCodCidade = new TTextField(5, 1);
    private TTextField txtDescEspecialidade = new TTextField(80);
    private TTextField txtDescCidade = new TTextField(80);
    private JLabel jLabel7 = new JLabel();
    private TTextField txtEndereco = new TTextField(80);
    private JLabel labelNumeroEndereco = new JLabel();
    private TTextField txtNumeroEndereco = new TTextField(15);
    private JLabel jLabel8 = new JLabel();
    private TTextField txtComplemento = new TTextField(50);
    private JLabel jLabel9 = new JLabel();
    private TTextField txtCodBairro = new TTextField(5);
    private TTextField txtDescBairro = new TTextField(80);
    private JLabel jLabel11 = new JLabel();
    private TTextField txtCEP = new TTextField(9, 9);
    private JButton bBuscaCep = ComponenteFactory.novoJButton(this, true);
    private JLabel jLabel12 = new JLabel();
    private TTextFieldTelefone txtFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    private JLabel jLabel13 = new JLabel();
    private TTextFieldTelefone txtCelular = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    private JLabel jLabel14 = new JLabel();
    private TTextFieldTelefone txtFax = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    private JLabel jLabel15 = new JLabel();
    private JTextArea txtObserv = new JTextArea(new TTextAreaDocument(500));
    private JLabel jLabel16 = new JLabel("Comiss\u00e3o:");
    private TTextField txtComissao = new TTextField(10, 2, 2);
    private JLabel jLabel17 = new JLabel();
    private TTextField txtEmail = new TTextField(100);
    private JLabel jLabel18 = new JLabel();
    private TTextField txtSite = new TTextField(100);
    private JLabel jLabel19 = new JLabel();
    private JButton jButton2 = new JButton();
    private JButton jButton3 = new JButton();
    private JButton buttonComissoes = ComponenteFactory.novoJButton("Comiss\u00f5es", 'u', null);
    private JButton buttonSenhaWeb = new JButton("Senha web");
    private JButton buttonMensagem = ComponenteFactory.novoJButton("Mensagem", this);
    private JButton buttonSMSEmail = ComponenteFactory.novoJButton("Envio autom\u00e1tico", this);
    private JScrollPane scroll;
    private JButton buttonOutrosContatos = ComponenteFactory.novoJButton("Outros contatos", 'O', null);
    private JLabel labelCBO = new JLabel("CBO-S:");
    private JComboBox comboCBO = new JComboBox();
    private JLabel labelCPF = new JLabel("CPF:");
    private TTextField textCPF = new TTextField(14, 1);
    private JLabel labelNascimento = new JLabel("Data nascimento:");
    private TTextField textNascimento = new TTextField(10, 4);
    private JButton buttonNascimento = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    JPanel panelDados = new JPanel(null);
    JPanel panelConvenios = new JPanel(new GridBagLayout());
    JPanel panelDestinos = new JPanel(new GridBagLayout());
    MedicoDestino panelDestino = new MedicoDestino();
    MedicoExame panelExame = new MedicoExame();
    MedicoConvenio2 panelProibidos = new MedicoConvenio2(1);
    MedicoConvenio2 panelTiss = new MedicoConvenio2(2);
    JPanel panelCelulaEstoque = new JPanel(new GridBagLayout());
    TTextField textCodigoCelula = new TTextField(5, 1);
    JButton buttonBuscaCelula = ComponenteFactory.novoJButton(this, true);
    JLabel labelDescricaoCelula = new JLabel();
    private String retornoParaPesquisa = "";
    MedicoContatoService service = new MedicoContatoService();
    private ArrayList<MedicoContatoVO> contatos = null;
    private ArrayList<MedicoContatoVO> listaContatosNovos = new ArrayList();
    private ArrayList<MedicoContatoVO> listaContatosAlterados = new ArrayList();
    private ArrayList<MedicoContatoVO> listaContatosRemovidos = new ArrayList();
    MedicoEnvioAutomaticoDTO medicoEnvioAutomatico = new MedicoEnvioAutomaticoDTO();
    private String senhaWeb = "";
    private String mensagem = "";
    private boolean medicoInativo = false;

    public Medico() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Medico (149)");
        }
        this.txtCodBairro.setUpperCase(true);
        this.txtCrm.setUpperCase(true);
        this.panelDestino.definirUpperCase();
        this.panelExame.definirUpperCase();
    }

    public void jbInit() throws Exception {
        this.setName("Medico");
        this.tabbed.setName("tabbed");
        if (this.isAlimentos()) {
            this.setLabelFormulario("Cadastro de coletadores");
            this.setLabelDescricao("Cadastro de coletadores");
        } else {
            this.setLabelFormulario("Cadastro de m\u00e9dicos");
            this.setLabelDescricao("Cadastro de m\u00e9dicos solicitantes e realizantes");
        }
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_medico.jpg"));
        this.labelConselho.setBounds(new Rectangle(7, 7, 90, 20));
        this.comboConselho.setBounds(new Rectangle(97, 7, 69, 20));
        this.comboConselho.setName("comboConselho");
        this.txtCrm.setBounds(new Rectangle(167, 7, 67, 20));
        this.txtCrm.setName("txtCrm");
        this.comboUf.setBounds(new Rectangle(235, 7, 67, 20));
        this.comboUf.setName("comboUf");
        this.jLabel2.setBounds(new Rectangle(7, 51, 41, 16));
        this.jLabel2.setDisplayedMnemonic('o');
        this.jLabel2.setLabelFor(this.txtNome);
        this.checkInativo.setBounds(new Rectangle(440, 7, 70, 20));
        this.checkInativo.setName("checkInativo");
        this.txtNome.setBounds(new Rectangle(97, 49, 400, 20));
        this.txtNome.setName("txtNome");
        this.jLabel3.setBounds(new Rectangle(7, 30, 86, 16));
        this.comboAbrev.setBounds(new Rectangle(97, 28, 69, 20));
        this.comboAbrev.setName("comboAbrev");
        this.jLabel4.setBounds(new Rectangle(7, 92, 41, 16));
        this.comboTipo.setBounds(new Rectangle(97, 91, 110, 20));
        this.comboTipo.setName("comboTipo");
        this.jLabel5.setText("Especialidade:");
        this.jLabel5.setBounds(new Rectangle(7, 72, 89, 16));
        this.jButton1.setBounds(new Rectangle(477, 70, 20, 20));
        this.jButton1.setText("");
        this.jButton1.setName("jButton1");
        Funcoes.imagemPesquisa(this.jButton1);
        this.jLabel6.setText("Cidade:");
        this.jLabel6.setBounds(new Rectangle(7, 114, 60, 16));
        this.txtCodCidade.setText("");
        this.txtCodCidade.setName("txtCodCidade");
        this.txtCodCidade.setBounds(new Rectangle(97, 112, 69, 20));
        this.txtDescEspecialidade.setText("");
        this.txtDescEspecialidade.setName("txtDescEspecialidade");
        this.txtDescEspecialidade.setEditable(false);
        this.txtDescEspecialidade.setBounds(new Rectangle(97, 70, 379, 20));
        this.txtDescCidade.setText("");
        this.txtDescCidade.setName("txtDescCidade");
        this.txtDescCidade.setEditable(false);
        this.txtDescCidade.setFocusable(false);
        this.txtDescCidade.setBounds(new Rectangle(188, 112, 309, 20));
        this.jLabel7.setText("Endere\u00e7o:");
        this.jLabel7.setBounds(new Rectangle(7, 135, 64, 16));
        this.comboTipoLogradouro.setBounds(new Rectangle(97, 133, 105, 19));
        this.comboTipoLogradouro.setName("comboTipoLogradouro");
        this.txtEndereco.setText("");
        this.txtEndereco.setName("txtEndereco");
        this.txtEndereco.setBounds(new Rectangle(203, 133, 205, 20));
        this.labelNumeroEndereco.setText("Nr.:");
        this.labelNumeroEndereco.setBounds(410, 133, 80, 20);
        this.txtNumeroEndereco.setText("");
        this.txtNumeroEndereco.setName("txtNumeroEndereco");
        this.txtNumeroEndereco.setBounds(new Rectangle(432, 133, 65, 20));
        this.jLabel8.setText("Complemento:");
        this.jLabel8.setBounds(new Rectangle(7, 156, 95, 16));
        this.txtComplemento.setText("");
        this.txtComplemento.setName("txtComplemento");
        this.txtComplemento.setBounds(new Rectangle(97, 154, 400, 20));
        this.jLabel9.setText("Bairro:");
        this.jLabel9.setBounds(new Rectangle(7, 177, 41, 16));
        this.txtCodBairro.setText("");
        this.txtCodBairro.setName("txtCodBairro");
        this.txtCodBairro.setBounds(new Rectangle(97, 175, 69, 20));
        this.txtDescBairro.setEditable(false);
        this.txtDescBairro.setName("txtDescBairro");
        this.txtDescBairro.setFocusable(false);
        this.txtDescBairro.setText("");
        this.txtDescBairro.setBounds(new Rectangle(188, 175, 309, 20));
        this.jLabel11.setText("CEP:");
        this.jLabel11.setBounds(new Rectangle(7, 198, 48, 16));
        this.txtCEP.setText("");
        this.txtCEP.setName("txtCEP");
        this.txtCEP.setBounds(new Rectangle(97, 196, 116, 20));
        this.bBuscaCep.setBounds(new Rectangle(214, 196, 20, 20));
        this.bBuscaCep.setName("bBuscaCep");
        this.jLabel12.setText("Fone:");
        this.jLabel12.setBounds(new Rectangle(343, 198, 48, 16));
        this.txtFone.clear();
        this.txtFone.setName("txtFone");
        this.txtFone.setBounds(new Rectangle(381, 196, 116, 20));
        this.jLabel13.setText("Celular:");
        this.jLabel13.setBounds(new Rectangle(7, 219, 48, 16));
        this.txtCelular.clear();
        this.txtCelular.setName("txtCelular");
        this.txtCelular.setBounds(new Rectangle(97, 217, 116, 20));
        this.jLabel14.setText("Fax:");
        this.jLabel14.setBounds(new Rectangle(343, 219, 48, 16));
        this.txtFax.clear();
        this.txtFax.setName("txtFax");
        this.txtFax.setBounds(new Rectangle(381, 217, 116, 20));
        this.jLabel15.setText("Observa\u00e7\u00e3o:");
        this.jLabel15.setBounds(new Rectangle(7, 322, 79, 16));
        this.txtObserv.setName("txtObserv");
        this.scroll = new JScrollPane(this.txtObserv);
        this.scroll.setBounds(new Rectangle(97, 322, 400, 57));
        this.jLabel17.setText("E-mail:");
        this.jLabel17.setBounds(new Rectangle(7, 240, 48, 16));
        this.txtEmail.setBounds(new Rectangle(97, 238, 280, 20));
        this.txtEmail.setName("txtEmail");
        this.buttonOutrosContatos.setBounds(new Rectangle(377, 238, 120, 20));
        this.buttonOutrosContatos.setName("buttonOutrosContatos");
        this.jLabel18.setText("Site:");
        this.jLabel18.setBounds(new Rectangle(7, 261, 48, 16));
        this.txtSite.setBounds(new Rectangle(97, 259, 400, 20));
        this.txtSite.setName("txtSite");
        this.labelCPF.setBounds(new Rectangle(7, 282, 65, 16));
        this.textCPF.setBounds(new Rectangle(97, 280, 150, 20));
        this.textCPF.setName("textCPF");
        this.labelNascimento.setBounds(new Rectangle(260, 282, 120, 16));
        this.textNascimento.setBounds(new Rectangle(381, 280, 96, 20));
        this.textNascimento.setName("textNascimento");
        this.buttonNascimento.setBounds(new Rectangle(477, 280, 20, 20));
        this.buttonNascimento.setName("buttonNascimento");
        this.jLabel16.setBounds(new Rectangle(7, 303, 65, 16));
        this.txtComissao.setBounds(new Rectangle(97, 301, 69, 20));
        this.txtComissao.setName("txtComissao");
        this.labelCBO.setBounds(new Rectangle(245, 303, 65, 16));
        this.comboCBO.setBounds(new Rectangle(291, 301, 205, 20));
        this.comboCBO.setName("comboCBO");
        this.jLabel19.setText("%");
        this.jLabel19.setBounds(new Rectangle(167, 303, 48, 16));
        this.jButton2.setText("");
        this.jButton2.setName("jButton2");
        Funcoes.imagemPesquisa(this.jButton2);
        this.jButton2.setBounds(new Rectangle(167, 112, 20, 20));
        this.jButton3.setBounds(new Rectangle(167, 175, 20, 20));
        this.jButton3.setName("jButton3");
        Funcoes.imagemPesquisa(this.jButton3);
        this.jButton1.setFocusable(false);
        this.buttonSenhaWeb.setBounds(new Rectangle(377, 380, 120, 20));
        this.buttonSenhaWeb.setName("buttonSenhaWeb");
        this.buttonSenhaWeb.setMnemonic('w');
        this.buttonComissoes.setBounds(new Rectangle(97, 380, 100, 20));
        this.buttonComissoes.setName("buttonComissoes");
        this.buttonSMSEmail.setBounds(new Rectangle(377, 401, 120, 20));
        this.buttonSMSEmail.setName("buttonSMSEmail");
        this.buttonMensagem.setBounds(new Rectangle(240, 380, 100, 20));
        this.buttonMensagem.setName("buttonMensagem");
        this.txtObserv.setWrapStyleWord(true);
        this.txtObserv.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.txtObserv);
        this.buttonComissoes.setVisible(false);
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.txtFone, this.txtFax, this.txtCelular);
        this.comboCBO.removeAllItems();
        this.comboCBO.addItem("");
        List<CBOS.CBO> listaCBOs = Arrays.asList(CBOS.getCBOS(null));
        List<CBOS.CBO> listaOrdenada = listaCBOs.stream().sorted(Comparator.comparing(c -> c.descricao, Collator.getInstance(new Locale("pt", "BR")))).collect(Collectors.toList());
        listaOrdenada.forEach(s -> this.comboCBO.addItem(new ObjetoCBO(s.codigo, s.descricao)));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medico.this.adicionaEspecialidade();
            }
        });
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medico.this.buscaCidade();
            }
        });
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medico.this.buscaBairro();
            }
        });
        this.buttonComissoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConveniosAutorizados conveniosAutorizados = new ConveniosAutorizados((JFrame)Medico.this.getTopLevelAncestor(), "Comiss\u00e3o");
                conveniosAutorizados.setConvenios(Medico.this.convenioComissao);
                conveniosAutorizados.setVisible(true);
                Medico.this.convenioComissao = conveniosAutorizados.getComissoes();
            }
        });
        this.buttonSenhaWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SenhaWeb senha = new SenhaWeb((Window)Medico.this.getTopLevelAncestor(), false, Medico.this.comboConselho.getSelectedItem().toString(), Medico.this.txtCrm.getText(), Medico.this.comboUf.getSelectedItem().toString(), Medico.this.txtEmail.getText(), Medico.this.getContatos(), Medico.this.txtCelular.getText(), true, true);
                senha.setSenha(Medico.this.senhaWeb);
                senha.setVisible(true);
                if (senha.getSalvarPressionado()) {
                    Medico.this.senhaWeb = senha.getSenha();
                }
                if (senha.isEmailEnviado()) {
                    Medico.this.senhaWeb = senha.getSenha();
                    Medico.this.salvar(false);
                    Medico.this.setStatus(3);
                }
                senha = null;
            }
        });
        this.txtEmail.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(Medico.this.txtEmail) && Medico.this.txtEmail.getText().trim().matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$")) {
                    Medico.this.buttonOutrosContatos.setEnabled(!Funcoes.textoVazio(Medico.this.txtEmail));
                } else {
                    Medico.this.buttonOutrosContatos.setEnabled(false);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.buttonOutrosContatos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medico.this.emailOutrosContatos();
            }
        });
        this.comboTipo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medico.this.txtComissao.setEnabled(Medico.this.comboTipo.getSelectedIndex() == 1);
                Medico.this.buttonComissoes.setVisible(Medico.this.comboTipo.getSelectedIndex() == 1);
            }
        });
        this.txtFone.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(Medico.this.txtFone.getText())) {
                    Medico.this.txtFone.setValue(null);
                }
            }
        });
        this.txtFax.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(Medico.this.txtFax.getText())) {
                    Medico.this.txtFax.setValue(null);
                }
            }
        });
        this.txtCelular.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(Medico.this.txtCelular.getText())) {
                    Medico.this.txtCelular.setValue(null);
                }
            }
        });
        this.textCodigoCelula.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(Medico.this.textCodigoCelula.getText())) {
                    try {
                        AbstractThreadBean vo = new CelulaEstoqueService().getVO(Medico.this.textCodigoCelula.getText());
                        if (vo != null) {
                            Medico.this.labelDescricaoCelula.setText(((CelulaEstoqueVO)vo).getDescricao());
                        } else {
                            Medico.this.labelDescricaoCelula.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(Medico.this, ex.getMessage(), ex.getStackTrace(), "Medico (361)");
                        Medico.this.controlaCampos();
                    }
                }
            }
        });
        this.painelCentral.setLayout(new BorderLayout());
        this.painelCentral.add((Component)this.tabbed, "Center");
        this.tabbed.add((Component)this.panelDados, "Dados");
        this.tabbed.add((Component)this.panelConvenios, "Conv\u00eanios");
        this.tabbed.add((Component)this.panelDestinos, "Adicionais");
        this.montaConvenios();
        this.montaDestinos();
        this.panelDados.add(this.labelConselho);
        this.panelDados.add(this.comboConselho);
        this.panelDados.add(this.jLabel2);
        this.panelDados.add(this.txtCrm);
        this.panelDados.add(this.comboUf);
        this.panelDados.add(this.jLabel5);
        this.panelDados.add(this.jLabel4);
        this.panelDados.add(this.jLabel3);
        this.panelDados.add(this.comboAbrev);
        this.panelDados.add(this.txtNome);
        this.panelDados.add(this.comboTipo);
        this.panelDados.add(this.jButton1);
        this.panelDados.add(this.txtDescEspecialidade);
        this.panelDados.add(this.jLabel11);
        this.panelDados.add(this.txtCodCidade);
        this.panelDados.add(this.jButton2);
        this.panelDados.add(this.txtDescCidade);
        this.panelDados.add(this.scroll);
        this.panelDados.add(this.jLabel15);
        this.panelDados.add(this.jLabel16);
        this.panelDados.add(this.txtComissao);
        this.panelDados.add(this.jLabel17);
        this.panelDados.add(this.txtEmail);
        this.panelDados.add(this.buttonOutrosContatos);
        this.panelDados.add(this.txtSite);
        this.panelDados.add(this.jLabel18);
        this.panelDados.add(this.jLabel14);
        this.panelDados.add(this.jLabel12);
        this.panelDados.add(this.txtFone);
        this.panelDados.add(this.txtFax);
        this.panelDados.add(this.txtCelular);
        this.panelDados.add(this.txtCEP);
        this.panelDados.add(this.txtCodBairro);
        this.panelDados.add(this.jButton3);
        this.panelDados.add(this.jLabel9);
        this.panelDados.add(this.txtDescBairro);
        this.panelDados.add(this.txtComplemento);
        this.panelDados.add(this.jLabel8);
        this.panelDados.add(this.jLabel7);
        this.panelDados.add(this.txtEndereco);
        this.panelDados.add(this.comboTipoLogradouro);
        this.panelDados.add(this.labelNumeroEndereco);
        this.panelDados.add(this.txtNumeroEndereco);
        this.panelDados.add(this.jLabel6);
        this.panelDados.add(this.buttonSenhaWeb);
        this.panelDados.add(this.buttonComissoes);
        this.panelDados.add(this.buttonMensagem);
        this.panelDados.add(this.buttonSMSEmail);
        this.panelDados.add(this.jLabel13);
        this.panelDados.add(this.jLabel19);
        this.panelDados.add(this.labelCBO);
        this.panelDados.add(this.comboCBO);
        this.panelDados.add(this.labelCPF);
        this.panelDados.add(this.textCPF);
        this.panelDados.add(this.labelNascimento);
        this.panelDados.add(this.textNascimento);
        this.panelDados.add(this.buttonNascimento);
        this.panelDados.add(this.bBuscaCep);
        this.panelDados.add(this.checkInativo);
        if (!Funcoes.textoVazio(ParametrosGerais.getUfDefault())) {
            this.comboUf.setSelectedItem(ParametrosGerais.getUfDefault());
        }
        this.controlaCampos();
        this.comboUf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(Medico.this.txtCrm.getText())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuilder buf = new StringBuilder("select a.med_nome, a.med_nome, a.med_abrev, a.med_observ, a.med_tipo, ");
                            buf.append(" a.med_comissao, a.med_complemento, a.med_endereco, a.med_numeroendereco, a. med_tipologradouroendereco, a.med_celular, a.med_fax, a.med_fone, a.med_cep, a.med_email, a.med_site, ");
                            buf.append("b.cid_nome, b.cid_uf, a.cid_codigo, c.bai_descricao, a.bai_codigo, a.med_senhaweb, a.med_cbo, a.med_cpf, a.med_datanascimento, ");
                            buf.append("a.med_mensagem, a.med_inativo, a.cel_codigo, l.cel_descricao, fil.fil_emailsenhawebmedico, ");
                            buf.append("a.med_bloquearsmsexamepronto, a.med_bloquearsmsrecoleta, a.med_bloquearemailexamepronto, a.med_bloquearemailrecoleta, a.med_bloquearpushexamepronto, a.med_bloquearpushrecoleta, ");
                            buf.append("a.med_bloquearwhatsappexamepronto, a.med_bloquearwhatsapprecoleta ");
                            buf.append("from medico a ");
                            buf.append("left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo=b.cid_codigo ");
                            buf.append("left join bairro c on a.fil_codigo = c.fil_codigo and upper(a.bai_codigo)=upper(c.bai_codigo) ");
                            buf.append("left join celulaestoque l on a.fil_codigo = l.fil_codigo and a.cel_codigo = l.cel_codigo ");
                            buf.append("left join filiais_postocoleta fil on a.fil_codigo = fil.fil_codigo ");
                            buf.append(" where a.fil_codigo=" + Variaveis.filialPadrao + " and a.med_conselho = ").append(StringUtil.textoDBEscape(Medico.this.comboConselho.getSelectedItem().toString()));
                            buf.append("and upper(a.med_crm)=upper(").append(Medico.this.txtCrm.getTextDBEscape()).append(") and med_uf=").append(StringUtil.textoDBEscape(Medico.this.comboUf.getSelectedItem().toString()));
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs != null && rs.next()) {
                                Object dados;
                                Medico.this.txtNome.setText(rs.getString("med_nome"));
                                Medico.this.txtCodCidade.setText(rs.getString("cid_codigo"));
                                if (!DBUtil.campoNull(rs.getString("cid_nome"))) {
                                    Medico.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                                }
                                Medico.this.txtCodBairro.setText(rs.getString("bai_codigo"));
                                Medico.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                                Medico.this.txtEndereco.setText(rs.getString("med_endereco"));
                                Medico.this.txtNumeroEndereco.setText(rs.getString("med_numeroendereco"));
                                Medico.this.comboTipoLogradouro.setSelectedItem(Tipos.tipoLogradouroDescricao(rs.getString("med_tipologradouroendereco")));
                                Medico.this.txtComplemento.setText(rs.getString("med_complemento"));
                                Medico.this.txtCEP.setText(rs.getString("med_cep"));
                                Medico.this.txtFone.setText(rs.getString("med_fone"));
                                Medico.this.txtFax.setText(rs.getString("med_fax"));
                                Medico.this.txtCelular.setText(rs.getString("med_celular"));
                                Medico.this.txtEmail.setText(rs.getString("med_email"));
                                Medico.this.txtSite.setText(rs.getString("med_site"));
                                Medico.this.txtComissao.setText(Funcoes.formataDecimal(Medico.this.txtComissao.getMaskDecimal(), rs.getDouble("med_comissao")));
                                Medico.this.txtObserv.setText(rs.getString("med_observ"));
                                Medico.this.comboTipo.setSelectedIndex(!DBUtil.campoNull(rs.getString("med_tipo")) && rs.getString("med_tipo").equals("S") ? 0 : 1);
                                Medico.this.medicoEnvioAutomatico.setBloquearEmailExamePronto(rs.getBoolean("med_bloquearemailexamepronto"));
                                Medico.this.medicoEnvioAutomatico.setBloquearEmailRecoleta(rs.getBoolean("med_bloquearemailrecoleta"));
                                Medico.this.medicoEnvioAutomatico.setBloquearSMSExamePronto(rs.getBoolean("med_bloquearsmsexamepronto"));
                                Medico.this.medicoEnvioAutomatico.setBloquearSMSRecoleta(rs.getBoolean("med_bloquearsmsrecoleta"));
                                Medico.this.medicoEnvioAutomatico.setBloquearPushExamePronto(rs.getBoolean("med_bloquearpushexamepronto"));
                                Medico.this.medicoEnvioAutomatico.setBloquearPushRecoleta(rs.getBoolean("med_bloquearpushrecoleta"));
                                Medico.this.medicoEnvioAutomatico.setBloquearWhatsAppExamePronto(rs.getBoolean("med_bloquearwhatsappexamepronto"));
                                Medico.this.medicoEnvioAutomatico.setBloquearWhatsAppRecoleta(rs.getBoolean("med_bloquearwhatsapprecoleta"));
                                if (!Funcoes.textoVazio(rs.getString("med_cpf"))) {
                                    Medico.this.textCPF.setText(rs.getString("med_cpf").replaceAll("[.-/-]", ""));
                                }
                                if (!DBUtil.campoNull(rs.getString("med_datanascimento"))) {
                                    Medico.this.textNascimento.setText(Funcoes.formataData(rs.getDate("med_datanascimento")));
                                }
                                if (!DBUtil.campoNull(rs.getString("med_abrev"))) {
                                    Medico.this.comboAbrev.setSelectedItem(rs.getString("med_abrev"));
                                }
                                Medico.this.senhaWeb = !DBUtil.campoNull(rs.getString("med_senhaweb")) ? rs.getString("med_senhaweb") : "";
                                Medico.this.mensagem = rs.getString("med_mensagem");
                                String cbo = rs.getString("med_cbo");
                                Medico.this.comboCBO.setSelectedIndex(0);
                                Medico.this.checkInativo.setSelected(rs.getBoolean("med_inativo"));
                                if (!Funcoes.textoVazio(cbo)) {
                                    String codigoCbo = StringUtil.getValor(cbo, "codigo");
                                    String descricaoCbo = StringUtil.getValor(cbo, "descricao");
                                    if (!Funcoes.textoVazio(cbo)) {
                                        for (int i = 0; i < Medico.this.comboCBO.getItemCount(); ++i) {
                                            ObjetoCBO o;
                                            if (!(Medico.this.comboCBO.getItemAt(i) instanceof ObjetoCBO) || !(o = (ObjetoCBO)Medico.this.comboCBO.getItemAt(i)).getCodigo().equalsIgnoreCase(codigoCbo) || !Funcoes.textoVazio(descricaoCbo) && !StringUtil.removerAcentos(o.getNome()).toLowerCase().equalsIgnoreCase(StringUtil.removerAcentos(descricaoCbo).toLowerCase())) continue;
                                            Medico.this.comboCBO.setSelectedIndex(i);
                                            break;
                                        }
                                    }
                                }
                                if (!DBUtil.campoNull(rs.getString("cel_codigo"))) {
                                    Medico.this.textCodigoCelula.setText(rs.getString("cel_codigo"));
                                    Medico.this.labelDescricaoCelula.setText(rs.getString("cel_descricao"));
                                }
                                if (Medico.this.getStatus() == 2) {
                                    Medico.this.setStatus(3);
                                }
                                Medico.this.txtCrm.setEnabled(false);
                                Medico.this.comboConselho.setEnabled(false);
                                Medico.this.comboUf.setEnabled(false);
                                Medico.this.txtDescEspecialidade.clear();
                                buf.delete(0, buf.length());
                                buf.append("select a.esp_codigo, b.esp_descricao from medicoespecialidades a ");
                                buf.append("left join especialidades b on a.fil_codigo = b.fil_codigo and a.esp_codigo=b.esp_codigo ");
                                buf.append(" where a.fil_codigo=");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and a.med_conselho = ").append(StringUtil.textoDBEscape(Medico.this.comboConselho.getSelectedItem().toString()));
                                buf.append(" and upper(a.med_crm)=upper(").append(Medico.this.txtCrm.getTextDBEscape()).append(") ");
                                buf.append(" and med_uf=").append(StringUtil.textoDBEscape(Medico.this.comboUf.getSelectedItem().toString()));
                                rs = Conexao.executeQuery(st, buf.toString());
                                if (rs != null) {
                                    while (rs.next()) {
                                        String esp = rs.getString("esp_descricao");
                                        Medico.this.medicoEspecialidade.add(new DadosME(rs.getInt("esp_codigo"), esp));
                                        Medico.this.txtDescEspecialidade.setText(Medico.this.txtDescEspecialidade.getText() + (Funcoes.textoVazio(Medico.this.txtDescEspecialidade.getText()) ? "" : ",") + esp);
                                    }
                                }
                                buf.delete(0, buf.length());
                                buf.append("select a.con_codigo, a.mco_comissao, b.con_fantasia from medicoconvenio a ");
                                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                                buf.append("where a.fil_codigo=");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and med_conselho = ").append(StringUtil.textoDBEscape(Medico.this.comboConselho.getSelectedItem().toString()));
                                buf.append(" and upper(med_crm)=upper(").append(Medico.this.txtCrm.getTextDBEscape()).append(") ");
                                buf.append(" and med_uf=").append(StringUtil.textoDBEscape(Medico.this.comboUf.getSelectedItem().toString()));
                                rs = Conexao.executeQuery(st, buf.toString());
                                if (rs != null) {
                                    while (rs.next()) {
                                        dados = new DadosConvenio(rs.getInt("con_codigo"), rs.getString("con_fantasia"), rs.getDouble("mco_comissao"));
                                        Medico.this.convenioComissao.add(dados);
                                    }
                                }
                                buf.delete(0, buf.length());
                                buf.append("select a.con_codigo, b.con_fantasia from medicoconvenioproibido a ");
                                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                                buf.append("where a.fil_codigo=");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and med_conselho = ").append(StringUtil.textoDBEscape(Medico.this.comboConselho.getSelectedItem().toString()));
                                buf.append(" and upper(med_crm)=upper(").append(Medico.this.txtCrm.getTextDBEscape()).append(") ");
                                buf.append(" and med_uf=").append(StringUtil.textoDBEscape(Medico.this.comboUf.getSelectedItem().toString()));
                                rs = Conexao.executeQuery(st, buf.toString());
                                if (rs != null) {
                                    while (rs.next()) {
                                        dados = new ObjetoMedicoConvenioProibido(rs.getString("con_codigo"), rs.getString("con_fantasia"));
                                        Medico.this.convenioAutorizado.add(dados);
                                    }
                                }
                                Medico.this.panelProibidos.setConveniosProibidos(Medico.this.convenioAutorizado);
                                buf.delete(0, buf.length());
                                buf.append("select a.con_codigo, a.mec_codigooperadora, b.con_fantasia from medicoconveniotiss a ");
                                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                                buf.append("where a.fil_codigo=");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and med_conselho = ").append(StringUtil.textoDBEscape(Medico.this.comboConselho.getSelectedItem().toString()));
                                buf.append(" and upper(med_crm)=upper(").append(Medico.this.txtCrm.getTextDBEscape()).append(") ");
                                buf.append(" and med_uf=").append(StringUtil.textoDBEscape(Medico.this.comboUf.getSelectedItem().toString()));
                                rs = Conexao.executeQuery(st, buf.toString());
                                if (rs != null) {
                                    while (rs.next()) {
                                        dados = new ObjetoMedicoConvenioTISS(rs.getString("con_codigo"), rs.getString("con_fantasia"), rs.getString("mec_codigooperadora"));
                                        Medico.this.convenioTiss.add(dados);
                                    }
                                }
                                Medico.this.panelTiss.setConveniosTiss(Medico.this.convenioTiss);
                                buf.delete(0, buf.length());
                                buf.append("select a.des_codigo, b.des_descricao, a.mde_tipo from medicodestino a ");
                                buf.append("left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
                                buf.append("where a.fil_codigo=");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and med_conselho = ").append(StringUtil.textoDBEscape(Medico.this.comboConselho.getSelectedItem().toString()));
                                buf.append(" and upper(med_crm)=upper(").append(Medico.this.txtCrm.getTextDBEscape()).append(") ");
                                buf.append(" and med_uf=").append(StringUtil.textoDBEscape(Medico.this.comboUf.getSelectedItem().toString()));
                                buf.append(" order by b.des_descricao");
                                rs = Conexao.executeQuery(st, buf.toString());
                                if (rs != null) {
                                    while (rs.next()) {
                                        Medico.this.medicoDestino.add(new ObjetoMedicoDestino(rs.getString("des_codigo"), rs.getString("des_descricao"), Tipos.tipoMedicoDestino(rs.getString("mde_tipo"))));
                                    }
                                }
                                Medico.this.panelDestino.setDestinos(Medico.this.medicoDestino);
                                buf.delete(0, buf.length());
                                buf.append("select a.exa_codigo, b.exa_descricao, a.mew_proibido from medicoexameweb a ");
                                buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                                buf.append("where a.fil_codigo = ");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and med_conselho = ").append(StringUtil.textoDBEscape(Medico.this.comboConselho.getSelectedItem().toString()));
                                buf.append(" and upper(med_crm)=upper(").append(Medico.this.txtCrm.getTextDBEscape()).append(") ");
                                buf.append(" and med_uf=").append(StringUtil.textoDBEscape(Medico.this.comboUf.getSelectedItem().toString()));
                                buf.append(" order by b.exa_descricao ");
                                rs = Conexao.executeQuery(st, buf.toString());
                                if (rs != null) {
                                    while (rs.next()) {
                                        dados = new ObjetoMedicoExame(rs.getString("exa_codigo"), rs.getString("exa_descricao"), rs.getInt("mew_proibido"));
                                        Medico.this.medicoExame.add(dados);
                                    }
                                }
                                Medico.this.panelExame.setExames(Medico.this.medicoExame);
                                Medico.this.buttonOutrosContatos.setEnabled(!Funcoes.textoVazio(Medico.this.txtEmail));
                                Medico.this.carregarContatos();
                                ScreenUtil.requisitarFoco(Medico.this.txtNome);
                            } else if (Medico.this.getStatus() == 3) {
                                Funcoes.mensagem(Medico.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Medico.this.setStatus(1);
                                Medico.this.controlaCampos();
                            }
                        }
                        Conexao.fecharStatement(st);
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Medico.this, sqlex.getMessage(), sqlex.getStackTrace(), "Medico (569)");
                    }
                }
            }
        });
        this.txtCodCidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Medico.this.txtCodCidade.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select cid_nome, cid_uf from cidades where fil_codigo = " + Variaveis.filialPadrao + " and cid_codigo=" + Medico.this.txtCodCidade.getText());
                        if (rs.next()) {
                            Medico.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                        } else {
                            Medico.this.txtDescCidade.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Medico.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Medico.this.setStatus(1);
                        Medico.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodBairro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Medico.this.txtCodBairro.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select bai_descricao from bairro where fil_codigo = " + Variaveis.filialPadrao + " and upper(bai_codigo)=upper(" + Medico.this.txtCodBairro.getTextDBEscape() + ") ");
                        if (rs.next()) {
                            Medico.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                        } else {
                            Medico.this.txtDescBairro.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Medico.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Medico.this.setStatus(1);
                        Medico.this.controlaCampos();
                    }
                }
            }
        });
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtEmail.setUpperCase(false);
        this.txtSite.setUpperCase(false);
        this.txtCEP.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    CEP.buscarCEP(Medico.this.comboTipoLogradouro, Medico.this.txtCEP, Medico.this.txtEndereco, Medico.this.txtCodCidade, Medico.this.txtDescCidade, Medico.this.txtCodBairro, Medico.this.txtDescBairro, Medico.this);
                }
            }
        });
        this.txtCEP.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean validaCEP;
                if (!Funcoes.textoVazio(Medico.this.txtCEP) && e.getOppositeComponent() != null && e.getOppositeComponent().getParent() == Medico.this.txtCEP.getParent() && !(validaCEP = CEP.cepValido(Medico.this.txtCEP))) {
                    ScreenUtil.requisitarFoco(Medico.this.txtCEP);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private void carregarContatos() {
        try {
            if (!this.contemContatos(this.contatos)) {
                this.contatos = this.getContatosMedico();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar contatos.\n" + ex.getMessage(), ex.getStackTrace(), "Medico");
        }
    }

    protected ArrayList<String> getContatos() {
        ArrayList<String> emails = new ArrayList<String>();
        if (this.contemContatos(this.contatos)) {
            for (MedicoContatoVO con : this.contatos) {
                if (!con.getEnviarEmail().booleanValue()) continue;
                emails.add(con.getContatoEmail());
            }
        }
        return emails;
    }

    private void emailOutrosContatos() {
        try {
            if (!this.contemContatos(this.contatos)) {
                this.contatos = this.getContatosMedico();
            }
            MedicoContato tela = MedicoContato.novaInstancia(Laboratorio.getInstancia(), this.contatos, this.listaContatosAlterados, this.listaContatosNovos, this.listaContatosRemovidos);
            tela.setVisible(true);
            if (tela.isOK()) {
                this.limpaListas();
                this.contatos.addAll(tela.getListaContatos());
                this.listaContatosAlterados.addAll(tela.getListaContatosAlterados());
                this.listaContatosRemovidos.addAll(tela.getListaContatosRemovidos());
                this.listaContatosNovos.addAll(tela.getListaContatosNovos());
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar e-mail de contatos.\n" + ex.getMessage(), ex.getStackTrace(), "Medico");
        }
    }

    private void limpaListas() {
        if (this.contemContatos(this.contatos)) {
            this.contatos.clear();
        }
        this.listaContatosAlterados.clear();
        this.listaContatosRemovidos.clear();
        this.listaContatosNovos.clear();
    }

    private ArrayList<MedicoContatoVO> getContatosMedico() throws SQLException {
        return this.service.getContatosMedico(Variaveis.filialPadrao, this.txtCrm.getText(), this.comboConselho.getSelectedItem().toString(), this.comboUf.getSelectedItem().toString());
    }

    private void montaDestinos() {
        JPanel pp = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Exames bloqueados para internet"));
        JPanel p = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Destinos"));
        p.add((Component)this.panelDestino, "Center");
        pp.add((Component)this.panelExame, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.panelDestinos.add((Component)p, c);
        ++c.gridy;
        this.panelDestinos.add((Component)pp, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.panelCelulaEstoque.setPreferredSize(new Dimension(100, 45));
        this.panelCelulaEstoque.setBorder(new TitledBorder("C\u00e9lula de estoque"));
        this.panelDestinos.add((Component)this.panelCelulaEstoque, c);
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.fill = 0;
        this.panelCelulaEstoque.add((Component)new JLabel("C\u00e9lula:"), gb);
        ++gb.gridx;
        this.textCodigoCelula.setPreferredSize(new Dimension(70, 20));
        this.textCodigoCelula.setMinimumSize(this.textCodigoCelula.getPreferredSize());
        this.panelCelulaEstoque.add((Component)this.textCodigoCelula, gb);
        ++gb.gridx;
        this.buttonBuscaCelula.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaCelula.setMinimumSize(this.buttonBuscaCelula.getPreferredSize());
        this.panelCelulaEstoque.add((Component)this.buttonBuscaCelula, gb);
        ++gb.gridx;
        gb.fill = 2;
        gb.weightx = 1.0;
        this.labelDescricaoCelula.setPreferredSize(new Dimension(80, 20));
        this.labelDescricaoCelula.setMinimumSize(new Dimension(80, 20));
        this.labelDescricaoCelula.setBorder(new TitledBorder(""));
        this.panelCelulaEstoque.add((Component)this.labelDescricaoCelula, gb);
    }

    private void montaConvenios() {
        JPanel p = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Conv\u00eanios n\u00e3o autorizados"));
        JPanel pp = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("C\u00f3digo na operadora"));
        p.add((Component)this.panelProibidos, "Center");
        pp.add((Component)this.panelTiss, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelConvenios.add((Component)p, c);
        ++c.gridx;
        this.panelConvenios.add((Component)pp, c);
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Medico.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101500201"));
        this.setModuloEdita(Long.parseLong("0101500202"));
        this.setModuloApaga(Long.parseLong("0101500203"));
        this.buttonSenhaWeb.setVisible(Acesso.getAcesso(Long.parseLong("0101500204")));
        this.buttonMensagem.setVisible(Acesso.getAcesso(101500205L));
        this.buttonSMSEmail.setVisible(true);
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.medico(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.comboConselho.setSelectedItem(resultado.get("med_conselho").toString());
            this.txtCrm.setText(resultado.get("med_crm").toString());
            this.comboUf.setSelectedItem(resultado.get("med_uf").toString());
        }
        this.comboUf.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos(true);
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.txtCrm.setDocument(new TTextField().criaDocument(10, 3));
        this.txtCrm.setUpperCase(true);
        this.limparCampos(true);
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.comboUf.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos(true);
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("medicoconvenio", 1);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                    salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                    salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.limpar();
                    salvar.setTabela("medicodestino");
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                    salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                    salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.setTabela("medico");
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "conselhoMedico", this.comboConselho.getSelectedItem().toString(), "crmMedico", this.txtCrm.getText(), "ufMedico", this.comboUf.getSelectedItem().toString()};
                    if (Variaveis.exportarWebFilial) {
                        DBUtil.insereExportaWeb(statement, "medicos", "D", ParametrosGerais.getCopiaMedico(), comando);
                        String[] comando2 = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "conselhoMedicoExame", this.comboConselho.getSelectedItem().toString(), "crmMedicoExame", this.txtCrm.getText(), "ufMedicoExame", this.comboUf.getSelectedItem().toString()};
                        DBUtil.insereExportaWeb(statement, "medicosexames", "D", ParametrosGerais.getCopiaMedico(), comando2);
                    }
                    DBUtil.gravaAutoCopiaWeb("medicos", Variaveis.filialPadrao, ParametrosGerais.getCopiaMedico(), statement, comando, 1, "D", true);
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Medico");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos(false);
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.txtCrm.setDocument(new TTextField().criaDocument(10, 18));
        this.txtCrm.setUpperCase(true);
        this.limparCampos(true);
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodCidade.setText(String.valueOf(ParametrosGerais.getCidCodigo()));
        this.comboConselho.grabFocus();
    }

    @Override
    public void salvar() {
        this.salvar(true);
    }

    public void salvar(boolean limparCampos) {
        if (this.validaCampos()) {
            Statement statement = Conexao.getStatement();
            if (Funcoes.textoVazio(this.senhaWeb) && this.getStatus() == 2) {
                this.senhaWeb = Funcoes.gerarSenhaWeb();
            } else if (Funcoes.textoVazio(this.senhaWeb) && this.getStatus() == 3 && Funcoes.mensagem(this, "A senha web n\u00e3o foi definida, deseja gerar uma senha autom\u00e1tica?", 4) == 0) {
                this.senhaWeb = Funcoes.gerarSenhaWeb();
            }
            if (statement != null) {
                try {
                    int i;
                    SalvaDados salvar = new SalvaDados("medico", this.getStatus() == 2 ? 0 : 2);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                    salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape().trim());
                    salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                    salvar.adicionaCampo("cid_codigo", 2, true, false, this.txtCodCidade.getText());
                    salvar.adicionaCampo("med_nome", 0, true, false, this.txtNome.getTextDBEscape());
                    salvar.adicionaCampo("med_abrev", 0, true, false, StringUtil.textoDBEscape(this.comboAbrev.getSelectedItem().toString()));
                    salvar.adicionaCampo("med_observ", 0, true, false, StringUtil.textoDBEscape(this.txtObserv.getText()));
                    salvar.adicionaCampo("med_tipo", 0, true, false, StringUtil.textoDBEscape(this.comboTipo.getSelectedItem().toString().substring(0, 1)));
                    salvar.adicionaCampo("med_comissao", 2, true, false, Funcoes.limpaDecimal(this.txtComissao.getText()));
                    salvar.adicionaCampo("med_complemento", 0, true, false, this.txtComplemento.getTextDBEscape());
                    salvar.adicionaCampo("med_tipologradouroendereco", 0, true, false, StringUtil.textoDBEscape(Tipos.tipoLogradouro(this.comboTipoLogradouro.getSelectedItem().toString())));
                    salvar.adicionaCampo("med_endereco", 0, true, false, this.txtEndereco.getTextDBEscape());
                    salvar.adicionaCampo("med_numeroendereco", 0, true, false, this.txtNumeroEndereco.getTextDBEscape());
                    salvar.adicionaCampo("med_celular", 0, true, false, this.txtCelular.getTextDBEscape());
                    salvar.adicionaCampo("med_fax", 0, true, false, this.txtFax.getTextDBEscape());
                    salvar.adicionaCampo("med_fone", 0, true, false, this.txtFone.getTextDBEscape());
                    salvar.adicionaCampo("bai_codigo", 0, true, false, !Funcoes.textoVazio(this.txtCodBairro.getText()) ? StringUtil.textoDBEscape(this.txtCodBairro.getText()) : null);
                    salvar.adicionaCampo("med_cep", 0, true, false, this.txtCEP.getTextDBEscape());
                    salvar.adicionaCampo("med_site", 0, true, false, this.txtSite.getTextDBEscape());
                    salvar.adicionaCampo("med_senhaweb", 0, true, false, StringUtil.textoDBEscape(this.senhaWeb));
                    salvar.adicionaCampo("med_email", 0, true, false, this.txtEmail.getTextDBEscape());
                    salvar.adicionaCampo("med_cpf", 0, true, false, this.textCPF.getTextDBEscape());
                    salvar.adicionaCampo("med_datanascimento", 1, true, false, this.textNascimento.getText());
                    salvar.adicionaCampo("med_mensagem", 0, true, false, StringUtil.textoDBEscape(this.mensagem));
                    salvar.adicionaCampo("med_inativo", 4, true, false, this.checkInativo.isSelected());
                    salvar.adicionaCampo("med_bloquearsmsexamepronto", 4, true, false, this.medicoEnvioAutomatico.isBloquearSMSExamePronto());
                    salvar.adicionaCampo("med_bloquearsmsrecoleta", 4, true, false, this.medicoEnvioAutomatico.isBloquearSMSRecoleta());
                    salvar.adicionaCampo("med_bloquearemailexamepronto", 4, true, false, this.medicoEnvioAutomatico.isBloquearEmailExamePronto());
                    salvar.adicionaCampo("med_bloquearemailrecoleta", 4, true, false, this.medicoEnvioAutomatico.isBloquearEmailRecoleta());
                    salvar.adicionaCampo("med_bloquearpushexamepronto", 4, true, false, this.medicoEnvioAutomatico.isBloquearPushExamePronto());
                    salvar.adicionaCampo("med_bloquearpushrecoleta", 4, true, false, this.medicoEnvioAutomatico.isBloquearPushRecoleta());
                    salvar.adicionaCampo("med_bloquearwhatsappexamepronto", 4, true, false, this.medicoEnvioAutomatico.isBloquearWhatsAppExamePronto());
                    salvar.adicionaCampo("med_bloquearwhatsapprecoleta", 4, true, false, this.medicoEnvioAutomatico.isBloquearWhatsAppRecoleta());
                    String cbo = "";
                    if (this.comboCBO.getSelectedItem() instanceof ObjetoCBO) {
                        cbo = ((ObjetoCBO)this.comboCBO.getSelectedItem()).getXml();
                    }
                    salvar.adicionaCampo("med_cbo", 0, true, false, StringUtil.textoDBEscape(cbo));
                    salvar.adicionaCampo("cel_codigo", 2, true, false, Funcoes.isNumeric(this.textCodigoCelula.getText()) ? this.textCodigoCelula.getText() : null);
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.limpar();
                    salvar.setOperacao(1);
                    salvar.setTabela("medicoespecialidades");
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                    salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                    salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.setTabela("medicoconvenio");
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.setTabela("medicoconvenioproibido");
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.setTabela("medicoexameweb");
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.setTabela("medicoconveniotiss");
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.setTabela("medicodestino");
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                    salvar.setOperacao(0);
                    if (this.medicoEspecialidade.size() > 0) {
                        salvar.setTabela("medicoespecialidades");
                        for (i = 0; i < this.medicoEspecialidade.size(); ++i) {
                            int codigo = this.medicoEspecialidade.get(i).getCodEspecialidade();
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("esp_codigo", 2, false, true, codigo);
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    if (this.convenioComissao.size() > 0) {
                        salvar.setTabela("medicoconvenio");
                        for (i = 0; i < this.convenioComissao.size(); ++i) {
                            int convenio = ((DadosConvenio)this.convenioComissao.get(i)).getCodConvenio();
                            double comissao = ((DadosConvenio)this.convenioComissao.get(i)).getComissaoMedico();
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("con_codigo", 2, false, true, convenio);
                            salvar.adicionaCampo("mco_comissao", 2, true, false, Funcoes.limpaDecimal(String.valueOf(comissao)));
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    this.convenioAutorizado = this.panelProibidos.getConveniosProibidos();
                    if (this.convenioAutorizado.size() > 0) {
                        salvar.setTabela("medicoconvenioproibido");
                        for (ObjetoMedicoConvenioProibido o : this.convenioAutorizado) {
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("con_codigo", 2, false, true, o.codigoConvenio);
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    this.medicoExame = this.panelExame.getExames();
                    if (this.medicoExame.size() > 0) {
                        salvar.setTabela("medicoexameweb");
                        for (ObjetoMedicoExame o : this.medicoExame) {
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDBEscape(o.codigoExame));
                            salvar.adicionaCampo("mew_proibido", 2, true, false, o.getProibidoWeb());
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    this.convenioTiss = this.panelTiss.getConveniosTISS();
                    if (this.convenioTiss.size() > 0) {
                        salvar.setTabela("medicoconveniotiss");
                        for (ObjetoMedicoConvenioTISS tmp : this.convenioTiss) {
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("con_codigo", 2, false, true, tmp.codigoConvenio);
                            salvar.adicionaCampo("mec_codigooperadora", 0, true, false, StringUtil.textoDBEscape(tmp.codigoOperadora));
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    this.medicoDestino = this.panelDestino.getDestinos();
                    if (this.medicoDestino.size() > 0) {
                        salvar.setTabela("medicodestino");
                        for (ObjetoMedicoDestino tmp : this.medicoDestino) {
                            String situacao = tmp.situacao;
                            String tipoSituacao = situacao.equals(Tipos.tipoMedicoDestino("D")) ? "D" : (situacao.equals(Tipos.tipoMedicoDestino("T")) ? "T" : "P");
                            salvar.limpar();
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("des_codigo", 0, false, true, StringUtil.textoDBEscape(tmp.codigoDestino));
                            salvar.adicionaCampo("mde_tipo", 0, true, false, StringUtil.textoDBEscape(tipoSituacao));
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    if (this.contemContatos(this.listaContatosNovos)) {
                        salvar.setTabela("medicocontato");
                        for (MedicoContatoVO con : this.listaContatosNovos) {
                            salvar.limpar();
                            salvar.setOperacao(0);
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("mct_codigo", 2, false, true, this.service.getSequence(Variaveis.filialPadrao));
                            salvar.adicionaCampo("mct_nome", 0, false, false, StringUtil.textoDBEscape(con.getContatoNome()));
                            salvar.adicionaCampo("mct_email", 0, false, false, StringUtil.textoDBEscape(con.getContatoEmail()));
                            salvar.adicionaCampo("mct_enviaremail", 4, false, false, con.getEnviarEmail());
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    if (this.contemContatos(this.listaContatosAlterados)) {
                        salvar.setTabela("medicocontato");
                        for (MedicoContatoVO con : this.listaContatosAlterados) {
                            salvar.limpar();
                            salvar.setOperacao(2);
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("mct_codigo", 2, false, true, con.getCodigo());
                            salvar.adicionaCampo("mct_nome", 0, false, false, StringUtil.textoDBEscape(con.getContatoNome()));
                            salvar.adicionaCampo("mct_email", 0, false, false, StringUtil.textoDBEscape(con.getContatoEmail()));
                            salvar.adicionaCampo("mct_enviaremail", 4, false, false, con.getEnviarEmail());
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    if (this.contemContatos(this.listaContatosRemovidos)) {
                        salvar.setTabela("medicocontato");
                        for (MedicoContatoVO con : this.listaContatosRemovidos) {
                            salvar.limpar();
                            salvar.setOperacao(1);
                            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                            salvar.adicionaCampo("med_conselho", 0, false, true, StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()));
                            salvar.adicionaCampo("med_crm", 0, false, true, this.txtCrm.getTextDBEscape());
                            salvar.adicionaCampo("med_uf", 0, false, true, StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                            salvar.adicionaCampo("mct_codigo", 2, false, true, con.getCodigo());
                            salvar.adicionaCampo("mct_nome", 0, false, false, StringUtil.textoDBEscape(con.getContatoNome()));
                            salvar.adicionaCampo("mct_email", 0, false, false, StringUtil.textoDBEscape(con.getContatoEmail()));
                            salvar.adicionaCampo("mct_enviaremail", 4, false, false, con.getEnviarEmail());
                            DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedico());
                        }
                    }
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "conselhoMedico", this.comboConselho.getSelectedItem().toString(), "crmMedico", this.txtCrm.getText(), "ufMedico", this.comboUf.getSelectedItem().toString(), "senhaMedico", this.senhaWeb, "nomeMedico", this.txtNome.getText()};
                    if (Variaveis.exportarWebFilial) {
                        DBUtil.insereExportaWeb(statement, "medicos", this.getStatus() == 2 ? "I" : "A", ParametrosGerais.getCopiaMedico(), comando);
                        String[] comando2 = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "conselhoMedicoExame", this.comboConselho.getSelectedItem().toString(), "crmMedicoExame", this.txtCrm.getText(), "ufMedicoExame", this.comboUf.getSelectedItem().toString()};
                        DBUtil.insereExportaWeb(statement, "medicosexames", "D", ParametrosGerais.getCopiaMedico(), comando2);
                        for (ObjetoMedicoExame o : this.medicoExame) {
                            comando2 = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "conselhoMedicoExame", this.comboConselho.getSelectedItem().toString(), "crmMedicoExame", this.txtCrm.getText(), "ufMedicoExame", this.comboUf.getSelectedItem().toString(), "codigoExameMedicoExame", o.codigoExame, "proibidoMedicoExame", String.valueOf(o.getProibidoWeb())};
                            DBUtil.insereExportaWeb(statement, "medicosexames", "I", ParametrosGerais.getCopiaMedico(), comando2);
                        }
                    }
                    DBUtil.gravaAutoCopiaWeb("medicos", Variaveis.filialPadrao, ParametrosGerais.getCopiaMedico(), statement, comando, 1, this.getStatus() == 2 ? "I" : "A", true);
                    Util.gravaAlteracaoMedico(statement, this.comboConselho.getSelectedItem().toString(), this.txtCrm.getText(), this.comboUf.getSelectedItem().toString());
                    this.retornoParaPesquisa = this.txtCrm.getText();
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Medico");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (limparCampos) {
                    this.limparCampos(true);
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
        }
    }

    private boolean contemContatos(ArrayList<MedicoContatoVO> list) {
        return list != null && list.size() > 0;
    }

    public void setBloquearSMSEmail(MedicoEnvioAutomaticoDTO medicoEnvioAutomatico) {
        medicoEnvioAutomatico.setBloquearSMSExamePronto(medicoEnvioAutomatico.isBloquearSMSExamePronto());
        medicoEnvioAutomatico.setBloquearSMSRecoleta(medicoEnvioAutomatico.isBloquearSMSRecoleta());
        medicoEnvioAutomatico.setBloquearEmailExamePronto(medicoEnvioAutomatico.isBloquearEmailExamePronto());
        medicoEnvioAutomatico.setBloquearEmailRecoleta(medicoEnvioAutomatico.isBloquearEmailRecoleta());
        medicoEnvioAutomatico.setBloquearPushExamePronto(medicoEnvioAutomatico.isBloquearPushExamePronto());
        medicoEnvioAutomatico.setBloquearPushRecoleta(medicoEnvioAutomatico.isBloquearPushRecoleta());
        medicoEnvioAutomatico.setBloquearWhatsAppExamePronto(medicoEnvioAutomatico.isBloquearWhatsAppExamePronto());
        medicoEnvioAutomatico.setBloquearWhatsAppRecoleta(medicoEnvioAutomatico.isBloquearWhatsAppRecoleta());
    }

    private void controlaCampos() {
        this.comboConselho.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCrm.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboUf.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoLogradouro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtNome.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboAbrev.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescEspecialidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodCidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescCidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtEndereco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtNumeroEndereco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtComplemento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodBairro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescBairro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCEP.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFone.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCelular.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFax.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtEmail.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtSite.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtComissao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboCBO.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCPF.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textNascimento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonNascimento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bBuscaCep.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtObserv.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton1.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton2.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton3.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonComissoes.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonSenhaWeb.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonOutrosContatos.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonOutrosContatos.setEnabled(!Funcoes.textoVazio(this.txtEmail));
        this.buttonMensagem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonSMSEmail.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoCelula.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaCelula.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkInativo.setEnabled(this.getStatus() == 3);
        this.panelDestino.setSituacaoCampos(this.getStatus() == 3 || this.getStatus() == 2 ? 1 : 2);
        this.panelExame.setSituacaoCampos(this.getStatus() == 3 || this.getStatus() == 2 ? 1 : 2);
        this.panelTiss.setSituacaoCampos(this.getStatus() == 3 || this.getStatus() == 2 ? 1 : 2);
        this.panelProibidos.setSituacaoCampos(this.getStatus() == 3 || this.getStatus() == 2 ? 1 : 2);
    }

    private void limparCampos(boolean voltarPrimeirAba) {
        this.txtCrm.setText("");
        this.txtNome.setText("");
        this.txtDescEspecialidade.setText("");
        this.txtCodCidade.setText("");
        this.txtDescCidade.setText("");
        this.txtEndereco.setText("");
        this.txtNumeroEndereco.setText("");
        this.txtComplemento.setText("");
        this.txtCodBairro.setText("");
        this.txtDescBairro.setText("");
        this.txtCEP.setText("");
        this.txtFone.clear();
        this.txtCelular.clear();
        this.txtFax.clear();
        this.txtFone.clear();
        this.txtCelular.clear();
        this.txtEmail.setText("");
        this.txtSite.setText("");
        this.txtComissao.setText("");
        this.txtObserv.setText("");
        this.textCPF.clear();
        this.textNascimento.clear();
        this.convenioAutorizado.clear();
        this.medicoEspecialidade.clear();
        this.convenioComissao.clear();
        this.convenioTiss.clear();
        this.medicoDestino.clear();
        this.medicoExame.clear();
        this.textCodigoCelula.clear();
        this.labelDescricaoCelula.setText("");
        this.panelDestino.limparDestinos();
        this.panelProibidos.limparConvenios();
        this.panelTiss.limparConvenios();
        this.panelExame.limparExames();
        this.comboCBO.setSelectedIndex(0);
        this.comboTipoLogradouro.setSelectedIndex(0);
        this.senhaWeb = "";
        this.mensagem = "";
        this.limpaListas();
        if (voltarPrimeirAba && this.tabbed.getSelectedIndex() != 0) {
            this.tabbed.setSelectedIndex(0);
        }
        this.checkInativo.setSelected(false);
        this.medicoInativo = false;
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 2) {
            Statement st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, "select med_crm from medico where fil_codigo=" + Variaveis.filialPadrao + " and med_conselho = " + StringUtil.textoDBEscape(this.comboConselho.getSelectedItem().toString()) + " and upper(med_crm)=upper(" + StringUtil.textoDBEscape(this.txtCrm.getText().trim()) + ") and med_uf=" + StringUtil.textoDBEscape(this.comboUf.getSelectedItem().toString()));
                if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                    Funcoes.mensagem(this, "M\u00e9dico j\u00e1 cadastrado", 1);
                    this.txtCrm.grabFocus();
                    return false;
                }
                rs.close();
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                this.txtCrm.grabFocus();
                return false;
            }
        }
        if (this.txtCrm.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo CRM n\u00e3o informado", 1);
            this.txtCrm.grabFocus();
            return false;
        }
        if (this.txtNome.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo nome n\u00e3o informado", 1);
            this.txtNome.selectAll();
            this.txtNome.grabFocus();
            return false;
        }
        if (this.txtCodCidade.getText().trim().length() > 0 && this.txtDescCidade.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cidade n\u00e3o localizada", 1);
            this.txtCodCidade.selectAll();
            this.txtCodCidade.grabFocus();
            return false;
        }
        if (this.txtCodBairro.getText().trim().length() > 0 && this.txtDescBairro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Bairro n\u00e3o localizado", 1);
            this.txtCodBairro.selectAll();
            this.txtCodBairro.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtEmail.getText()) && !this.txtEmail.getText().trim().matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$")) {
            Funcoes.mensagem(this, "Email inv\u00e1lido.", 2);
            this.txtEmail.selectAll();
            this.txtEmail.grabFocus();
            return false;
        }
        if (this.textCPF.getText().trim().length() < 14 && !Funcoes.textoVazio(this.textCPF.getText()) && !ValidaDoc.checkDoc(this.textCPF.getText(), 8) || this.textCPF.getText().trim().length() > 11 && this.textCPF.getText().trim().length() < 14) {
            Funcoes.mensagem(this, "Campo CPF inv\u00e1lido", 1);
            this.textCPF.selectAll();
            this.textCPF.grabFocus();
            return false;
        }
        if (this.textCPF.getText().trim().length() == 14 && !Funcoes.textoVazio(this.textCPF.getText()) && !ValidaDoc.checkDoc(this.textCPF.getText(), 7)) {
            Funcoes.mensagem(this, "Campo CNPJ inv\u00e1lido", 1);
            this.textCPF.selectAll();
            this.textCPF.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textNascimento.getText()) && !Funcoes.verificaData(this.textNascimento.getText())) {
            Funcoes.mensagem(this, "Campo Data nascimento inv\u00e1lido", 1);
            this.textNascimento.selectAll();
            this.textNascimento.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textCodigoCelula.getText()) && this.labelDescricaoCelula.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "C\u00e9lula de Estoque n\u00e3o localizada", 1);
            this.tabbed.setSelectedIndex(2);
            this.textCodigoCelula.selectAll();
            this.textCodigoCelula.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCEP) && !CEP.tamanhoDoCepCorreto(this.txtCEP)) {
            Funcoes.mensagem(this, "CEP Inv\u00e1lido", 1);
            this.txtCEP.grabFocus();
            return false;
        }
        return true;
    }

    private void buscaCidade() {
        Hashtable resultado = Pesquisas.cidade(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodCidade.setText(resultado.get("cid_codigo").toString());
        }
        this.txtCodCidade.requestFocus();
    }

    private void buscaBairro() {
        Hashtable resultado = Pesquisas.bairro(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodBairro.setText(resultado.get("bai_codigo").toString());
        }
        this.txtCodBairro.requestFocus();
    }

    private void adicionaEspecialidade() {
        MedicoEspecialidades telaMedicoEspecialidades = MedicoEspecialidades.novaInstancia(this.getTopLevelAncestor());
        if (telaMedicoEspecialidades != null) {
            telaMedicoEspecialidades.setEspecialidades(this.medicoEspecialidade);
            telaMedicoEspecialidades.setVisible(true);
            if (telaMedicoEspecialidades.isOK()) {
                this.medicoEspecialidade = telaMedicoEspecialidades.getEspecialidades();
                this.txtDescEspecialidade.clear();
                if (this.medicoEspecialidade != null && this.medicoEspecialidade.size() > 0) {
                    for (int i = 0; i < this.medicoEspecialidade.size(); ++i) {
                        DadosME d = this.medicoEspecialidade.get(i);
                        this.txtDescEspecialidade.setText(this.txtDescEspecialidade.getText() + (Funcoes.textoVazio(this.txtDescEspecialidade.getText()) ? "" : ",") + d.getNomeEspecialidade());
                    }
                }
            }
        }
    }

    private void buscaCelula() {
        AbstractThreadVO vo = new CelulaEstoqueService().pesquisaVO(this.getTopLevelAncestor(), new CelulaEstoqueVO(), "Pesquisando c\u00e9lula de estoque", Acesso.getAcesso(CelulaEstoque.getModuloAcesso()));
        if (vo != null) {
            this.textCodigoCelula.setText(((CelulaEstoqueVO)vo).getCodigo().toString());
        }
        this.textCodigoCelula.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoCelula.hasFocus()) {
            this.buscaCelula();
        } else if (this.txtCodCidade.hasFocus()) {
            this.buscaCidade();
        } else if (this.txtCodBairro.hasFocus()) {
            this.buscaBairro();
        } else if (this.txtDescEspecialidade.hasFocus()) {
            this.adicionaEspecialidade();
        } else if (this.textNascimento.hasFocus()) {
            Funcoes.mostraData(this.textNascimento, this.buttonNascimento, this.panelDados, false);
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101500200");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaCelula) {
            this.buscaCelula();
        } else if (e.getSource() == this.buttonNascimento) {
            Funcoes.mostraData(this.textNascimento, this.buttonNascimento, this.panelDados, true);
        } else if (e.getSource() == this.buttonMensagem) {
            this.configuraMensagem();
        } else if (e.getSource() == this.buttonSMSEmail) {
            MedicoSMSEmail bm = new MedicoSMSEmail((Frame)Laboratorio.getInstancia(), this.medicoEnvioAutomatico);
            bm.setVisible(true);
            this.setBloquearSMSEmail(bm.medicoEnvioAutomatico);
        } else if (e.getSource() == this.bBuscaCep) {
            CEP.buscarCEP(this.comboTipoLogradouro, this.txtCEP, this.txtEndereco, this.txtCodCidade, this.txtDescCidade, this.txtCodBairro, this.txtDescBairro, this);
            ScreenUtil.requisitarFoco(this.txtCEP);
        }
    }

    private void configuraMensagem() {
        Mensagem m = Mensagem.novaInstancia(this.getTopLevelAncestor());
        if (m != null) {
            m.setMensagem(this.mensagem);
            m.setLocationRelativeTo(this.getTopLevelAncestor());
            m.setVisible(true);
            if (m.getOK()) {
                this.mensagem = m.getMensagem();
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "med_crm";
    }
}

