/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class Medicamento
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TTextField txtFabricante;
    private JTabbedPane abas;
    private JTextArea indicacoes;
    private JTextArea interacoes;
    private JPanel panelPrincipios;
    private TTextField txtCodPri;
    private TTextField txtDescPri;
    private JButton botaoPri;
    private JTable tabelaPri;
    private JScrollPane scroll;
    private JButton botaoOK;
    private JLabel labelPri;
    private ModeloGridTable modelo;
    private String retornoParaPesquisa = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Medicamento.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900121"));
        this.setModuloEdita(Long.parseLong("0101900122"));
        this.setModuloApaga(Long.parseLong("0101900123"));
    }

    public Medicamento() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Medicamento");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Medicamento");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.labelPri = new JLabel("C\u00f3digo");
        this.txtFabricante = new TTextField(80);
        this.txtFabricante.setName("txtFabricante");
        this.abas = new JTabbedPane(1);
        this.indicacoes = new JTextArea(new TTextAreaDocument(2000));
        this.indicacoes.setName("indicacoes");
        this.interacoes = new JTextArea(new TTextAreaDocument(2000));
        this.interacoes.setName("interacoes");
        this.panelPrincipios = new JPanel(null);
        this.botaoPri = new JButton("");
        this.botaoPri.setName("botaoPri");
        Funcoes.imagemPesquisa(this.botaoPri);
        this.txtCodPri = new TTextField(5, 1);
        this.txtCodPri.setName("txtCodPri");
        this.txtDescPri = new TTextField(80);
        this.txtDescPri.setName("txtDescPri");
        this.txtDescPri.setEditable(false);
        this.txtDescPri.setFocusable(false);
        this.botaoOK = new JButton("OK");
        this.botaoOK.setName("botaoOK");
        this.modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Pr\u00edncipio"});
        this.tabelaPri = new JTable(this.modelo);
        this.tabelaPri.setName("tabelaPri");
        this.modelo.setColumnSize(new int[]{70, 0}, this.tabelaPri);
        this.scroll = new JScrollPane(this.tabelaPri);
        this.labelPri.setBounds(new Rectangle(5, 4, 45, 15));
        this.txtCodPri.setBounds(new Rectangle(5, 19, 48, 20));
        this.botaoPri.setBounds(new Rectangle(54, 19, 20, 20));
        this.txtDescPri.setBounds(new Rectangle(76, 19, 300, 20));
        this.botaoOK.setBounds(new Rectangle(378, 19, 40, 20));
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.botaoPri.setFocusable(false);
        this.scroll.setBounds(new Rectangle(5, 41, 413, 217));
        this.panelPrincipios.add((Component)this.labelPri, null);
        this.panelPrincipios.add((Component)this.txtCodPri, null);
        this.panelPrincipios.add((Component)this.botaoPri, null);
        this.panelPrincipios.add((Component)this.txtDescPri, null);
        this.panelPrincipios.add((Component)this.botaoOK, null);
        this.panelPrincipios.add((Component)this.scroll, null);
        this.abas.setName("abas");
        this.abas.addTab("Indica\u00e7\u00f5es", new JScrollPane(this.indicacoes));
        this.abas.addTab("Intera\u00e7\u00f5es", new JScrollPane(this.interacoes));
        this.abas.addTab("Pr\u00edncipios", this.panelPrincipios);
        this.setLabelDescricao("Cadastro de medicamentos para utiliza\u00e7\u00e3o em dados cl\u00ednicos de pacientes");
        this.setLabelFormulario("Cadastro de medicamentos");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_medicamento.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setBounds(new Rectangle(80, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(80, 28, 400, 20));
        this.txtFabricante.setBounds(new Rectangle(80, 49, 400, 20));
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel3.setText("Fabricante:");
        this.jLabel3.setBounds(new Rectangle(7, 51, 70, 14));
        this.abas.setBounds(new Rectangle(7, 72, 470, 300));
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.txtFabricante, null);
        this.painelCentral.add((Component)this.abas, null);
        this.indicacoes.setWrapStyleWord(true);
        this.indicacoes.setLineWrap(true);
        this.interacoes.setWrapStyleWord(true);
        this.interacoes.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.indicacoes);
        ScreenUtil.montaSaidaTextArea(this.interacoes);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Medicamento.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Medicamento.this.txtCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select mto_descricao, mto_fabricante, mto_indicacao, mto_interacao ");
                            buf.append("from medicamentos where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and mto_codigo = ");
                            buf.append(Medicamento.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                Medicamento.this.txtDescricao.setText(rs.getString("mto_descricao"));
                                Medicamento.this.txtFabricante.setText(rs.getString("mto_fabricante"));
                                Medicamento.this.indicacoes.setText(rs.getString("mto_indicacao"));
                                Medicamento.this.interacoes.setText(rs.getString("mto_interacao"));
                                ScreenUtil.posicionaTextoTopo(Medicamento.this.indicacoes);
                                ScreenUtil.posicionaTextoTopo(Medicamento.this.interacoes);
                                buf.delete(0, buf.length());
                                buf.append("select a.prc_codigo, b.prc_descricao from medprincipios a ");
                                buf.append("left join principios b on a.fil_codigo = b.fil_codigo and a.prc_codigo = b.prc_codigo where a.fil_codigo = ");
                                buf.append(Variaveis.filialPadrao);
                                buf.append(" and a.mto_codigo = ");
                                buf.append(Medicamento.this.txtCodigo.getText());
                                buf.append(" order by b.prc_descricao");
                                ResultSet pri = Conexao.executeQuery(st, buf.toString());
                                while (pri.next()) {
                                    Medicamento.this.modelo.addLine(new Object[]{pri.getString("prc_codigo"), pri.getString("prc_descricao")});
                                }
                                pri.close();
                                Medicamento.this.txtCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(Medicamento.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Medicamento.this.setStatus(1);
                                Medicamento.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Medicamento.this, sqlex.getMessage(), sqlex.getStackTrace(), "Medicamento");
                    }
                }
            }
        });
        this.botaoPri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medicamento.this.buscaPrincipios();
            }
        });
        this.botaoOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Medicamento.this.txtDescPri.getText().equals("N\u00e3o cadastrado") && Medicamento.this.txtCodPri.getText().trim().length() > 0 && Medicamento.this.modelo.localizar(0, Medicamento.this.txtCodPri.getText()) < 0) {
                    Medicamento.this.modelo.addLine(new String[]{Medicamento.this.txtCodPri.getText(), Medicamento.this.txtDescPri.getText()});
                }
                Medicamento.this.txtCodPri.clear();
                Medicamento.this.txtDescPri.clear();
                Medicamento.this.txtCodPri.selectAll();
                Medicamento.this.txtCodPri.grabFocus();
            }
        });
        this.tabelaPri.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && Funcoes.mensagem(Medicamento.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Medicamento.this.modelo.removeLine(Medicamento.this.tabelaPri.getSelectedRow());
                }
            }
        });
        this.txtCodPri.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Medicamento.this.txtCodPri.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select prc_descricao from principios where fil_codigo = " + Variaveis.filialPadrao + " and prc_codigo=" + Medicamento.this.txtCodPri.getText());
                        if (rs.next()) {
                            Medicamento.this.txtDescPri.setText(rs.getString("prc_descricao"));
                        } else {
                            Medicamento.this.txtDescPri.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Medicamento.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Medicamento.this.setStatus(1);
                        Medicamento.this.controlaCampos();
                    }
                }
            }
        });
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.medicamentos(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("mto_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("medicamentos", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mto_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedicamento());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Medicamento");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "medicamentos", true);
                }
                SalvaDados salvar = new SalvaDados("medicamentos", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("mto_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("mto_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("mto_interacao", 0, true, false, StringUtil.textoDBEscape(this.interacoes.getText()));
                salvar.adicionaCampo("mto_indicacao", 0, true, false, StringUtil.textoDBEscape(this.indicacoes.getText()));
                salvar.adicionaCampo("mto_fabricante", 0, true, false, this.txtFabricante.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedicamento(), "medicamentos", Integer.parseInt(codigo));
                Util.gravaAlteracaoMedicamento(statement, codigo);
                salvar.limpar();
                salvar.setTabela("medprincipios");
                salvar.setOperacao(1);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("mto_codigo", 2, false, true, codigo);
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedicamento());
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    salvar.limpar();
                    salvar.setTabela("medprincipios");
                    salvar.setOperacao(0);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mto_codigo", 2, false, true, codigo);
                    salvar.adicionaCampo("prc_codigo", 2, false, true, this.modelo.getValueAt(i, 0));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMedicamento());
                }
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Medicamento");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFabricante.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.abas.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodPri.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.botaoPri.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.botaoOK.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.scroll.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.txtFabricante.setText("");
        this.indicacoes.setText("");
        this.interacoes.setText("");
        this.txtCodPri.setText("");
        this.txtDescPri.setText("");
        this.modelo.clear();
        this.abas.setSelectedIndex(0);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    private void buscaPrincipios() {
        Hashtable resultado = Pesquisas.principios(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodPri.setText(resultado.get("prc_codigo").toString());
        }
        this.txtCodPri.grabFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodPri.hasFocus()) {
            this.buscaPrincipios();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900120");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "mto_codigo";
    }
}

