/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosModelo;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;

class MaterialColetado
extends JDialog
implements DisposeListener {
    private ExameMatCol materialColetado;
    private DadosModelo dados;
    private String nomeExameBarra = "";
    private String codigoExameBarra = "";
    private boolean editando = false;
    private String perguntasFilial = "";

    public MaterialColetado(JDialog owner, String codigoExameBarra, String nomeExameBarra, String perguntasFilial) {
        super((Dialog)owner, true);
        this.codigoExameBarra = codigoExameBarra;
        this.nomeExameBarra = nomeExameBarra;
        this.perguntasFilial = perguntasFilial;
        this.setResizable(false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Exame");
        }
    }

    public MaterialColetado(JFrame owner, String codigoExameBarra, String nomeExameBarra, String perguntasFilial) {
        super((Frame)owner, true);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.codigoExameBarra = codigoExameBarra;
        this.nomeExameBarra = nomeExameBarra;
        this.perguntasFilial = perguntasFilial;
        this.setResizable(false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Exame");
        }
    }

    public void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.materialColetado = new ExameMatCol(this, this.codigoExameBarra, this.nomeExameBarra);
        this.materialColetado.setPerguntasFilial(this.perguntasFilial);
        this.getContentPane().add((Component)this.materialColetado, "Center");
        this.setTitle("Material Coletado");
        this.setModal(true);
        this.setSize(new Dimension(940, 620));
        this.setLocationRelativeTo(this.getParent());
    }

    public void setIdade(int idadeIni, int idadeFim, String tipoIdadeIni, String tipoIdadeFim) {
        this.materialColetado.setIdade(idadeIni, idadeFim, tipoIdadeIni, tipoIdadeFim);
    }

    public void setDadosModelo(DadosModelo dados) {
        this.dados = dados;
        this.materialColetado.setDadosModelo(this.dados);
    }

    public void setEditando(boolean edit) {
        this.editando = edit;
        this.materialColetado.setEditando(edit);
    }

    public boolean getEditando() {
        return this.editando;
    }

    public boolean isOK() {
        return this.materialColetado.isOK();
    }

    public DadosModelo getDadosModelo() {
        return this.materialColetado.getDadosModelo();
    }

    public String getTags() {
        return this.materialColetado.getTags();
    }

    public void setTags(String xmlTags) {
        if (!Funcoes.textoVazio(xmlTags)) {
            String listaTags = StringUtil.getValor(xmlTags, "LISTA_TAGS_RESULTADO");
            String[] tags = StringUtil.getValores(listaTags, "TAG_RESULTADO");
            ArrayList<String> listaNova = new ArrayList<String>();
            for (String tag : tags) {
                boolean isExcluida;
                boolean bl = isExcluida = !Funcoes.textoVazio(StringUtil.getValor(tag, "EXCLUIDA")) ? Boolean.parseBoolean(StringUtil.getValor(tag, "EXCLUIDA")) : Boolean.FALSE;
                if (isExcluida) continue;
                listaNova.add(StringUtil.getValor(tag, "NOME"));
            }
            String tag = StringUtil.implode(listaNova, ";");
            this.materialColetado.setTags(tag);
        }
    }
}

