/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.cadastro.exame.TipoMaterialColetaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.exame.TipoMaterialColetaVO;
import jalis.service.cadastro.exame.TipoMaterialColetaService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class MaterialColeta
extends FrmCadPadrao {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelAbreviatura = new JLabel("Abreviatura:");
    private JLabel labelTipoMatColeta = new JLabel("Tipo Mat. Coleta:");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(80);
    private TTextField textAbreviatura = new TTextField(3);
    private TTextField textTipoMatColeta = new TTextField(5, 1);
    private TTextField textDescTipoMatCol = new TTextField(200, 3);
    private JCheckBox checkSolicitar = new JCheckBox();
    private JCheckBox checkSolicitarArea = new JCheckBox("Solicitar \u00e1rea");
    private JButton buttonPesquisa = new JButton();
    private String retornoParaPesquisa = "";

    public MaterialColeta() {
        this.montaTela();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montaTela() {
        this.setLabelDescricao("Cadastro de materiais coletados para realiza\u00e7\u00e3o de exames");
        this.setLabelFormulario("Cadastro de materiais coletados");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_mat_coleta.jpg"));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.fill = 0;
        g.gridx = 0;
        g.gridy = 0;
        g.weighty = 0.0;
        g.weightx = 0.0;
        this.painelCentral.add((Component)this.labelCodigo, g);
        ++g.gridx;
        this.textCodigo.setPreferredSize(new Dimension(100, 20));
        this.textCodigo.setMinimumSize(new Dimension(100, 20));
        this.painelCentral.add((Component)this.textCodigo, g);
        this.textCodigo.addFocusListener(this.listenerTTextField());
        g.gridx = 0;
        ++g.gridy;
        this.labelDescricao.setDisplayedMnemonic('D');
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.painelCentral.add((Component)this.labelDescricao, g);
        ++g.gridx;
        g.gridwidth = 3;
        g.fill = 2;
        this.painelCentral.add((Component)this.textDescricao, g);
        this.labelAbreviatura.setDisplayedMnemonic('A');
        this.labelAbreviatura.setLabelFor(this.textAbreviatura);
        g.gridwidth = 1;
        g.weightx = 0.0;
        g.fill = 0;
        g.gridx = 0;
        ++g.gridy;
        this.painelCentral.add((Component)this.labelAbreviatura, g);
        ++g.gridx;
        this.textAbreviatura.setPreferredSize(new Dimension(100, 20));
        this.textAbreviatura.setMinimumSize(new Dimension(100, 20));
        this.painelCentral.add((Component)this.textAbreviatura, g);
        this.labelTipoMatColeta.setDisplayedMnemonic('T');
        this.labelTipoMatColeta.setLabelFor(this.textTipoMatColeta);
        g.gridx = 0;
        ++g.gridy;
        this.painelCentral.add((Component)this.labelTipoMatColeta, g);
        ++g.gridx;
        g.gridwidth = 1;
        this.textTipoMatColeta.setPreferredSize(new Dimension(80, 20));
        this.textTipoMatColeta.setMinimumSize(new Dimension(80, 20));
        this.painelCentral.add((Component)this.textTipoMatColeta, g);
        g.anchor = 13;
        g.gridy = 3;
        this.buttonPesquisa.setPreferredSize(new Dimension(20, 20));
        this.buttonPesquisa.setMinimumSize(new Dimension(20, 20));
        this.buttonPesquisa.setFocusable(false);
        this.painelCentral.add((Component)this.buttonPesquisa, g);
        Funcoes.imagemPesquisa(this.buttonPesquisa);
        this.buttonPesquisa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialColeta.this.buscaTipoMaterialColeta();
            }
        });
        ++g.gridx;
        g.gridy = 3;
        g.fill = 2;
        this.painelCentral.add((Component)this.textDescTipoMatCol, g);
        g.gridy = 4;
        g.gridx = 1;
        g.gridwidth = 2;
        this.checkSolicitar.setText("Solicitar material");
        this.checkSolicitar.setToolTipText("<html>Ao ser adicionado o exame com este material na requisi\u00e7\u00e3o, <br>o material dever\u00e1 ser especificado</html>");
        this.painelCentral.add((Component)this.checkSolicitar, g);
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            ++g.gridy;
            this.painelCentral.add((Component)this.checkSolicitarArea, g);
        }
        g.gridx = 0;
        ++g.gridy;
        g.weightx = 1.0;
        g.weighty = 1.0;
        g.fill = 1;
        g.gridwidth = 3;
        this.painelCentral.add((Component)new JLabel(), g);
        this.controlaCampos();
    }

    private void buscaTipoMaterialColeta() {
        TipoMaterialColetaService services = new TipoMaterialColetaService();
        TipoMaterialColetaVO vo = (TipoMaterialColetaVO)services.pesquisaVO(Laboratorio.getInstancia(), new TipoMaterialColetaVO(), "Pesquisando tipo de material coletado", true);
        if (vo != null) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", vo.getFilial().getCodigo());
            chaves.put("tmc_codigo", vo.getCodigo());
            try {
                TipoMaterialColetaBean bean = (TipoMaterialColetaBean)services.getBean(chaves);
                this.textTipoMatColeta.setText(String.valueOf(bean.getCodigo()));
                this.textDescTipoMatCol.setText(bean.getDescricao());
            }
            catch (ThreadDaoException ex) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados.\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private FocusListener listenerTTextField() {
        FocusAdapter listener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (MaterialColeta.this.textCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(MaterialColeta.this.textCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select mco.mco_codigo, mco.mco_descricao, mco.mco_abreviatura, mco.mco_solicitarmat, ");
                            buf.append("mco.mco_solicitararea, mco.tmc_codigo, tmc.tmc_descricao ");
                            buf.append("from materialcoleta mco ");
                            buf.append("left join tipomaterialcoleta tmc on tmc.fil_codigo = mco.fil_codigo and tmc.tmc_codigo = mco.tmc_codigo ");
                            buf.append("where mco.fil_codigo = ").append(Variaveis.filialPadrao);
                            buf.append(" and mco.mco_codigo = ");
                            buf.append(MaterialColeta.this.textCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                MaterialColeta.this.textDescricao.setText(rs.getString("mco_descricao"));
                                MaterialColeta.this.textAbreviatura.setText(rs.getString("mco_abreviatura"));
                                MaterialColeta.this.textTipoMatColeta.setText(rs.getString("tmc_codigo"));
                                MaterialColeta.this.textDescTipoMatCol.setText(rs.getString("tmc_descricao"));
                                MaterialColeta.this.checkSolicitar.setSelected(rs.getBoolean("mco_solicitarmat"));
                                MaterialColeta.this.checkSolicitarArea.setSelected(rs.getBoolean("mco_solicitararea"));
                                MaterialColeta.this.textCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(MaterialColeta.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                MaterialColeta.this.setStatus(1);
                                MaterialColeta.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(MaterialColeta.this, sqlex.getMessage(), sqlex.getStackTrace(), "MaterialColeta");
                    }
                }
            }
        };
        return listener;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(MaterialColeta.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900501"));
        this.setModuloEdita(Long.parseLong("0101900502"));
        this.setModuloApaga(Long.parseLong("0101900503"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.materialColeta(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.textCodigo.setText(resultado.get("mco_codigo").toString());
        }
        this.textCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.textCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("materialcoleta", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mco_codigo", 2, false, true, this.textCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMaterialColeta());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "MaterialColeta");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.textDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.textCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "materialcoleta", true);
                }
                SalvaDados salvar = new SalvaDados("materialcoleta", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("mco_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("mco_descricao", 0, true, false, this.textDescricao.getTextDBEscape());
                salvar.adicionaCampo("tmc_codigo", 2, true, false, this.textTipoMatColeta.getText());
                salvar.adicionaCampo("mco_solicitarmat", 4, true, false, this.checkSolicitar.isSelected());
                salvar.adicionaCampo("mco_solicitararea", 4, true, false, this.checkSolicitarArea.isSelected());
                salvar.adicionaCampo("mco_abreviatura", 0, true, false, this.textAbreviatura.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMaterialColeta(), "materialcoleta", Integer.parseInt(codigo));
                Util.gravaAlteracaoMaterialColeta(statement, codigo);
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "MaterialColeta");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.textDescTipoMatCol.setEnabled(false);
        this.textCodigo.setEnabled(this.getStatus() == 3);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textAbreviatura.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textTipoMatColeta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonPesquisa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkSolicitar.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkSolicitarArea.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    public void pressioneiF2() {
        if (this.textTipoMatColeta.hasFocus()) {
            this.buscaTipoMaterialColeta();
        }
    }

    private void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.textAbreviatura.setText("");
        this.textTipoMatColeta.setText("");
        this.textDescTipoMatCol.setText("");
        this.checkSolicitar.setSelected(false);
        this.checkSolicitarArea.setSelected(false);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.textCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.textCodigo.grabFocus();
                return false;
            }
            if (this.textCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.textCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.textCodigo.selectAll();
                this.textCodigo.grabFocus();
                return false;
            }
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.textDescricao.selectAll();
            this.textDescricao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.textAbreviatura.getText())) {
            Funcoes.mensagem(this, "Campo abreviatura n\u00e3o informado", 1);
            this.textAbreviatura.selectAll();
            this.textAbreviatura.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900500");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "mco_codigo";
    }
}

