/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class MaterialCelulas
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00e9lula", "Estoque"});
    private JTable tabela = new JTable(this.modelo);

    public static MaterialCelulas novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new MaterialCelulas((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new MaterialCelulas((Dialog)owner);
        }
        return null;
    }

    public MaterialCelulas(Frame owner) {
        super(owner, "C\u00e9lulas");
        this.montaTela();
    }

    public MaterialCelulas(Dialog owner) {
        super(owner, "C\u00e9lulas");
        this.montaTela();
    }

    public void setMaterial(String filial, String codigo) {
        try {
            this.modelo.clear();
            ArrayList<SaldoEstoqueCelulaBean> saldo = new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterial(filial, codigo);
            if (saldo != null) {
                for (SaldoEstoqueCelulaBean s : saldo) {
                    if (!(s.getSaldo() > 0.0)) continue;
                    this.modelo.addLine(new Object[]{s.getCelula().getCodigo(), s.getCelula().getDescricao(), Funcoes.formataDecimal("#,##0.0000", s.getSaldo())});
                }
            }
            if (this.modelo.getRowCount() > 0) {
                ScreenUtil.requisitarFoco(this.tabela);
            } else {
                ScreenUtil.requisitarFoco(this.getBotaoOK());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "MaterialCelulas: 1210");
        }
    }

    @Override
    public boolean acaoOk() {
        return true;
    }

    private void montaTela() {
        this.setSize(new Dimension(350, 450));
        this.setLocationRelativeTo(this.getParent());
        JPanel panel = this.getPanelCentral();
        this.getBotaoCancelar().setVisible(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.tabela), "Center");
        this.modelo.setColumnSize(new int[]{70, 0, 100}, this.tabela);
    }
}

