/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.MaterialAlternativoBean;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class MaterialAlternativo
extends JDialog
implements DisposeListener {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panel = new JPanel(this.grid);
    private TTextField txtAlternativo = new TTextField(18);
    private JButton buttonOKMaterial = new JButton("OK");
    private JLabel labelAlternativo = new JLabel("Material Alternativo");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Material Alternativo"});
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JTable tabela = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.tabela);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private int linhaAlterada = -1;
    private boolean isOK = false;

    public MaterialAlternativo(JDialog owner, String title) {
        super((Dialog)owner, title);
        this.montaTela(owner);
    }

    public MaterialAlternativo(JFrame owner, String title) {
        super((Frame)owner, title);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.montaTela(owner);
    }

    private void montaTela(Window owner) {
        this.getContentPane().setLayout(new BorderLayout());
        this.modelo.setColumnSize(new int[]{100, 230, 80}, this.tabela);
        this.buttonOKMaterial.setMargin(new Insets(2, 2, 2, 2));
        this.scroll.setBounds(new Rectangle(5, 41, 413, 217));
        this.scroll.setPreferredSize(new Dimension(new Dimension(20, 20)));
        this.buttonOK.setMnemonic('F');
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.buttonOKMaterial.setMnemonic('K');
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.labelAlternativo.setLabelFor(this.txtAlternativo);
        this.labelAlternativo.setDisplayedMnemonic('M');
        this.panel.add((Component)this.labelAlternativo, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.buttonOKMaterial.setPreferredSize(new Dimension(40, 20));
        this.buttonOKMaterial.setMinimumSize(new Dimension(40, 20));
        this.panel.add((Component)this.buttonOKMaterial, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.txtAlternativo.setPreferredSize(new Dimension(155, 20));
        this.txtAlternativo.setMinimumSize(new Dimension(155, 20));
        this.panel.add((Component)this.txtAlternativo, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.constraints.weighty = 1.0;
        this.constraints.gridwidth = 2;
        this.panel.add((Component)this.scroll, this.constraints);
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.setModal(true);
        this.setSize(new Dimension(220, 350));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)this.panel);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.buttonOKMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(MaterialAlternativo.this.txtAlternativo.getText())) {
                    int localizado = MaterialAlternativo.this.modelo.localizar(0, MaterialAlternativo.this.txtAlternativo.getText().trim().toLowerCase());
                    if (localizado < 0 && MaterialAlternativo.this.linhaAlterada > -1) {
                        MaterialAlternativoBean bean = new MaterialAlternativoBean();
                        bean.setCodigo(MaterialAlternativo.this.txtAlternativo.getText().trim());
                        bean.setAlterar(true);
                        MaterialAlternativo.this.modelo.setValueAt(bean.getCodigo(), MaterialAlternativo.this.linhaAlterada, 0);
                        MaterialAlternativo.this.modelo.setValueAt(bean, MaterialAlternativo.this.linhaAlterada, 1);
                        MaterialAlternativo.this.linhaAlterada = -1;
                    } else if (localizado < 0) {
                        MaterialAlternativoBean bean = new MaterialAlternativoBean();
                        bean.setCodigo(MaterialAlternativo.this.txtAlternativo.getText().trim());
                        bean.setInserir(true);
                        MaterialAlternativo.this.modelo.addLine(new Object[]{bean.getCodigo(), bean});
                    }
                }
                MaterialAlternativo.this.txtAlternativo.clear();
                MaterialAlternativo.this.txtAlternativo.grabFocus();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialAlternativo.this.isOK = true;
                MaterialAlternativo.this.setVisible(false);
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialAlternativo.this.isOK = false;
                MaterialAlternativo.this.setVisible(false);
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = MaterialAlternativo.this.tabela.getSelectedRow();
                if (row == -1) {
                    return;
                }
                if (e.getKeyCode() == 127 && Funcoes.mensagem(MaterialAlternativo.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    MaterialAlternativo.this.modelo.removeLine(row);
                } else if (e.getKeyCode() == 32) {
                    MaterialAlternativo.this.linhaAlterada = row;
                    MaterialAlternativo.this.txtAlternativo.setText(MaterialAlternativo.this.modelo.getValueAt(row, 0).toString());
                    ScreenUtil.requisitarFoco(MaterialAlternativo.this.txtAlternativo);
                }
            }
        });
    }

    public ArrayList<MaterialAlternativoBean> getAlternativos() {
        ArrayList<MaterialAlternativoBean> alternativos = new ArrayList<MaterialAlternativoBean>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            alternativos.add((MaterialAlternativoBean)this.modelo.getValueAt(i, 1));
        }
        return alternativos;
    }

    public void setAlternativos(ArrayList<MaterialAlternativoBean> alternativos) {
        this.modelo.clear();
        for (MaterialAlternativoBean s : alternativos) {
            this.modelo.addLine(new Object[]{s.getCodigo(), s});
        }
    }

    public boolean getOK() {
        return this.isOK;
    }
}

