/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosPatrimonio;
import jalis.laboratorio.cadastro.MaterialAlternativo;
import jalis.laboratorio.cadastro.MaterialCelulas;
import jalis.laboratorio.cadastro.Patrimonio;
import jalis.laboratorio.cadastro.util.AvisarReposicaoEstoque;
import jalis.laboratorio.estoque.VisualizarLoteMaterial;
import jalis.model.bean.cadastro.material.FichaTecnicaBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialAlternativoBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.SaldoEstoqueBean;
import jalis.model.bean.estoque.TipoMaterialBean;
import jalis.model.bean.estoque.UnidadeMedidaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.material.MaterialUsuarioVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialLoteLanctoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.SaldoEstoqueService;
import jalis.service.estoque.TipoMaterialService;
import jalis.service.estoque.UnidadeMedidaService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class Material
extends FrmCadPadrao
implements ActionListener {
    private JLabel labelCodigo;
    private JLabel labelDescricao;
    private JLabel labelUnidade;
    private JLabel labelTipo;
    private JLabel labelValorUnitario;
    private JLabel labelValorIPI = new JLabel("Vl. IPI:");
    private JLabel labelValorFrete = new JLabel("Vl. Frete:");
    private JLabel labelRateioFrete = new JLabel("Rateio Frete:");
    private JLabel labelTotal;
    private JLabel labelReposicao;
    private JLabel labelData;
    private JLabel labelValor;
    private JLabel labelQuantidade;
    private JLabel labelEntrega;
    private JLabel labelEstoque = new JLabel("Estoque atual:");
    private JLabel labelEstoqueAtual = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private JLabel labelFornecedor;
    private JLabel labelVlrTotal = new JLabel();
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o:");
    private JLabel labelDiasAntes = new JLabel("dias antes");
    private TTextField textCodigo;
    private TTextField textDescricao;
    private TTextField textUnidade;
    private TTextField textDescUnidade;
    private TTextField textValorIPI;
    private TTextField textValorFrete;
    private TTextField textRateioFrete;
    private TTextField textValorUnit;
    private TTextField textCodTipo;
    private TTextField textDescTipo;
    private TTextField textDataCompra;
    private TTextField textValorCompra;
    private TTextField textQtdeCompra;
    private TTextField textEntregaCompra;
    private TTextField textFornecedorCompra;
    private TTextField textPtoReposicao;
    private TTextField textMarca = new TTextField(80);
    private TTextField textModelo = new TTextField(80);
    private TTextField textDias = ComponenteFactory.novoTTextField(3, 1);
    private JButton buttonBuscaUnidade;
    private JButton buttonBuscaTipo;
    private JButton buttonBuscaDataCompra;
    private JButton buttonBuscaDataEntrega;
    private JButton buttonPatrimonio = ComponenteFactory.novoJButton("Patrim\u00f4nios", 'P', this);
    private JButton buttonCelula = ComponenteFactory.novoJButton("C\u00e9lulas", 'l', this);
    private JButton buttonLotes = ComponenteFactory.novoJButton("Lotes", 't', this);
    private JButton buttonAlternativo = ComponenteFactory.novoJButton("Alternativos", 'n', this);
    private JButton buttonBuscaUsuarioVencimento = ComponenteFactory.novoJButton("Usu\u00e1rios", 'n', this);
    private JButton buttonBuscaUsuarioReposicao = ComponenteFactory.novoJButton("Usu\u00e1rios", 'n', this);
    private JPanel panelCompra;
    private JPanel panelEstoque = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Estoque"));
    private JCheckBox checkImobilizado = new JCheckBox("Imobilizado");
    private JCheckBox checkPatrimonio = new JCheckBox("Solicitar patrim\u00f4nio");
    private JCheckBox checkAvisarReposicao = new JCheckBox("Avisar quando produto atingir ponto de reposi\u00e7\u00e3o");
    private JCheckBox checkReutilizavel = new JCheckBox("Reutiliz\u00e1vel");
    private JCheckBox checkSolicitarLote = new JCheckBox("Solicitar lote");
    private JCheckBox checkAvisarVencimentoLote = new JCheckBox("Avisar vencimento do lote");
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    private JTextArea areaObservacao = new JTextArea();
    private JScrollPane scrollObservacao = new JScrollPane(this.areaObservacao);
    private ArrayList<DadosPatrimonio> patrimonios = null;
    private ArrayList<FichaTecnicaBean> fichaTecnica = null;
    private ArrayList<MaterialLoteBean> lotes = null;
    private ArrayList<MaterialAlternativoBean> materiaisAlternativos = new ArrayList();
    int casas = 4;
    RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
    private static JDialog diagPai = null;
    private String retornoParaPesquisa = "";
    private List<MaterialUsuarioVO> listaUsuarios = new ArrayList<MaterialUsuarioVO>();
    private List<List<Object>> loteLanctoInserir = new ArrayList<List<Object>>();
    private List<List<Object>> loteLanctoRemover = new ArrayList<List<Object>>();
    private MaterialLoteService materialLoteService = new MaterialLoteService();
    private MaterialLoteLanctoEstoqueService materialLoteLanctoEstoqueService = new MaterialLoteLanctoEstoqueService();
    private MaterialBean beanMat;
    private Boolean flagAcaoMouseLote = false;
    String descricao;
    String descricaoTipo;
    String unidade;
    boolean solicitarLote = false;
    boolean cancelada = false;
    String codigoAlternativo = null;

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Material.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101300301"));
        this.setModuloEdita(Long.parseLong("0101300302"));
        this.setModuloApaga(Long.parseLong("0101300303"));
    }

    public static void novaInstanciaDialog(Frame owner) {
        diagPai = new JDialog(owner, "Cadastro de Materiais", true);
        diagPai.setSize(550, 580);
        diagPai.setLocationRelativeTo(null);
        Material mat = new Material();
        Container container = diagPai.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)mat, "Center");
        diagPai.setVisible(true);
    }

    public Material() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Material");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.textUnidade.setUpperCase(false);
    }

    public Material(String codigoAlternativo) {
        try {
            this.codigoAlternativo = codigoAlternativo;
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Material");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.textUnidade.setUpperCase(false);
    }

    public void jbInit() throws Exception {
        this.setLabelDescricao("Cadastro de materiais para controle de estoque");
        this.setLabelFormulario("Cadastro de materiais");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_material.jpg"));
        this.labelCodigo = new JLabel();
        this.textCodigo = new TTextField(5, 1);
        this.checkInativo.setBounds(592, 9, 75, 14);
        this.textDescricao = new TTextField(200);
        this.labelDescricao = new JLabel();
        this.labelUnidade = new JLabel();
        this.textUnidade = new TTextField(8);
        this.buttonBuscaUnidade = new JButton();
        this.buttonBuscaTipo = new JButton();
        this.buttonBuscaDataCompra = new JButton();
        this.buttonBuscaDataEntrega = new JButton();
        this.textDescUnidade = new TTextField(80);
        this.textDescTipo = new TTextField(80);
        this.labelTipo = new JLabel();
        this.labelValorUnitario = new JLabel();
        this.labelReposicao = new JLabel();
        this.textValorUnit = new TTextField(12, 2, 4);
        this.textPtoReposicao = new TTextField(12, 2, 3);
        this.textCodTipo = new TTextField(5, 1);
        this.textValorIPI = new TTextField(15, 2, 4);
        this.textValorFrete = new TTextField(15, 2, 2);
        this.textRateioFrete = new TTextField(15, 2, 2);
        this.areaObservacao.setToolTipText("M\u00e1ximo: 250 caracteres");
        this.areaObservacao.setLineWrap(true);
        this.scrollObservacao.setBounds(new Rectangle(97, 156, 561, 60));
        this.scrollObservacao.setPreferredSize(new Dimension(561, 60));
        this.labelObservacao.setBounds(new Rectangle(5, 156, 90, 14));
        this.panelCompra = new JPanel();
        this.panelCompra.setBorder(new TitledBorder("Informa\u00e7\u00f5es da \u00faltima compra realizada"));
        this.panelCompra.setBounds(new Rectangle(5, 216, 654, 110));
        this.labelTotal = new JLabel("Total:");
        this.labelData = new JLabel("Data:");
        this.labelValor = new JLabel("Vl. Unit\u00e1rio:");
        this.labelQuantidade = new JLabel("Quantidade:");
        this.labelEntrega = new JLabel("Entrega:");
        this.labelFornecedor = new JLabel("Fornecedor:");
        this.textDataCompra = new TTextField(10, 4);
        this.textFornecedorCompra = new TTextField();
        this.textValorCompra = new TTextField(12, 2, 4);
        this.textQtdeCompra = new TTextField(12, 2, 3);
        this.textEntregaCompra = new TTextField(10, 4);
        Funcoes.imagemPesquisa(this.buttonBuscaDataCompra);
        this.buttonBuscaDataCompra.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaDataEntrega);
        this.buttonBuscaDataEntrega.setFocusable(false);
        this.panelCompra.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelCompra.add((Component)this.labelData, c);
        ++c.gridx;
        this.textDataCompra.setMinimumSize(new Dimension(80, 20));
        this.textDataCompra.setMaximumSize(new Dimension(80, 20));
        this.panelCompra.add((Component)this.textDataCompra, c);
        ++c.gridx;
        this.buttonBuscaDataCompra.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaDataCompra.setMaximumSize(new Dimension(20, 20));
        this.panelCompra.add((Component)this.buttonBuscaDataCompra, c);
        c.insets = new Insets(1, 20, 1, 1);
        ++c.gridx;
        this.panelCompra.add((Component)this.labelEntrega, c);
        c.insets = new Insets(1, 1, 1, 1);
        ++c.gridx;
        this.textEntregaCompra.setMinimumSize(new Dimension(80, 20));
        this.textEntregaCompra.setMaximumSize(new Dimension(80, 20));
        this.panelCompra.add((Component)this.textEntregaCompra, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.buttonBuscaDataEntrega.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaDataEntrega.setMaximumSize(new Dimension(20, 20));
        this.panelCompra.add((Component)this.buttonBuscaDataEntrega, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.panelCompra.add((Component)this.labelQuantidade, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textQtdeCompra.setMinimumSize(new Dimension(102, 20));
        this.textQtdeCompra.setMaximumSize(new Dimension(102, 20));
        this.panelCompra.add((Component)this.textQtdeCompra, c);
        c.gridwidth = 1;
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 1);
        this.panelCompra.add((Component)this.labelValor, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = new Insets(1, 1, 1, 1);
        this.textValorCompra.setMinimumSize(new Dimension(102, 20));
        this.textValorCompra.setMaximumSize(new Dimension(102, 20));
        this.panelCompra.add((Component)this.textValorCompra, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelValorFrete.setMinimumSize(new Dimension(80, 20));
        this.labelValorFrete.setMaximumSize(new Dimension(80, 20));
        this.panelCompra.add((Component)this.labelValorFrete, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textValorFrete.setMinimumSize(new Dimension(102, 20));
        this.textValorFrete.setMaximumSize(new Dimension(102, 20));
        this.panelCompra.add((Component)this.textValorFrete, c);
        c.gridwidth = 1;
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 1);
        this.labelValorIPI.setMinimumSize(new Dimension(70, 20));
        this.labelValorIPI.setMaximumSize(new Dimension(70, 20));
        this.panelCompra.add((Component)this.labelValorIPI, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = new Insets(1, 1, 1, 1);
        this.textValorIPI.setMinimumSize(new Dimension(102, 20));
        this.textValorIPI.setMaximumSize(new Dimension(102, 20));
        this.panelCompra.add((Component)this.textValorIPI, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = new Insets(1, 18, 1, 1);
        this.labelTotal.setMinimumSize(new Dimension(35, 20));
        this.labelTotal.setMaximumSize(new Dimension(35, 20));
        this.panelCompra.add((Component)this.labelTotal, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelVlrTotal.setBorder(new TitledBorder(""));
        this.labelVlrTotal.setMinimumSize(new Dimension(120, 20));
        this.labelVlrTotal.setMaximumSize(new Dimension(120, 20));
        this.labelVlrTotal.setHorizontalAlignment(4);
        this.panelCompra.add((Component)this.labelVlrTotal, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        this.labelRateioFrete.setMinimumSize(new Dimension(80, 20));
        this.labelRateioFrete.setMaximumSize(new Dimension(80, 20));
        this.panelCompra.add((Component)this.labelRateioFrete, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textRateioFrete.setMinimumSize(new Dimension(102, 20));
        this.textRateioFrete.setMaximumSize(new Dimension(102, 20));
        this.panelCompra.add((Component)this.textRateioFrete, c);
        c.gridwidth = 1;
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 1);
        this.labelFornecedor.setMinimumSize(new Dimension(80, 20));
        this.labelFornecedor.setMaximumSize(new Dimension(80, 20));
        this.panelCompra.add((Component)this.labelFornecedor, c);
        c.gridwidth = 8;
        ++c.gridx;
        c.fill = 2;
        c.weightx = 2.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.textFornecedorCompra.setMinimumSize(new Dimension(220, 20));
        this.textFornecedorCompra.setMaximumSize(new Dimension(220, 20));
        this.panelCompra.add((Component)this.textFornecedorCompra, c);
        this.labelEstoqueAtual.setPreferredSize(new Dimension(100, 20));
        this.labelEstoqueAtual.setMinimumSize(new Dimension(100, 20));
        this.labelEstoqueAtual.setMaximumSize(new Dimension(100, 20));
        this.labelEstoqueAtual.setHorizontalAlignment(4);
        GridBagConstraints pc = new GridBagConstraints();
        pc.insets = new Insets(1, 1, 1, 1);
        pc.gridx = 0;
        pc.gridy = 0;
        pc.anchor = 17;
        this.panelEstoque.add((Component)this.labelEstoque, pc);
        ++pc.gridx;
        this.panelEstoque.add((Component)this.labelEstoqueAtual, pc);
        ++pc.gridx;
        pc.fill = 2;
        pc.weightx = 1.0;
        pc.anchor = 13;
        pc.insets = new Insets(1, 20, 1, 1);
        this.panelEstoque.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 5, 1, this.buttonCelula, this.buttonPatrimonio, this.buttonLotes), pc);
        this.panelEstoque.setBounds(5, 327, 654, 50);
        JPanel panelUsuario = new JPanel(new GridBagLayout());
        panelUsuario.setBorder(new TitledBorder("Avisos"));
        panelUsuario.setBounds(new Rectangle(5, 377, 654, 70));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 4;
        this.checkAvisarReposicao.setMnemonic('q');
        panelUsuario.add((Component)this.checkAvisarReposicao, gc);
        gc.gridx += 4;
        gc.gridwidth = 1;
        this.buttonBuscaUsuarioReposicao.setMinimumSize(new Dimension(100, 20));
        this.buttonBuscaUsuarioReposicao.setPreferredSize(new Dimension(100, 20));
        panelUsuario.add((Component)this.buttonBuscaUsuarioReposicao, gc);
        ++gc.gridy;
        gc.gridx = 0;
        this.checkAvisarVencimentoLote.setMnemonic('q');
        panelUsuario.add((Component)this.checkAvisarVencimentoLote, gc);
        ++gc.gridx;
        this.textDias.setMinimumSize(new Dimension(30, 20));
        this.textDias.setPreferredSize(new Dimension(30, 20));
        panelUsuario.add((Component)this.textDias, gc);
        ++gc.gridx;
        gc.gridwidth = 1;
        panelUsuario.add((Component)this.labelDiasAntes, gc);
        gc.gridx += 2;
        gc.gridwidth = 1;
        this.buttonBuscaUsuarioVencimento.setMinimumSize(new Dimension(100, 20));
        this.buttonBuscaUsuarioVencimento.setPreferredSize(new Dimension(100, 20));
        panelUsuario.add((Component)this.buttonBuscaUsuarioVencimento, gc);
        gc.gridx = 5;
        gc.gridy = 0;
        gc.gridheight = 2;
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(230, 0));
        panel.setPreferredSize(new Dimension(230, 0));
        panelUsuario.add((Component)panel, gc);
        JPanel panelAlternativo = ComponenteFactory.novoJPanelFlowLayout(2, 1, 1, this.buttonAlternativo);
        panelAlternativo.setBounds(new Rectangle(532, 450, 125, 50));
        JPanel panelAlternativoMensagem = null;
        if (!StringUtil.isEmpty(this.codigoAlternativo)) {
            JLabel labelMensagem = new JLabel();
            labelMensagem.setText("<html><b><font color='#FF9900'>O material alternativo '" + this.codigoAlternativo + "' ser\u00e1 relacionado com esse material. </font></b></html>");
            panelAlternativoMensagem = ComponenteFactory.novoJPanelFlowLayout(0, 1, 1, labelMensagem);
            panelAlternativoMensagem.setBounds(new Rectangle(5, 450, 500, 50));
        }
        this.labelCodigo.setDisplayedMnemonic('i');
        this.labelCodigo.setLabelFor(this.textCodigo);
        this.labelCodigo.setText("C\u00f3digo:");
        this.labelCodigo.setBounds(new Rectangle(5, 9, 55, 14));
        this.textCodigo.setText("");
        this.textCodigo.setBounds(new Rectangle(97, 7, 69, 20));
        this.textDescricao.setBounds(new Rectangle(97, 28, 560, 20));
        this.textDescricao.setText("");
        this.labelDescricao.setBounds(new Rectangle(5, 30, 63, 14));
        this.labelDescricao.setText("Descri\u00e7\u00e3o:");
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.labelDescricao.setDisplayedMnemonic('r');
        this.labelUnidade.setDisplayedMnemonic('U');
        this.labelUnidade.setLabelFor(this.textUnidade);
        this.labelUnidade.setText("Unidade:");
        this.labelUnidade.setBounds(new Rectangle(5, 51, 63, 14));
        this.textUnidade.setText("");
        this.textUnidade.setBounds(new Rectangle(97, 49, 69, 20));
        this.buttonBuscaUnidade.setBounds(new Rectangle(167, 49, 20, 20));
        this.buttonBuscaUnidade.setFocusable(false);
        this.buttonBuscaUnidade.setText("");
        Funcoes.imagemPesquisa(this.buttonBuscaUnidade);
        this.textDescUnidade.setText("");
        this.textDescUnidade.setEditable(false);
        this.textDescUnidade.setFocusable(false);
        this.textDescUnidade.setBounds(new Rectangle(188, 49, 469, 20));
        this.labelTipo.setText("Tipo:");
        this.labelTipo.setBounds(new Rectangle(5, 72, 63, 14));
        this.textCodTipo.setText("");
        this.textCodTipo.setBounds(new Rectangle(97, 70, 69, 20));
        this.buttonBuscaTipo.setBounds(new Rectangle(167, 70, 20, 20));
        this.buttonBuscaTipo.setFocusable(false);
        this.buttonBuscaTipo.setText("");
        Funcoes.imagemPesquisa(this.buttonBuscaTipo);
        this.textDescTipo.setText("");
        this.textDescTipo.setEditable(false);
        this.textDescTipo.setFocusable(false);
        this.textDescTipo.setBounds(new Rectangle(188, 70, 469, 20));
        this.labelValorUnitario.setLabelFor(this.textValorUnit);
        this.labelValorUnitario.setText("Valor Unit\u00e1rio:");
        this.labelValorUnitario.setBounds(new Rectangle(5, 114, 92, 14));
        this.labelValorUnitario.setDisplayedMnemonic('V');
        this.labelValorUnitario.setLabelFor(this.textValorUnit);
        this.labelReposicao.setLabelFor(this.textValorUnit);
        this.labelReposicao.setText("Reposi\u00e7\u00e3o:");
        this.labelReposicao.setBounds(new Rectangle(305, 114, 92, 14));
        this.textValorUnit.setText("");
        this.textValorUnit.setBounds(new Rectangle(97, 112, 92, 20));
        this.textPtoReposicao.setText("");
        this.textPtoReposicao.setBounds(new Rectangle(376, 112, 116, 20));
        JLabel labelMarca = new JLabel("Marca:");
        labelMarca.setBounds(new Rectangle(5, 93, 92, 14));
        labelMarca.setDisplayedMnemonic('M');
        labelMarca.setLabelFor(this.textMarca);
        this.textMarca.setBounds(new Rectangle(97, 91, 186, 20));
        JLabel labelModelo = new JLabel("Modelo:");
        labelModelo.setBounds(new Rectangle(305, 93, 92, 14));
        labelModelo.setDisplayedMnemonic('o');
        labelModelo.setLabelFor(this.textModelo);
        this.textModelo.setBounds(new Rectangle(376, 91, 281, 20));
        this.checkImobilizado.setBounds(new Rectangle(94, 135, 110, 20));
        this.checkImobilizado.setMnemonic('b');
        this.checkReutilizavel.setBounds(new Rectangle(230, 135, 106, 20));
        this.checkReutilizavel.setMnemonic('z');
        this.checkSolicitarLote.setBounds(372, 135, 113, 20);
        this.checkSolicitarLote.setMnemonic('a');
        this.checkPatrimonio.setBounds(new Rectangle(512, 135, 154, 20));
        this.checkPatrimonio.setMnemonic('t');
        this.painelCentral.add(panelAlternativo);
        if (!StringUtil.isEmpty(this.codigoAlternativo)) {
            this.painelCentral.add(panelAlternativoMensagem);
        }
        this.painelCentral.add(this.labelDescricao);
        this.painelCentral.add(this.labelCodigo);
        this.painelCentral.add(this.checkInativo);
        this.painelCentral.add(this.labelValorUnitario);
        this.painelCentral.add(this.labelTipo);
        this.painelCentral.add(this.labelUnidade);
        this.painelCentral.add(this.textCodTipo);
        this.painelCentral.add(this.buttonBuscaTipo);
        this.painelCentral.add(this.textDescTipo);
        this.painelCentral.add(this.textValorUnit);
        this.painelCentral.add(this.labelObservacao);
        this.painelCentral.add(this.labelReposicao);
        this.painelCentral.add(this.textPtoReposicao);
        this.painelCentral.add(this.textUnidade);
        this.painelCentral.add(this.textDescricao);
        this.painelCentral.add(this.textCodigo);
        this.painelCentral.add(this.buttonBuscaUnidade);
        this.painelCentral.add(this.textDescUnidade);
        this.painelCentral.add(this.scrollObservacao);
        this.painelCentral.add(this.panelCompra);
        this.painelCentral.add(panelUsuario);
        this.painelCentral.add(this.panelEstoque);
        this.painelCentral.add(this.checkImobilizado);
        this.painelCentral.add(this.checkPatrimonio);
        this.painelCentral.add(this.checkReutilizavel);
        this.painelCentral.add(this.checkSolicitarLote);
        this.painelCentral.add(this.textMarca);
        this.painelCentral.add(this.textModelo);
        this.painelCentral.add(labelMarca);
        this.painelCentral.add(labelModelo);
        this.controlaCampos();
        this.checkPatrimonio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = Material.this.getStatus() == 3 || Material.this.getStatus() == 2;
            }
        });
        this.checkImobilizado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = Material.this.getStatus() == 3 || Material.this.getStatus() == 2;
                Material.this.buttonPatrimonio.setEnabled(Material.this.checkImobilizado.isSelected() && enabled);
                Material.this.checkPatrimonio.setEnabled(Material.this.checkImobilizado.isSelected() && enabled);
            }
        });
        this.checkAvisarReposicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.habilitarUsuario(Material.this.checkAvisarReposicao.isSelected(), "R");
            }
        });
        this.checkAvisarVencimentoLote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.habilitarUsuario(Material.this.checkAvisarVencimentoLote.isSelected(), "L");
            }
        });
        this.buttonBuscaUnidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.buscaUnidade();
            }
        });
        this.buttonBuscaTipo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.buscaTipo();
            }
        });
        this.buttonBuscaUsuarioReposicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.adicionarUsuarioMaterial("R");
            }
        });
        this.buttonBuscaUsuarioVencimento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.adicionarUsuarioMaterial("L");
            }
        });
        this.buttonBuscaDataCompra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.dataCompra();
            }
        });
        this.buttonBuscaDataEntrega.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material.this.dataEntrega();
            }
        });
        this.buttonLotes.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent e) {
                Boolean bl = Material.this.flagAcaoMouseLote;
                synchronized (bl) {
                    if (Material.this.buttonLotes.isEnabled()) {
                        Material.this.flagAcaoMouseLote = true;
                        Material.this.mostrarLotes((e.getModifiersEx() & 0x40) != 0);
                        Material.this.flagAcaoMouseLote = false;
                    }
                }
            }
        });
        this.textUnidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Material.this.textUnidade.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select unm_codigo, unm_descricao from unidademedida where fil_codigo = " + Variaveis.filialPadrao + " and upper(unm_codigo) = upper(" + Material.this.textUnidade.getTextDBEscape() + ") ");
                        if (rs.next()) {
                            Material.this.textUnidade.setText(rs.getString("unm_codigo"));
                            Material.this.textDescUnidade.setText(rs.getString("unm_descricao"));
                        } else {
                            Material.this.textDescUnidade.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Material.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Material.this.setStatus(1);
                        Material.this.controlaCampos();
                    }
                }
            }
        });
        this.textCodTipo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Material.this.textCodTipo.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select tpm_descricao from tipomaterial where fil_codigo = " + Variaveis.filialPadrao + " and tpm_codigo=" + Material.this.textCodTipo.getText());
                        if (rs.next()) {
                            Material.this.textDescTipo.setText(rs.getString("tpm_descricao"));
                        } else {
                            Material.this.textDescTipo.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Material.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Material.this.setStatus(1);
                        Material.this.controlaCampos();
                    }
                }
            }
        });
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Material.this.beanMat = null;
                EntidadeVO fornecedor = null;
                if (Material.this.textCodigo.getText().isEmpty()) {
                    Funcoes.mensagem(Material.this, "N\u00e3o \u00e9 poss\u00edvel localizar o material.", 2);
                    return;
                }
                try {
                    Conexao.setSessaoConexao(true);
                    MaterialService materialService = new MaterialService();
                    Material.this.beanMat = (MaterialBean)materialService.getTodosSemLote(Variaveis.filialPadrao, Material.this.textCodigo.getText(), null, null);
                    Conexao.setSessaoConexao(false);
                    fornecedor = new MaterialService().getUltimoFornecedorCompra(Variaveis.filialPadrao, Material.this.textCodigo.getText());
                    Material.this.listaUsuarios = materialService.buscaUsuarioMaterial(Variaveis.filialPadrao, Material.this.textCodigo.getText());
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Material.this, "N\u00e3o \u00e9 poss\u00edvel carregar os dados do material.\n" + e1.getMessage(), e1.getStackTrace());
                    return;
                }
                if (Material.this.beanMat != null) {
                    Material.this.areaObservacao.setText(Material.this.beanMat.getObservacao());
                    Material.this.checkInativo.setSelected(Material.this.beanMat.getInativo());
                    Material.this.textDescricao.setText(Material.this.beanMat.getDescricao());
                    Material.this.textUnidade.setText(Material.this.beanMat.getUnidadeMedida().getCodigo());
                    Material.this.textDescUnidade.setText(Material.this.beanMat.getUnidadeMedida().getDescricao());
                    Material.this.textValorUnit.setText(Funcoes.formataDecimal("#,##0.0000", Material.this.beanMat.getValorUnitario()));
                    Material.this.textPtoReposicao.setText(Funcoes.formataDecimal(Material.this.textPtoReposicao.getMaskDecimal(), Material.this.beanMat.getPontoReposicao()));
                    Material.this.textCodTipo.setText(Material.this.beanMat.getTipoMaterial().getCodigo().toString());
                    Material.this.textDescTipo.setText(Material.this.beanMat.getTipoMaterial().getDescricao());
                    if (Funcoes.verificaData(Funcoes.formataData(Material.this.beanMat.getDataUltimaCompra()))) {
                        Material.this.textDataCompra.setText(Funcoes.formataData(Material.this.beanMat.getDataUltimaCompra()));
                    }
                    Material.this.textQtdeCompra.setText(Funcoes.formataDecimal("#,##0.000", Material.this.beanMat.getQuantidadeUltimaCompra()));
                    Material.this.textValorCompra.setText(Funcoes.formataDecimal("#,##0.0000", Material.this.beanMat.getValorUltimaCompra()));
                    Material.this.textValorFrete.setText(Funcoes.formataDecimal("#,##0.0000", Material.this.beanMat.getFreteUltimaCompra()));
                    Material.this.textRateioFrete.setText(Funcoes.formataDecimal("#,##0.0000", Material.this.beanMat.getCalculoRateioFreteUltimaCompra()));
                    Material.this.textValorIPI.setText(Funcoes.formataDecimal("#,##0.0000", Material.this.beanMat.getIpiUltimaCompra()));
                    if (fornecedor != null) {
                        Material.this.textFornecedorCompra.setText(fornecedor.getFantasia());
                    } else {
                        Material.this.textFornecedorCompra.setText("");
                    }
                    if (Funcoes.verificaData(Funcoes.formataData(Material.this.beanMat.getDataUltimaEntrega()))) {
                        Material.this.textEntregaCompra.setText(Funcoes.formataData(Material.this.beanMat.getDataUltimaEntrega()));
                    }
                    SaldoEstoqueBean bean = null;
                    try {
                        bean = (SaldoEstoqueBean)new SaldoEstoqueService().getSaldoAtualEstoqueMaterial(Variaveis.filialPadrao, Material.this.beanMat.getCodigo().toString());
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao buscar saldo de estoque. " + e1.getMessage(), e1.getStackTrace());
                        return;
                    }
                    Double estoque = bean != null ? bean.getSaldo() : 0.0;
                    Material.this.labelEstoqueAtual.setText(Funcoes.formataDecimal("#,##0.00", estoque));
                    Material.this.textMarca.setText(Material.this.beanMat.getMarca());
                    Material.this.textModelo.setText(Material.this.beanMat.getModelo());
                    Material.this.checkSolicitarLote.setSelected(Material.this.beanMat.getSolicitarLote() == null ? false : Material.this.beanMat.getSolicitarLote());
                    Material.this.checkPatrimonio.setSelected(Material.this.beanMat.getSolicitarPatrimonio() == null ? false : Material.this.beanMat.getSolicitarPatrimonio());
                    Material.this.checkImobilizado.setSelected(Material.this.beanMat.getImobilizado() == null ? false : Material.this.beanMat.getImobilizado());
                    Material.this.checkReutilizavel.setSelected(Material.this.beanMat.getReutilizavel() == null ? false : Material.this.beanMat.getReutilizavel());
                    Material.this.checkAvisarReposicao.setSelected(Material.this.beanMat.getReposicaoAutomatica() == null ? false : Material.this.beanMat.getReposicaoAutomatica());
                    Material.this.checkAvisarVencimentoLote.setSelected(Material.this.beanMat.isAvisarValidadeLote());
                    Material.this.textDias.setText(Material.this.beanMat.getDiasAvisoLote() == null ? "" : Material.this.beanMat.getDiasAvisoLote().toString());
                    Material.this.habilitarUsuario(Material.this.checkAvisarReposicao.isSelected(), "R");
                    Material.this.habilitarUsuario(Material.this.checkAvisarVencimentoLote.isSelected(), "L");
                    MaterialPatrimonioService servicePatrimonioMaterial = new MaterialPatrimonioService();
                    ArrayList<MaterialPatrimonioBean> listaPatrimonios = Material.this.beanMat.getPatrimonios();
                    for (int i = 0; i < listaPatrimonios.size(); ++i) {
                        if (Material.this.patrimonios == null) {
                            Material.this.patrimonios = new ArrayList();
                        }
                        MaterialPatrimonioBean beanPat = listaPatrimonios.get(i);
                        DadosPatrimonio dados = null;
                        try {
                            dados = new DadosPatrimonio(Material.this.beanMat, beanPat.getPatrimonio(), beanPat.getSerie(), beanPat.getNumeroNotaFiscal() == null ? null : beanPat.getNumeroNotaFiscal().toString(), beanPat.getSetor(), servicePatrimonioMaterial.podeAlterarPatrimonioMaterial(Variaveis.filialPadrao, Material.this.textCodigo.getText(), beanPat.getPatrimonio()), false);
                        }
                        catch (Exception e1) {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao buscar dados dos patrim\u00f4nios. " + e1.getMessage(), e1.getStackTrace());
                            return;
                        }
                        Material.this.patrimonios.add(dados);
                    }
                    Material.this.controlaCampos();
                    Material.this.fichaTecnica = Material.this.beanMat.getMateriaisComposicao();
                    Material.this.materiaisAlternativos = Material.this.beanMat.getMateriaisAlternativos();
                    Material.this.textCodigo.setEnabled(false);
                    Material.this.calcularValorTotalMaterial();
                } else if (Material.this.getStatus() == 3) {
                    Funcoes.mensagem(Material.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                    Material.this.setStatus(1);
                    Material.this.controlaCampos();
                }
            }
        });
        this.textQtdeCompra.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Material.this.calcularValorTotalMaterial();
            }
        });
        this.textValorCompra.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Material.this.calcularValorTotalMaterial();
            }
        });
        this.checkSolicitarLote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Material.this.validaMudancaEmLote()) {
                    Material.this.buttonLotes.setEnabled(Material.this.checkSolicitarLote.isSelected() && Material.this.getStatus() == 3);
                }
            }
        });
    }

    private boolean validaMudancaEmLote() {
        Double qtde;
        if (this.getStatus() != 2 && (qtde = Double.valueOf(!this.labelEstoqueAtual.getText().isEmpty() && Funcoes.isNumeric(this.labelEstoqueAtual.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.labelEstoqueAtual.getText())) : 0.0)) > 0.0) {
            Funcoes.mensagem(this, "A solicita\u00e7\u00e3o de lote s\u00f3 pode ser alterada com o estoque vazio", 2);
            this.checkSolicitarLote.setSelected(!this.checkSolicitarLote.isSelected());
        }
        return true;
    }

    private void calcularValorTotalMaterial() {
        if (!Funcoes.textoVazio(this.textQtdeCompra) && !Funcoes.textoVazio(this.textValorCompra)) {
            BigDecimal qtde = new BigDecimal(Funcoes.limpaDecimal(this.textQtdeCompra.getText())).setScale(this.casas, this.round);
            BigDecimal unitario = new BigDecimal(Funcoes.limpaDecimal(this.textValorCompra.getText())).setScale(this.casas, this.round);
            BigDecimal valor = qtde.multiply(unitario);
            valor = valor.setScale(this.casas, this.round);
            valor = valor.add(new BigDecimal(Funcoes.limpaDecimal(this.textValorIPI.getText())).setScale(this.casas, this.round));
            this.labelVlrTotal.setText(Funcoes.formataDecimal(valor.doubleValue(), this.casas));
        } else {
            this.labelVlrTotal.setText(Funcoes.formataDecimal(0.0));
        }
    }

    private void controlaButtonPatrimonio(boolean enabled) {
        boolean aux = enabled && this.checkImobilizado.isSelected();
        this.buttonPatrimonio.setEnabled(aux);
        this.checkPatrimonio.setEnabled(aux);
        this.checkPatrimonio.setSelected(this.checkPatrimonio.isSelected() && aux);
    }

    private void controlaButtonLote(boolean enabled) {
        this.buttonLotes.setEnabled(enabled && this.checkSolicitarLote.isSelected());
    }

    private void habilitarUsuario(boolean b, String tipo) {
        if (tipo.equals("R")) {
            this.buttonBuscaUsuarioReposicao.setEnabled(b);
        } else {
            this.buttonBuscaUsuarioVencimento.setEnabled(b);
            if (!b) {
                this.textDias.setText("0");
            }
            this.textDias.setEnabled(b);
        }
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.materialTodos(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.textCodigo.setText(resultado.get("mat_codigo").toString());
            this.textCodigo.requestFocus();
        }
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.textCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null && this.podeExcluir()) {
                    SalvaDados salvar = new SalvaDados("materialpatrimonio", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mat_codigo", 2, false, true, this.textCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMaterial());
                    salvar = new SalvaDados("materialalternativo", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mat_codigo", 2, false, true, this.textCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMaterial());
                    salvar = new SalvaDados("material", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mat_codigo", 2, false, true, this.textCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMaterial());
                    Conexao.arquivaSQL();
                } else if (this.checkInativo.isSelected()) {
                    Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel excluir, pois o material j\u00e1 possui movimenta\u00e7\u00e3o e se encontra inativo.", 2);
                } else if (Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel fazer a exclus\u00e3o, pois o material possui movimenta\u00e7\u00e3o no estoque.\nDeseja inativar o material?", 4) == 0) {
                    SalvaDados salvar = new SalvaDados("material", 2);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("mat_codigo", 2, false, true, this.textCodigo.getText());
                    salvar.adicionaCampo("mat_inativo", 4, false, false, Boolean.TRUE);
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaMaterial());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Material");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    private boolean podeExcluir() {
        LancamentoEstoqueService les = new LancamentoEstoqueService();
        try {
            ArrayList<LancamentoEstoqueBean> lanctos = les.getLancamentosMaterial(Variaveis.filialPadrao, this.textCodigo.getText(), 1);
            if (lanctos != null && lanctos.size() > 0) {
                return false;
            }
        }
        catch (ThreadDaoException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Material");
        }
        return true;
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.cancelada = true;
            this.setVisible(false);
            if (diagPai != null) {
                diagPai.setVisible(false);
            }
        }
    }

    @Override
    public void novo() {
        this.beanMat = new MaterialBean();
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.textDescricao.grabFocus();
    }

    private MaterialBean getBeanPreenchido() {
        try {
            MaterialBean material = new MaterialBean();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            if (!this.textCodigo.getText().isEmpty()) {
                material.setCodigo(Integer.parseInt(this.textCodigo.getText()));
            }
            material.setFilial(filial);
            material.setDescricao(this.textDescricao.getText());
            material.setInativo(this.checkInativo.isSelected());
            material.setValorUnitario(Funcoes.isNumeric(this.textValorUnit.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorUnit.getText())) : 0.0);
            material.setPontoReposicao(Funcoes.isNumeric(this.textPtoReposicao.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPtoReposicao.getText())) : 0.0);
            material.setDataUltimaCompra(Funcoes.verificaData(this.textDataCompra.getText()) ? Funcoes.getData("dd/MM/yyyy", this.textDataCompra.getText()) : new Date());
            material.setValorUltimaCompra(Funcoes.isNumeric(this.textValorCompra.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorCompra.getText())) : 0.0);
            material.setQuantidadeUltimaCompra(Funcoes.isNumeric(this.textQtdeCompra.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textQtdeCompra.getText())) : 0.0);
            material.setDataUltimaEntrega(Funcoes.verificaData(this.textEntregaCompra.getText()) ? Funcoes.getData("dd/MM/yyyy", this.textEntregaCompra.getText()) : new Date());
            TipoMaterialBean tipoMaterial = (TipoMaterialBean)new TipoMaterialService().get(Variaveis.filialPadrao, this.textCodTipo.getText());
            material.setTipoMaterial(tipoMaterial);
            material.setMarca(this.textMarca.getText());
            material.setModelo(this.textModelo.getText());
            material.setImobilizado(this.checkImobilizado.isSelected());
            material.setSolicitarPatrimonio(this.checkPatrimonio.isSelected());
            material.setReposicaoAutomatica(this.checkAvisarReposicao.isSelected());
            material.setReutilizavel(this.checkReutilizavel.isSelected());
            material.setSolicitarLote(this.checkSolicitarLote.isSelected());
            material.setAvisarValidadeLote(this.checkAvisarVencimentoLote.isSelected());
            material.setDiasAvisoLote(Funcoes.isNumeric(this.textDias.getText()) ? Integer.valueOf(this.textDias.getText()) : 0);
            String observacao = this.areaObservacao.getText();
            material.setObservacao(observacao.length() > 250 ? observacao.substring(0, 250) : observacao);
            BigDecimal qtde = new BigDecimal(material.getQuantidadeUltimaCompra().toString()).setScale(this.casas, this.round);
            BigDecimal unitario = new BigDecimal(material.getValorUltimaCompra().toString()).setScale(this.casas, this.round);
            BigDecimal valor = qtde.multiply(unitario).setScale(this.casas, this.round);
            material.setValorTotalUltimaCompra(valor.doubleValue());
            if (!Funcoes.textoVazio(this.textUnidade.getText())) {
                UnidadeMedidaBean unidade = (UnidadeMedidaBean)new UnidadeMedidaService().get(Variaveis.filialPadrao, this.textUnidade.getText());
                material.setUnidadeMedida(unidade);
            }
            ArrayList<MaterialPatrimonioBean> listaPatrimonios = new ArrayList<MaterialPatrimonioBean>();
            if (this.patrimonios != null) {
                for (int i = 0; i < this.patrimonios.size(); ++i) {
                    DadosPatrimonio dados = this.patrimonios.get(i);
                    MaterialPatrimonioBean patrimonio = new MaterialPatrimonioBean();
                    patrimonio.setFilial(filial);
                    patrimonio.setMaterial((MaterialVO)material.toVO());
                    patrimonio.setNumeroNotaFiscal(Funcoes.textoVazio(dados.getNotaFiscal()) ? null : Integer.valueOf(Integer.parseInt(dados.getNotaFiscal())));
                    patrimonio.setSerie(dados.getSerie());
                    patrimonio.setPatrimonio(dados.getPatrimonio());
                    patrimonio.setSetor(dados.getSetor());
                    patrimonio.setInutilizado(false);
                    listaPatrimonios.add(patrimonio);
                }
            }
            if (listaPatrimonios.size() > 0) {
                material.setPatrimonios(listaPatrimonios);
            }
            material.setMateriaisComposicao(this.fichaTecnica);
            material.setLotes(this.lotes);
            material.setAtualizarAlternativos(true);
            if (!StringUtil.isEmpty(this.codigoAlternativo)) {
                if (this.materiaisAlternativos == null) {
                    this.materiaisAlternativos = new ArrayList();
                }
                if (this.materiaisAlternativos.stream().noneMatch(a -> a.getCodigo().equalsIgnoreCase(this.codigoAlternativo))) {
                    MaterialAlternativoBean bean = new MaterialAlternativoBean();
                    bean.setCodigo(this.codigoAlternativo);
                    bean.setFilial(filial);
                    bean.setInserir(true);
                    this.materiaisAlternativos.add(bean);
                }
            }
            material.setMateriaisAlternativos(this.materiaisAlternativos);
            return material;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void salvar() {
        MaterialBean bean;
        MaterialService service = new MaterialService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, ParametrosGerais.getCopiaMaterial());
                this.salvarAssociacaoLote();
                this.salvarAssociacaoUsuario(bean.getCodigo());
                this.descricao = this.textDescricao.getText();
                this.descricaoTipo = this.textDescTipo.getText();
                this.unidade = this.textUnidade.getText();
                this.solicitarLote = this.checkSolicitarLote.isSelected();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar material. - " + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void salvarAssociacaoUsuario(Integer codigoMaterial) throws SQLException {
        MaterialService service = new MaterialService();
        this.removerUsuarios(service, codigoMaterial);
        for (MaterialUsuarioVO materialUsuarioVO : this.listaUsuarios) {
            materialUsuarioVO.setCodigoMaterial(codigoMaterial);
            service.inserirMaterialUsuario(materialUsuarioVO);
        }
    }

    private void removerUsuarios(MaterialService service, Integer codigoMaterial) throws SQLException {
        ArrayList<MaterialUsuarioVO> removidos = new ArrayList<MaterialUsuarioVO>();
        for (MaterialUsuarioVO materialUsuario : this.listaUsuarios) {
            if (!this.checkAvisarReposicao.isSelected() && materialUsuario.getTipoMaterialUsuario().equals("R")) {
                removidos.add(materialUsuario);
            }
            if (this.checkAvisarVencimentoLote.isSelected() || !materialUsuario.getTipoMaterialUsuario().equals("L")) continue;
            removidos.add(materialUsuario);
        }
        for (MaterialUsuarioVO materialUsuarioVO : removidos) {
            this.listaUsuarios.remove(materialUsuarioVO);
        }
        service.removeUsuarios(this.listaUsuarios, new MaterialUsuarioVO(Integer.valueOf(Variaveis.filialPadrao), codigoMaterial));
    }

    private void salvarAssociacaoLote() throws SQLException {
        try {
            MaterialLoteLanctoEstoqueBean materialLoteLanctoEstoqueBean;
            MaterialLoteBean materialLoteBean;
            for (List<Object> lisObjects : this.loteLanctoRemover) {
                materialLoteBean = null;
                materialLoteLanctoEstoqueBean = null;
                for (Object object : lisObjects) {
                    if (object instanceof MaterialLoteBean) {
                        materialLoteBean = (MaterialLoteBean)object;
                        continue;
                    }
                    if (!(object instanceof MaterialLoteLanctoEstoqueBean)) continue;
                    materialLoteLanctoEstoqueBean = (MaterialLoteLanctoEstoqueBean)object;
                }
                if (materialLoteBean == null || materialLoteLanctoEstoqueBean == null) continue;
                if (materialLoteBean.getLancamentosEstoque() == null) {
                    materialLoteBean.setLancamentosEstoque(new HashSet<MaterialLoteLanctoEstoqueBean>());
                }
                materialLoteBean.getLancamentosEstoque().add(materialLoteLanctoEstoqueBean);
                this.materialLoteService.removerLoteLancamentoEstoque(Variaveis.filialPadrao, materialLoteLanctoEstoqueBean, new Date());
            }
            for (List<Object> lisObjects : this.loteLanctoInserir) {
                materialLoteBean = null;
                materialLoteLanctoEstoqueBean = null;
                for (Object object : lisObjects) {
                    if (object instanceof MaterialLoteBean) {
                        materialLoteBean = (MaterialLoteBean)object;
                        continue;
                    }
                    if (!(object instanceof MaterialLoteLanctoEstoqueBean)) continue;
                    materialLoteLanctoEstoqueBean = (MaterialLoteLanctoEstoqueBean)object;
                }
                if (materialLoteBean == null || materialLoteLanctoEstoqueBean == null) continue;
                if (materialLoteBean.getLancamentosEstoque() == null) {
                    materialLoteBean.setLancamentosEstoque(new HashSet<MaterialLoteLanctoEstoqueBean>());
                }
                materialLoteBean.getLancamentosEstoque().add(materialLoteLanctoEstoqueBean);
                if (!materialLoteBean.getAlterar()) {
                    this.materialLoteService.gravaAutoCopiaSemCommit(materialLoteBean, 0, Variaveis.filialPadrao, null);
                    continue;
                }
                this.materialLoteService.gravaAutoCopiaSemCommit(materialLoteBean, 1, Variaveis.filialPadrao, null);
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            Conexao.anulaSQL();
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar associa\u00e7\u00e3o de lotes", e.getStackTrace());
        }
    }

    private void adicionarUsuarioMaterial(String tipo) {
        String titulo = tipo.equals("R") ? "Avisar reposi\u00e7\u00e3o de estoque" : "Avisar vencimento do lote";
        AvisarReposicaoEstoque avisar = AvisarReposicaoEstoque.novaInstancia(Laboratorio.getInstancia(), titulo, tipo);
        avisar.setListaUsuarios(this.listaUsuarios, tipo);
        avisar.setVisible(true);
        List<MaterialUsuarioVO> usuarios = avisar.getListaUsuarios();
        this.listaUsuarios.clear();
        for (MaterialUsuarioVO materialUsuario : usuarios) {
            boolean adicionar = true;
            materialUsuario.setCodigoFilial(Integer.valueOf(Variaveis.filialPadrao));
            materialUsuario.setTipoMaterialUsuario(materialUsuario.getTipoMaterialUsuario());
            this.listaUsuarios.add(materialUsuario);
        }
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 3 || this.getStatus() == 2;
        this.textCodigo.setEnabled(this.getStatus() == 3);
        this.checkInativo.setEnabled(this.getStatus() == 3);
        this.buttonCelula.setEnabled(this.getStatus() == 3);
        this.textDataCompra.setEnabled(false);
        this.textQtdeCompra.setEnabled(false);
        this.textEntregaCompra.setEnabled(false);
        this.buttonBuscaDataCompra.setEnabled(false);
        this.buttonBuscaDataEntrega.setEnabled(false);
        this.textValorCompra.setEnabled(false);
        this.checkSolicitarLote.setEnabled(enabled);
        this.textDescricao.setEnabled(enabled);
        this.textUnidade.setEnabled(enabled);
        this.textValorUnit.setEnabled(enabled);
        this.textValorCompra.setEnabled(false);
        this.textValorFrete.setEnabled(false);
        this.textRateioFrete.setEnabled(false);
        this.textValorIPI.setEnabled(false);
        this.textPtoReposicao.setEnabled(enabled);
        this.textCodTipo.setEnabled(enabled);
        this.buttonBuscaUnidade.setEnabled(enabled);
        this.buttonBuscaTipo.setEnabled(enabled);
        this.textFornecedorCompra.setEnabled(false);
        this.checkAvisarReposicao.setEnabled(enabled);
        this.checkAvisarVencimentoLote.setEnabled(enabled);
        this.checkImobilizado.setEnabled(enabled);
        this.checkPatrimonio.setEnabled(enabled);
        this.checkReutilizavel.setEnabled(enabled);
        this.textMarca.setEnabled(enabled);
        this.textModelo.setEnabled(enabled);
        this.habilitarUsuario(this.checkAvisarReposicao.isSelected(), "R");
        this.habilitarUsuario(this.checkAvisarVencimentoLote.isSelected(), "L");
        this.buttonLotes.setEnabled(enabled);
        this.areaObservacao.setEnabled(enabled);
        this.buttonAlternativo.setEnabled(enabled);
        this.controlaButtonPatrimonio(enabled);
        this.controlaButtonLote(enabled);
    }

    private void limparCampos() {
        this.textCodigo.setText("");
        this.checkInativo.setSelected(false);
        this.textDescricao.setText("");
        this.textUnidade.setText("");
        this.textDescUnidade.setText("");
        this.textValorUnit.setText("");
        this.textPtoReposicao.setText("");
        this.textCodTipo.setText("");
        this.textDescTipo.setText("");
        this.textDataCompra.setText("");
        this.textValorCompra.setText("");
        this.textQtdeCompra.setText("");
        this.textEntregaCompra.setText("");
        this.checkImobilizado.setSelected(false);
        this.checkAvisarReposicao.setSelected(false);
        this.checkPatrimonio.setSelected(false);
        this.checkReutilizavel.setSelected(false);
        this.checkSolicitarLote.setSelected(false);
        this.checkAvisarVencimentoLote.setSelected(false);
        this.textMarca.clear();
        this.textModelo.clear();
        this.labelEstoqueAtual.setText("");
        this.labelVlrTotal.setText("");
        this.areaObservacao.setText("");
        this.textValorIPI.clear();
        this.textValorFrete.clear();
        this.textRateioFrete.clear();
        this.textFornecedorCompra.clear();
        this.textDias.clear();
        if (this.patrimonios != null) {
            this.patrimonios.clear();
            this.patrimonios = null;
        }
        this.fichaTecnica = null;
        this.lotes = null;
        this.loteLanctoInserir.clear();
        this.loteLanctoRemover.clear();
        if (this.materiaisAlternativos != null) {
            this.materiaisAlternativos.clear();
        }
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.textCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.textCodigo.grabFocus();
                return false;
            }
        } else if (this.getStatus() == 2) {
            if (!Funcoes.textoVazio(this.textDataCompra.getText()) && !Funcoes.verificaData(this.textDataCompra.getText())) {
                Funcoes.mensagem(this, "Data da compra com valor incorreto", 1);
                this.textDataCompra.selectAll();
                this.textDataCompra.grabFocus();
                return false;
            }
            if (!Funcoes.textoVazio(this.textEntregaCompra.getText()) && !Funcoes.verificaData(this.textEntregaCompra.getText())) {
                Funcoes.mensagem(this, "Data da entrega com valor incorreto", 1);
                this.textEntregaCompra.selectAll();
                this.textEntregaCompra.grabFocus();
                return false;
            }
        }
        if (this.checkAvisarReposicao.isSelected()) {
            try {
                this.validarUsuario("R");
            }
            catch (Exception e) {
                Funcoes.mensagem(this, e.getMessage(), 1);
                this.buttonBuscaUsuarioReposicao.grabFocus();
                return false;
            }
        }
        if (this.checkAvisarVencimentoLote.isSelected()) {
            try {
                this.validarUsuario("L");
            }
            catch (Exception e) {
                Funcoes.mensagem(this, e.getMessage(), 1);
                this.buttonBuscaUsuarioReposicao.grabFocus();
                return false;
            }
        }
        if (this.textDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.textDescricao.selectAll();
            this.textDescricao.grabFocus();
            return false;
        }
        if (this.textUnidade.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo unidade n\u00e3o informado", 1);
            this.textUnidade.selectAll();
            this.textUnidade.grabFocus();
            return false;
        }
        if (this.textCodTipo.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo tipo n\u00e3o informado", 1);
            this.textCodTipo.selectAll();
            this.textCodTipo.grabFocus();
            return false;
        }
        if (this.textUnidade.getText().trim().length() > 0 && this.textDescUnidade.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Unidade n\u00e3o localizada", 1);
            this.textUnidade.selectAll();
            this.textUnidade.grabFocus();
            return false;
        }
        if (this.textCodTipo.getText().trim().length() > 0 && this.textDescTipo.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Tipo n\u00e3o localizado", 1);
            this.textCodTipo.selectAll();
            this.textCodTipo.grabFocus();
            return false;
        }
        if (this.textQtdeCompra.getText().isEmpty()) {
            this.textQtdeCompra.setText(Funcoes.formataDecimal(0));
        }
        Double qtdeMaterial = 0.0;
        qtdeMaterial = !this.labelEstoqueAtual.getText().isEmpty() ? Double.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.labelEstoqueAtual.getText()))) : Double.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.textQtdeCompra.getText())));
        if (qtdeMaterial > 0.0) {
            if (this.checkPatrimonio.isSelected() && (this.patrimonios == null || (double)this.patrimonios.size() < qtdeMaterial)) {
                Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 inferior \u00e0 quantidade do material.\n\u00c9 necess\u00e1rio informar " + qtdeMaterial.intValue() + " patrim\u00f4nios.", 1);
                return false;
            }
            if (this.checkPatrimonio.isSelected() && (double)this.patrimonios.size() > qtdeMaterial) {
                Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 superior \u00e0 quantidade do material.\n\u00c9 necess\u00e1rio informar apenas " + qtdeMaterial.intValue() + " patrim\u00f4nios.", 1);
                return false;
            }
        }
        return true;
    }

    private void validarUsuario(String tipo) throws Exception {
        for (MaterialUsuarioVO materialUsuarioVO : this.listaUsuarios) {
            if (!materialUsuarioVO.getTipoMaterialUsuario().equalsIgnoreCase(tipo)) continue;
            return;
        }
        String mensagem = "Selecione usu\u00e1rio para enviar aviso de validade do lote.";
        if (tipo.equals("R")) {
            mensagem = "Selecione usu\u00e1rio para enviar aviso de reposi\u00e7\u00e3o do lote.";
        }
        throw new Exception(mensagem);
    }

    private void buscaUnidade() {
        Hashtable resultado = Pesquisas.unidadeMedida(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.textUnidade.setText(resultado.get("unm_codigo").toString());
        }
        this.textUnidade.requestFocus();
    }

    private void buscaTipo() {
        Hashtable resultado = Pesquisas.tipoMaterial(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.textCodTipo.setText(resultado.get("tpm_codigo").toString());
        }
        this.textCodTipo.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.textUnidade.hasFocus()) {
            this.buscaUnidade();
        } else if (this.textCodTipo.hasFocus()) {
            this.buscaTipo();
        } else if (this.textDataCompra.hasFocus()) {
            this.dataCompra();
        } else if (this.textEntregaCompra.hasFocus()) {
            this.dataEntrega();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101300300");
    }

    private void dataCompra() {
        Funcoes.mostraData(this.textDataCompra, this.buttonBuscaDataCompra, this.panelCompra, true);
    }

    private void dataEntrega() {
        Funcoes.mostraData(this.textEntregaCompra, this.buttonBuscaDataEntrega, this.panelCompra, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonPatrimonio) {
            this.mostrarPatrimonio();
        } else if (e.getSource() == this.buttonCelula) {
            this.mostrarCelulas();
        } else if (e.getSource() == this.buttonAlternativo) {
            this.adicionaMaterialAlternativo();
        } else if (e.getSource() == this.buttonLotes && !this.flagAcaoMouseLote.booleanValue()) {
            this.mostrarLotes(false);
        }
    }

    private void adicionaMaterialAlternativo() {
        MaterialAlternativo s = null;
        s = this.getTopLevelAncestor() instanceof JFrame ? new MaterialAlternativo((JFrame)this.getTopLevelAncestor(), "Alternativos") : new MaterialAlternativo((JDialog)this.getTopLevelAncestor(), "Alternativos");
        if (this.materiaisAlternativos != null && this.materiaisAlternativos.size() > 0) {
            s.setAlternativos(this.materiaisAlternativos);
        }
        s.setVisible(true);
        if (s.getOK()) {
            ArrayList<Object> listaAtual = new ArrayList();
            if (s.getAlternativos() != null) {
                listaAtual = s.getAlternativos();
                ArrayList<MaterialAlternativoBean> listaAnterior = this.materiaisAlternativos == null ? new ArrayList<MaterialAlternativoBean>() : this.materiaisAlternativos;
                for (MaterialAlternativoBean altAnterior : listaAnterior) {
                    if (s.getAlternativos().contains(altAnterior)) continue;
                    altAnterior.setRemovido(true);
                    listaAtual.add(altAnterior);
                }
                MaterialBean bean = this.getBeanPreenchido();
                for (MaterialAlternativoBean materialAlternativoBean : listaAtual) {
                    if (!materialAlternativoBean.isInserir()) continue;
                    materialAlternativoBean.setFilial(bean.getFilial());
                    materialAlternativoBean.setMaterial((MaterialVO)bean.toVO());
                }
            }
            this.materiaisAlternativos = s.getAlternativos();
        }
    }

    private void mostrarLotes(boolean isMostrarBotaoAssociarLotes) {
        VisualizarLoteMaterial lote = new VisualizarLoteMaterial(Laboratorio.getInstancia(), this.textDescricao.getText(), this.textDescUnidade.getText(), this.lotes, (Double)(Funcoes.isNumeric(this.labelEstoqueAtual.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.labelEstoqueAtual.getText())) : (Funcoes.isNumeric(this.textQtdeCompra.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textQtdeCompra.getText())) : 0.0)), this.beanMat, this.loteLanctoInserir, this.loteLanctoRemover, isMostrarBotaoAssociarLotes, this.textCodigo.getText());
        if (lote != null) {
            lote.setVisible(true);
        }
        this.loteLanctoRemover = lote.getLoteLanctoTempRemover();
        this.loteLanctoInserir = lote.getLoteLanctoInserir();
    }

    private void mostrarCelulas() {
        MaterialCelulas mat = MaterialCelulas.novaInstancia(this.getTopLevelAncestor());
        if (mat != null) {
            mat.setMaterial(Variaveis.filialPadrao, this.textCodigo.getText());
            mat.setVisible(true);
        }
    }

    public String getDescTipo() {
        return this.descricaoTipo;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public boolean isSolicitarLote() {
        return this.solicitarLote;
    }

    public boolean isCancelada() {
        return this.cancelada;
    }

    private void mostrarPatrimonio() {
        Patrimonio p = Patrimonio.novaInstancia(this.getTopLevelAncestor(), false);
        if (p != null) {
            p.setPatrimonios(this.patrimonios);
            p.setVisible(true);
            if (p.getOK()) {
                this.patrimonios = p.getPatrimonios();
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "mat_codigo";
    }
}

