/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.ApresentarMensagens;
import jalis.laboratorio.cadastro.ApresentarTermoAceite;
import jalis.laboratorio.cadastro.DesbloquearExames;
import jalis.laboratorio.cadastro.SelecionarModeloImportacaoWeb;
import jalis.laboratorio.cadastro.VisualizarTermoAceito;
import jalis.laboratorio.cadastro.exame.ExameMaterial;
import jalis.laboratorio.cadastro.exame.externo.ExameLaboratorioExternoService;
import jalis.laboratorio.cadastro.exame.externo.LaboratorioExternoException;
import jalis.laboratorio.cadastro.labexterno.ConfiguracaoExamesLaboratorioExterno;
import jalis.laboratorio.cadastro.labexterno.ConfiguracaoParametroRelacionamento;
import jalis.laboratorio.cadastro.labexterno.ImportadorExames;
import jalis.laboratorio.cadastro.labexterno.RelacionamentoLabExterno;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.AbstractIntegracaoProtocolo;
import jalis.laboratorio.util.parsers.DialogoImportacaoLabExterno;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.FabricaImportador;
import jalis.laboratorio.util.parsers.FabricaIntegracaoLabExterno;
import jalis.laboratorio.util.parsers.NomeModeloWeb;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RetornoIntegracaoDePara;
import jalis.laboratorio.util.parsers.pardini.JanelaHistoricoLotes;
import jalis.model.vo.cadastro.exame.LabExternoVersaoTermoVO;
import jalis.service.cadastro.exame.LabExternoVersaoTermoService;
import jalis.util.ComponenteUtils;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LabExterno
extends FrmCadPadrao
implements ActionListener {
    private JComboBox comboProtocolo = new JComboBox();
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private TTextField txtDescricao = new TTextField(80);
    private JLabel labelNome = new JLabel("Nome:");
    private JLabel labelProtocolo = new JLabel("Protocolo:");
    private TTextField txtResponsavel = new TTextField(100);
    private TTextField txtContato = new TTextField(100);
    private TTextField txtEmail = new TTextField(100);
    private TTextField txtSite = new TTextField(100);
    private TTextFieldTelefone txtFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    private JLabel labelContato = new JLabel("Contato:");
    private JLabel labelFone = new JLabel("Fone:");
    private JLabel labelEmail = new JLabel("E-mail:");
    private JLabel labelSite = new JLabel("Site:");
    private JLabel labelResponsavel = new JLabel("Respons\u00e1vel:");
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'f', null);
    private JButton buttonImportarListaExames = ComponenteFactory.novoJButton("Importar lista de exames", 'i', null);
    private JButton buttonParametrosRelacionamento = ComponenteFactory.novoJButton("Par\u00e2m. de relacionamento", 'p', this);
    private JButton buttonRelacionamento = ComponenteFactory.novoJButton("Relacionamento", 'r', null);
    private JButton buttonLog = ComponenteFactory.novoJButton("Logs", 'L', this);
    private JLabel labelUltimaAtualizacao = new JLabel();
    private TTextField textCodigoUsuario = new TTextField(20);
    private JButton buttonBuscaUsuario = ComponenteFactory.novoJButton(this, true);
    private JLabel labelUsuario = new JLabel("");
    private JCheckBox checkInativo = ComponenteFactory.novoJCheckBox("Inativo", 'I');
    private JCheckBox checkAgruparMultiguia = ComponenteFactory.novoJCheckBox("Agrupar requisi\u00e7\u00f5es multiguias", 'A');
    private JCheckBox checkIgnorarConfiguracaoProtocolo = ComponenteFactory.novoJCheckBox("Ignorar configura\u00e7\u00e3o de protocolo na atualiza\u00e7\u00e3o da lista de exames", 'g');
    private JCheckBox checkConferirAutomatico = ComponenteFactory.novoJCheckBox("Conferir resultado importado automaticamente", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            LabExterno.this.textCodigoUsuario.setEnabled(LabExterno.this.checkConferirAutomatico.isSelected());
            LabExterno.this.buttonBuscaUsuario.setEnabled(LabExterno.this.checkConferirAutomatico.isSelected());
            if (LabExterno.this.checkConferirAutomatico.isSelected()) {
                LabExterno.this.textCodigoUsuario.clear();
                LabExterno.this.labelUsuario.setText("");
            }
        }
    });
    private JPanel panelIntegracaoDePara;
    private JButton buttonExportarDePara = new JButton("Exportar lista");
    private JButton buttonImportarDePara = new JButton("Importar lista");
    private JButton buttonHistoricoLotes = ComponenteFactory.novoJButton("Hist\u00f3rico", this);
    private JButton buttonHistoricoSuspensos = ComponenteFactory.novoJButton("Exames suspensos", this);
    private JLabel labelTermoAceite = new JLabel("");
    private JButton buttonVerTermoAceite = new JButton("Visualizar");
    private JButton buttonModeloWeb = new JButton("Modelo para importa\u00e7\u00e3o");
    private JPanel panelTermoAceite = ComponenteFactory.novoJPanelFlowLayout(0, this.labelTermoAceite, this.buttonVerTermoAceite);
    private String configuracao = "";
    private int codigoModeloWeb = -1;
    private String retornoParaPesquisa = "";
    private String xmlParametrosRelacionamento = null;
    private final ExameLaboratorioExternoService service = new ExameLaboratorioExternoService();
    private final HashSet<ExameMaterial> exames = new HashSet();
    private JButton buttonPrecos = ComponenteFactory.novoJButton("Pre\u00e7os", 'o', new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfiguracaoExamesLaboratorioExterno config = new ConfiguracaoExamesLaboratorioExterno(Integer.valueOf(Variaveis.filialPadrao), Integer.valueOf(LabExterno.this.txtCodigo.getText()), LabExterno.this.exames);
        }
    });

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(LabExterno.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901401"));
        this.setModuloEdita(Long.parseLong("0101901402"));
        this.setModuloApaga(Long.parseLong("0101901403"));
    }

    public LabExterno() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "LabExterno (49)");
        }
        this.textCodigoUsuario.setUpperCase(false);
        this.textCodigoUsuario.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offs, str, a);
            }
        });
    }

    public void jbInit() throws Exception {
        this.setLabelDescricao("Cadastro de laborat\u00f3rios externos para envio de solicita\u00e7\u00e3o de exames");
        this.setLabelFormulario("Cadastro de laborat\u00f3rios externos");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/p_externo.jpg"));
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.txtFone);
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelCodigo.setDisplayedMnemonic('D');
        this.labelCodigo.setLabelFor(this.txtCodigo);
        this.txtCodigo.setPreferredSize(new Dimension(69, 20));
        this.txtDescricao.setPreferredSize(new Dimension(400, 20));
        this.labelNome.setLabelFor(this.txtDescricao);
        this.labelNome.setDisplayedMnemonic('m');
        this.comboProtocolo.setPreferredSize(new Dimension(400, 20));
        this.txtSite.setPreferredSize(new Dimension(400, 20));
        this.txtEmail.setPreferredSize(new Dimension(400, 20));
        this.txtResponsavel.setPreferredSize(new Dimension(400, 20));
        this.txtContato.setPreferredSize(new Dimension(280, 20));
        this.txtFone.setPreferredSize(new Dimension(150, 20));
        JPanel panelEspaco = new JPanel();
        panelEspaco.setPreferredSize(new Dimension(20, 20));
        JPanel panelContato = new JPanel(new FlowLayout(0, 0, 0));
        panelContato.setPreferredSize(new Dimension(100, 20));
        panelContato.add(this.txtContato);
        panelContato.add(panelEspaco);
        panelContato.add(this.labelFone);
        panelContato.add(this.txtFone);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.labelNome, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.labelProtocolo, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.labelSite, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.labelEmail, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.labelResponsavel, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.labelContato, c);
        c.gridy = 0;
        c.gridx = 1;
        this.painelCentral.add((Component)this.txtCodigo, c);
        c.weightx = 1.0;
        ++c.gridy;
        c.fill = 2;
        this.painelCentral.add((Component)this.txtDescricao, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.comboProtocolo, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.txtSite, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.txtEmail, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.txtResponsavel, c);
        ++c.gridy;
        this.painelCentral.add((Component)panelContato, c);
        c.fill = 0;
        ++c.gridy;
        this.painelCentral.add((Component)this.checkConferirAutomatico, c);
        c.fill = 2;
        ++c.gridy;
        this.painelCentral.add((Component)this.montaPanelUsuario(), c);
        ++c.gridy;
        this.painelCentral.add((Component)this.montaPanelConfiguracoes(), c);
        ++c.gridy;
        this.panelIntegracaoDePara = this.montaPanelIntegracaoDePara();
        this.painelCentral.add((Component)this.panelIntegracaoDePara, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.montaPanelLog(), c);
        c.fill = 0;
        ++c.gridy;
        this.painelCentral.add((Component)this.checkInativo, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.checkAgruparMultiguia, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.checkIgnorarConfiguracaoProtocolo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        c.weighty = 1.0;
        this.painelCentral.add((Component)new JPanel(), c);
        ScreenUtil.setBorda(new Component[]{this.labelUsuario}, new TitledBorder(""));
        this.controlaCampos();
        this.comboProtocolo.addItem("");
        for (Protocolo p : Protocolo.values()) {
            this.comboProtocolo.addItem(p);
        }
        this.buttonRelacionamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int qtImportados = 0;
                try {
                    qtImportados = FabricaConfigurador.qtExamesImportados((Protocolo)((Object)LabExterno.this.comboProtocolo.getSelectedItem()), LabExterno.this.txtCodigo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter informa\u00e7\u00f5es dos exames importados.\n" + e1.getMessage(), e1.getStackTrace());
                    return;
                }
                if (qtImportados <= 0) {
                    Funcoes.mensagem(LabExterno.this, "A lista de exames n\u00e3o foi importada.\n\u00c9 necess\u00e1rio importar a lista de exames para iniciar o relacionamento.", 2);
                    ScreenUtil.requisitarFoco(LabExterno.this.buttonImportarListaExames);
                    return;
                }
                if (Funcoes.textoVazio(LabExterno.this.xmlParametrosRelacionamento) || Funcoes.textoVazio(StringUtil.getValor(LabExterno.this.xmlParametrosRelacionamento, "metodo"))) {
                    Funcoes.mensagem(LabExterno.this, "Os par\u00e2metros de relacionamento devem ser configurados.", 2);
                    ScreenUtil.requisitarFoco(LabExterno.this.buttonParametrosRelacionamento);
                    return;
                }
                if (!Funcoes.textoVazio(LabExterno.this.txtCodigo)) {
                    RelacionamentoLabExterno relacionamento = RelacionamentoLabExterno.novaInstancia(LabExterno.this.txtCodigo.getText(), (Protocolo)((Object)LabExterno.this.comboProtocolo.getSelectedItem()), Laboratorio.getInstancia(), LabExterno.this.xmlParametrosRelacionamento);
                    relacionamento.setVisible(true);
                }
            }
        });
        this.buttonImportarListaExames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabExterno.this.carregaImportador();
            }
        });
        this.comboProtocolo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isProtocolo = LabExterno.this.comboProtocolo.getSelectedItem() instanceof Protocolo;
                boolean importarDePara = isProtocolo && ((Protocolo)((Object)LabExterno.this.comboProtocolo.getSelectedItem())).isImportarExportarDePara();
                boolean solicitarTermoAceite = isProtocolo && ((Protocolo)((Object)LabExterno.this.comboProtocolo.getSelectedItem())).isApresentarTermoAceite();
                boolean importarModeloLayoutWeb = isProtocolo && ((Protocolo)((Object)LabExterno.this.comboProtocolo.getSelectedItem())).isImportarModeloLayoutWeb();
                LabExterno.this.buttonConfigurar.setEnabled(isProtocolo);
                LabExterno.this.panelIntegracaoDePara.setVisible(LabExterno.this.getStatus() == 3 && isProtocolo && importarDePara);
                LabExterno.this.panelTermoAceite.setVisible(LabExterno.this.panelIntegracaoDePara.isVisible() && solicitarTermoAceite);
                LabExterno.this.buttonModeloWeb.setVisible(LabExterno.this.panelIntegracaoDePara.isVisible() && importarModeloLayoutWeb);
                if (solicitarTermoAceite && LabExterno.this.panelIntegracaoDePara.isVisible()) {
                    LabExterno.this.atualizarLabelTermoAceite(LabExterno.this.getFabricaIntegracao(), Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(LabExterno.this.txtCodigo.getText()));
                }
            }
        });
        this.buttonConfigurar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(LabExterno.this.comboProtocolo.getSelectedItem() instanceof Protocolo)) {
                    return;
                }
                AbstractConfiguradorProtocolo c = FabricaConfigurador.novoConfiguradorProtocolo(LabExterno.this.getTopLevelAncestor(), (Protocolo)((Object)LabExterno.this.comboProtocolo.getSelectedItem()), LabExterno.this.txtCodigo.getText());
                String codigoHash = null;
                if (!Funcoes.textoVazio(LabExterno.this.configuracao)) {
                    codigoHash = LabExterno.this.calculaHash(LabExterno.this.configuracao);
                }
                c.setXML(LabExterno.this.configuracao, true);
                c.setVisible(true);
                if (c.getOK()) {
                    LabExterno.this.configuracao = c.getXML();
                    String codigoHashAtual = LabExterno.this.calculaHash(LabExterno.this.configuracao);
                    if (!Funcoes.textoVazio(codigoHash) && !codigoHash.equalsIgnoreCase(codigoHashAtual)) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Configura\u00e7\u00f5es foram alteradas, clique em salvar antes de executar qualquer opera\u00e7\u00e3o.", 2);
                    }
                }
            }
        });
        this.textCodigoUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (LabExterno.this.textCodigoUsuario.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select usr_codigo, usr_nome from usuario where upper(usr_codigo)=upper(" + LabExterno.this.textCodigoUsuario.getTextDBEscape() + ")");
                        if (rs.next()) {
                            LabExterno.this.labelUsuario.setText(rs.getString("usr_nome"));
                            LabExterno.this.textCodigoUsuario.setText(rs.getString("usr_codigo"));
                        } else {
                            LabExterno.this.labelUsuario.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(LabExterno.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        LabExterno.this.setStatus(1);
                        LabExterno.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(LabExterno.this.txtCodigo.getText()) && Funcoes.isNumeric(LabExterno.this.txtCodigo.getText())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select a.lae_descricao, a.lae_configuracao, a.lae_protocolo, a.lae_contato, a.lae_inativo, ");
                            buf.append("a.lae_email, a.lae_site, a.lae_fone, a.lae_responsavel, a.lae_conferirautomatico, a.usr_codconferir, b.usr_nome, a.lae_ultimaimportacaoexames ");
                            buf.append(" ,lae_agruparmultiguias, lae_codigomodeloweb ");
                            buf.append(" ,lae_ignorarcopiaconfiguracao ");
                            buf.append("from labexterno a left join usuario b on a.usr_codconferir = b.usr_codigo where a.fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and a.lae_codigo = ");
                            buf.append(LabExterno.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                LabExterno.this.txtDescricao.setText(rs.getString("lae_descricao"));
                                String protocolo = rs.getString("lae_protocolo");
                                LabExterno.this.comboProtocolo.setSelectedItem((Object)Protocolo.getProtocolo(protocolo));
                                LabExterno.this.txtContato.setText(rs.getString("lae_contato"));
                                LabExterno.this.txtEmail.setText(rs.getString("lae_email"));
                                LabExterno.this.txtSite.setText(rs.getString("lae_site"));
                                LabExterno.this.txtFone.setText(rs.getString("lae_fone"));
                                LabExterno.this.txtResponsavel.setText(rs.getString("lae_responsavel"));
                                Timestamp dateAtualizacao = rs.getTimestamp("lae_ultimaimportacaoexames");
                                if (dateAtualizacao != null) {
                                    LabExterno.this.buttonLog.setEnabled(true);
                                    LabExterno.this.labelUltimaAtualizacao.setText("Data da \u00faltima importa\u00e7\u00e3o: " + Funcoes.formataData("dd/MM/yyyy HH:mm:ss", dateAtualizacao));
                                } else {
                                    LabExterno.this.buttonLog.setEnabled(false);
                                    LabExterno.this.labelUltimaAtualizacao.setText("");
                                }
                                LabExterno.this.configuracao = rs.getString("lae_configuracao");
                                if (!Funcoes.textoVazio(LabExterno.this.configuracao)) {
                                    LabExterno.this.xmlParametrosRelacionamento = "<paramrelacionamento>";
                                    LabExterno.this.xmlParametrosRelacionamento = LabExterno.this.xmlParametrosRelacionamento + StringUtil.getValor(LabExterno.this.configuracao, "paramrelacionamento");
                                    LabExterno.this.xmlParametrosRelacionamento = LabExterno.this.xmlParametrosRelacionamento + ")</paramrelacionamento>";
                                    if (!Funcoes.textoVazio(LabExterno.this.xmlParametrosRelacionamento)) {
                                        LabExterno.this.configuracao = StringUtil.removerTagCompletaXML(LabExterno.this.configuracao, "paramrelacionamento", true);
                                    }
                                }
                                LabExterno.this.checkConferirAutomatico.setSelected(rs.getBoolean("lae_conferirautomatico"));
                                if (LabExterno.this.checkConferirAutomatico.isSelected() && !DBUtil.campoNull(rs.getString("usr_codconferir"))) {
                                    LabExterno.this.textCodigoUsuario.setText(rs.getString("usr_codconferir"));
                                    LabExterno.this.labelUsuario.setText(rs.getString("usr_nome"));
                                }
                                LabExterno.this.checkInativo.setSelected(rs.getBoolean("lae_inativo"));
                                LabExterno.this.checkAgruparMultiguia.setSelected(rs.getBoolean("lae_agruparmultiguias"));
                                LabExterno.this.checkIgnorarConfiguracaoProtocolo.setSelected(rs.getBoolean("lae_ignorarcopiaconfiguracao"));
                                LabExterno.this.codigoModeloWeb = rs.getInt("lae_codigomodeloweb");
                                LabExterno.this.txtCodigo.setEnabled(false);
                                LabExterno.this.textCodigoUsuario.setEnabled(LabExterno.this.checkConferirAutomatico.isSelected());
                                LabExterno.this.buttonBuscaUsuario.setEnabled(LabExterno.this.checkConferirAutomatico.isSelected());
                                LabExterno.this.txtDescricao.grabFocus();
                            } else {
                                Funcoes.mensagem(LabExterno.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                LabExterno.this.setStatus(1);
                                LabExterno.this.controlaCampos();
                            }
                        }
                        st.close();
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(LabExterno.this, sqlex.getMessage(), sqlex.getStackTrace(), "LabExterno (116)");
                    }
                }
            }
        });
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtEmail.setUpperCase(false);
        this.txtSite.setUpperCase(false);
    }

    private void aceitarTermoAceite(AbstractIntegracaoProtocolo integra, int filial, int labExterno, String versao, String usuario, boolean commit) {
        if (integra != null) {
            try {
                integra.aceitarTermoAceite(filial, labExterno, versao, usuario);
                if (commit) {
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception e) {
                if (commit) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                Funcoes.mensagem(this, "Ocorreu uma falha ao aceitar o termo de aceite", 1);
            }
        }
    }

    private void atualizarLabelTermoAceite(AbstractIntegracaoProtocolo integra, int filial, int labExterno) {
        String mensagem = "Termo de aceite n\u00e3o identificado";
        if (integra != null) {
            LabExternoVersaoTermoVO bean = integra.getTermoDeAceite(filial, labExterno);
            mensagem = bean != null ? (bean.getDataHoraAceite() != null ? "Termo aceito em " + Funcoes.formataData("dd/MM/yyyy kk:mm", bean.getDataHoraAceite()) + " por " + bean.getUsuarioAceite() : "Termo n\u00e3o aceito") : "Termo de aceite n\u00e3o localizado";
        }
        this.labelTermoAceite.setText(mensagem);
    }

    private AbstractIntegracaoProtocolo getFabricaIntegracao() {
        Protocolo p = (Protocolo)((Object)this.comboProtocolo.getSelectedItem());
        return FabricaIntegracaoLabExterno.novaIntegracaoLabExterno(p);
    }

    private JPanel montaPanelIntegracaoDePara() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Integra\u00e7\u00e3o De/Para"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 2, 2, 0);
        c.fill = 2;
        c.anchor = 17;
        panel.add((Component)this.buttonExportarDePara, c);
        ++c.gridx;
        panel.add((Component)this.buttonImportarDePara, c);
        ++c.gridx;
        panel.add((Component)this.buttonHistoricoLotes, c);
        ++c.gridx;
        panel.add((Component)this.buttonHistoricoSuspensos, c);
        JPanel panelTemp = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        panelTemp.add((Component)this.panelTermoAceite, gc);
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.gridx = 2;
        panelTemp.add((Component)this.buttonModeloWeb, gc);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        panel.add((Component)panelTemp, c);
        panel.setVisible(false);
        this.buttonVerTermoAceite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIntegracaoProtocolo integra = LabExterno.this.getFabricaIntegracao();
                if (integra != null) {
                    int labExterno;
                    int filial = Integer.parseInt(Variaveis.filialPadrao);
                    LabExternoVersaoTermoVO termo = integra.getTermoDeAceite(filial, labExterno = Integer.parseInt(LabExterno.this.txtCodigo.getText()));
                    if (termo != null) {
                        if (termo.getDataHoraAceite() != null) {
                            VisualizarTermoAceito v = new VisualizarTermoAceito(Laboratorio.getInstancia());
                            v.setTermoAceito(termo.getTermo());
                            v.setVisible(true);
                        } else {
                            ApresentarTermoAceite a = new ApresentarTermoAceite(Laboratorio.getInstancia());
                            a.setTermoAceite(termo.getTermo());
                            a.setVisible(true);
                            if (a.getOK()) {
                                LabExterno.this.aceitarTermoAceite(integra, filial, labExterno, termo.getVersao(), Variaveis.login, true);
                                LabExterno.this.atualizarLabelTermoAceite(integra, filial, labExterno);
                            }
                        }
                    } else {
                        Funcoes.mensagem(LabExterno.this, "N\u00e3o foi poss\u00edvel identificar o termo de aceite do laborat\u00f3rio", 2);
                    }
                }
            }
        });
        this.buttonModeloWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIntegracaoProtocolo in = LabExterno.this.getFabricaIntegracao();
                NomeModeloWeb[] modelos = in.importarNomesModelosWeb(1, 24);
                if (modelos != null) {
                    SelecionarModeloImportacaoWeb mo = new SelecionarModeloImportacaoWeb((Frame)Laboratorio.getInstancia(), modelos);
                    mo.setCodigoModeloSelecionado(LabExterno.this.codigoModeloWeb);
                    mo.setVisible(true);
                    if (mo.getOK()) {
                        LabExterno.this.codigoModeloWeb = mo.getCodigoModeloSelecionado();
                    }
                }
            }
        });
        this.buttonExportarDePara.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Protocolo p = (Protocolo)((Object)LabExterno.this.comboProtocolo.getSelectedItem());
                AbstractIntegracaoProtocolo integra = LabExterno.this.getFabricaIntegracao();
                if (integra != null) {
                    if (!integra.validarConfiguracaoParaExportar(LabExterno.this.configuracao)) {
                        Funcoes.mensagem(LabExterno.this, "\u00c9 necess\u00e1rio configurar o protocolo antes de exportar os exames", 2);
                        LabExterno.this.buttonConfigurar.doClick();
                    }
                    if (!integra.validarConfiguracaoParaExportar(LabExterno.this.configuracao)) {
                        Funcoes.mensagem(LabExterno.this, "N\u00e3o \u00e9 poss\u00edvel exportar a lista de exames sem a configura\u00e7\u00e3o do protocolo", 2);
                    } else {
                        RetornoIntegracaoDePara ret;
                        LabExternoVersaoTermoVO termoBean;
                        boolean temTermoImportado;
                        if (!integra.pingar()) {
                            Funcoes.mensagem(LabExterno.this, "<html>N\u00e3o foi poss\u00edvel conectar com o servidor do laborat\u00f3rio de apoio, verifique sua internet ou se possui algum bloqueio para o endere\u00e7o <b>lab2lab.grupopardini.com.br</b> e tente novamente.</html>", 1);
                            return;
                        }
                        int f = Integer.parseInt(Variaveis.filialPadrao);
                        int l = Integer.parseInt(LabExterno.this.txtCodigo.getText());
                        boolean bl = temTermoImportado = !p.isApresentarTermoAceite() || p.isApresentarTermoAceite() && LabExterno.this.temTermoDeAceiteCadastrado(integra, f, l);
                        if (!temTermoImportado) {
                            Funcoes.mensagem(LabExterno.this, "N\u00e3o foi localizado nenhum termo de aceite, verifique a conex\u00e3o com a internet ou o c\u00f3digo e senha informado na configura\u00e7\u00e3o. A exporta\u00e7\u00e3o n\u00e3o ser\u00e1 realizada", 2);
                        }
                        boolean aceito = integra.isTermoAceito(f, l);
                        if (p.isApresentarTermoAceite() && !aceito && temTermoImportado && (termoBean = integra.getTermoDeAceite(f, l)) != null) {
                            ApresentarTermoAceite termo = new ApresentarTermoAceite(Laboratorio.getInstancia());
                            termo.setTermoAceite(termoBean.getTermo());
                            termo.setVisible(true);
                            aceito = termo.getOK();
                            if (!aceito) {
                                Funcoes.mensagem(LabExterno.this, "N\u00e3o \u00e9 poss\u00edvel enviar os dados de exames sem concordar com o termo", 2);
                            } else {
                                LabExterno.this.aceitarTermoAceite(integra, f, l, termoBean.getVersao(), Variaveis.login, true);
                                LabExterno.this.atualizarLabelTermoAceite(integra, f, l);
                            }
                        }
                        if (aceito && null != (ret = integra.enviarDados(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(LabExterno.this.txtCodigo.getText()), LabExterno.this.configuracao))) {
                            if (ret.isSucesso()) {
                                ApresentarMensagens apresentar = new ApresentarMensagens(Laboratorio.getInstancia());
                                apresentar.setTexto(LabExterno.this.converterParaTexto(ret.getMensagens()));
                                apresentar.setVisible(true);
                            } else {
                                String mensagens = "";
                                for (String s : ret.getMensagens()) {
                                    if (!Funcoes.textoVazio(mensagens)) {
                                        mensagens = mensagens + "\n";
                                    }
                                    mensagens = mensagens + s;
                                }
                                Funcoes.mensagem(LabExterno.this, "N\u00e3o foi poss\u00edvel exportar os exames para o servidor de relacionamento.\nMensagem apresentada:" + mensagens, 1);
                            }
                        }
                    }
                }
            }
        });
        this.buttonImportarDePara.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIntegracaoProtocolo integra = LabExterno.this.getFabricaIntegracao();
                RetornoIntegracaoDePara resultado = null;
                if (integra != null) {
                    if (integra.validarConfiguracaoParaImportar(LabExterno.this.configuracao, LabExterno.this.xmlParametrosRelacionamento)) {
                        try {
                            resultado = integra.importarDados(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(LabExterno.this.txtCodigo.getText()), LabExterno.this.configuracao, LabExterno.this.xmlParametrosRelacionamento);
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e2) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            e2.printStackTrace();
                            Funcoes.mensagem(LabExterno.this, "N\u00e3o foi poss\u00edvel importar a lista de exames do laborat\u00f3rio\n" + e2.getMessage(), 2);
                        }
                    } else {
                        Funcoes.mensagem(LabExterno.this, "As configura\u00e7\u00f5es est\u00e3o incompletas, verifique a configura\u00e7\u00e3o do protocolo e os par\u00e2metros de relacionamento", 2);
                    }
                    if (resultado != null && resultado.getMensagens() != null && resultado.getMensagens().length > 0) {
                        ApresentarMensagens apresentar = new ApresentarMensagens(Laboratorio.getInstancia());
                        apresentar.setTexto(LabExterno.this.converterParaTexto(resultado.getMensagens()));
                        apresentar.setVisible(true);
                        if (resultado.isSucesso()) {
                            DesbloquearExames desbloquear = new DesbloquearExames((Frame)Laboratorio.getInstancia(), Integer.parseInt(LabExterno.this.txtCodigo.getText()));
                            desbloquear.carregarExames(resultado.getImportados());
                            desbloquear.setVisible(true);
                        }
                    }
                }
            }
        });
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean temTermoDeAceiteCadastrado(AbstractIntegracaoProtocolo integra, int filial, int labExterno) {
        boolean retorno = false;
        LabExternoVersaoTermoService termoService = new LabExternoVersaoTermoService();
        try {
            LabExternoVersaoTermoVO termoVO = termoService.getTermoAceiteMaisNovo(filial, labExterno);
            boolean bl = retorno = termoVO != null;
            if (!retorno) {
                String codigoLCJalis = StringUtil.getValor(this.configuracao, "codigoProtocolo");
                String senhaJalis = StringUtil.getValor(this.configuracao, "senhaWeb");
                integra.importarTermoAceite(filial, labExterno, codigoLCJalis, senhaJalis);
                termoVO = termoService.getTermoAceiteMaisNovo(filial, labExterno);
                retorno = termoVO != null;
                return retorno;
            }
        }
        catch (Exception e1) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel importar o termo de aceite inicial.\nMensagem apresentada: " + e1.getMessage(), 1);
        }
        finally {
            return retorno;
        }
    }

    private String converterParaTexto(String[] mensagens) {
        StringBuilder buf = new StringBuilder();
        if (mensagens != null) {
            for (String s : mensagens) {
                buf.append(s).append("\n");
            }
        }
        return buf.toString();
    }

    private JPanel montaPanelConfiguracoes() {
        JPanel panelConfiguracoes = new JPanel(new GridBagLayout());
        panelConfiguracoes.setBorder(new TitledBorder("Configura\u00e7\u00f5es"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 2, 2, 0);
        panelConfiguracoes.add((Component)this.buttonImportarListaExames, c);
        ++c.gridx;
        panelConfiguracoes.add((Component)this.buttonConfigurar, c);
        c.gridx = 0;
        ++c.gridy;
        panelConfiguracoes.add((Component)this.buttonParametrosRelacionamento, c);
        ++c.gridx;
        panelConfiguracoes.add((Component)this.buttonRelacionamento, c);
        c.gridx = 0;
        ++c.gridy;
        panelConfiguracoes.add((Component)this.buttonPrecos, c);
        return panelConfiguracoes;
    }

    private JPanel montaPanelLog() {
        JPanel panelLog = new JPanel(new GridBagLayout());
        panelLog.setBorder(new TitledBorder("\u00daltima atualiza\u00e7\u00e3o"));
        GridBagConstraints cLog = new GridBagConstraints();
        cLog.gridx = 0;
        cLog.gridy = 0;
        cLog.anchor = 17;
        cLog.fill = 2;
        cLog.weightx = 1.0;
        cLog.insets = new Insets(0, 2, 2, 0);
        this.labelUltimaAtualizacao.setPreferredSize(new Dimension(500, 20));
        this.labelUltimaAtualizacao.setMinimumSize(new Dimension(333, 20));
        panelLog.add((Component)this.labelUltimaAtualizacao, cLog);
        ++cLog.gridx;
        cLog.fill = 0;
        cLog.weightx = 0.0;
        panelLog.add((Component)this.buttonLog, cLog);
        return panelLog;
    }

    private JPanel montaPanelUsuario() {
        this.textCodigoUsuario.setPreferredSize(new Dimension(100, 20));
        this.textCodigoUsuario.setMinimumSize(new Dimension(100, 20));
        this.buttonBuscaUsuario.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaUsuario.setMinimumSize(new Dimension(20, 20));
        this.labelUsuario.setPreferredSize(new Dimension(80, 20));
        JPanel panelUsuario = new JPanel(new GridBagLayout());
        panelUsuario.setBorder(new TitledBorder("Usu\u00e1rio de confer\u00eancia"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        panelUsuario.add((Component)this.labelUsuario, c);
        ++c.gridx;
        Insets in = c.insets;
        in.right = 1;
        c.insets = in;
        panelUsuario.add((Component)this.textCodigoUsuario, c);
        ++c.gridx;
        panelUsuario.add((Component)this.buttonBuscaUsuario, c);
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 2;
        panelUsuario.add((Component)this.labelUsuario, c);
        return panelUsuario;
    }

    public String calculaHash(String xml) {
        String codigoHash = "";
        try {
            codigoHash = StringUtil.calcularCodigoHash(xml);
        }
        catch (NoSuchAlgorithmException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel calcular o hash." + e1.getMessage(), e1.getStackTrace());
            return "";
        }
        return codigoHash;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoUsuario.hasFocus()) {
            this.pesquisaUsuario();
        }
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.labexterno(this.getTopLevelAncestor(), false, true);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("lae_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    protected void carregaImportador() {
        try {
            Protocolo p = Protocolo.getProtocolo(this.comboProtocolo.getSelectedItem().toString());
            if (Acesso.getAcesso(FabricaImportador.getModuloAcesso(p))) {
                AbstractImportadorLabExterno importadorExame = FabricaImportador.novoImportadorLabExterno(Integer.parseInt(this.txtCodigo.getText()), p);
                ImportadorExames importador = ImportadorExames.novaInstancia(this.getTopLevelAncestor(), importadorExame);
                importador.setVisible(true);
                Statement st = Conexao.getStatement();
                StringBuffer buf = new StringBuffer("select lae_ultimaimportacaoexames ");
                buf.append("from labexterno where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and lae_codigo = ");
                buf.append(this.txtCodigo.getText());
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Timestamp dateAtualizacao = rs.getTimestamp("lae_ultimaimportacaoexames");
                    if (dateAtualizacao != null) {
                        this.buttonLog.setEnabled(true);
                        this.labelUltimaAtualizacao.setText("Data da \u00faltima importa\u00e7\u00e3o: " + Funcoes.formataData("dd/MM/yyyy HH:mm:ss", dateAtualizacao));
                    } else {
                        this.buttonLog.setEnabled(false);
                        this.labelUltimaAtualizacao.setText("");
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel apresentar o importador de exames", e.getStackTrace());
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("labexterno", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("lae_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
                    this.removerSequence(statement, this.txtCodigo.getText());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "LabExterno (187)");
            }
        }
        this.limparCampos();
    }

    private void removerSequence(Statement st, String codigoLabExterno) {
        StringBuilder buf = new StringBuilder();
        ResultSet rs = null;
        Statement stament = Conexao.getStatement();
        try {
            buf.append("select c.relname from pg_class c ");
            buf.append("where c.relname = 'codigolote_").append(Variaveis.filialPadrao).append("_").append(codigoLabExterno).append("_sequence'");
            rs = Conexao.executeQuery(stament, buf.toString());
            if (rs.next()) {
                Conexao.execute(Variaveis.filialPadrao, st, "drop sequence codigolote_" + Variaveis.filialPadrao + "_" + codigoLabExterno + "_sequence");
            }
            if (ParametrosGerais.getCopiaLabExterno() != null) {
                String[] codigosFiliais;
                String filiasAutoCopia = StringUtil.getValor(ParametrosGerais.getCopiaLabExterno(), "filiais");
                for (String codigoFilial : codigosFiliais = filiasAutoCopia.split(",")) {
                    buf.setLength(0);
                    buf.append("select c.relname from pg_class c ");
                    buf.append("where c.relname = 'codigolote_").append(codigoFilial).append("_").append(codigoLabExterno).append("_sequence'");
                    rs = Conexao.executeQuery(stament, buf.toString());
                    if (!rs.next()) continue;
                    Conexao.execute(Variaveis.filialPadrao, st, "drop sequence codigolote_" + codigoFilial + "_" + codigoLabExterno + "_sequence");
                }
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.getStatus() == 2 ? DBUtil.getSequencia(statement, "labexterno", true) : this.txtCodigo.getText();
                SalvaDados salvar = new SalvaDados("labexterno", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("lae_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("lae_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("lae_site", 0, true, false, this.txtSite.getTextDBEscape());
                salvar.adicionaCampo("lae_email", 0, true, false, this.txtEmail.getTextDBEscape());
                salvar.adicionaCampo("lae_contato", 0, true, false, this.txtContato.getTextDBEscape());
                salvar.adicionaCampo("lae_fone", 0, true, false, this.txtFone.getTextDBEscape());
                salvar.adicionaCampo("lae_responsavel", 0, true, false, this.txtResponsavel.getTextDBEscape());
                salvar.adicionaCampo("lae_protocolo", 0, true, false, StringUtil.textoDBEscape(this.comboProtocolo.getSelectedItem().toString()));
                salvar.adicionaCampo("lae_configuracao", 0, true, false, StringUtil.textoDBEscape(this.configuracao + this.getTagCompletaParametrosRelacionamento()));
                salvar.adicionaCampo("lae_conferirautomatico", 4, true, false, this.checkConferirAutomatico.isSelected());
                salvar.adicionaCampo("lae_inativo", 4, true, false, this.checkInativo.isSelected());
                salvar.adicionaCampo("lae_agruparmultiguias", 4, true, false, this.checkAgruparMultiguia.isSelected());
                salvar.adicionaCampo("lae_ignorarcopiaconfiguracao", 4, true, false, this.checkIgnorarConfiguracaoProtocolo.isSelected());
                salvar.adicionaCampo("lae_codigomodeloweb", 2, true, false, this.codigoModeloWeb);
                if (this.checkConferirAutomatico.isSelected()) {
                    salvar.adicionaCampo("usr_codconferir", 0, true, false, !Funcoes.textoVazio(this.textCodigoUsuario.getText()) ? StringUtil.textoDBEscape(this.textCodigoUsuario.getText()) : null);
                } else {
                    salvar.adicionaCampo("usr_codconferir", 0, true, false, null);
                }
                if (this.checkIgnorarConfiguracaoProtocolo.isSelected()) {
                    salvar.removerCampo("lae_configuracao");
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno(), "labexterno", Integer.parseInt(codigo));
                    salvar.adicionaCampo("lae_configuracao", 0, true, false, StringUtil.textoDBEscape(this.configuracao + this.getTagCompletaParametrosRelacionamento()));
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", StringUtil.getTag("filiais", ""), "labexterno", Integer.parseInt(codigo));
                } else {
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno(), "labexterno", Integer.parseInt(codigo));
                }
                this.criarSequence(statement, codigo);
                this.configuracao = "";
                this.retornoParaPesquisa = codigo;
                this.atualizarExames();
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "LabExterno (240)");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void atualizarExames() {
        try {
            this.service.atualizar(this.exames);
            this.exames.clear();
        }
        catch (LaboratorioExternoException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    private void criarSequence(Statement st, String codigoLabExterno) {
        StringBuilder buf = new StringBuilder();
        ResultSet rs = null;
        Statement stament = Conexao.getStatement();
        try {
            buf.append("select c.relname from pg_class c ");
            buf.append("where c.relname = 'codigolote_").append(Variaveis.filialPadrao).append("_").append(codigoLabExterno).append("_sequence'");
            rs = Conexao.executeQuery(stament, buf.toString());
            if (!rs.next()) {
                Conexao.execute(Variaveis.filialPadrao, st, "create sequence codigolote_" + Variaveis.filialPadrao + "_" + codigoLabExterno + "_sequence");
            }
            if (ParametrosGerais.getCopiaLabExterno() != null) {
                String[] codigosFiliais;
                String filiasAutoCopia = StringUtil.getValor(ParametrosGerais.getCopiaLabExterno(), "filiais");
                for (String codigoFilial : codigosFiliais = filiasAutoCopia.split(",")) {
                    buf.setLength(0);
                    buf.append("select c.relname from pg_class c ");
                    buf.append("where c.relname = 'codigolote_").append(codigoFilial).append("_").append(codigoLabExterno).append("_sequence'");
                    rs = Conexao.executeQuery(stament, buf.toString());
                    if (rs.next()) continue;
                    Conexao.execute(Variaveis.filialPadrao, st, "create sequence codigolote_" + codigoFilial + "_" + codigoLabExterno + "_sequence");
                }
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private String getTagCompletaParametrosRelacionamento() {
        return this.xmlParametrosRelacionamento;
    }

    private void controlaCampos() {
        this.buttonLog.setEnabled(this.getStatus() == 3);
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtSite.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtEmail.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFone.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtResponsavel.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtContato.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboProtocolo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonConfigurar.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonImportarListaExames.setEnabled(!Funcoes.textoVazio(this.txtCodigo) && (this.getStatus() == 3 || this.getStatus() == 2));
        this.buttonParametrosRelacionamento.setEnabled(!Funcoes.textoVazio(this.txtCodigo) && (this.getStatus() == 3 || this.getStatus() == 2));
        this.buttonRelacionamento.setEnabled(!Funcoes.textoVazio(this.txtCodigo) && (this.getStatus() == 3 || this.getStatus() == 2));
        this.buttonPrecos.setEnabled(!Funcoes.textoVazio(this.txtCodigo) && (this.getStatus() == 3 || this.getStatus() == 2));
        this.checkConferirAutomatico.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkInativo.setEnabled(this.getStatus() == 3);
        this.checkAgruparMultiguia.setEnabled(this.getStatus() == 3);
        this.checkIgnorarConfiguracaoProtocolo.setEnabled(this.getStatus() == 3);
        this.textCodigoUsuario.setEnabled(this.checkConferirAutomatico.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
        this.buttonBuscaUsuario.setEnabled(this.checkConferirAutomatico.isSelected() && (this.getStatus() == 3 || this.getStatus() == 2));
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.txtFone.clear();
        this.txtResponsavel.setText("");
        this.txtEmail.setText("");
        this.txtSite.setText("");
        this.txtContato.setText("");
        this.comboProtocolo.setSelectedIndex(0);
        this.checkConferirAutomatico.setSelected(false);
        this.checkInativo.setSelected(false);
        this.checkAgruparMultiguia.setSelected(false);
        this.checkIgnorarConfiguracaoProtocolo.setSelected(false);
        this.textCodigoUsuario.clear();
        this.labelUsuario.setText("");
        this.configuracao = "";
        this.labelUltimaAtualizacao.setText("");
        this.xmlParametrosRelacionamento = null;
        this.labelTermoAceite.setText("");
        this.exames.clear();
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (Funcoes.textoVazio(this.txtDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (this.comboProtocolo.getSelectedItem() != null ? Funcoes.textoVazio(this.comboProtocolo.getSelectedItem().toString()) : this.comboProtocolo.getSelectedItem() == null) {
            Funcoes.mensagem(this, "Campo protocolo n\u00e3o informado", 1);
            this.comboProtocolo.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtEmail.getText()) && this.txtEmail.getText().indexOf("@") <= 0) {
            Funcoes.mensagem(this, "Campo e-mail inv\u00e1lido", 1);
            this.txtEmail.selectAll();
            this.txtEmail.grabFocus();
            return false;
        }
        if (this.checkConferirAutomatico.isSelected() && this.labelUsuario.getText().equalsIgnoreCase("N\u00e3o cadastrado") || Funcoes.textoVazio(this.textCodigoUsuario.getText()) && this.checkConferirAutomatico.isSelected()) {
            Funcoes.mensagem(this, "Usu\u00e1rio de confer\u00eancia deve ser informado.", 1);
            ScreenUtil.requisitarFoco(this.textCodigoUsuario);
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901400");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "lae_codigo";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaUsuario) {
            this.pesquisaUsuario();
        } else if (e.getSource() == this.buttonParametrosRelacionamento) {
            this.configuraParametrosRelacionamento();
        } else if (e.getSource().equals(this.buttonLog)) {
            DialogoImportacaoLabExterno dialogoImportacaoLabExterno = DialogoImportacaoLabExterno.novaInstancia(Laboratorio.getInstancia(), Variaveis.filialPadrao, this.txtCodigo.getText());
            dialogoImportacaoLabExterno.setVisible(true);
        } else if (e.getSource() == this.buttonHistoricoLotes) {
            this.apresentarHistoricoLote();
        } else if (e.getSource() == this.buttonHistoricoSuspensos) {
            this.apresentarHistoricoExamesSuspensos();
        }
    }

    private void apresentarHistoricoLote() {
        if (Funcoes.isNumeric(Variaveis.filialPadrao) && Funcoes.isNumeric(this.txtCodigo.getText())) {
            JanelaHistoricoLotes his = new JanelaHistoricoLotes((Frame)Laboratorio.getInstancia(), Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(this.txtCodigo.getText()));
            if (null != his) {
                his.setVisible(true);
            }
        } else {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel identificar o laborat\u00f3rio externo", 2);
        }
    }

    private void apresentarHistoricoExamesSuspensos() {
        SplashMensagem s = SplashMensagem.getInstancia(this);
        s.mostrar("Verificando exames suspensos...");
        AbstractIntegracaoProtocolo integra = this.getFabricaIntegracao();
        if (Funcoes.isNumeric(Variaveis.filialPadrao) && Funcoes.isNumeric(this.txtCodigo.getText()) && null != integra) {
            integra.apresentarHistoricoExamesSuspensos(Laboratorio.getInstancia(), this.configuracao);
        } else {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel identificar o laborat\u00f3rio externo", 2);
        }
        s.apagar();
        s.setFinalizada(true);
        s = null;
    }

    private void configuraParametrosRelacionamento() {
        ConfiguracaoParametroRelacionamento janela = ConfiguracaoParametroRelacionamento.novaInstancia(Laboratorio.getInstancia());
        if (janela != null) {
            janela.setXml(this.xmlParametrosRelacionamento);
            janela.setVisible(true);
            if (janela.getOK()) {
                this.xmlParametrosRelacionamento = janela.getXml();
            }
        }
    }

    private void pesquisaUsuario() {
        Hashtable resultado = Pesquisas.usuario(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.textCodigoUsuario.setText(resultado.get("usr_codigo").toString());
        }
        this.textCodigoUsuario.requestFocus();
    }
}

