/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.DisposeListener;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class JanelaTagsResultado
extends JDialog
implements DisposeListener {
    public static final String TAG_LISTA_TAGS_RESULTADO = "LISTA_TAGS_RESULTADO";
    public static final String TAG_TAG_RESULTADO = "TAG_RESULTADO";
    public static final String TAG_NOME = "NOME";
    public static final String TAG_EM_USO = "EM_USO";
    public static final String TAG_EXCLUIDA = "EXCLUIDA";
    private static final int COLUNA_TAG = 0;
    private static final int COLUNA_EM_USO = 1;
    private static final String REGEX_TAG_RESULTADO = "^[\\w]{5,}$";
    private JLabel labelTagResultado = new JLabel("Tag de resultado");
    private TTextField textTagResultado = new TTextField(50);
    private JButton buttonOK = new JButton("OK");
    private JButton buttonFechar = new JButton("Fechar");
    private ModeloGridTable modelTagsResultado = new ModeloGridTable(new String[]{"Tag de resultado", "Em uso"});
    private JTable tableTagsResultado = new JTable(this.modelTagsResultado){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return Boolean.class;
            }
            return String.class;
        }
    };
    private JScrollPane scrollTagsResultado = new JScrollPane(this.tableTagsResultado);
    private JPanel panelSuperior = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentral = new JPanel(new GridBagLayout());
    private int linhaAlterada = -1;
    private ArrayList<String> listaTagsExcluidos = new ArrayList();

    public JanelaTagsResultado(JDialog owner) {
        super((Dialog)owner, "Configurando tags de resultado");
        this.montaTela();
    }

    public JanelaTagsResultado(JFrame owner) {
        super((Frame)owner, "Configurando tags de resultado");
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.setSize(450, 400);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.add((Component)this.panelSuperior, "North");
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.montaPainelSuperior();
        this.montaPainelCentral();
        this.montaPainelBotoes();
        this.montaListeners();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montaPainelSuperior() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelTagResultado.setDisplayedMnemonic('T');
        this.labelTagResultado.setLabelFor(this.textTagResultado);
        this.panelSuperior.add((Component)this.labelTagResultado, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelSuperior.add((Component)this.textTagResultado, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOK.setMnemonic('O');
        this.buttonOK.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.panelSuperior.add((Component)this.buttonOK, c);
        Funcoes.montaEnter((JComponent)this.panelSuperior);
    }

    private void montaPainelCentral() {
        this.modelTagsResultado.setColumnSize(new int[]{0, 80}, this.tableTagsResultado);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelCentral.add((Component)this.scrollTagsResultado, c);
        Funcoes.montaEnter((JComponent)this.panelCentral);
    }

    private void montaPainelBotoes() {
        this.buttonFechar.setMnemonic('F');
        this.panelBotoes.add(this.buttonFechar);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
    }

    private boolean validaTagResultado(String tag) {
        if (Funcoes.textoVazio(tag)) {
            return false;
        }
        return tag.matches(REGEX_TAG_RESULTADO);
    }

    private void montaListeners() {
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tag = JanelaTagsResultado.this.textTagResultado.getText();
                if (!JanelaTagsResultado.this.validaTagResultado(tag)) {
                    Funcoes.mensagem(JanelaTagsResultado.this, "A tag informada \u00e9 inv\u00e1lida.\nA tag deve possuir no m\u00ednimo 5 caracteres e n\u00e3o utilizar espa\u00e7os em branco e caracteres especiais.", 2);
                    JanelaTagsResultado.this.textTagResultado.selectAll();
                    ScreenUtil.requisitarFoco(JanelaTagsResultado.this.textTagResultado);
                    return;
                }
                int localizado = JanelaTagsResultado.this.modelTagsResultado.localizar(0, tag);
                if (localizado < 0 && JanelaTagsResultado.this.linhaAlterada > -1) {
                    JanelaTagsResultado.this.modelTagsResultado.setValueAt(tag, JanelaTagsResultado.this.linhaAlterada, 0);
                    JanelaTagsResultado.this.linhaAlterada = -1;
                } else if (localizado < 0) {
                    JanelaTagsResultado.this.modelTagsResultado.addLine(new Object[]{tag, false});
                }
                JanelaTagsResultado.this.textTagResultado.clear();
                ScreenUtil.requisitarFoco(JanelaTagsResultado.this.textTagResultado);
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaTagsResultado.this.setVisible(false);
            }
        });
        this.tableTagsResultado.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = JanelaTagsResultado.this.tableTagsResultado.getSelectedRow();
                if (row < 0) {
                    return;
                }
                if (((Boolean)JanelaTagsResultado.this.modelTagsResultado.getValueAt(row, 1)).booleanValue()) {
                    Funcoes.mensagem(JanelaTagsResultado.this, "A tag est\u00e1 em uso.\nN\u00e3o \u00e9 poss\u00edvel remover a tag.", 2);
                    return;
                }
                if (e.getKeyCode() == 127 && Funcoes.mensagem(JanelaTagsResultado.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    JanelaTagsResultado.this.listaTagsExcluidos.add(JanelaTagsResultado.this.modelTagsResultado.getValueAt(row, 0).toString());
                    JanelaTagsResultado.this.modelTagsResultado.removeLine(row);
                } else if (e.getKeyCode() == 32) {
                    JanelaTagsResultado.this.alteraLinha(row);
                }
            }
        });
        this.tableTagsResultado.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && JanelaTagsResultado.this.tableTagsResultado.getSelectedRow() > -1) {
                    JanelaTagsResultado.this.alteraLinha(JanelaTagsResultado.this.tableTagsResultado.getSelectedRow());
                }
            }
        });
    }

    private void alteraLinha(int linha) {
        if (linha < this.modelTagsResultado.getRowCount()) {
            if (((Boolean)this.modelTagsResultado.getValueAt(linha, 1)).booleanValue()) {
                Funcoes.mensagem(this, "A tag est\u00e1 em uso.\nN\u00e3o \u00e9 poss\u00edvel alterar a tag.", 2);
                return;
            }
            this.linhaAlterada = linha;
            this.textTagResultado.setText(this.modelTagsResultado.getValueAt(linha, 0).toString());
            ScreenUtil.requisitarFoco(this.textTagResultado);
        }
    }

    public String getXMLTagsResultado() {
        if (this.modelTagsResultado.getRowCount() == 0) {
            return null;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_LISTA_TAGS_RESULTADO);
            for (int i = 0; i < this.modelTagsResultado.getRowCount(); ++i) {
                xml.abrir(TAG_TAG_RESULTADO);
                xml.escrever(TAG_NOME, this.modelTagsResultado.getValueAt(i, 0).toString());
                xml.escrever(TAG_EM_USO, this.modelTagsResultado.getValueAt(i, 1).toString());
                xml.escrever(TAG_EXCLUIDA, "false");
                xml.fechar(TAG_TAG_RESULTADO);
            }
            for (String tag : this.listaTagsExcluidos) {
                xml.abrir(TAG_TAG_RESULTADO);
                xml.escrever(TAG_NOME, tag);
                xml.escrever(TAG_EM_USO, tag);
                xml.escrever(TAG_EXCLUIDA, "true");
                xml.fechar(TAG_TAG_RESULTADO);
            }
            xml.fechar(TAG_LISTA_TAGS_RESULTADO);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar XML das tags.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    public void setXMLTagsResultado(String xmlTagsResultado) {
        String[] tags;
        if (Funcoes.textoVazio(xmlTagsResultado)) {
            return;
        }
        String listaTags = StringUtil.getValor(xmlTagsResultado, TAG_LISTA_TAGS_RESULTADO);
        for (String tag : tags = StringUtil.getValores(listaTags, TAG_TAG_RESULTADO)) {
            boolean isExcluida;
            String nome = StringUtil.getValor(tag, TAG_NOME);
            boolean emUso = Boolean.parseBoolean(StringUtil.getValor(tag, TAG_EM_USO));
            boolean bl = isExcluida = !Funcoes.textoVazio(StringUtil.getValor(tag, TAG_EXCLUIDA)) ? Boolean.parseBoolean(StringUtil.getValor(tag, TAG_EXCLUIDA)) : Boolean.FALSE;
            if (!isExcluida) {
                this.modelTagsResultado.addLine(new Object[]{nome, emUso});
                continue;
            }
            this.listaTagsExcluidos.add(nome);
        }
    }
}

